/*
 * Decompiled with CFR 0.152.
 */
package rtg.world.gen.feature;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;

public class WorldGenBlock
extends WorldGenerator {
    protected Block placeBlock;
    protected byte placeBlockMeta;
    protected Block replaceBlock;
    protected byte replaceBlockMeta;
    protected Block adjacentBlock;
    protected byte adjacentBlockMeta;
    protected int minAdjacents;

    public WorldGenBlock(Block placeBlock, byte placeBlockMeta, Block replaceBlock, byte replaceBlockMeta, Block adjacentBlock, byte adjacentBlockMeta, int minAdjacents) {
        super(false);
        this.placeBlock = placeBlock;
        this.placeBlockMeta = placeBlockMeta;
        this.replaceBlock = replaceBlock;
        this.replaceBlockMeta = replaceBlockMeta;
        this.adjacentBlock = adjacentBlock;
        this.adjacentBlockMeta = adjacentBlockMeta;
        this.minAdjacents = minAdjacents;
    }

    public boolean func_76484_a(World world, Random rand, int x, int y, int z) {
        Block targetBlock = world.func_147439_a(x, y, z);
        if (targetBlock != this.replaceBlock) {
            return false;
        }
        if (!this.isAdjacent(world, x, y, z)) {
            return false;
        }
        world.func_147465_d(x, y, z, this.placeBlock, (int)this.placeBlockMeta, 2);
        return true;
    }

    protected boolean isAdjacent(World world, int x, int y, int z) {
        int adjacentCount = 0;
        if (world.func_147439_a(x + 1, y, z) == this.adjacentBlock) {
            ++adjacentCount;
        }
        if (world.func_147439_a(x - 1, y, z) == this.adjacentBlock) {
            ++adjacentCount;
        }
        if (world.func_147439_a(x, y + 1, z) == this.adjacentBlock) {
            ++adjacentCount;
        }
        if (world.func_147439_a(x, y - 1, z) == this.adjacentBlock) {
            ++adjacentCount;
        }
        if (world.func_147439_a(x, y, z + 1) == this.adjacentBlock) {
            ++adjacentCount;
        }
        if (world.func_147439_a(x, y, z - 1) == this.adjacentBlock) {
            ++adjacentCount;
        }
        return adjacentCount > 0 && adjacentCount >= this.minAdjacents;
    }
}

