/*
 * Decompiled with CFR 0.152.
 */
package rtg.world.gen.terrain;

import rtg.util.CellNoise;
import rtg.util.OpenSimplexNoise;
import rtg.world.gen.terrain.TerrainBase;

public class TerrainRollingHills
extends TerrainBase {
    private float minHeight = 63.0f;
    private float maxHeight = 80.0f;
    private float hillStrength = 30.0f;

    public TerrainRollingHills(float minHeight, float maxHeight, float hillStrength) {
        this.minHeight = minHeight;
        this.maxHeight = maxHeight > this.rollingHillsMaxHeight ? this.rollingHillsMaxHeight : (maxHeight < this.minHeight ? this.rollingHillsMaxHeight : maxHeight);
        this.hillStrength = hillStrength;
    }

    @Override
    public float generateNoise(OpenSimplexNoise simplex, CellNoise cell, int x, int y, float border, float river) {
        this.groundNoise = TerrainRollingHills.groundNoise(x, y, this.groundNoiseAmplitudeHills, simplex);
        float m = TerrainRollingHills.hills(x, y, this.hillStrength, simplex, river);
        float floNoise = TerrainRollingHills.riverized(this.minHeight + this.groundNoise, river) + m;
        return floNoise + 0.0f;
    }
}

