/*
 * Decompiled with CFR 0.152.
 */
package rtg.world.gen.terrain.biomesoplenty;

import rtg.util.CellNoise;
import rtg.util.OpenSimplexNoise;
import rtg.util.SimplexOctave;
import rtg.world.gen.terrain.TerrainBase;

public class TerrainBOPChaparral
extends TerrainBase {
    private float baseHeight = 76.0f;
    private float peakyHillWavelength = 40.0f;
    private float peakyHillStrength = 40.0f;
    private float smoothHillWavelength = 60.0f;
    private float smoothHillStrength = 30.0f;
    private SimplexOctave.Derivative jitter = new SimplexOctave.Derivative();
    private float wavelength = 10.0f;
    private float amplitude = 2.0f;

    public TerrainBOPChaparral() {
    }

    public TerrainBOPChaparral(float bh, float hs) {
        this.baseHeight = bh;
        this.peakyHillStrength = hs;
    }

    @Override
    public float generateNoise(OpenSimplexNoise simplex, CellNoise cell, int x, int y, float border, float river) {
        this.groundNoise = TerrainBOPChaparral.groundNoise(x, y, this.groundNoiseAmplitudeHills, simplex);
        simplex.riverJitter().evaluateNoise((float)x / this.wavelength, (float)y / this.wavelength, this.jitter);
        int pX = (int)Math.round((double)x + this.jitter.deltax() * (double)this.amplitude);
        int pY = (int)Math.round((double)y + this.jitter.deltay() * (double)this.amplitude);
        float h = TerrainBOPChaparral.terrainGrasslandHills(pX, pY, simplex, cell, river, this.peakyHillWavelength, this.peakyHillStrength, this.smoothHillWavelength, this.smoothHillStrength, this.baseHeight);
        return this.groundNoise + h;
    }
}

