/*
 * Decompiled with CFR 0.152.
 */
package rtg.world.gen.terrain.enhancedbiomes;

import rtg.util.CellNoise;
import rtg.util.OpenSimplexNoise;
import rtg.world.gen.terrain.GroundEffect;
import rtg.world.gen.terrain.HeightEffect;
import rtg.world.gen.terrain.HeightVariation;
import rtg.world.gen.terrain.JitterEffect;
import rtg.world.gen.terrain.MountainsWithPassesEffect;
import rtg.world.gen.terrain.TerrainBase;

public class TerrainEBSnowyRanges
extends TerrainBase {
    private float width;
    private float strength;
    private float terrainHeight;
    private float spikeWidth = 25.0f;
    private float spikeHeight = 75.0f;
    private HeightEffect heightEffect;

    public TerrainEBSnowyRanges(float mountainWidth, float mountainStrength, float height) {
        this.width = mountainWidth;
        this.strength = mountainStrength;
        this.terrainHeight = height;
        MountainsWithPassesEffect mountainEffect = new MountainsWithPassesEffect();
        mountainEffect.mountainHeight = this.strength;
        mountainEffect.mountainWavelength = this.width;
        mountainEffect.spikeHeight = this.spikeHeight;
        mountainEffect.spikeWavelength = this.spikeWidth;
        this.heightEffect = new JitterEffect(5.0f, 10.0f, mountainEffect);
        this.heightEffect = new JitterEffect(2.0f, 6.0f, this.heightEffect);
        HeightVariation hilliness = new HeightVariation();
        hilliness.octave = 2;
        hilliness.wavelength = 40.0f;
        hilliness.height = 6.0f;
        this.heightEffect = this.heightEffect.plus(hilliness);
        GroundEffect ground = new GroundEffect(3.0f);
        this.heightEffect = this.heightEffect.plus(ground);
    }

    @Override
    public float generateNoise(OpenSimplexNoise simplex, CellNoise cell, int x, int y, float border, float river) {
        return TerrainEBSnowyRanges.riverized(this.heightEffect.added(simplex, cell, x, y) + this.terrainHeight, river);
    }
}

