/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.smeltery.blocks;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import mantle.blocks.iface.IServantLogic;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import tconstruct.library.TConstructRegistry;
import tconstruct.smeltery.logic.LavaTankLogic;
import tconstruct.smeltery.model.TankRender;

public class LavaTankBlock
extends BlockContainer {
    public IIcon[] icons;
    String texturePrefix = "";

    public LavaTankBlock() {
        super(Material.field_151576_e);
        this.func_149711_c(3.0f);
        this.func_149752_b(20.0f);
        this.func_149647_a(TConstructRegistry.blockTab);
        this.func_149663_c("TConstruct.LavaTank");
        this.func_149672_a(Block.field_149779_h);
    }

    public LavaTankBlock(String prefix) {
        this();
        this.texturePrefix = prefix;
    }

    public String[] getTextureNames() {
        String[] textureNames = new String[]{"lavatank_side", "lavatank_top", "searedgague_top", "searedgague_side", "searedgague_bottom", "searedwindow_top", "searedwindow_side", "searedwindow_bottom"};
        if (!this.texturePrefix.equals("")) {
            for (int i = 0; i < textureNames.length; ++i) {
                textureNames[i] = this.texturePrefix + "_" + textureNames[i];
            }
        }
        return textureNames;
    }

    public void func_149651_a(IIconRegister IIconRegister2) {
        String[] textureNames = this.getTextureNames();
        this.icons = new IIcon[textureNames.length];
        for (int i = 0; i < this.icons.length; ++i) {
            this.icons[i] = IIconRegister2.func_94245_a("tinker:" + textureNames[i]);
        }
    }

    public int func_149701_w() {
        return 1;
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    public boolean func_149646_a(IBlockAccess world, int x, int y, int z, int side) {
        Block bID = world.func_147439_a(x, y, z);
        return bID == this ? false : super.func_149646_a(world, x, y, z, side);
    }

    public boolean canRenderInPass(int pass) {
        TankRender.renderPass = pass;
        return true;
    }

    public int getLightValue(IBlockAccess world, int x, int y, int z) {
        TileEntity logic = world.func_147438_o(x, y, z);
        if (logic != null && logic instanceof LavaTankLogic) {
            return ((LavaTankLogic)logic).getBrightness();
        }
        return 0;
    }

    public int func_149645_b() {
        return TankRender.tankModelID;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int meta) {
        if (meta >= 3) {
            meta = 0;
        }
        if (meta == 0) {
            if (side == 0 || side == 1) {
                return this.icons[1];
            }
            return this.icons[0];
        }
        return this.icons[meta * 3 + this.getTextureIndex(side) - 1];
    }

    public int getTextureIndex(int side) {
        if (side == 0) {
            return 2;
        }
        if (side == 1) {
            return 0;
        }
        return 1;
    }

    public TileEntity createTileEntity(World world, int metadata) {
        return new LavaTankLogic();
    }

    public boolean func_149727_a(World world, int i, int j, int k, EntityPlayer entityplayer, int par6, float par7, float par8, float par9) {
        ItemStack current = entityplayer.field_71071_by.func_70448_g();
        if (current != null) {
            FluidStack liquid = FluidContainerRegistry.getFluidForFilledItem((ItemStack)current);
            LavaTankLogic logic = (LavaTankLogic)world.func_147438_o(i, j, k);
            if (liquid != null && !world.field_72995_K) {
                int amount = logic.fill(ForgeDirection.UNKNOWN, liquid, false);
                if (amount == liquid.amount) {
                    logic.fill(ForgeDirection.UNKNOWN, liquid, true);
                    if (!entityplayer.field_71075_bZ.field_75098_d) {
                        entityplayer.field_71071_by.func_70299_a(entityplayer.field_71071_by.field_70461_c, LavaTankBlock.consumeItem(current));
                    }
                    entityplayer.field_71069_bz.func_75142_b();
                    world.func_147471_g(i, j, k);
                }
                return true;
            }
            if (FluidContainerRegistry.isBucket((ItemStack)current)) {
                ItemStack fillStack;
                FluidTankInfo[] tanks = logic.getTankInfo(ForgeDirection.UNKNOWN);
                FluidStack fillFluid = tanks[0].fluid;
                if (!world.field_72995_K && (fillStack = FluidContainerRegistry.fillFluidContainer((FluidStack)fillFluid, (ItemStack)current)) != null) {
                    logic.drain(ForgeDirection.UNKNOWN, FluidContainerRegistry.getFluidForFilledItem((ItemStack)fillStack).amount, true);
                    if (!entityplayer.field_71075_bZ.field_75098_d && !world.field_72995_K) {
                        if (current.field_77994_a == 1) {
                            entityplayer.field_71071_by.func_70299_a(entityplayer.field_71071_by.field_70461_c, fillStack);
                        } else {
                            entityplayer.field_71071_by.func_70299_a(entityplayer.field_71071_by.field_70461_c, LavaTankBlock.consumeItem(current));
                            if (!entityplayer.field_71071_by.func_70441_a(fillStack)) {
                                entityplayer.func_71019_a(fillStack, false);
                            }
                        }
                        entityplayer.field_71069_bz.func_75142_b();
                    }
                    world.func_147471_g(i, j, k);
                }
                return true;
            }
        }
        return false;
    }

    public static ItemStack consumeItem(ItemStack stack) {
        if (stack.field_77994_a == 1) {
            if (stack.func_77973_b().func_77634_r()) {
                return stack.func_77973_b().getContainerItem(stack);
            }
            return null;
        }
        stack.func_77979_a(1);
        return stack;
    }

    public TileEntity func_149915_a(World world, int test) {
        return this.createTileEntity(world, 0);
    }

    public void func_149666_a(Item id, CreativeTabs tab, List list) {
        for (int iter = 0; iter < 3; ++iter) {
            list.add(new ItemStack(id, 1, iter));
        }
    }

    public int func_149692_a(int meta) {
        return meta;
    }

    public void func_149695_a(World world, int x, int y, int z, Block nBlockID) {
        if (!Minecraft.func_71410_x().func_71356_B()) {
            return;
        }
        TileEntity logic = world.func_147438_o(x, y, z);
        if (logic instanceof IServantLogic) {
            ((IServantLogic)logic).notifyMasterOfChange();
        }
    }

    public boolean removedByPlayer(World world, EntityPlayer player, int x, int y, int z) {
        player.func_71020_j(0.025f);
        int meta = world.func_72805_g(x, y, z);
        ItemStack stack = new ItemStack((Block)this, 1, meta);
        LavaTankLogic logic = (LavaTankLogic)world.func_147438_o(x, y, z);
        FluidStack liquid = logic.tank.getFluid();
        if (liquid != null) {
            NBTTagCompound tag = new NBTTagCompound();
            NBTTagCompound liquidTag = new NBTTagCompound();
            liquid.writeToNBT(liquidTag);
            tag.func_74782_a("Fluid", (NBTBase)liquidTag);
            stack.func_77982_d(tag);
        }
        if (!player.field_71075_bZ.field_75098_d || player.func_70093_af()) {
            this.dropTankBlock(world, x, y, z, stack);
        }
        return world.func_147468_f(x, y, z);
    }

    protected void dropTankBlock(World world, int x, int y, int z, ItemStack stack) {
        if (!world.field_72995_K && world.func_82736_K().func_82766_b("doTileDrops")) {
            float f = 0.7f;
            double d0 = (double)(world.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
            double d1 = (double)(world.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
            double d2 = (double)(world.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
            EntityItem entityitem = new EntityItem(world, (double)x + d0, (double)y + d1, (double)z + d2, stack);
            entityitem.field_145804_b = 10;
            world.func_72838_d((Entity)entityitem);
        }
    }

    public void func_149636_a(World par1World, EntityPlayer par2EntityPlayer, int par3, int par4, int par5, int par6) {
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase living, ItemStack stack) {
        NBTTagCompound liquidTag;
        if (stack.func_77942_o() && (liquidTag = stack.func_77978_p().func_74775_l("Fluid")) != null) {
            FluidStack liquid = FluidStack.loadFluidStackFromNBT((NBTTagCompound)liquidTag);
            LavaTankLogic logic = (LavaTankLogic)world.func_147438_o(x, y, z);
            logic.tank.setFluid(liquid);
        }
    }

    public boolean func_149740_M() {
        return true;
    }

    public int func_149736_g(World world, int x, int y, int z, int comparatorSide) {
        return LavaTankBlock.getTankLogic((IBlockAccess)world, x, y, z).comparatorStrength();
    }

    public static LavaTankLogic getTankLogic(IBlockAccess blockAccess, int par1, int par2, int par3) {
        return (LavaTankLogic)blockAccess.func_147438_o(par1, par2, par3);
    }
}

