/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.smeltery.gui;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;
import tconstruct.TConstruct;
import tconstruct.library.crafting.Smeltery;
import tconstruct.smeltery.TinkerSmeltery;
import tconstruct.smeltery.gui.ActiveContainerGui;
import tconstruct.smeltery.inventory.ActiveContainer;
import tconstruct.smeltery.inventory.SmelteryContainer;
import tconstruct.smeltery.logic.SmelteryLogic;
import tconstruct.util.network.SmelteryPacket;

public class SmelteryGui
extends ActiveContainerGui {
    public SmelteryLogic logic;
    private boolean isScrolling = false;
    private boolean wasClicking;
    private float currentScroll = 0.0f;
    private int slotPos = 0;
    private int prevSlotPos = 0;
    private final int columns;
    private final int smelterySize;
    public static final int maxRows = 8;
    private static final ResourceLocation background = new ResourceLocation("tinker", "textures/gui/smeltery.png");
    private static final ResourceLocation backgroundSide = new ResourceLocation("tinker", "textures/gui/smelteryside.png");

    public SmelteryGui(InventoryPlayer inventoryplayer, SmelteryLogic smeltery, World world, int x, int y, int z) {
        super((ActiveContainer)smeltery.getGuiContainer(inventoryplayer, world, x, y, z));
        this.logic = smeltery;
        this.smelterySize = smeltery.getBlockCapacity();
        smeltery.updateFuelDisplay();
        this.columns = ((SmelteryContainer)this.field_147002_h).columns;
        this.field_146999_f = 254 + (this.columns - 3) * 22;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        if (this.logic != null) {
            this.logic.updateFuelDisplay();
        }
    }

    public void func_73863_a(int mouseX, int mouseY, float par3) {
        if (this.logic.getBlockCapacity() != this.smelterySize) {
            this.field_146297_k.field_71439_g.func_71053_j();
            return;
        }
        super.func_73863_a(mouseX, mouseY, par3);
        this.updateScrollbar(mouseX, mouseY, par3);
    }

    protected void updateScrollbar(int mouseX, int mouseY, float par3) {
        if (this.smelterySize > this.columns * 8) {
            boolean mouseDown = Mouse.isButtonDown((int)0);
            int lefto = this.field_147003_i;
            int topo = this.field_147009_r;
            int xScroll = lefto + 67 + (this.columns - 3) * 22;
            int yScroll = topo + 8;
            int scrollWidth = xScroll + 14;
            int scrollHeight = yScroll + 144;
            if (!this.wasClicking && mouseDown && mouseX >= xScroll && mouseY >= yScroll && mouseX < scrollWidth && mouseY < scrollHeight) {
                this.isScrolling = true;
            }
            if (!mouseDown) {
                this.isScrolling = false;
            }
            if (this.wasClicking && !this.isScrolling && this.slotPos != this.prevSlotPos) {
                this.prevSlotPos = this.slotPos;
            }
            this.wasClicking = mouseDown;
            if (this.isScrolling) {
                int s;
                this.currentScroll = ((float)(mouseY - yScroll) - 7.5f) / ((float)(scrollHeight - yScroll) - 15.0f);
                if (this.currentScroll < 0.0f) {
                    this.currentScroll = 0.0f;
                }
                if (this.currentScroll > 1.0f) {
                    this.currentScroll = 1.0f;
                }
                if ((s = ((SmelteryContainer)this.field_147002_h).scrollTo(this.currentScroll)) != -1) {
                    this.slotPos = s;
                }
            }
        }
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        int baseX = 86 + (this.columns - 3) * 22;
        this.field_146289_q.func_78276_b(StatCollector.func_74838_a((String)"crafters.Smeltery"), baseX, 5, 0x404040);
        this.field_146289_q.func_78276_b(StatCollector.func_74838_a((String)"container.inventory"), baseX + 4, this.field_147000_g - 96 + 2, 0x404040);
        int cornerX = (this.field_146294_l - this.field_146999_f) / 2 + 36 + (this.columns - 3) * 22;
        int cornerY = (this.field_146295_m - this.field_147000_g) / 2;
        int[] fluidHeights = this.calcLiquidHeights();
        int base = 0;
        for (int i = 0; i < fluidHeights.length; ++i) {
            int leftX = cornerX + 54;
            int topY = cornerY + 68 - fluidHeights[i] - base;
            if (mouseX >= leftX && mouseX <= leftX + 52 && mouseY >= topY && mouseY < topY + fluidHeights[i]) {
                this.drawFluidStackTooltip(this.logic.moltenMetal.get(i), mouseX - cornerX + 36, mouseY - cornerY, false);
            }
            base += fluidHeights[i];
        }
        if (this.logic.fuelGague > 0) {
            int leftX = cornerX + 117;
            int topY = cornerY + 68 - this.logic.getScaledFuelGague(52);
            int sizeX = 12;
            int sizeY = this.logic.getScaledFuelGague(52);
            if (mouseX >= leftX && mouseX <= leftX + sizeX && mouseY >= topY && mouseY < topY + sizeY) {
                this.drawFluidStackTooltip(this.logic.getFuel(), mouseX - cornerX + 36, mouseY - cornerY, true);
            }
        }
    }

    protected void func_146976_a(float f, int mouseX, int mouseY) {
        int iter;
        int i;
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(background);
        int cornerX = (this.field_146294_l - this.field_146999_f) / 2 + 36 + (this.columns - 3) * 22;
        int cornerY = (this.field_146295_m - this.field_147000_g) / 2;
        this.func_73729_b(cornerX + 46, cornerY, 0, 0, 176, this.field_147000_g);
        this.field_146297_k.func_110434_K().func_110577_a(TextureMap.field_110575_b);
        if (this.logic.fuelGague > 0) {
            FluidStack fuelStack = this.logic.getFuel();
            IIcon lavaIcon = fuelStack.getFluid().getStillIcon();
            if (lavaIcon == null) {
                lavaIcon = Blocks.field_150353_l.func_149691_a(0, 0);
            }
            int fuel = this.logic.getScaledFuelGague(52);
            int count = 0;
            while (fuel > 0) {
                int size = Math.min(fuel, 16);
                fuel -= size;
                this.drawLiquidRect(cornerX + 117, cornerY + 68 - size - 16 * count, lavaIcon, 12, size, fuelStack.getFluid().getColor(fuelStack));
                ++count;
            }
        }
        if (this.logic.getCapacity() > 0) {
            int base = 0;
            int[] fluidHeights = this.calcLiquidHeights();
            int basePos = 54;
            for (i = 0; i < this.logic.moltenMetal.size(); ++i) {
                int height;
                FluidStack liquid = this.logic.moltenMetal.get(i);
                IIcon icon = liquid.getFluid().getStillIcon();
                int color = liquid.getFluid().getColor(liquid);
                if (icon == null) continue;
                for (int h = height = fluidHeights[i]; h > 0; h -= 16) {
                    int v = Math.min(16, h);
                    this.drawLiquidRect(cornerX + basePos, cornerY + 68 - h - base, icon, 16, v, color);
                    this.drawLiquidRect(cornerX + basePos + 16, cornerY + 68 - h - base, icon, 16, v, color);
                    this.drawLiquidRect(cornerX + basePos + 32, cornerY + 68 - h - base, icon, 16, v, color);
                    this.drawLiquidRect(cornerX + basePos + 48, cornerY + 68 - h - base, icon, 4, v, color);
                }
                base += height;
            }
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(background);
        this.func_73729_b(cornerX + 54, cornerY + 16, 176, 76, 52, 52);
        int xleft = 46;
        xleft += 22 * (this.columns - 3);
        int h = this.smelterySize / this.columns;
        if (this.smelterySize % this.columns != 0) {
            ++h;
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(backgroundSide);
        if (this.smelterySize > 0) {
            if (h >= 8) {
                this.func_73729_b(cornerX - xleft, cornerY, 0, 0, 72, this.field_147000_g - 8);
                for (int i2 = 0; i2 < this.columns - 3; ++i2) {
                    this.func_73729_b(cornerX - xleft + 72 + i2 * 22, cornerY, 50, 0, 22, this.field_147000_g - 8);
                }
                this.func_73729_b(cornerX - 46 + 72, cornerY, 72, 0, 25, this.field_147000_g - 8);
                int sx = cornerX + 32;
                int sy = (int)((float)(cornerY + 8) + 127.0f * this.currentScroll);
                if (this.isScrolling || mouseX >= sx && mouseX <= sx + 12 && mouseY >= sy && mouseY <= sy + 15) {
                    this.func_73729_b(sx, sy, 122, 0, 12, 15);
                } else {
                    this.func_73729_b(sx, sy, 98, 0, 12, 15);
                }
            } else {
                int yd = 43 + 18 * (h - 3);
                this.func_73729_b(cornerX - xleft, cornerY, 0, 0, 72, yd);
                for (i = 0; i < this.columns - 3; ++i) {
                    this.func_73729_b(cornerX - xleft + 72 + i * 22, cornerY, 50, 0, 22, yd);
                }
                this.func_73729_b(cornerX - 46 + 72, cornerY, 72, 0, 25, yd);
                this.func_73729_b(cornerX - xleft, cornerY + yd, 0, 133, 72, 25);
                for (i = 0; i < this.columns - 3; ++i) {
                    this.func_73729_b(cornerX - xleft + 72 + i * 22, cornerY + yd, 50, 133, 22, 25);
                }
                this.func_73729_b(cornerX - 46 + 72, cornerY + yd, 72, 133, 25, 25);
                this.func_73729_b(cornerX + 32, (int)((float)(cornerY + 8) + 127.0f * this.currentScroll), 110, 0, 12, 15);
            }
        }
        xleft -= 8;
        int slotSize = this.smelterySize;
        if (slotSize > this.columns * 8) {
            slotSize = this.columns * 8;
        }
        for (iter = 0; iter < slotSize && iter + this.slotPos * this.columns < this.smelterySize; ++iter) {
            int slotTemp = this.logic.getTempForSlot(iter + this.slotPos * this.columns) - 20;
            int maxTemp = this.logic.getMeltingPointForSlot(iter + this.slotPos * this.columns) - 20;
            if (slotTemp <= 0 || maxTemp <= 0) continue;
            int size = 16 * slotTemp / maxTemp + 1;
            this.func_73729_b(cornerX - xleft + iter % this.columns * 22, cornerY + 8 + iter / this.columns * 18 + 16 - size, 98, 31 - size, 5, size);
        }
        int maxSlots = Math.min(8, h) * this.columns;
        while (iter < maxSlots) {
            this.func_73729_b(cornerX - xleft + iter % this.columns * 22 - 1, cornerY + 8 + iter / this.columns * 18 - 1, 98, 47, 22, 18);
            ++iter;
        }
    }

    protected int[] calcLiquidHeights() {
        int[] fluidHeights = new int[this.logic.moltenMetal.size()];
        int cap = this.logic.getCapacity();
        if (this.logic.getTotalLiquid() > cap) {
            cap = this.logic.getTotalLiquid();
        }
        for (int i = 0; i < this.logic.moltenMetal.size(); ++i) {
            FluidStack liquid = this.logic.moltenMetal.get(i);
            float h = (float)liquid.amount / (float)cap;
            fluidHeights[i] = Math.max(3, (int)Math.ceil(h * 52.0f));
        }
        int sum = 0;
        do {
            sum = 0;
            int biggest = -1;
            int m = 0;
            for (int i = 0; i < fluidHeights.length; ++i) {
                sum += fluidHeights[i];
                if (this.logic.moltenMetal.get((int)i).amount <= biggest) continue;
                biggest = this.logic.moltenMetal.get((int)i).amount;
                m = i;
            }
            if (sum <= 52) continue;
            int n = m;
            fluidHeights[n] = fluidHeights[n] - 1;
        } while (sum > 52);
        return fluidHeights;
    }

    protected void drawFluidStackTooltip(FluidStack par1ItemStack, int par2, int par3, boolean fuel) {
        this.field_73735_i = 100.0f;
        List list = this.getLiquidTooltip(par1ItemStack, this.field_146297_k.field_71474_y.field_82882_x, fuel);
        for (int k = 0; k < list.size(); ++k) {
            list.set(k, EnumChatFormatting.GRAY + (String)list.get(k));
        }
        this.drawToolTip(list, par2, par3);
        this.field_73735_i = 0.0f;
    }

    public List getLiquidTooltip(FluidStack liquid, boolean advanced, boolean fuel) {
        ArrayList<String> list = new ArrayList<String>();
        if (fuel) {
            list.add("\u00a7f" + StatCollector.func_74838_a((String)"gui.smeltery.fuel"));
            list.add("mB: " + liquid.amount);
        } else {
            Fluid f = liquid.getFluid();
            String name = f.getLocalizedName(liquid);
            list.add("\u00a7f" + name);
            if (f == TinkerSmeltery.moltenEmeraldFluid) {
                list.add(StatCollector.func_74838_a((String)"gui.smeltery.emerald") + (float)liquid.amount / 640.0f);
            } else if (f == TinkerSmeltery.moltenGlassFluid) {
                int mB;
                int panels;
                int blocks = liquid.amount / 1000;
                if (blocks > 0) {
                    list.add(StatCollector.func_74838_a((String)"gui.smeltery.glass.block") + blocks);
                }
                if ((panels = liquid.amount % 1000 / 250) > 0) {
                    list.add(StatCollector.func_74838_a((String)"gui.smeltery.glass.pannel") + panels);
                }
                if ((mB = liquid.amount % 1000 % 250) > 0) {
                    list.add("mB: " + mB);
                }
            } else if (f == TinkerSmeltery.moltenStoneFluid) {
                int mB;
                int ingots;
                int blocks = liquid.amount / 144;
                if (blocks > 0) {
                    list.add(StatCollector.func_74838_a((String)"gui.smeltery.glass.block") + blocks);
                }
                if ((ingots = liquid.amount % 144 / 36) > 0) {
                    list.add(StatCollector.func_74838_a((String)"gui.smeltery.metal.ingot") + ingots);
                }
                if ((mB = liquid.amount % 144 % 36) > 0) {
                    list.add("mB: " + mB);
                }
            } else if (SmelteryGui.isMolten(f)) {
                int mB;
                int ingots = liquid.amount / 144;
                if (ingots > 0) {
                    list.add(StatCollector.func_74838_a((String)"gui.smeltery.metal.ingot") + ingots);
                }
                if ((mB = liquid.amount % 144) > 0) {
                    int nuggets = mB / 16;
                    int junk = mB % 16;
                    if (nuggets > 0) {
                        list.add(StatCollector.func_74838_a((String)"gui.smeltery.metal.nugget") + nuggets);
                    }
                    if (junk > 0) {
                        list.add("mB: " + junk);
                    }
                }
            } else {
                list.add("mB: " + liquid.amount);
            }
        }
        return list;
    }

    private static boolean isMolten(Fluid f) {
        boolean foundedIngot = false;
        boolean foundedNugget = false;
        for (FluidStack e : Smeltery.getSmeltingList().values()) {
            if (!foundedIngot && e.amount == 144 && e.getFluid() == f) {
                foundedIngot = true;
            }
            if (!foundedNugget && e.amount == 16 && e.getFluid() == f) {
                foundedNugget = true;
            }
            if (!foundedIngot || !foundedNugget) continue;
            return true;
        }
        return false;
    }

    private boolean isMolten(String fluidName) {
        String[] moltenNames;
        boolean molten = false;
        for (String moltenName : moltenNames = StatCollector.func_74838_a((String)"gui.smeltery.molten.check").split(",")) {
            if (!fluidName.contains(moltenName.trim())) continue;
            molten = true;
            break;
        }
        return molten;
    }

    protected void drawToolTip(List par1List, int par2, int par3) {
        if (!par1List.isEmpty()) {
            GL11.glDisable((int)32826);
            RenderHelper.func_74518_a();
            GL11.glDisable((int)2896);
            GL11.glDisable((int)2929);
            int k = 0;
            for (Object o : par1List) {
                String s = (String)o;
                int l = this.field_146289_q.func_78256_a(s);
                if (l <= k) continue;
                k = l;
            }
            int i1 = par2 + 12;
            int j1 = par3 - 12;
            int k1 = 8;
            if (par1List.size() > 1) {
                k1 += 2 + (par1List.size() - 1) * 10;
            }
            if (i1 + k > this.field_146294_l) {
                i1 -= 28 + k;
            }
            if (j1 + k1 + 6 > this.field_146295_m) {
                j1 = this.field_146295_m - k1 - 6;
            }
            this.field_73735_i = 300.0f;
            SmelteryGui.field_146296_j.field_77023_b = 300.0f;
            int l1 = -267386864;
            this.func_73733_a(i1 - 3, j1 - 4, i1 + k + 3, j1 - 3, l1, l1);
            this.func_73733_a(i1 - 3, j1 + k1 + 3, i1 + k + 3, j1 + k1 + 4, l1, l1);
            this.func_73733_a(i1 - 3, j1 - 3, i1 + k + 3, j1 + k1 + 3, l1, l1);
            this.func_73733_a(i1 - 4, j1 - 3, i1 - 3, j1 + k1 + 3, l1, l1);
            this.func_73733_a(i1 + k + 3, j1 - 3, i1 + k + 4, j1 + k1 + 3, l1, l1);
            int i2 = 0x505000FF;
            int j2 = (i2 & 0xFEFEFE) >> 1 | i2 & 0xFF000000;
            this.func_73733_a(i1 - 3, j1 - 3 + 1, i1 - 3 + 1, j1 + k1 + 3 - 1, i2, j2);
            this.func_73733_a(i1 + k + 2, j1 - 3 + 1, i1 + k + 3, j1 + k1 + 3 - 1, i2, j2);
            this.func_73733_a(i1 - 3, j1 - 3, i1 + k + 3, j1 - 3 + 1, i2, i2);
            this.func_73733_a(i1 - 3, j1 + k1 + 2, i1 + k + 3, j1 + k1 + 3, j2, j2);
            for (int k2 = 0; k2 < par1List.size(); ++k2) {
                String s1 = (String)par1List.get(k2);
                this.field_146289_q.func_78261_a(s1, i1, j1, -1);
                if (k2 == 0) {
                    j1 += 2;
                }
                j1 += 10;
            }
            this.field_73735_i = 0.0f;
            SmelteryGui.field_146296_j.field_77023_b = 0.0f;
            RenderHelper.func_74520_c();
        }
    }

    public void drawLiquidRect(int startU, int startV, IIcon icon, int endU, int endV, int color) {
        float top = icon.func_94207_b((double)(16 - endV));
        float bottom = icon.func_94210_h();
        float left = icon.func_94209_e();
        float right = icon.func_94214_a((double)endU);
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        tessellator.func_78378_d(color);
        tessellator.func_78374_a((double)startU, (double)(startV + endV), (double)this.field_73735_i, (double)left, (double)bottom);
        tessellator.func_78374_a((double)(startU + endU), (double)(startV + endV), (double)this.field_73735_i, (double)right, (double)bottom);
        tessellator.func_78374_a((double)(startU + endU), (double)startV, (double)this.field_73735_i, (double)right, (double)top);
        tessellator.func_78374_a((double)startU, (double)startV, (double)this.field_73735_i, (double)left, (double)top);
        tessellator.func_78381_a();
    }

    public void func_73864_a(int mouseX, int mouseY, int mouseButton) {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        int cornerX = (this.field_146294_l - this.field_146999_f) / 2 + 36 + (this.columns - 3) * 22;
        int cornerY = (this.field_146295_m - this.field_147000_g) / 2;
        int fluidToBeBroughtUp = -1;
        int[] fluidHeights = this.calcLiquidHeights();
        int base = 0;
        for (int i = 0; i < fluidHeights.length; ++i) {
            int leftX = cornerX + 54;
            int topY = cornerY + 68 - fluidHeights[i] - base;
            if (mouseX >= leftX && mouseX <= leftX + 52 && mouseY >= topY && mouseY < topY + fluidHeights[i]) {
                fluidToBeBroughtUp = this.logic.moltenMetal.get(i).getFluidID();
                TConstruct.packetPipeline.sendToServer(new SmelteryPacket(this.logic.func_145831_w().field_73011_w.field_76574_g, this.logic.field_145851_c, this.logic.field_145848_d, this.logic.field_145849_e, SmelteryGui.func_146272_n(), fluidToBeBroughtUp));
            }
            base += fluidHeights[i];
        }
    }
}

