/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermaldynamics.block;

import cofh.api.tileentity.IPortableData;
import cofh.api.tileentity.ITileInfo;
import cofh.core.block.TileCoFHBase;
import cofh.core.network.ITileInfoPacketHandler;
import cofh.core.network.ITilePacketHandler;
import cofh.core.network.PacketCoFHBase;
import cofh.core.render.hitbox.CustomHitBox;
import cofh.core.render.hitbox.ICustomHitBox;
import cofh.lib.util.helpers.BlockHelper;
import cofh.lib.util.helpers.ServerHelper;
import cofh.lib.util.position.BlockPosition;
import cofh.repack.codechicken.lib.raytracer.IndexedCuboid6;
import cofh.repack.codechicken.lib.raytracer.RayTracer;
import cofh.repack.codechicken.lib.vec.Cuboid6;
import cofh.repack.codechicken.lib.vec.Vector3;
import cofh.thermaldynamics.block.Attachment;
import cofh.thermaldynamics.block.AttachmentRegistry;
import cofh.thermaldynamics.block.SubTileMultiBlock;
import cofh.thermaldynamics.core.TickHandler;
import cofh.thermaldynamics.duct.BlockDuct;
import cofh.thermaldynamics.duct.Duct;
import cofh.thermaldynamics.duct.TDDucts;
import cofh.thermaldynamics.duct.attachments.cover.Cover;
import cofh.thermaldynamics.duct.attachments.cover.CoverHoleRender;
import cofh.thermaldynamics.duct.attachments.relay.Relay;
import cofh.thermaldynamics.multiblock.IMultiBlock;
import cofh.thermaldynamics.multiblock.MultiBlockFormer;
import cofh.thermaldynamics.multiblock.MultiBlockGrid;
import cofh.thermaldynamics.util.Utils;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.Facing;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class TileTDBase
extends TileCoFHBase
implements IMultiBlock,
ITilePacketHandler,
ICustomHitBox,
ITileInfoPacketHandler,
IPortableData,
ITileInfo {
    public static Cuboid6[] subSelection = new Cuboid6[12];
    public static Cuboid6 selection = new Cuboid6(0.3, 0.3, 0.3, 0.7, 0.7, 0.7);
    public static Cuboid6[] subSelection_large = new Cuboid6[12];
    public static Cuboid6 selectionlarge = new Cuboid6(0.1, 0.1, 0.1, 0.9, 0.9, 0.9);
    public int facadeMask;
    public boolean isValid = true;
    public boolean isNode = false;
    public MultiBlockGrid myGrid;
    public IMultiBlock[] neighborMultiBlocks = new IMultiBlock[ForgeDirection.VALID_DIRECTIONS.length];
    public NeighborTypes[] neighborTypes = new NeighborTypes[]{NeighborTypes.NONE, NeighborTypes.NONE, NeighborTypes.NONE, NeighborTypes.NONE, NeighborTypes.NONE, NeighborTypes.NONE};
    public ConnectionTypes[] connectionTypes = new ConnectionTypes[]{ConnectionTypes.NORMAL, ConnectionTypes.NORMAL, ConnectionTypes.NORMAL, ConnectionTypes.NORMAL, ConnectionTypes.NORMAL, ConnectionTypes.NORMAL, ConnectionTypes.BLOCKED};
    public byte internalSideCounter = 0;
    public Attachment[] attachments = new Attachment[]{null, null, null, null, null, null};
    public Cover[] covers = new Cover[6];
    LinkedList<Attachment> tickingAttachments = new LinkedList();
    public static final SubTileMultiBlock[] blankSubTiles = new SubTileMultiBlock[0];
    public SubTileMultiBlock[] subTiles = blankSubTiles;
    public long lastUpdateTime = -1L;
    public int hashCode = 0;
    public LinkedList<WeakReference<Chunk>> neighbourChunks = new LinkedList();
    Duct duct = null;
    public boolean isOutput = false;
    public boolean isInput = false;

    private static void genSelectionBoxes(Cuboid6[] var0, int var1, double var2, double var4, double var6) {
        var0[var1] = new Cuboid6(var4, 0.0, var4, var6, var2, var6);
        var0[var1 + 1] = new Cuboid6(var4, 1.0 - var2, var4, var6, 1.0, var6);
        var0[var1 + 2] = new Cuboid6(var4, var4, 0.0, var6, var6, var2);
        var0[var1 + 3] = new Cuboid6(var4, var4, 1.0 - var2, var6, var6, 1.0);
        var0[var1 + 4] = new Cuboid6(0.0, var4, var4, var2, var6, var6);
        var0[var1 + 5] = new Cuboid6(1.0 - var2, var4, var4, 1.0, var6, var6);
    }

    public void onChunkUnload() {
        if (ServerHelper.isServerWorld((World)this.field_145850_b)) {
            for (SubTileMultiBlock var4 : this.subTiles) {
                var4.onChunkUnload();
            }
            if (this.myGrid != null) {
                this.tileUnloading();
                this.myGrid.removeBlock(this);
            }
        }
        super.func_145843_s();
    }

    public void tileUnloading() {
    }

    @Override
    public World world() {
        return this.func_145831_w();
    }

    @Override
    public int x() {
        return this.field_145851_c;
    }

    @Override
    public int y() {
        return this.field_145848_d;
    }

    @Override
    public int z() {
        return this.field_145849_e;
    }

    public void func_145843_s() {
        super.func_145843_s();
        if (ServerHelper.isServerWorld((World)this.field_145850_b)) {
            for (SubTileMultiBlock var4 : this.subTiles) {
                var4.invalidate();
            }
            if (this.myGrid != null) {
                this.myGrid.removeBlock(this);
            }
        }
    }

    @Override
    public void setInvalidForForming() {
        this.isValid = false;
    }

    @Override
    public void setValidForForming() {
        this.isValid = true;
    }

    @Override
    public boolean isValidForForming() {
        return this.isValid;
    }

    @Override
    public abstract MultiBlockGrid getNewGrid();

    @Override
    public MultiBlockGrid getGrid() {
        return this.myGrid;
    }

    @Override
    public void setGrid(MultiBlockGrid var1) {
        this.myGrid = var1;
    }

    @Override
    public IMultiBlock getConnectedSide(byte var1) {
        return var1 >= this.neighborMultiBlocks.length ? null : this.neighborMultiBlocks[var1];
    }

    @Override
    public boolean isBlockedSide(int var1) {
        return this.connectionTypes[var1] == ConnectionTypes.BLOCKED || this.attachments[var1] != null && !this.attachments[var1].allowPipeConnection();
    }

    @Override
    public boolean isSideConnected(byte var1) {
        if (var1 >= this.neighborMultiBlocks.length) {
            return false;
        }
        IMultiBlock var2 = this.neighborMultiBlocks[var1];
        return var2 != null && !this.isBlockedSide(var1) && !var2.isBlockedSide(var1 ^ 1);
    }

    @Override
    public void setNotConnected(byte var1) {
        TileEntity var2 = BlockPosition.getAdjacentTileEntity((TileEntity)this, (ForgeDirection)ForgeDirection.getOrientation((int)var1));
        if (this.isSignificantTile(var2, var1)) {
            this.neighborMultiBlocks[var1] = null;
            this.neighborTypes[var1] = NeighborTypes.OUTPUT;
            if (!this.isNode) {
                this.isNode = true;
                if (this.myGrid != null) {
                    this.myGrid.addBlock(this);
                }
            }
        } else if (this.isStructureTile(var2, var1)) {
            this.neighborMultiBlocks[var1] = null;
            this.neighborTypes[var1] = NeighborTypes.STRUCTURE;
        } else {
            this.neighborTypes[var1] = NeighborTypes.NONE;
            this.neighborMultiBlocks[var1] = null;
            this.connectionTypes[var1] = ConnectionTypes.BLOCKED;
        }
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        for (SubTileMultiBlock var6 : this.subTiles) {
            var6.onNeighbourChange();
        }
    }

    public boolean isStructureTile(TileEntity var1, int var2) {
        return false;
    }

    public boolean removeAttachment(Attachment var1) {
        if (var1 == null) {
            return false;
        }
        this.attachments[var1.side] = null;
        this.tickingAttachments.remove(var1);
        this.connectionTypes[var1.side] = ConnectionTypes.NORMAL;
        this.field_145850_b.func_147459_d(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.func_145838_q());
        this.onNeighborBlockChange();
        if (this.myGrid != null) {
            this.myGrid.destroyAndRecreate();
        }
        for (SubTileMultiBlock var5 : this.subTiles) {
            var5.destroyAndRecreate();
        }
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        return true;
    }

    public boolean addAttachment(Attachment var1) {
        if (this.attachments[var1.side] == null && var1.canAddToTile(this)) {
            if (ServerHelper.isClientWorld((World)this.field_145850_b)) {
                return true;
            }
            this.attachments[var1.side] = var1;
            if (var1.doesTick()) {
                this.tickingAttachments.add(var1);
            }
            this.connectionTypes[var1.side] = ConnectionTypes.BLOCKED;
            this.field_145850_b.func_147459_d(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.func_145838_q());
            this.onNeighborBlockChange();
            if (this.myGrid != null) {
                this.myGrid.destroyAndRecreate();
            }
            for (SubTileMultiBlock var5 : this.subTiles) {
                var5.destroyAndRecreate();
            }
            return true;
        }
        return false;
    }

    public void blockPlaced() {
        if (ServerHelper.isServerWorld((World)this.field_145850_b)) {
            TickHandler.addMultiBlockToCalculate(this);
        }
    }

    @Override
    public void onNeighborBlockChange() {
        if (!(ServerHelper.isClientWorld((World)this.field_145850_b) && this.lastUpdateTime == this.field_145850_b.func_82737_E() || this.func_145837_r())) {
            boolean var1 = this.isNode;
            this.isNode = false;
            boolean var2 = this.isInput;
            this.isInput = false;
            boolean var3 = this.isOutput;
            this.isOutput = false;
            for (int var4 = 0; var4 < ForgeDirection.VALID_DIRECTIONS.length; var4 = (int)((byte)(var4 + 1))) {
                this.handleSideUpdate(var4);
            }
            if (this.myGrid != null) {
                if (var1 != this.isNode) {
                    this.myGrid.addBlock(this);
                } else if (this.isOutput != var3 || this.isInput != var2) {
                    this.myGrid.onMajorGridChange();
                }
            }
            for (SubTileMultiBlock var7 : this.subTiles) {
                var7.onNeighbourChange();
            }
            for (Attachment var10 : this.tickingAttachments) {
                var10.postNeighbourChange();
            }
            if (ServerHelper.isServerWorld((World)this.field_145850_b)) {
                this.rebuildChunkCache();
            }
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
    }

    public void handleSideUpdate(int var1) {
        if (this.cachesExist()) {
            this.clearCache(var1);
        }
        this.handleAttachmentUpdate(var1);
        this.handleTileSideUpdate(var1);
    }

    public void handleAttachmentUpdate(int var1) {
        this.neighborTypes[var1] = null;
        if (this.attachments[var1] != null) {
            this.attachments[var1].onNeighborChange();
            this.neighborMultiBlocks[var1] = null;
            this.neighborTypes[var1] = this.attachments[var1].getNeighborType();
            if (this.neighborTypes[var1] == NeighborTypes.MULTIBLOCK) {
                TileEntity var4 = this.getAdjTileEntitySafe(var1);
                if (this.isConnectable(var4, var1) && this.isUnblocked(var4, var1)) {
                    this.neighborMultiBlocks[var1] = (IMultiBlock)var4;
                } else {
                    this.neighborTypes[var1] = NeighborTypes.NONE;
                }
            } else if (this.neighborTypes[var1] == NeighborTypes.OUTPUT) {
                TileEntity var2 = this.getAdjTileEntitySafe(var1);
                if (this.isSignificantTile(var2, var1)) {
                    if (!this.cachesExist()) {
                        this.createCaches();
                    }
                    this.cacheImportant(var2, var1);
                }
                this.isOutput = true;
            } else if (this.neighborTypes[var1] == NeighborTypes.INPUT) {
                TileEntity var3 = this.getAdjTileEntitySafe(var1);
                if (var3 != null) {
                    if (!this.cachesExist()) {
                        this.createCaches();
                    }
                    this.cacheInputTile(var3, var1);
                }
                this.isInput = true;
            } else {
                this.neighborMultiBlocks[var1] = null;
            }
            this.connectionTypes[var1] = ConnectionTypes.NORMAL;
            this.isNode = this.attachments[var1].isNode();
        }
    }

    public void handleTileSideUpdate(int var1) {
        if (this.neighborTypes[var1] == null) {
            TileEntity var2 = this.getAdjTileEntitySafe(var1);
            if (var2 == null) {
                this.neighborMultiBlocks[var1] = null;
                this.neighborTypes[var1] = NeighborTypes.NONE;
                if (this.connectionTypes[var1] != ConnectionTypes.FORCED) {
                    this.connectionTypes[var1] = ConnectionTypes.NORMAL;
                }
            } else if (this.isConnectable(var2, var1) && this.isUnblocked(var2, var1)) {
                this.neighborMultiBlocks[var1] = (IMultiBlock)var2;
                this.neighborTypes[var1] = NeighborTypes.MULTIBLOCK;
            } else if (this.connectionTypes[var1].allowTransfer && this.isSignificantTile(var2, var1)) {
                this.neighborMultiBlocks[var1] = null;
                this.neighborTypes[var1] = NeighborTypes.OUTPUT;
                if (!this.cachesExist()) {
                    this.createCaches();
                }
                this.cacheImportant(var2, var1);
                this.isNode = true;
                this.isOutput = true;
            } else if (this.connectionTypes[var1].allowTransfer && this.isStructureTile(var2, var1)) {
                this.neighborMultiBlocks[var1] = null;
                this.neighborTypes[var1] = NeighborTypes.STRUCTURE;
                if (!this.cachesExist()) {
                    this.createCaches();
                }
                this.cacheStructural(var2, var1);
                this.isNode = true;
            } else {
                this.neighborMultiBlocks[var1] = null;
                this.neighborTypes[var1] = NeighborTypes.NONE;
            }
        }
    }

    public void cacheInputTile(TileEntity var1, int var2) {
    }

    public TileEntity getAdjTileEntitySafe(int var1) {
        return BlockHelper.getAdjacentTileEntity((TileEntity)this, (int)var1);
    }

    public boolean checkForChunkUnload() {
        if (this.neighbourChunks.isEmpty()) {
            return false;
        }
        for (WeakReference weakReference : this.neighbourChunks) {
            Object var3 = weakReference.get();
            if (var3 == null || ((Chunk)var3).field_76636_d) continue;
            this.neighbourChunks.clear();
            this.onNeighborBlockChange();
            return true;
        }
        return false;
    }

    public void rebuildChunkCache() {
        if (!this.neighbourChunks.isEmpty()) {
            this.neighbourChunks.clear();
        }
        if (this.isNode) {
            Chunk var1 = this.field_145850_b.func_72938_d(this.x(), this.y());
            for (int var2 = 0; var2 < 6; var2 = (int)((byte)(var2 + 1))) {
                Chunk var3;
                if (this.neighborTypes[var2] != NeighborTypes.INPUT && this.neighborTypes[var2] != NeighborTypes.OUTPUT || (var3 = this.field_145850_b.func_72938_d(this.x() + Facing.field_71586_b[var2], this.z() + Facing.field_71585_d[var2])) == var1) continue;
                this.neighbourChunks.add(new WeakReference<Chunk>(var3));
            }
        }
    }

    public void cacheStructural(TileEntity var1, int var2) {
    }

    public void onNeighborTileChange(int var1, int var2, int var3) {
        if (!(ServerHelper.isClientWorld((World)this.field_145850_b) && this.lastUpdateTime == this.field_145850_b.func_82737_E() || this.func_145837_r())) {
            int var4 = BlockHelper.determineAdjacentSide((TileEntity)this, (int)var1, (int)var2, (int)var3);
            boolean var5 = this.isNode;
            boolean var6 = this.isInput;
            boolean var7 = this.isOutput;
            this.handleSideUpdate(var4);
            for (SubTileMultiBlock var11 : this.subTiles) {
                var11.onNeighbourChange();
            }
            this.checkIsNode();
            if (var5 != this.isNode && this.myGrid != null) {
                this.myGrid.addBlock(this);
            } else if (this.myGrid != null && (this.isOutput != var7 || this.isInput != var6)) {
                this.myGrid.onMajorGridChange();
            }
            for (Attachment var13 : this.tickingAttachments) {
                var13.postNeighbourChange();
            }
            if (ServerHelper.isServerWorld((World)this.field_145850_b)) {
                this.rebuildChunkCache();
            }
        }
    }

    public void checkIsNode() {
        this.isNode = false;
        for (int var1 = 0; var1 < ForgeDirection.VALID_DIRECTIONS.length; var1 = (int)((byte)(var1 + 1))) {
            if (this.neighborTypes[var1] == NeighborTypes.OUTPUT || this.neighborTypes[var1] == NeighborTypes.STRUCTURE || this.attachments[var1] != null && this.attachments[var1].isNode()) {
                this.isNode = true;
            }
            if (this.neighborTypes[var1] == NeighborTypes.OUTPUT) {
                this.isOutput = true;
            }
            if (this.neighborTypes[var1] != NeighborTypes.INPUT) continue;
            this.isInput = true;
        }
    }

    public void tickInternalSideCounter(int var1) {
        for (int var2 = var1; var2 < this.neighborTypes.length; ++var2) {
            if (this.neighborTypes[var2] != NeighborTypes.OUTPUT || this.connectionTypes[var2] != ConnectionTypes.NORMAL) continue;
            this.internalSideCounter = (byte)var2;
            return;
        }
        for (int var3 = 0; var3 < var1; ++var3) {
            if (this.neighborTypes[var3] != NeighborTypes.OUTPUT || this.connectionTypes[var3] != ConnectionTypes.NORMAL) continue;
            this.internalSideCounter = (byte)var3;
            return;
        }
    }

    public boolean isConnectable(TileEntity var1, int var2) {
        return var1 instanceof TileTDBase;
    }

    public boolean isUnblocked(TileEntity var1, int var2) {
        return !this.isBlockedSide(var2) && !((TileTDBase)var1).isBlockedSide(var2 ^ 1);
    }

    public boolean isSignificantTile(TileEntity var1, int var2) {
        return false;
    }

    public String getName() {
        return "tile.thermaldynamics.multiblock.name";
    }

    public int getType() {
        return 0;
    }

    @Override
    public void tickMultiBlock() {
        if (!this.func_145837_r()) {
            this.onNeighborBlockChange();
            this.formGrid();
            for (SubTileMultiBlock var4 : this.subTiles) {
                var4.onNeighbourChange();
                var4.formGrid();
            }
        }
    }

    public void formGrid() {
        if (this.myGrid == null && ServerHelper.isServerWorld((World)this.field_145850_b)) {
            new MultiBlockFormer().formGrid(this);
        }
    }

    @Override
    public boolean tickPass(int var1) {
        if (this.checkForChunkUnload()) {
            return false;
        }
        if (!this.tickingAttachments.isEmpty()) {
            for (Attachment var3 : this.tickingAttachments) {
                var3.tick(var1);
            }
        }
        return true;
    }

    @Override
    public boolean isNode() {
        return this.isNode;
    }

    @Override
    public boolean existsYet() {
        return this.field_145850_b != null && this.field_145850_b.func_72899_e(this.field_145851_c, this.field_145848_d, this.field_145849_e) && this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d, this.field_145849_e) instanceof BlockDuct;
    }

    @Override
    public IMultiBlock[] getSubTiles() {
        return this.subTiles;
    }

    public void func_145839_a(NBTTagCompound var1) {
        super.func_145839_a(var1);
        for (byte var2 = 0; var2 < 6; var2 = (byte)(var2 + 1)) {
            if (var1.func_150297_b("attachment" + var2, 10)) {
                NBTTagCompound var3 = var1.func_74775_l("attachment" + var2);
                short var4 = var3.func_74765_d("id");
                this.attachments[var2] = AttachmentRegistry.createAttachment(this, var2, var4);
                if (this.attachments[var2] != null) {
                    this.attachments[var2].readFromNBT(var3);
                    if (this.attachments[var2].doesTick()) {
                        this.tickingAttachments.add(this.attachments[var2]);
                    }
                }
            } else {
                this.attachments[var2] = null;
            }
            if (var1.func_150297_b("facade" + var2, 10)) {
                NBTTagCompound var6 = var1.func_74775_l("facade" + var2);
                this.covers[var2] = new Cover(this, var2);
                this.covers[var2].readFromNBT(var6);
            } else {
                this.covers[var2] = null;
            }
            this.connectionTypes[var2] = ConnectionTypes.values()[var1.func_74771_c("conTypes" + var2)];
        }
        this.recalcFacadeMask();
        for (int var5 = 0; var5 < this.subTiles.length; ++var5) {
            this.subTiles[var5].readFromNBT(var1.func_74775_l("subTile" + var5));
        }
        TickHandler.addMultiBlockToCalculate(this);
    }

    public void func_145841_b(NBTTagCompound var1) {
        super.func_145841_b(var1);
        for (int var2 = 0; var2 < 6; ++var2) {
            if (this.attachments[var2] != null) {
                NBTTagCompound var3 = new NBTTagCompound();
                var3.func_74777_a("id", (short)this.attachments[var2].getId());
                this.attachments[var2].writeToNBT(var3);
                var1.func_74782_a("attachment" + var2, (NBTBase)var3);
            }
            if (this.covers[var2] != null) {
                NBTTagCompound var6 = new NBTTagCompound();
                this.covers[var2].writeToNBT(var6);
                var1.func_74782_a("facade" + var2, (NBTBase)var6);
            }
            var1.func_74774_a("conTypes" + var2, (byte)this.connectionTypes[var2].ordinal());
        }
        for (int var5 = 0; var5 < this.subTiles.length; ++var5) {
            SubTileMultiBlock var7 = this.subTiles[var5];
            NBTTagCompound var4 = new NBTTagCompound();
            var7.writeToNBT(var4);
            var1.func_74782_a("subTile" + var5, (NBTBase)var4);
        }
    }

    public boolean openGui(EntityPlayer var1) {
        MovingObjectPosition var2 = RayTracer.retraceBlock((World)this.field_145850_b, (EntityPlayer)var1, (int)this.field_145851_c, (int)this.field_145848_d, (int)this.field_145849_e);
        if (var2 == null) {
            return false;
        }
        int var3 = var2.subHit;
        return var3 > 13 && var3 < 20 ? this.attachments[var3 - 14].openGui(var1) : super.openGui(var1);
    }

    public Duct getDuctType() {
        if (this.duct == null) {
            Block b = this.func_145838_q();
            if (b instanceof BlockDuct) {
                this.duct = TDDucts.getDuct(((BlockDuct)b).offset + this.func_145832_p());
            } else {
                this.func_145843_s();
                this.duct = TDDucts.getDuct(0);
            }
        }
        return this.duct;
    }

    public void addTraceableCuboids(List<IndexedCuboid6> var1) {
        if (!this.getDuctType().isLargeTube()) {
            this.addTraceableCuboids(var1, selection, subSelection);
        } else {
            this.addTraceableCuboids(var1, selectionlarge, subSelection_large);
        }
    }

    public void addTraceableCuboids(List<IndexedCuboid6> var1, Cuboid6 var2, Cuboid6[] var3) {
        Vector3 var4 = new Vector3((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e);
        for (int var5 = 0; var5 < 6; ++var5) {
            if (this.attachments[var5] != null) {
                var1.add(new IndexedCuboid6((Object)(var5 + 14), this.attachments[var5].getCuboid().add(var4)));
                if (this.neighborTypes[var5] != NeighborTypes.NONE) {
                    var1.add(new IndexedCuboid6((Object)(var5 + 14), var3[var5 + 6].copy().add(var4)));
                }
            }
            if (this.covers[var5] != null) {
                var1.add(new IndexedCuboid6((Object)(var5 + 20), this.covers[var5].getCuboid().add(var4)));
            }
            if (this.neighborTypes[var5] == NeighborTypes.OUTPUT) {
                var1.add(new IndexedCuboid6((Object)var5, var3[var5].copy().add(var4)));
                continue;
            }
            if (this.neighborTypes[var5] == NeighborTypes.MULTIBLOCK) {
                var1.add(new IndexedCuboid6((Object)(var5 + 6), var3[var5 + 6].copy().add(var4)));
                continue;
            }
            if (this.neighborTypes[var5] != NeighborTypes.STRUCTURE) continue;
            var1.add(new IndexedCuboid6((Object)var5, var3[var5 + 6].copy().add(var4)));
        }
        var1.add(new IndexedCuboid6((Object)13, var2.copy().add(var4)));
    }

    public boolean onWrench(EntityPlayer var1, int var2) {
        if (Utils.isHoldingUsableWrench(var1, this.field_145851_c, this.field_145848_d, this.field_145849_e)) {
            MovingObjectPosition var3 = RayTracer.retraceBlock((World)this.field_145850_b, (EntityPlayer)var1, (int)this.field_145851_c, (int)this.field_145848_d, (int)this.field_145849_e);
            if (var3 == null) {
                return false;
            }
            int var4 = var3.subHit;
            if (var4 >= 0 && var4 <= 13) {
                int var5 = var4 == 13 ? var2 : (var4 < 6 ? var4 : var4 - 6);
                this.onNeighborBlockChange();
                this.connectionTypes[var5] = this.connectionTypes[var5].next();
                TileEntity var6 = BlockHelper.getAdjacentTileEntity((TileEntity)this, (int)var5);
                if (this.isConnectable(var6, var5)) {
                    ((TileTDBase)var6).connectionTypes[var5 ^ 1] = this.connectionTypes[var5];
                }
                this.field_145850_b.func_147459_d(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.func_145838_q());
                if (this.myGrid != null) {
                    this.myGrid.destroyAndRecreate();
                }
                for (SubTileMultiBlock var10 : this.subTiles) {
                    var10.destroyAndRecreate();
                }
                this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                return true;
            }
            if (var4 > 13 && var4 < 20) {
                return this.attachments[var4 - 14].onWrenched();
            }
            if (var4 >= 20 && var4 < 26) {
                return this.covers[var4 - 20].onWrenched();
            }
        }
        return false;
    }

    public void doDebug(EntityPlayer var1) {
    }

    public boolean addFacade(Cover var1) {
        if (this.covers[var1.side] != null) {
            return false;
        }
        this.covers[var1.side] = var1;
        this.recalcFacadeMask();
        this.func_145831_w().func_147459_d(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.func_145838_q());
        this.onNeighborBlockChange();
        this.func_145831_w().func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        return true;
    }

    public void removeFacade(Cover var1) {
        this.covers[var1.side] = null;
        this.recalcFacadeMask();
        this.func_145831_w().func_147459_d(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.func_145838_q());
        this.onNeighborBlockChange();
        this.func_145831_w().func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public void recalcFacadeMask() {
        this.facadeMask = 0;
        for (int var1 = 0; var1 < 6; var1 = (int)((byte)(var1 + 1))) {
            if (this.covers[var1] == null) continue;
            this.facadeMask |= 1 << var1;
        }
    }

    public PacketCoFHBase getPacket() {
        PacketCoFHBase var1 = super.getPacket();
        int var2 = 0;
        this.recalcFacadeMask();
        for (int var3 = 0; var3 < this.neighborTypes.length; var3 = (int)((byte)(var3 + 1))) {
            var1.addByte(this.neighborTypes[var3].ordinal());
            var1.addByte(this.connectionTypes[var3].ordinal());
            if (this.attachments[var3] == null) continue;
            var2 |= 1 << var3;
        }
        var1.addBool(this.isNode);
        var1.addByte(var2);
        for (int var4 = 0; var4 < 6; var4 = (int)((byte)(var4 + 1))) {
            if (this.attachments[var4] == null) continue;
            var1.addByte(this.attachments[var4].getId());
            this.attachments[var4].addDescriptionToPacket(var1);
        }
        var1.addByte(this.facadeMask);
        for (int var5 = 0; var5 < 6; var5 = (int)((byte)(var5 + 1))) {
            if (this.covers[var5] == null) continue;
            this.covers[var5].addDescriptionToPacket(var1);
        }
        var1.addInt(this.myGrid == null ? 0 : this.myGrid.hashCode());
        return var1;
    }

    public void handleTileInfoPacket(PacketCoFHBase var1, boolean var2, EntityPlayer var3) {
        byte var4 = var1.getByte();
        if (var4 == 0) {
            this.handleInfoPacket(var1, var2, var3);
        } else if (var4 >= 1 && var4 <= 6) {
            this.attachments[var4 - 1].handleInfoPacket(var1, var2, var3);
        }
    }

    public void handleInfoPacket(PacketCoFHBase var1, boolean var2, EntityPlayer var3) {
    }

    public abstract boolean cachesExist();

    public abstract void createCaches();

    public abstract void cacheImportant(TileEntity var1, int var2);

    public abstract void clearCache(int var1);

    public void handleTilePacket(PacketCoFHBase var1, boolean var2) {
        if (!var2) {
            for (int var3 = 0; var3 < this.neighborTypes.length; var3 = (int)((byte)(var3 + 1))) {
                this.neighborTypes[var3] = NeighborTypes.values()[var1.getByte()];
                this.connectionTypes[var3] = ConnectionTypes.values()[var1.getByte()];
            }
            this.isNode = var1.getBool();
            byte var5 = var1.getByte();
            for (byte var4 = 0; var4 < 6; var4 = (byte)(var4 + 1)) {
                if ((var5 & 1 << var4) != 0) {
                    this.attachments[var4] = AttachmentRegistry.createAttachment(this, var4, var1.getByte());
                    this.attachments[var4].getDescriptionFromPacket(var1);
                    continue;
                }
                this.attachments[var4] = null;
            }
            this.facadeMask = var1.getByte();
            for (byte var6 = 0; var6 < 6; var6 = (byte)(var6 + 1)) {
                if ((this.facadeMask & 1 << var6) != 0) {
                    this.covers[var6] = new Cover(this, var6);
                    this.covers[var6].getDescriptionFromPacket(var1);
                    continue;
                }
                this.covers[var6] = null;
            }
            this.recalcFacadeMask();
            this.hashCode = var1.getInt();
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            this.lastUpdateTime = this.field_145850_b.func_82737_E();
        }
    }

    public BlockDuct.ConnectionTypes getRenderConnectionType(int var1) {
        return this.attachments[var1] != null ? this.attachments[var1].getRenderConnectionType() : TileTDBase.getDefaultConnectionType(this.neighborTypes[var1], this.connectionTypes[var1]);
    }

    public static BlockDuct.ConnectionTypes getDefaultConnectionType(NeighborTypes var0, ConnectionTypes var1) {
        return var0 == NeighborTypes.STRUCTURE ? BlockDuct.ConnectionTypes.STRUCTURE : (var0 == NeighborTypes.INPUT ? BlockDuct.ConnectionTypes.DUCT : (var0 == NeighborTypes.NONE ? (var1 == ConnectionTypes.FORCED ? BlockDuct.ConnectionTypes.DUCT : BlockDuct.ConnectionTypes.NONE) : (var1 != ConnectionTypes.BLOCKED && var1 != ConnectionTypes.REJECTED ? (var0 == NeighborTypes.OUTPUT ? BlockDuct.ConnectionTypes.TILECONNECTION : BlockDuct.ConnectionTypes.DUCT) : BlockDuct.ConnectionTypes.NONE)));
    }

    public void randomDisplayTick() {
    }

    public boolean canUpdate() {
        return false;
    }

    public boolean renderAdditional(int var1, int[] var2, int var3) {
        return false;
    }

    public boolean isSubNode() {
        return false;
    }

    public IIcon getBaseIcon() {
        return this.getDuctType().iconBaseTexture;
    }

    public ItemStack getDrop() {
        return new ItemStack(this.func_145838_q(), 1, this.func_145832_p());
    }

    public void onPlacedBy(EntityLivingBase var1, ItemStack var2) {
    }

    public void dropAdditional(ArrayList<ItemStack> var1) {
    }

    @SideOnly(value=Side.CLIENT)
    public CoverHoleRender.ITransformer[] getHollowMask(byte var1) {
        BlockDuct.ConnectionTypes var2 = this.getRenderConnectionType(var1);
        return var2 == BlockDuct.ConnectionTypes.TILECONNECTION ? CoverHoleRender.hollowDuctTile : (var2 == BlockDuct.ConnectionTypes.NONE ? null : CoverHoleRender.hollowDuct);
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return AxisAlignedBB.func_72330_a((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, (double)(this.field_145851_c + 1), (double)(this.field_145848_d + 1), (double)(this.field_145849_e + 1));
    }

    public String getDataType() {
        return "tile.thermaldynamics.duct";
    }

    public void cofh_invalidate() {
        this.markChunkDirty();
    }

    @Override
    public void addRelays() {
        for (Attachment var4 : this.attachments) {
            if (var4 == null) continue;
            if (var4.getId() == 7) {
                Relay var5 = (Relay)var4;
                if (var5.isInput()) {
                    this.myGrid.addSignalInput(var5);
                    continue;
                }
                this.myGrid.addSignalOutput(var4);
                continue;
            }
            if (!var4.respondsToSignallum()) continue;
            this.myGrid.addSignalOutput(var4);
        }
    }

    public boolean shouldRenderCustomHitBox(int var1, EntityPlayer var2) {
        return var1 == 13 || var1 > 5 && var1 < 13 && !Utils.isHoldingUsableWrench(var2, this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public CustomHitBox getCustomHitBox(int var1, EntityPlayer var2) {
        double var3 = this.getDuctType().isLargeTube() ? 0.075 : 0.3;
        double var5 = 1.0 - var3 * 2.0;
        CustomHitBox var7 = new CustomHitBox(var5, var5, var5, (double)this.field_145851_c + var3, (double)this.field_145848_d + var3, (double)this.field_145849_e + var3);
        for (int var8 = 0; var8 < this.neighborTypes.length; ++var8) {
            if (this.neighborTypes[var8] == NeighborTypes.MULTIBLOCK) {
                var7.drawSide(var8, true);
                var7.setSideLength(var8, var3);
                continue;
            }
            if (this.neighborTypes[var8] == NeighborTypes.NONE) continue;
            var7.drawSide(var8, true);
            var7.setSideLength(var8, 0.04);
        }
        return var7;
    }

    public void readPortableData(EntityPlayer var1, NBTTagCompound var2) {
        int var4;
        MovingObjectPosition var3;
        if (var2.func_150297_b("AttachmentType", 8) && (var3 = RayTracer.retraceBlock((World)this.field_145850_b, (EntityPlayer)var1, (int)this.field_145851_c, (int)this.field_145848_d, (int)this.field_145849_e)) != null && (var4 = var3.subHit) > 13 && var4 < 20 && this.attachments[var4 - 14] instanceof IPortableData) {
            IPortableData var5 = (IPortableData)this.attachments[var4 - 14];
            if (var2.func_74779_i("AttachmentType").equals(var5.getDataType())) {
                var5.readPortableData(var1, var2);
            }
        }
    }

    public void writePortableData(EntityPlayer var1, NBTTagCompound var2) {
        int var4;
        MovingObjectPosition var3 = RayTracer.retraceBlock((World)this.field_145850_b, (EntityPlayer)var1, (int)this.field_145851_c, (int)this.field_145848_d, (int)this.field_145849_e);
        if (var3 != null && (var4 = var3.subHit) > 13 && var4 < 20 && this.attachments[var4 - 14] instanceof IPortableData) {
            IPortableData var5 = (IPortableData)this.attachments[var4 - 14];
            var5.writePortableData(var1, var2);
            if (!var2.func_82582_d()) {
                var2.func_74778_a("AttachmentType", var5.getDataType());
            }
        }
    }

    public void getTileInfo(List<IChatComponent> var1, ForgeDirection var2, EntityPlayer var3, boolean var4) {
        Attachment var10;
        MultiBlockGrid var5 = this.getGrid();
        if (var5 != null) {
            var1.add((IChatComponent)new ChatComponentTranslation("info.thermaldynamics.info.duct", new Object[0]));
            var5.addInfo(var1, var3, var4);
            if (this.subTiles.length != 0) {
                for (SubTileMultiBlock var9 : this.subTiles) {
                    if (var9.grid == null) continue;
                    var9.grid.addInfo(var1, var3, var4);
                }
            }
        }
        if ((var10 = this.getAttachmentSelected(var3)) != null) {
            var1.add((IChatComponent)new ChatComponentTranslation("info.thermaldynamics.info.attachment", new Object[0]));
            int var11 = var1.size();
            var10.addInfo(var1, var3, var4);
            if (var1.size() == var11) {
                var1.remove(var11 - 1);
            }
        }
    }

    public Attachment getAttachmentSelected(EntityPlayer var1) {
        MovingObjectPosition var2 = RayTracer.retraceBlock((World)this.field_145850_b, (EntityPlayer)var1, (int)this.field_145851_c, (int)this.field_145848_d, (int)this.field_145849_e);
        if (var2 == null) {
            return null;
        }
        int var3 = var2.subHit;
        return var3 > 13 && var3 < 20 ? this.attachments[var3 - 14] : (var3 >= 20 && var3 < 26 ? this.covers[var3 - 20] : null);
    }

    public Object getConfigGuiServer(InventoryPlayer var1) {
        return null;
    }

    public Object getConfigGuiClient(InventoryPlayer var1) {
        return null;
    }

    static {
        GameRegistry.registerTileEntityWithAlternatives(TileTDBase.class, (String)"thermaldynamics.Duct", (String[])new String[]{"thermaldynamics.multiblock"});
        TileTDBase.genSelectionBoxes(subSelection, 0, 0.25, 0.2, 0.8);
        TileTDBase.genSelectionBoxes(subSelection, 6, 0.3, 0.3, 0.7);
        TileTDBase.genSelectionBoxes(subSelection_large, 0, 0.1, 0.1, 0.9);
        TileTDBase.genSelectionBoxes(subSelection_large, 6, 0.1, 0.1, 0.9);
    }

    public static enum NeighborTypes {
        NONE,
        MULTIBLOCK,
        OUTPUT(true),
        INPUT(true),
        STRUCTURE(true),
        DUCT_ATTACHMENT;

        public final boolean attachedToNeightbour;

        private NeighborTypes() {
            this(false);
        }

        private NeighborTypes(boolean var3) {
            this.attachedToNeightbour = var3;
        }
    }

    public static enum ConnectionTypes {
        NORMAL(true),
        ONEWAY(true),
        REJECTED(false),
        BLOCKED(false),
        FORCED(true);

        public final boolean allowTransfer;

        private ConnectionTypes(boolean var3) {
            this.allowTransfer = var3;
        }

        public ConnectionTypes next() {
            return this == NORMAL ? BLOCKED : NORMAL;
        }
    }
}

