/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermaldynamics.render.item;

import cofh.core.render.RenderUtils;
import cofh.lib.render.RenderHelper;
import cofh.repack.codechicken.lib.render.CCRenderState;
import cofh.thermaldynamics.duct.attachments.cover.Cover;
import cofh.thermaldynamics.duct.attachments.cover.CoverHelper;
import cofh.thermaldynamics.duct.attachments.cover.CoverRenderer;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.common.util.ForgeDirection;
import org.lwjgl.opengl.GL11;

public class RenderItemCover
implements IItemRenderer {
    public static IItemRenderer instance = new RenderItemCover();

    public boolean handleRenderType(ItemStack var1, IItemRenderer.ItemRenderType var2) {
        return true;
    }

    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType var1, ItemStack var2, IItemRenderer.ItemRendererHelper var3) {
        return true;
    }

    public void renderItem(IItemRenderer.ItemRenderType renderType, ItemStack stack, Object ... args) {
        NBTTagCompound nbt = stack.func_77978_p();
        if (nbt != null && nbt.func_150297_b("Meta", 1) && nbt.func_150297_b("Block", 8)) {
            byte meta = nbt.func_74771_c("Meta");
            Block block = Block.func_149684_b((String)nbt.func_74779_i("Block"));
            if (block == null) {
                block = Blocks.field_150350_a;
            }
            if (block == Blocks.field_150350_a || meta < 0 || meta >= 16 || !CoverHelper.isValid(block, meta)) {
                nbt.func_82580_o("Meta");
                nbt.func_82580_o("Block");
                if (nbt.func_82582_d()) {
                    stack.func_77982_d(null);
                }
            }
            GL11.glPushMatrix();
            double d = -0.5;
            if (renderType != IItemRenderer.ItemRenderType.EQUIPPED && renderType != IItemRenderer.ItemRenderType.EQUIPPED_FIRST_PERSON) {
                if (renderType == IItemRenderer.ItemRenderType.ENTITY) {
                    GL11.glScaled((double)0.5, (double)0.5, (double)0.5);
                }
            } else {
                d = 0.0;
            }
            RenderHelper.setBlockTextureSheet();
            RenderUtils.preItemRender();
            RenderHelper.enableGUIStandardItemLighting();
            CCRenderState.startDrawing();
            GL11.glTranslated((double)d, (double)(d - 128.0), (double)d);
            SingleBlockAccess.instance.block = block;
            SingleBlockAccess.instance.meta = meta;
            CoverRenderer.renderBlocks.field_147845_a = SingleBlockAccess.instance;
            Tessellator.field_78398_a.func_78375_b(0.0f, 1.0f, 0.0f);
            ForgeDirection direction = renderType == IItemRenderer.ItemRenderType.EQUIPPED_FIRST_PERSON ? ForgeDirection.WEST : ForgeDirection.SOUTH;
            GL11.glTranslated((double)((double)(-direction.offsetX) * 0.5), (double)((double)(-direction.offsetY) * 0.5), (double)((double)(-direction.offsetZ) * 0.5));
            for (int pass = 0; pass < 2; ++pass) {
                if (!block.canRenderInPass(pass)) continue;
                CoverRenderer.renderCover(CoverRenderer.renderBlocks, 0, 128, 0, direction.ordinal(), block, meta, Cover.bounds[direction.ordinal()], true, false, null);
            }
            CCRenderState.draw();
            CCRenderState.useNormals = false;
            RenderHelper.setItemTextureSheet();
            RenderUtils.postItemRender();
            net.minecraft.client.renderer.RenderHelper.func_74519_b();
            GL11.glPopMatrix();
        }
    }

    public static class SingleBlockAccess
    implements IBlockAccess {
        public static SingleBlockAccess instance = new SingleBlockAccess();
        public Block block;
        public int meta;

        public boolean isLoc(int var1, int var2, int var3) {
            return var1 == 0 && var2 == 128 && var3 == 0;
        }

        public SingleBlockAccess() {
        }

        public SingleBlockAccess(Block var1, int var2) {
            this.block = var1;
            this.meta = var2;
        }

        public Block func_147439_a(int var1, int var2, int var3) {
            return this.isLoc(var1, var2, var3) ? this.block : Blocks.field_150350_a;
        }

        public TileEntity func_147438_o(int var1, int var2, int var3) {
            return null;
        }

        public int func_72802_i(int var1, int var2, int var3, int var4) {
            return 0xF000F0;
        }

        public int func_72805_g(int var1, int var2, int var3) {
            return this.isLoc(var1, var2, var3) ? this.meta : 0;
        }

        public int func_72879_k(int var1, int var2, int var3, int var4) {
            return 0;
        }

        public boolean func_147437_c(int var1, int var2, int var3) {
            return this.isLoc(var1, var2, var3);
        }

        public BiomeGenBase func_72807_a(int var1, int var2) {
            return BiomeGenBase.field_76772_c;
        }

        public int func_72800_K() {
            return 140;
        }

        public boolean func_72806_N() {
            return false;
        }

        public boolean isSideSolid(int var1, int var2, int var3, ForgeDirection var4, boolean var5) {
            return this.isLoc(var1, var2, var3) && this.block.isSideSolid((IBlockAccess)this, var1, var2, var3, var4);
        }
    }
}

