/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.block.cell;

import cofh.api.energy.IEnergyContainerItem;
import cofh.api.tileentity.IRedstoneControl;
import cofh.core.item.ItemBlockBase;
import cofh.lib.util.helpers.EnergyHelper;
import cofh.lib.util.helpers.ItemHelper;
import cofh.lib.util.helpers.MathHelper;
import cofh.lib.util.helpers.RedstoneControlHelper;
import cofh.lib.util.helpers.SecurityHelper;
import cofh.lib.util.helpers.StringHelper;
import cofh.thermalexpansion.block.cell.BlockCell;
import cofh.thermalexpansion.block.cell.TileCell;
import cofh.thermalexpansion.block.cell.TileCellCreative;
import cofh.thermalexpansion.util.helpers.ReconfigurableHelper;
import com.gamerforea.cofh.EventConfig;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.ItemStack;

public class ItemBlockCell
extends ItemBlockBase
implements IEnergyContainerItem {
    public static ItemStack setDefaultTag(ItemStack var0, int var1) {
        ReconfigurableHelper.setFacing(var0, 3);
        ReconfigurableHelper.setSideCache(var0, ItemHelper.getItemDamage((ItemStack)var0) == BlockCell.Types.CREATIVE.ordinal() ? TileCellCreative.DEFAULT_SIDES : TileCell.DEFAULT_SIDES);
        RedstoneControlHelper.setControl((ItemStack)var0, (IRedstoneControl.ControlMode)IRedstoneControl.ControlMode.LOW);
        EnergyHelper.setDefaultEnergyTag((ItemStack)var0, (int)var1);
        var0.field_77990_d.func_74768_a("Send", TileCell.MAX_SEND[var0.func_77960_j()]);
        var0.field_77990_d.func_74768_a("Recv", TileCell.MAX_RECEIVE[var0.func_77960_j()]);
        return var0;
    }

    public ItemBlockCell(Block var1) {
        super(var1);
        this.func_77627_a(true);
        if (EventConfig.fixMaxDamage) {
            this.func_77656_e(0);
        } else {
            this.func_77656_e(1);
        }
        this.func_77625_d(1);
        this.setNoRepair();
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return stack.func_77960_j() != BlockCell.Types.CREATIVE.ordinal();
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return MathHelper.clamp((double)(1.0 - (double)this.getEnergyStored(stack) / (double)this.getMaxEnergyStored(stack)), (double)0.0, (double)1.0);
    }

    public boolean isRepairable() {
        return false;
    }

    public boolean func_82789_a(ItemStack stack1, ItemStack stack2) {
        return false;
    }

    public String func_77667_c(ItemStack var1) {
        return "tile.thermalexpansion.cell." + BlockCell.NAMES[ItemHelper.getItemDamage((ItemStack)var1)] + ".name";
    }

    public int getDisplayDamage(ItemStack var1) {
        return var1.field_77990_d == null ? TileCell.CAPACITY[ItemHelper.getItemDamage((ItemStack)var1)] : TileCell.CAPACITY[ItemHelper.getItemDamage((ItemStack)var1)] - var1.field_77990_d.func_74762_e("Energy");
    }

    public int getMaxDamage(ItemStack stack) {
        if (EventConfig.fixMaxDamage) {
            return super.getMaxDamage(stack);
        }
        return TileCell.CAPACITY[ItemHelper.getItemDamage((ItemStack)stack)];
    }

    public boolean isDamaged(ItemStack var1) {
        return ItemHelper.getItemDamage((ItemStack)var1) != BlockCell.Types.CREATIVE.ordinal();
    }

    public EnumRarity func_77613_e(ItemStack var1) {
        switch (BlockCell.Types.values()[ItemHelper.getItemDamage((ItemStack)var1)]) {
            case CREATIVE: {
                return EnumRarity.epic;
            }
            case RESONANT: {
                return EnumRarity.rare;
            }
            case REINFORCED: {
                return EnumRarity.uncommon;
            }
        }
        return EnumRarity.common;
    }

    public void func_77624_a(ItemStack var1, EntityPlayer var2, List var3, boolean var4) {
        if (var1.field_77990_d == null) {
            ItemBlockCell.setDefaultTag(var1, 0);
        }
        SecurityHelper.addOwnerInformation((ItemStack)var1, (List)var3);
        if (StringHelper.displayShiftForDetail && !StringHelper.isShiftKeyDown()) {
            var3.add(StringHelper.shiftForDetails());
        }
        if (StringHelper.isShiftKeyDown()) {
            SecurityHelper.addAccessInformation((ItemStack)var1, (List)var3);
            if (ItemHelper.getItemDamage((ItemStack)var1) == BlockCell.Types.CREATIVE.ordinal()) {
                var3.add(StringHelper.localize((String)"info.cofh.charge") + ": 1.21G RF");
            } else {
                var3.add(StringHelper.localize((String)"info.cofh.charge") + ": " + StringHelper.getScaledNumber((long)var1.field_77990_d.func_74762_e("Energy")) + " / " + StringHelper.getScaledNumber((long)TileCell.CAPACITY[ItemHelper.getItemDamage((ItemStack)var1)]) + " RF");
            }
            var3.add(StringHelper.localize((String)"info.cofh.send") + "/" + StringHelper.localize((String)"info.cofh.receive") + ": " + var1.field_77990_d.func_74762_e("Send") + "/" + var1.field_77990_d.func_74762_e("Recv") + " RF/t");
            RedstoneControlHelper.addRSControlInformation((ItemStack)var1, (List)var3);
        }
    }

    public int receiveEnergy(ItemStack var1, int var2, boolean var3) {
        int var4;
        if (var1.field_77990_d == null) {
            ItemBlockCell.setDefaultTag(var1, 0);
        }
        if ((var4 = ItemHelper.getItemDamage((ItemStack)var1)) == BlockCell.Types.CREATIVE.ordinal()) {
            return 0;
        }
        int var5 = var1.field_77990_d.func_74762_e("Energy");
        int var6 = Math.min(var2, Math.min(TileCell.CAPACITY[var4] - var5, TileCell.MAX_RECEIVE[var4]));
        if (!var3) {
            var1.field_77990_d.func_74768_a("Energy", var5 += var6);
        }
        return var6;
    }

    public int extractEnergy(ItemStack var1, int var2, boolean var3) {
        int var4;
        if (var1.field_77990_d == null) {
            ItemBlockCell.setDefaultTag(var1, 0);
        }
        if ((var4 = ItemHelper.getItemDamage((ItemStack)var1)) == BlockCell.Types.CREATIVE.ordinal()) {
            return var2;
        }
        int var5 = var1.field_77990_d.func_74762_e("Energy");
        int var6 = Math.min(var2, Math.min(var5, TileCell.MAX_SEND[var4]));
        if (!var3) {
            var1.field_77990_d.func_74768_a("Energy", var5 -= var6);
        }
        return var6;
    }

    public int getEnergyStored(ItemStack var1) {
        if (var1.field_77990_d == null) {
            ItemBlockCell.setDefaultTag(var1, 0);
        }
        return var1.field_77990_d.func_74762_e("Energy");
    }

    public int getMaxEnergyStored(ItemStack var1) {
        return TileCell.CAPACITY[ItemHelper.getItemDamage((ItemStack)var1)];
    }
}

