/*
 * Decompiled with CFR 0.152.
 */
package tterrag.wailaplugins.plugins;

import com.enderio.core.common.util.BlockCoord;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.ICoverable;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.BaseMetaPipeEntity;
import gregtech.api.metatileentity.BaseMetaTileEntity;
import gregtech.api.metatileentity.BaseTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_BasicBatteryBuffer;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_BasicMachine;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_MultiBlockBase;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Transformer;
import gregtech.api.util.GT_Utility;
import gregtech.common.covers.GT_Cover_Fluidfilter;
import gregtech.common.tileentities.boilers.GT_MetaTileEntity_Boiler_Solar;
import gregtech.common.tileentities.machines.multi.GT_MetaTileEntity_HeatExchanger;
import gregtech.common.tileentities.machines.multi.GT_MetaTileEntity_LargeBoiler;
import gregtech.common.tileentities.machines.multi.GT_MetaTileEntity_PrimitiveBlastFurnace;
import gregtech.common.tileentities.machines.multi.pumps.GT_MetaTileEntity_WaterPumpPrimitive;
import java.util.List;
import mcp.mobius.waila.api.IWailaDataAccessor;
import mcp.mobius.waila.api.IWailaRegistrar;
import mcp.mobius.waila.api.SpecialChars;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import tterrag.wailaplugins.api.Plugin;
import tterrag.wailaplugins.plugins.PluginBase;

@Plugin(name="Gregtech5U", deps={"gregtech"})
public class PluginGregtech5U
extends PluginBase {
    @Override
    public void load(IWailaRegistrar registrar) {
        super.load(registrar);
        this.addConfig("machineFacing");
        this.addConfig("transformer");
        this.addConfig("solar");
        this.addConfig("basicmachine");
        this.addConfig("multiblock");
        this.addConfig("fluidfilter");
        this.addConfig("pblastfurnace");
        this.registerBody(BaseTileEntity.class);
        this.registerNBT(BaseTileEntity.class);
    }

    @Override
    protected void getBody(ItemStack stack, List<String> currenttip, IWailaDataAccessor accessor) {
        String filterKey;
        boolean allowedToWork;
        TileEntity tile = accessor.getTileEntity();
        MovingObjectPosition pos = accessor.getPosition();
        NBTTagCompound tag = accessor.getNBTData();
        byte side = (byte)accessor.getSide().ordinal();
        IGregTechTileEntity tBaseMetaTile = tile instanceof IGregTechTileEntity ? (IGregTechTileEntity)tile : null;
        IMetaTileEntity tMeta = tBaseMetaTile != null ? tBaseMetaTile.getMetaTileEntity() : null;
        BaseMetaTileEntity mBaseMetaTileEntity = tile instanceof BaseMetaTileEntity ? (BaseMetaTileEntity)tile : null;
        GT_MetaTileEntity_BasicMachine BasicMachine = tMeta instanceof GT_MetaTileEntity_BasicMachine ? (GT_MetaTileEntity_BasicMachine)tMeta : null;
        GT_MetaTileEntity_MultiBlockBase multiBlockBase = tMeta instanceof GT_MetaTileEntity_MultiBlockBase ? (GT_MetaTileEntity_MultiBlockBase)tMeta : null;
        GT_MetaTileEntity_BasicBatteryBuffer bateryBuffer = tMeta instanceof GT_MetaTileEntity_BasicBatteryBuffer ? (GT_MetaTileEntity_BasicBatteryBuffer)tMeta : null;
        boolean showTransformer = tMeta instanceof GT_MetaTileEntity_Transformer && this.getConfig("transformer");
        boolean showSolar = tMeta instanceof GT_MetaTileEntity_Boiler_Solar && this.getConfig("solar");
        boolean bl = allowedToWork = tag.func_74764_b("isAllowedToWork") && tag.func_74767_n("isAllowedToWork");
        if (tBaseMetaTile != null && this.getConfig("fluidfilter") && tag.func_74764_b(filterKey = "filterInfo" + side)) {
            currenttip.add(tag.func_74779_i(filterKey));
        }
        if (tMeta != null) {
            String facingStr = "Facing";
            if (showTransformer && tag.func_74764_b("isAllowedToWork")) {
                currenttip.add(String.format("%s %d(%dA) -> %d(%dA)", (allowedToWork ? SpecialChars.GREEN + "Step Down" : SpecialChars.RED + "Step Up") + SpecialChars.RESET, tag.func_74763_f("maxEUInput"), tag.func_74763_f("maxAmperesIn"), tag.func_74763_f("maxEUOutput"), tag.func_74763_f("maxAmperesOut")));
                String string = facingStr = tag.func_74767_n("isAllowedToWork") ? "Input" : "Output";
            }
            if (showSolar && tag.func_74764_b("calcificationOutput")) {
                currenttip.add(String.format(SpecialChars.GOLD + "Solar Boiler Output: " + SpecialChars.RESET + "%d/%d L/s", tag.func_74762_e("calcificationOutput"), tag.func_74762_e("maxCalcificationOutput")));
            }
            if (tMeta instanceof GT_MetaTileEntity_PrimitiveBlastFurnace && this.getConfig("pblastfurnace")) {
                if (tag.func_74767_n("incompleteStructurePrimitiveBlastFurnace")) {
                    currenttip.add(SpecialChars.RED + "Incomplete Structure" + SpecialChars.RESET);
                }
                if (tag.func_74762_e("progressPrimitiveBlastFurnace") <= 20 && tag.func_74762_e("maxProgressPrimitiveBlastFurnace") <= 20) {
                    currenttip.add(String.format("Progress: %d t / %d t", tag.func_74762_e("progressPrimitiveBlastFurnace"), tag.func_74762_e("maxProgressPrimitiveBlastFurnace")));
                } else {
                    currenttip.add(String.format("Progress: %d s / %d s", tag.func_74762_e("progressPrimitiveBlastFurnace") / 20, tag.func_74762_e("maxProgressPrimitiveBlastFurnace") / 20));
                }
            }
            if (mBaseMetaTileEntity != null && this.getConfig("machineFacing")) {
                byte facing = mBaseMetaTileEntity.getFrontFacing();
                if (showTransformer) {
                    if (side == facing && allowedToWork || side != facing && !allowedToWork) {
                        currenttip.add(String.format(SpecialChars.GOLD + "Input:" + SpecialChars.RESET + " %d(%dA)", tag.func_74763_f("maxEUInput"), tag.func_74763_f("maxAmperesIn")));
                    } else {
                        currenttip.add(String.format(SpecialChars.BLUE + "Output:" + SpecialChars.RESET + " %d(%dA)", tag.func_74763_f("maxEUOutput"), tag.func_74763_f("maxAmperesOut")));
                    }
                } else {
                    currenttip.add(String.format("%s: %s", facingStr, ForgeDirection.getOrientation((int)facing).name()));
                }
            }
            if (BasicMachine != null && this.getConfig("basicmachine")) {
                if (tag.func_74762_e("progressSingleBlock") <= 20 && tag.func_74762_e("maxProgressSingleBlock") <= 20) {
                    currenttip.add(String.format("Progress: %d t / %d t", tag.func_74762_e("progressSingleBlock"), tag.func_74762_e("maxProgressSingleBlock")));
                } else {
                    currenttip.add(String.format("Progress: %d s / %d s", tag.func_74762_e("progressSingleBlock") / 20, tag.func_74762_e("maxProgressSingleBlock") / 20));
                }
                currenttip.add("Consumption: " + SpecialChars.RED + tag.func_74762_e("EUOut") + SpecialChars.RESET + " EU/t");
            }
            if (bateryBuffer != null && this.getConfig("basicmachine")) {
                currenttip.add("Used Capacity: " + SpecialChars.GREEN + GT_Utility.formatNumbers((long)tag.func_74763_f("nowStorage")) + SpecialChars.RESET + " EU");
                currenttip.add("Total Capacity: " + SpecialChars.YELLOW + GT_Utility.formatNumbers((long)tag.func_74763_f("maxStorage")) + SpecialChars.RESET + " EU");
                currenttip.add("In: " + SpecialChars.GREEN + GT_Utility.formatNumbers((long)tag.func_74763_f("energyInput")) + SpecialChars.RESET + " EU/t");
                currenttip.add("Out: " + SpecialChars.RED + GT_Utility.formatNumbers((long)tag.func_74763_f("energyOutput")) + SpecialChars.RESET + " EU/t");
            }
            if (multiBlockBase != null && this.getConfig("multiblock")) {
                if (tag.func_74767_n("incompleteStructure")) {
                    currenttip.add(SpecialChars.RED + "** INCOMPLETE STRUCTURE **" + SpecialChars.RESET);
                }
                currenttip.add((tag.func_74767_n("hasProblems") ? SpecialChars.RED + "** HAS PROBLEMS **" : SpecialChars.GREEN + "Running Fine") + SpecialChars.RESET + "  Efficiency: " + tag.func_74760_g("efficiency") + "%");
                if (tag.func_74762_e("progress") <= 20 && tag.func_74762_e("maxProgress") <= 20) {
                    currenttip.add(String.format("Progress: %d t / %d t", tag.func_74762_e("progress"), tag.func_74762_e("maxProgress")));
                } else {
                    currenttip.add(String.format("Progress: %d s / %d s", tag.func_74762_e("progress") / 20, tag.func_74762_e("maxProgress") / 20));
                }
                if (tag.func_74763_f("energyGeneration") > 0L) {
                    currenttip.add("Generation: " + SpecialChars.GREEN + GT_Utility.formatNumbers((long)tag.func_74763_f("energyGeneration")) + SpecialChars.RESET + " EU/t");
                } else if (tag.func_74763_f("energyConsumption") < 0L) {
                    currenttip.add("Consumption : " + SpecialChars.RED + GT_Utility.formatNumbers((long)(-tag.func_74763_f("energyConsumption"))) + SpecialChars.RESET + " EU/t");
                }
            }
        }
    }

    @Override
    protected void getNBTData(TileEntity tile, NBTTagCompound tag, World world, BlockCoord pos) {
        GT_MetaTileEntity_BasicBatteryBuffer bateryBuffer;
        IGregTechTileEntity tBaseMetaTile = tile instanceof IGregTechTileEntity ? (IGregTechTileEntity)tile : null;
        IMetaTileEntity tMeta = tBaseMetaTile != null ? tBaseMetaTile.getMetaTileEntity() : null;
        GT_MetaTileEntity_BasicMachine BasicMachine = tMeta instanceof GT_MetaTileEntity_BasicMachine ? (GT_MetaTileEntity_BasicMachine)tMeta : null;
        GT_MetaTileEntity_MultiBlockBase multiBlockBase = tMeta instanceof GT_MetaTileEntity_MultiBlockBase ? (GT_MetaTileEntity_MultiBlockBase)tMeta : null;
        GT_MetaTileEntity_BasicBatteryBuffer gT_MetaTileEntity_BasicBatteryBuffer = bateryBuffer = tMeta instanceof GT_MetaTileEntity_BasicBatteryBuffer ? (GT_MetaTileEntity_BasicBatteryBuffer)tMeta : null;
        if (tMeta != null) {
            if (tMeta instanceof GT_MetaTileEntity_Transformer) {
                GT_MetaTileEntity_Transformer transformer = (GT_MetaTileEntity_Transformer)tMeta;
                tag.func_74757_a("isAllowedToWork", tMeta.getBaseMetaTileEntity().isAllowedToWork());
                tag.func_74772_a("maxEUInput", transformer.maxEUInput());
                tag.func_74772_a("maxAmperesIn", transformer.maxAmperesIn());
                tag.func_74772_a("maxEUOutput", transformer.maxEUOutput());
                tag.func_74772_a("maxAmperesOut", transformer.maxAmperesOut());
            } else if (tMeta instanceof GT_MetaTileEntity_Boiler_Solar) {
                GT_MetaTileEntity_Boiler_Solar solar = (GT_MetaTileEntity_Boiler_Solar)tMeta;
                tag.func_74768_a("calcificationOutput", solar.getCalcificationOutput() * 20 / 25);
                tag.func_74768_a("maxCalcificationOutput", solar.getBasicOutput() * 20 / 25);
            } else if (tMeta instanceof GT_MetaTileEntity_PrimitiveBlastFurnace) {
                GT_MetaTileEntity_PrimitiveBlastFurnace blastFurnace = (GT_MetaTileEntity_PrimitiveBlastFurnace)tMeta;
                int progress = blastFurnace.mProgresstime;
                int maxProgress = blastFurnace.mMaxProgresstime;
                tag.func_74768_a("progressPrimitiveBlastFurnace", progress);
                tag.func_74768_a("maxProgressPrimitiveBlastFurnace", maxProgress);
                tag.func_74757_a("incompleteStructurePrimitiveBlastFurnace", !blastFurnace.mMachine);
            }
            if (BasicMachine != null) {
                int progressSingleBlock = BasicMachine.mProgresstime;
                int maxProgressSingleBlock = BasicMachine.mMaxProgresstime;
                int EUOut = BasicMachine.mEUt;
                tag.func_74768_a("progressSingleBlock", progressSingleBlock);
                tag.func_74768_a("maxProgressSingleBlock", maxProgressSingleBlock);
                tag.func_74768_a("EUOut", EUOut);
            }
            if (bateryBuffer != null) {
                long[] tmp = bateryBuffer.getStoredEnergy();
                long nowStorage = tmp[0];
                long maxStorage = tmp[1];
                long energyInput = bateryBuffer.getBaseMetaTileEntity().getAverageElectricInput();
                long energyOutput = bateryBuffer.getBaseMetaTileEntity().getAverageElectricOutput();
                tag.func_74772_a("nowStorage", nowStorage);
                tag.func_74772_a("maxStorage", maxStorage);
                tag.func_74772_a("energyInput", energyInput);
                tag.func_74772_a("energyOutput", energyOutput);
            }
            if (multiBlockBase != null) {
                int problems = multiBlockBase.getIdealStatus() - multiBlockBase.getRepairStatus();
                float efficiency = (float)multiBlockBase.mEfficiency / 100.0f;
                int mEfficiency = multiBlockBase.mEfficiency;
                int progress = multiBlockBase.mProgresstime;
                int maxProgress = multiBlockBase.mMaxProgresstime;
                int mEUt = multiBlockBase.mEUt;
                long energy = 0L;
                if (!(multiBlockBase instanceof GT_MetaTileEntity_LargeBoiler || multiBlockBase instanceof GT_MetaTileEntity_WaterPumpPrimitive || multiBlockBase instanceof GT_MetaTileEntity_HeatExchanger || progress <= 0 && maxProgress <= 0)) {
                    if (mEUt > 0) {
                        energy = (long)mEUt * (long)mEfficiency / 10000L;
                    } else if (mEUt < 0) {
                        energy = (long)mEUt * 10000L / (long)Math.max(1000, mEfficiency);
                    }
                }
                tag.func_74757_a("hasProblems", problems > 0);
                tag.func_74776_a("efficiency", efficiency);
                tag.func_74768_a("progress", progress);
                tag.func_74768_a("maxProgress", maxProgress);
                tag.func_74757_a("incompleteStructure", (tBaseMetaTile.getErrorDisplayID() & 0x40) != 0);
                tag.func_74772_a("energyGeneration", energy);
                tag.func_74772_a("energyConsumption", energy);
            }
        }
        if (tBaseMetaTile != null && tBaseMetaTile instanceof BaseMetaPipeEntity) {
            for (byte side = 0; side < 6; side = (byte)(side + 1)) {
                if (!(tBaseMetaTile.getCoverBehaviorAtSide(side) instanceof GT_Cover_Fluidfilter)) continue;
                tag.func_74778_a("filterInfo" + side, tBaseMetaTile.getCoverBehaviorAtSide(side).getDescription(side, tBaseMetaTile.getCoverIDAtSide(side), tBaseMetaTile.getCoverDataAtSide(side), (ICoverable)tBaseMetaTile));
            }
        }
        tile.func_145841_b(tag);
    }
}

