/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.api.impl;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import mcp.mobius.waila.Waila;
import mcp.mobius.waila.api.IWailaBlock;
import mcp.mobius.waila.api.IWailaDataProvider;
import mcp.mobius.waila.api.IWailaEntityProvider;
import mcp.mobius.waila.api.impl.ConfigHandler;
import mcp.mobius.waila.api.impl.DataAccessorCommon;
import mcp.mobius.waila.api.impl.ModuleRegistrar;
import mcp.mobius.waila.cbcore.Layout;
import mcp.mobius.waila.network.Message0x01TERequest;
import mcp.mobius.waila.network.Message0x03EntRequest;
import mcp.mobius.waila.network.WailaPacketHandler;
import mcp.mobius.waila.utils.WailaExceptionHandler;
import ml.luxinfine.waila.PlayerWatchHandler;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;

public class MetaDataProvider {
    private Map<Integer, List<IWailaDataProvider>> headBlockProviders = new TreeMap<Integer, List<IWailaDataProvider>>();
    private Map<Integer, List<IWailaDataProvider>> bodyBlockProviders = new TreeMap<Integer, List<IWailaDataProvider>>();
    private Map<Integer, List<IWailaDataProvider>> tailBlockProviders = new TreeMap<Integer, List<IWailaDataProvider>>();
    private Map<Integer, List<IWailaEntityProvider>> headEntityProviders = new TreeMap<Integer, List<IWailaEntityProvider>>();
    private Map<Integer, List<IWailaEntityProvider>> bodyEntityProviders = new TreeMap<Integer, List<IWailaEntityProvider>>();
    private Map<Integer, List<IWailaEntityProvider>> tailEntityProviders = new TreeMap<Integer, List<IWailaEntityProvider>>();
    private Class prevBlock = null;
    private Class prevTile = null;

    public ItemStack identifyBlockHighlight(World world, EntityPlayer player, MovingObjectPosition mop, DataAccessorCommon accessor) {
        NBTTagCompound luxinfineTeam;
        accessor = PlayerWatchHandler.INSTANCE.getAccessor(mop);
        if (accessor.remoteNbt != null && accessor.remoteNbt.func_74764_b("luxinfineTeam") && (luxinfineTeam = accessor.remoteNbt.func_74775_l("luxinfineTeam")).func_74767_n("cantInfoAccess")) {
            return null;
        }
        Block block = accessor.getBlock();
        int blockID = accessor.getBlockID();
        if (IWailaBlock.class.isInstance(block)) {
            try {
                return ((IWailaBlock)block).getWailaStack(accessor, ConfigHandler.instance());
            }
            catch (Throwable var13) {
                WailaExceptionHandler.handleErr(var13, block.getClass().toString(), null);
            }
        }
        if (ModuleRegistrar.instance().hasStackProviders(block)) {
            for (List<IWailaDataProvider> providerList : ModuleRegistrar.instance().getStackProviders(block).values()) {
                for (IWailaDataProvider dataProvider : providerList) {
                    try {
                        ItemStack retval = dataProvider.getWailaStack(accessor, ConfigHandler.instance());
                        if (retval == null) continue;
                        return retval;
                    }
                    catch (Throwable var12) {
                        WailaExceptionHandler.handleErr(var12, dataProvider.getClass().toString(), null);
                    }
                }
            }
        }
        return null;
    }

    public List<String> handleBlockTextData(ItemStack itemStack, World world, EntityPlayer player, MovingObjectPosition mop, DataAccessorCommon accessor, List<String> currenttip, Layout layout) {
        accessor = PlayerWatchHandler.INSTANCE.getAccessor(mop);
        Block block = accessor.getBlock();
        if (Minecraft.func_71410_x().func_71356_B() && accessor.getTileEntity() != null && Waila.instance.serverPresent && accessor.isTimeElapsed(250L)) {
            accessor.resetTimer();
            HashSet<String> keys = new HashSet<String>();
            if (ModuleRegistrar.instance().hasSyncedNBTKeys(block)) {
                keys.addAll(ModuleRegistrar.instance().getSyncedNBTKeys(block));
            }
            if (ModuleRegistrar.instance().hasSyncedNBTKeys(accessor.getTileEntity())) {
                keys.addAll(ModuleRegistrar.instance().getSyncedNBTKeys(accessor.getTileEntity()));
            }
            if (keys.size() != 0 || ModuleRegistrar.instance().hasNBTProviders(block) || ModuleRegistrar.instance().hasNBTProviders(accessor.getTileEntity())) {
                WailaPacketHandler.INSTANCE.sendToServer(new Message0x01TERequest(accessor.getTileEntity(), keys));
            }
        } else if (accessor.getTileEntity() != null && !Waila.instance.serverPresent && accessor.isTimeElapsed(250L)) {
            try {
                NBTTagCompound tag = new NBTTagCompound();
                accessor.getTileEntity().func_145841_b(tag);
                accessor.setNBTData(tag);
            }
            catch (Exception var20) {
                WailaExceptionHandler.handleErr(var20, this.getClass().getName(), null);
            }
        }
        if (block instanceof IWailaBlock) {
            world.func_147438_o(mop.field_72311_b, mop.field_72312_c, mop.field_72309_d);
            if (layout == Layout.HEADER) {
                try {
                    return ((IWailaBlock)block).getWailaHead(itemStack, currenttip, accessor, ConfigHandler.instance());
                }
                catch (Throwable var14) {
                    return WailaExceptionHandler.handleErr(var14, block.getClass().toString(), currenttip);
                }
            }
            if (layout == Layout.BODY) {
                try {
                    return ((IWailaBlock)block).getWailaBody(itemStack, currenttip, accessor, ConfigHandler.instance());
                }
                catch (Throwable var15) {
                    return WailaExceptionHandler.handleErr(var15, block.getClass().toString(), currenttip);
                }
            }
            if (layout == Layout.FOOTER) {
                List<String> types;
                try {
                    types = ((IWailaBlock)block).getWailaTail(itemStack, currenttip, accessor, ConfigHandler.instance());
                }
                catch (Throwable var16) {
                    types = WailaExceptionHandler.handleErr(var16, block.getClass().toString(), currenttip);
                }
                if (types == null) {
                    types = new ArrayList<String>();
                }
                this.addCustomInfo(accessor.remoteNbt, types);
                return types;
            }
        }
        this.headBlockProviders.clear();
        this.bodyBlockProviders.clear();
        this.tailBlockProviders.clear();
        if (layout == Layout.HEADER && ModuleRegistrar.instance().hasHeadProviders(block)) {
            this.headBlockProviders.putAll(ModuleRegistrar.instance().getHeadProviders(block));
        } else if (layout == Layout.BODY && ModuleRegistrar.instance().hasBodyProviders(block)) {
            this.bodyBlockProviders.putAll(ModuleRegistrar.instance().getBodyProviders(block));
        } else if (layout == Layout.FOOTER && ModuleRegistrar.instance().hasTailProviders(block)) {
            this.tailBlockProviders.putAll(ModuleRegistrar.instance().getTailProviders(block));
        }
        if (layout == Layout.HEADER && ModuleRegistrar.instance().hasHeadProviders(accessor.getTileEntity())) {
            this.headBlockProviders.putAll(ModuleRegistrar.instance().getHeadProviders(accessor.getTileEntity()));
        } else if (layout == Layout.BODY && ModuleRegistrar.instance().hasBodyProviders(accessor.getTileEntity())) {
            this.bodyBlockProviders.putAll(ModuleRegistrar.instance().getBodyProviders(accessor.getTileEntity()));
        } else if (layout == Layout.FOOTER && ModuleRegistrar.instance().hasTailProviders(accessor.getTileEntity())) {
            this.tailBlockProviders.putAll(ModuleRegistrar.instance().getTailProviders(accessor.getTileEntity()));
        }
        if (layout == Layout.HEADER) {
            for (List<IWailaDataProvider> providersList : this.headBlockProviders.values()) {
                for (IWailaDataProvider dataProvider : providersList) {
                    try {
                        currenttip = dataProvider.getWailaHead(itemStack, currenttip, accessor, ConfigHandler.instance());
                    }
                    catch (Throwable var19) {
                        currenttip = WailaExceptionHandler.handleErr(var19, dataProvider.getClass().toString(), currenttip);
                    }
                }
            }
        }
        if (layout == Layout.BODY) {
            for (List<IWailaDataProvider> providersList : this.bodyBlockProviders.values()) {
                for (IWailaDataProvider dataProvider : providersList) {
                    try {
                        currenttip = dataProvider.getWailaBody(itemStack, currenttip, accessor, ConfigHandler.instance());
                    }
                    catch (Throwable var18) {
                        currenttip = WailaExceptionHandler.handleErr(var18, dataProvider.getClass().toString(), currenttip);
                    }
                }
            }
        }
        if (layout == Layout.FOOTER) {
            for (List<IWailaDataProvider> providersList : this.tailBlockProviders.values()) {
                for (IWailaDataProvider dataProvider : providersList) {
                    try {
                        currenttip = dataProvider.getWailaTail(itemStack, currenttip, accessor, ConfigHandler.instance());
                    }
                    catch (Throwable var17) {
                        currenttip = WailaExceptionHandler.handleErr(var17, dataProvider.getClass().toString(), currenttip);
                    }
                }
            }
            this.addCustomInfo(accessor.remoteNbt, currenttip);
        }
        return currenttip;
    }

    private void addCustomInfo(NBTTagCompound tags, List<String> tips) {
        if (Waila.instance.serverPresent && tags != null && tags.func_74764_b("luxinfineTeam") && tags.func_74775_l("luxinfineTeam").func_74767_n("cantInfoAccess")) {
            tips.add(StatCollector.func_74838_a((String)"hud.msg.warns.noaccess"));
        }
    }

    public List<String> handleEntityTextData(Entity entity, World world, EntityPlayer player, MovingObjectPosition mop, DataAccessorCommon accessor, List<String> currenttip, Layout layout) {
        accessor = PlayerWatchHandler.INSTANCE.getAccessor(mop);
        if (Minecraft.func_71410_x().func_71356_B() && accessor.getEntity() != null && Waila.instance.serverPresent && accessor.isTimeElapsed(250L)) {
            accessor.resetTimer();
            HashSet<String> keys = new HashSet<String>();
            if (ModuleRegistrar.instance().hasSyncedNBTKeys(accessor.getEntity())) {
                keys.addAll(ModuleRegistrar.instance().getSyncedNBTKeys(accessor.getEntity()));
            }
            if (keys.size() != 0 || ModuleRegistrar.instance().hasNBTEntityProviders(accessor.getEntity())) {
                WailaPacketHandler.INSTANCE.sendToServer(new Message0x03EntRequest(accessor.getEntity(), keys));
            }
        } else if (accessor.getEntity() != null && !Waila.instance.serverPresent && accessor.isTimeElapsed(250L)) {
            try {
                NBTTagCompound tag = new NBTTagCompound();
                accessor.getEntity().func_70109_d(tag);
                accessor.remoteNbt = tag;
            }
            catch (Exception var16) {
                WailaExceptionHandler.handleErr(var16, this.getClass().getName(), null);
            }
        }
        this.headEntityProviders.clear();
        this.bodyEntityProviders.clear();
        this.tailEntityProviders.clear();
        if (layout == Layout.HEADER && ModuleRegistrar.instance().hasHeadEntityProviders(entity)) {
            this.headEntityProviders.putAll(ModuleRegistrar.instance().getHeadEntityProviders(entity));
        } else if (layout == Layout.BODY && ModuleRegistrar.instance().hasBodyEntityProviders(entity)) {
            this.bodyEntityProviders.putAll(ModuleRegistrar.instance().getBodyEntityProviders(entity));
        } else if (layout == Layout.FOOTER && ModuleRegistrar.instance().hasTailEntityProviders(entity)) {
            this.tailEntityProviders.putAll(ModuleRegistrar.instance().getTailEntityProviders(entity));
        }
        if (layout == Layout.HEADER) {
            for (List<IWailaEntityProvider> providersList : this.headEntityProviders.values()) {
                for (IWailaEntityProvider dataProvider : providersList) {
                    try {
                        currenttip = dataProvider.getWailaHead(entity, currenttip, accessor, ConfigHandler.instance());
                    }
                    catch (Throwable var15) {
                        currenttip = WailaExceptionHandler.handleErr(var15, dataProvider.getClass().toString(), currenttip);
                    }
                }
            }
        }
        if (layout == Layout.BODY) {
            for (List<IWailaEntityProvider> providersList : this.bodyEntityProviders.values()) {
                for (IWailaEntityProvider dataProvider : providersList) {
                    try {
                        currenttip = dataProvider.getWailaBody(entity, currenttip, accessor, ConfigHandler.instance());
                    }
                    catch (Throwable var14) {
                        currenttip = WailaExceptionHandler.handleErr(var14, dataProvider.getClass().toString(), currenttip);
                    }
                }
            }
        }
        if (layout == Layout.FOOTER) {
            for (List<IWailaEntityProvider> providersList : this.tailEntityProviders.values()) {
                for (IWailaEntityProvider dataProvider : providersList) {
                    try {
                        currenttip = dataProvider.getWailaTail(entity, currenttip, accessor, ConfigHandler.instance());
                    }
                    catch (Throwable var13) {
                        currenttip = WailaExceptionHandler.handleErr(var13, dataProvider.getClass().toString(), currenttip);
                    }
                }
            }
        }
        if (Waila.instance.serverPresent && accessor.remoteNbt != null && layout == Layout.FOOTER && accessor.remoteNbt.func_74764_b("luxinfineTeam") && accessor.remoteNbt.func_74775_l("luxinfineTeam").func_74767_n("cantInfoAccess")) {
            currenttip.add(StatCollector.func_74838_a((String)"hud.msg.warns.noaccess"));
        }
        return currenttip;
    }
}

