/*
 * Decompiled with CFR 0.152.
 */
package com.wildmobsmod.entity;

import com.wildmobsmod.misc.WeightedRandomSelector;
import cpw.mods.fml.common.FMLLog;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.NoSuchElementException;
import java.util.Set;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.config.Configuration;
import org.apache.logging.log4j.Level;

public class EntityConfig {
    private static final Set<EntityConfig> ALL_CONFIGS = new LinkedHashSet<EntityConfig>();
    protected final String id;
    protected final int defaultSpawnrate;
    protected final int defaultMinPack;
    protected final int defaultMaxPack;
    protected final boolean defaultEnabled;
    protected int spawnrate;
    protected int minPack;
    protected int maxPack;
    protected boolean enabled;
    protected static final String PATTERN_WEIGHTEDRANDOMSTACKSELECTOR = "[Pattern: <modid>:<itemid>:<meta>, <amount>, <weight>]";
    protected static final String PATTERN_STACKLIST = "[Pattern: <modid>:<itemid>:<meta>, <amount>]";

    protected static void registerEntityConfig(EntityConfig entityConfig) {
        ALL_CONFIGS.add(entityConfig);
    }

    public static EntityConfig construct(String id, int spawnrate, int minPack, int maxPack, boolean enabled) {
        EntityConfig cfg = new EntityConfig(id, spawnrate, minPack, maxPack, enabled);
        EntityConfig.registerEntityConfig(cfg);
        return cfg;
    }

    public static void syncAll(Configuration config) {
        ALL_CONFIGS.forEach(eCfg -> eCfg.sync(config));
    }

    protected EntityConfig(String id, int defaultSpawnrate, int defaultMinPack, int defaultMaxPack, boolean defaultEnabled) {
        this.id = id;
        this.defaultSpawnrate = defaultSpawnrate;
        this.defaultMinPack = defaultMinPack;
        this.defaultMaxPack = defaultMaxPack;
        this.defaultEnabled = defaultEnabled;
        this.spawnrate = defaultSpawnrate;
        this.minPack = defaultMinPack;
        this.maxPack = defaultMaxPack;
        this.enabled = defaultEnabled;
    }

    protected void sync(Configuration config) {
        this.enabled = config.getBoolean("register", this.getConfigCategory(), this.defaultEnabled, String.format("Register the %s Entity to the Game Registry? (Setting this to false will completely disable it.)", this.id));
        this.spawnrate = config.getInt("spawnrate", this.getConfigCategory(), this.defaultSpawnrate, 0, 100, String.format("The spawnrate of the %s Entity - higher means more frequent spawns. Set to 0 to disable natural spawning (it will still be registered).", this.id));
        this.minPack = config.getInt("minPackSize", this.getConfigCategory(), this.defaultMinPack, 1, 20, String.format("The minimum number of %s Entities to spawn per pack - has to be lower than maxPackSize (if it's larger, all packs will spawn with a size of minPackSize).", this.id));
        this.maxPack = Math.max(this.minPack, config.getInt("maxPackSize", this.getConfigCategory(), this.defaultMaxPack, 1, 20, String.format("The maximum number of %s Entities to spawn per pack - has to be larger than minPackSize (if it's lower, all packs will spawn with a size of minPackSize).", this.id)));
    }

    protected String getConfigCategory() {
        return "entities." + this.id;
    }

    public int getSpawnrate() {
        return this.spawnrate;
    }

    public int getMinPackSize() {
        return this.minPack;
    }

    public int getMaxPackSize() {
        return this.maxPack;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    protected static WeightedRandomSelector<ItemStack> buildWeightedRandomStackSelector(String ... stackList) {
        int size = stackList.length;
        if (size < 1) {
            return new WeightedRandomSelector<ItemStack>(new ItemStack[]{null}, new double[]{1.0});
        }
        ItemStack[] stacks = new ItemStack[size];
        int[] weights = new int[size];
        int totalWeight = 0;
        for (int i = 0; i < size; ++i) {
            ItemStack stack;
            int weight;
            String def = stackList[i];
            try {
                String itemid;
                int meta;
                int pos = def.lastIndexOf(44);
                weight = Integer.parseInt(def.substring(pos + 1).trim());
                def = def.substring(0, pos);
                pos = def.lastIndexOf(44);
                int stacksize = Integer.parseInt(def.substring(pos + 1).trim());
                def = def.substring(0, pos).trim();
                pos = def.indexOf(58);
                String modid = def.substring(0, pos);
                def = def.substring(pos + 1);
                pos = def.lastIndexOf(58);
                if (pos < 0) {
                    meta = 0;
                    itemid = def;
                } else {
                    itemid = def.substring(0, pos);
                    meta = Integer.parseInt(def.substring(pos + 1).trim());
                }
                String key = modid + ":" + itemid;
                Item item = (Item)Item.field_150901_e.func_82594_a(key);
                if (item == null) {
                    throw new NoSuchElementException(key);
                }
                stack = new ItemStack(item, stacksize, meta);
            }
            catch (IndexOutOfBoundsException | NumberFormatException | NoSuchElementException e) {
                FMLLog.log((String)"wildmobsmod", (Level)Level.ERROR, (Throwable)e, (String)"Invalid config entry: \"%s\" (index:%d)", (Object[])new Object[]{stackList[i], i});
                stack = null;
                weight = 0;
            }
            stacks[i] = stack;
            weights[i] = weight;
            totalWeight += weight;
        }
        double[] probabilities = new double[size];
        if (totalWeight > 0) {
            double totalWeight_d = totalWeight;
            for (int i = 0; i < size; ++i) {
                probabilities[i] = (double)weights[i] / totalWeight_d;
            }
        } else {
            Arrays.fill(probabilities, 1.0 / (double)size);
        }
        return new WeightedRandomSelector<ItemStack>(stacks, probabilities);
    }

    protected static ItemStack[] parseItemStackArray(String ... stackArray) {
        int size = stackArray.length;
        ItemStack[] stacks = new ItemStack[size];
        for (int i = 0; i < size; ++i) {
            ItemStack stack;
            String def = stackArray[i];
            try {
                String itemid;
                int meta;
                int pos = def.lastIndexOf(44);
                int stacksize = Integer.parseInt(def.substring(pos + 1).trim());
                def = def.substring(0, pos).trim();
                pos = def.indexOf(58);
                String modid = def.substring(0, pos);
                def = def.substring(pos + 1);
                pos = def.lastIndexOf(58);
                if (pos < 0) {
                    meta = 0;
                    itemid = def;
                } else {
                    itemid = def.substring(0, pos);
                    meta = Integer.parseInt(def.substring(pos + 1).trim());
                }
                String key = modid + ":" + itemid;
                Item item = (Item)Item.field_150901_e.func_82594_a(key);
                if (item == null) {
                    throw new NoSuchElementException(key);
                }
                stack = new ItemStack(item, stacksize, meta);
            }
            catch (IndexOutOfBoundsException | NumberFormatException | NoSuchElementException e) {
                FMLLog.log((String)"wildmobsmod", (Level)Level.ERROR, (Throwable)e, (String)"Invalid config entry: \"%s\" (index:%d)", (Object[])new Object[]{stackArray[i], i});
                stack = null;
            }
            stacks[i] = stack;
        }
        return stacks;
    }
}

