/*
 * Decompiled with CFR 0.152.
 */
package com.wildmobsmod.entity;

import com.google.common.collect.Sets;
import com.wildmobsmod.entity.EntityConfig;
import com.wildmobsmod.main.WildMobsMod;
import cpw.mods.fml.common.registry.EntityRegistry;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.BiomeDictionary;

public class EntityRegistrar {
    private static final Set<EntityRegistrar> ALL_REGISTRARS = new LinkedHashSet<EntityRegistrar>();
    protected final Class entityClass;
    protected final String entityName;
    protected final EntityConfig config;
    protected final int entityId;
    protected final int trackingRange;
    protected final int updateFrequency;
    protected final boolean sendsVelocityUpdates;
    protected final EnumCreatureType creatureType;
    protected final BiomeGenBase[] biomes;

    protected static void registerRegistrar(EntityRegistrar entityRegistrar) {
        ALL_REGISTRARS.add(entityRegistrar);
    }

    static void registerAllEntities() {
        ALL_REGISTRARS.forEach(reg -> reg.registerEntity());
    }

    static void registerAllSpawns() {
        ALL_REGISTRARS.forEach(reg -> reg.registerSpawns());
    }

    public static EntityRegistrar constructDisjunct(Class entityClass, EntityConfig config, String entityName, int entityId, int trackingRange, int updateFrequency, boolean sendsVelocityUpdates, EnumCreatureType creatureType, BiomeDictionary.Type ... biomeTypes) {
        return EntityRegistrar.construct(entityClass, config, entityName, entityId, trackingRange, updateFrequency, sendsVelocityUpdates, creatureType, EntityRegistrar.getBiomesFromTypesDisjunct(biomeTypes));
    }

    public static EntityRegistrar constructConjunct(Class entityClass, EntityConfig config, String entityName, int entityId, int trackingRange, int updateFrequency, boolean sendsVelocityUpdates, EnumCreatureType creatureType, BiomeDictionary.Type ... biomeTypes) {
        return EntityRegistrar.construct(entityClass, config, entityName, entityId, trackingRange, updateFrequency, sendsVelocityUpdates, creatureType, EntityRegistrar.getBiomesFromTypesConjunct(biomeTypes));
    }

    public static EntityRegistrar construct(Class entityClass, EntityConfig config, String entityName, int entityId, int trackingRange, int updateFrequency, boolean sendsVelocityUpdates, EnumCreatureType creatureType, BiomeDictionary.Type biomeType) {
        return EntityRegistrar.construct(entityClass, config, entityName, entityId, trackingRange, updateFrequency, sendsVelocityUpdates, creatureType, BiomeDictionary.getBiomesForType((BiomeDictionary.Type)biomeType));
    }

    public static EntityRegistrar construct(Class entityClass, EntityConfig config, String entityName, int entityId, int trackingRange, int updateFrequency, boolean sendsVelocityUpdates, EnumCreatureType creatureType, BiomeGenBase[] biomes) {
        EntityRegistrar registrar = new EntityRegistrar(entityClass, config, entityName, entityId, trackingRange, updateFrequency, sendsVelocityUpdates, creatureType, biomes);
        EntityRegistrar.registerRegistrar(registrar);
        return registrar;
    }

    public static BiomeGenBase[] getBiomesFromTypesDisjunct(BiomeDictionary.Type ... biomeTypes) {
        HashMap<Integer, BiomeGenBase> biomes = new HashMap<Integer, BiomeGenBase>();
        for (BiomeDictionary.Type type : biomeTypes) {
            for (BiomeGenBase biome : BiomeDictionary.getBiomesForType((BiomeDictionary.Type)type)) {
                biomes.putIfAbsent(biome.field_76756_M, biome);
            }
        }
        return biomes.values().toArray(new BiomeGenBase[0]);
    }

    public static BiomeGenBase[] getBiomesFromTypesConjunct(BiomeDictionary.Type ... biomeTypes) {
        if (biomeTypes.length < 1) {
            return new BiomeGenBase[0];
        }
        HashSet biomes = Sets.newHashSet((Object[])BiomeDictionary.getBiomesForType((BiomeDictionary.Type)biomeTypes[0]));
        for (int i = 1; i < biomeTypes.length; ++i) {
            HashSet typeBiomes = Sets.newHashSet((Object[])BiomeDictionary.getBiomesForType((BiomeDictionary.Type)biomeTypes[0]));
            biomes.retainAll(typeBiomes);
        }
        return biomes.toArray(new BiomeGenBase[0]);
    }

    public static BiomeGenBase[] excludeBiomes(BiomeGenBase[] biomes, BiomeGenBase ... blacklist) {
        HashSet result = Sets.newHashSet((Object[])biomes);
        result.removeAll(Arrays.asList(blacklist));
        return result.toArray(new BiomeGenBase[0]);
    }

    protected EntityRegistrar(Class entityClass, EntityConfig config, String entityName, int entityId, int trackingRange, int updateFrequency, boolean sendsVelocityUpdates, EnumCreatureType creatureType, BiomeGenBase[] biomes) {
        this.entityClass = entityClass;
        this.config = config;
        this.entityName = entityName;
        this.entityId = entityId;
        this.trackingRange = trackingRange;
        this.updateFrequency = updateFrequency;
        this.sendsVelocityUpdates = sendsVelocityUpdates;
        this.creatureType = creatureType;
        this.biomes = biomes;
    }

    protected void registerEntity() {
        if (this.config.isEnabled()) {
            EntityRegistry.registerModEntity((Class)this.entityClass, (String)this.entityName, (int)this.entityId, (Object)WildMobsMod.modInstance, (int)this.trackingRange, (int)this.updateFrequency, (boolean)this.sendsVelocityUpdates);
        }
    }

    protected void registerSpawns() {
        int spawnrate = this.config.getSpawnrate();
        if (spawnrate > 0 && this.biomes != null && this.biomes.length > 0) {
            EntityRegistry.addSpawn((Class)this.entityClass, (int)spawnrate, (int)this.config.getMinPackSize(), (int)this.config.getMaxPackSize(), (EnumCreatureType)this.creatureType, (BiomeGenBase[])this.biomes);
        }
    }
}

