/*
 * Decompiled with CFR 0.152.
 */
package com.wildmobsmod.entity.monster.dreath;

import com.wildmobsmod.entity.EntityConfig;
import com.wildmobsmod.misc.WeightedRandomSelector;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.config.Configuration;

public class EntityConfigDreathMired
extends EntityConfig {
    protected final boolean defaultEnableBabyDreath;
    protected final boolean defaultRegisterMiredEntities;
    protected final boolean defaultEnableMiredBottle;
    protected final boolean defaultGuaranteeDropCount;
    protected boolean enableBabyDreath;
    protected boolean registerMiredEntities;
    protected boolean enableMiredBottle;
    protected boolean guaranteeDropCount;
    protected final double defaultBottleDropChance;
    protected double bottleDropChance;
    protected final int defaultMiredDropCount;
    protected int miredDropCount;
    protected final String[] defaultMiredLoot;
    protected String[] miredLoot;
    protected WeightedRandomSelector<ItemStack> miredLootTable;

    public static EntityConfigDreathMired construct(String id, int spawnrate, int minPack, int maxPack, boolean enabled, boolean enableBabyDreath, boolean registerMiredEntities, double bottleDropChance, boolean enableMiredBottle, int miredDropCount, String[] miredLoot, boolean guaranteeDropCount) {
        EntityConfigDreathMired cfg = new EntityConfigDreathMired(id, spawnrate, minPack, maxPack, enabled, enableBabyDreath, registerMiredEntities, bottleDropChance, enableMiredBottle, miredDropCount, miredLoot, guaranteeDropCount);
        EntityConfigDreathMired.registerEntityConfig(cfg);
        return cfg;
    }

    protected EntityConfigDreathMired(String id, int defaultSpawnrate, int defaultMinPack, int defaultMaxPack, boolean defaultEnabled, boolean defaultEnableBabyDreath, boolean defaultRegisterMiredEntities, double defaultBottleDropChance, boolean defaultEnableMiredBottle, int defaultMiredDropCount, String[] defaultMiredLoot, boolean defaultGuaranteeDropCount) {
        super(id, defaultSpawnrate, defaultMinPack, defaultMaxPack, defaultEnabled);
        this.defaultEnableBabyDreath = defaultEnableBabyDreath;
        this.defaultRegisterMiredEntities = defaultRegisterMiredEntities;
        this.defaultBottleDropChance = defaultBottleDropChance;
        this.defaultEnableMiredBottle = defaultEnableMiredBottle;
        this.defaultMiredDropCount = defaultMiredDropCount;
        this.defaultMiredLoot = defaultMiredLoot;
        this.defaultGuaranteeDropCount = defaultGuaranteeDropCount;
        this.enableBabyDreath = defaultEnableBabyDreath;
        this.registerMiredEntities = defaultRegisterMiredEntities;
        this.bottleDropChance = defaultBottleDropChance;
        this.enableMiredBottle = defaultEnableMiredBottle;
        this.miredDropCount = defaultMiredDropCount;
        this.miredLoot = defaultMiredLoot;
        this.guaranteeDropCount = defaultGuaranteeDropCount;
    }

    @Override
    protected void sync(Configuration config) {
        super.sync(config);
        this.enableBabyDreath = config.getBoolean("enableBabyDreath", this.getConfigCategory(), this.defaultEnableBabyDreath, "Allow Baby Dreaths?");
        this.registerMiredEntities = config.getBoolean("registerMiredEntities", this.getMiredCategory(), this.defaultRegisterMiredEntities, "Register the Mired and MiredSummoner Entities?");
        this.bottleDropChance = config.get(this.getMiredCategory(), "bottleDropChance", this.defaultBottleDropChance, "Chance (in percent) of a mired dropping a mired bottle.", 0.0, 1.0).getDouble();
        this.enableMiredBottle = config.getBoolean("enableMiredBottle", this.getMiredCategory(), this.defaultEnableMiredBottle, "Allow MiredSummoners (and consequentially Mireds) to be spawned via Mired Bottles (which are dropped by Dreaths)? [Ignored if \"registerMiredEntities\" is false]");
        this.miredDropCount = config.getInt("miredDropCount", this.getMiredCategory(), this.defaultMiredDropCount, 1, 20, "Amount of Loot a Mired Bottle is meant to drop.");
        this.miredLoot = config.getStringList("miredLoot", this.getMiredCategory(), this.defaultMiredLoot, "Mired LootTable definition. [Pattern: <modid>:<itemid>:<meta>, <amount>, <weight>]");
        this.miredLootTable = EntityConfigDreathMired.buildWeightedRandomStackSelector(this.miredLoot);
        this.guaranteeDropCount = config.getBoolean("guaranteeDropCount", this.getMiredCategory(), this.defaultGuaranteeDropCount, "If a MiredSummoners loot pool hasn't been exhausted during its lifetime, drop the leftovers on it's own death?");
    }

    protected String getMiredCategory() {
        return super.getConfigCategory() + ".mired";
    }

    public boolean getEnableBabyDreath() {
        return this.enableBabyDreath;
    }

    public boolean getRegisterMiredEntities() {
        return this.registerMiredEntities;
    }

    public double getBottleDropChance() {
        return this.bottleDropChance;
    }

    public boolean getEnableMiredBottle() {
        return this.registerMiredEntities && this.enableMiredBottle;
    }

    public int getMiredDropCount() {
        return this.miredDropCount;
    }

    public ItemStack getRandomLootStack() {
        return this.miredLootTable.next();
    }

    public boolean getGuaranteeDropCount() {
        return this.guaranteeDropCount;
    }
}

