/*
 * Decompiled with CFR 0.152.
 */
package com.wildmobsmod.entity.monster.dreath.mired;

import com.wildmobsmod.entity.monster.dreath.mired.EntityMired;
import com.wildmobsmod.main.WildMobsMod;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class EntityMiredSummoner
extends Entity {
    public static final int EXPECTED_LIFETIME = 1200;
    private static final int DROPPING_THRESHOLD = 1140;
    private static final int DROPPING_DURATION = 1040;
    private static final int AVERAGE_DROPPING_TRIES = 10;
    private final int miredSpawnChance;
    private int remainingDrops;

    public EntityMiredSummoner(World world) {
        super(world);
        this.func_70105_a(1.0f, 1.0f);
        this.remainingDrops = WildMobsMod.DREATH_MIRED_CONFIG.getMiredDropCount();
        this.miredSpawnChance = 1040 / (10 * this.remainingDrops);
    }

    protected void func_70088_a() {
        this.field_70180_af.func_75682_a(21, (Object)new Integer(0));
    }

    protected void func_70037_a(NBTTagCompound nbt) {
        this.setLifeTime(nbt.func_74762_e("LifeTime"));
    }

    protected void func_70014_b(NBTTagCompound nbt) {
        nbt.func_74768_a("LifeTime", this.getLifeTime());
    }

    public int getLifeTime() {
        return this.field_70180_af.func_75679_c(21);
    }

    public void setLifeTime(int lifetime) {
        this.field_70180_af.func_75692_b(21, (Object)lifetime);
    }

    public void func_70071_h_() {
        for (int i = 0; i < 4; ++i) {
            this.field_70170_p.func_72869_a("largesmoke", this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, this.field_70163_u + this.field_70146_Z.nextDouble() * (double)this.field_70131_O, this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, 0.0, 0.0, 0.0);
        }
        if (!this.field_70170_p.field_72995_K) {
            int lifetime = this.getLifeTime();
            if (lifetime <= 0) {
                if (WildMobsMod.DREATH_MIRED_CONFIG.getGuaranteeDropCount()) {
                    while (this.remainingDrops-- > 0) {
                        this.spawnMired((int)this.field_70165_t, (int)this.field_70163_u, (int)this.field_70161_v, WildMobsMod.DREATH_MIRED_CONFIG.getRandomLootStack());
                    }
                }
                this.func_70106_y();
            } else {
                this.setLifeTime(--lifetime);
            }
            if (lifetime <= 1140 && this.remainingDrops > 0 && this.field_70146_Z.nextInt(this.miredSpawnChance) == 0 && this.trySpawnMired()) {
                --this.remainingDrops;
            }
        }
        super.func_70071_h_();
    }

    private boolean trySpawnMired() {
        int miredZ;
        int miredY;
        int miredX = (int)this.field_70165_t + this.field_70146_Z.nextInt(11) - 5;
        Block block = this.field_70170_p.func_147439_a(miredX, miredY = (int)this.field_70163_u + this.field_70146_Z.nextInt(10) - 4, miredZ = (int)this.field_70161_v + this.field_70146_Z.nextInt(11) - 5);
        if ((block.isAir((IBlockAccess)this.field_70170_p, miredX, miredY, miredZ) || block.func_149668_a(this.field_70170_p, miredX, miredY, miredZ) == null) && this.field_70170_p.func_147439_a(miredX, miredY - 1, miredZ).func_149688_o().func_76230_c()) {
            ItemStack loot = WildMobsMod.DREATH_MIRED_CONFIG.getRandomLootStack();
            if (loot != null && loot.func_77984_f()) {
                loot.func_77964_b(this.field_70170_p.field_73012_v.nextInt(loot.func_77958_k()));
            }
            this.spawnMired(miredX, miredY, miredZ, loot);
            return true;
        }
        return false;
    }

    private void spawnMired(int x, int y, int z, ItemStack loot) {
        EntityMired entitymired = new EntityMired(this.field_70170_p);
        entitymired.func_70012_b(x, y, z, this.field_70177_z, this.field_70125_A);
        entitymired.func_70062_b(0, loot);
        this.field_70170_p.func_72838_d((Entity)entitymired);
    }
}

