/*
 * Decompiled with CFR 0.152.
 */
package com.wildmobsmod.entity.monster.seascorpion;

import com.wildmobsmod.entity.bases.EntityMobTameable;
import com.wildmobsmod.items.WildMobsModItems;
import com.wildmobsmod.main.WildMobsMod;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.command.IEntitySelector;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityGhast;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;

public class EntitySeaScorpion
extends EntityMobTameable {
    private ChunkCoordinates cachedPosition;
    private Entity closestLivingEntity;
    private Sorter theNearestAttackableTargetSorter;
    private int eatingTimer;
    public float seaScorpionPitch;
    public float prevSeaScorpionPitch;
    private float nextSeaScorpionPitch;
    private double prevPosY;
    private int timeToCalculatePosY;
    private double movedDist;
    private int timeToJump;
    private boolean canSpawnPack = true;
    private ItemStack food;
    public final IEntitySelector targetEntitySelectorMob = new IEntitySelector(){

        public boolean func_82704_a(Entity entity) {
            return entity.func_70089_S() && EntitySeaScorpion.this.func_70635_at().func_75522_a(entity) && EntitySeaScorpion.this.field_70170_p.func_147439_a(MathHelper.func_76128_c((double)entity.field_70165_t), MathHelper.func_76128_c((double)entity.field_70163_u), MathHelper.func_76128_c((double)entity.field_70161_v)).func_149688_o() == Material.field_151586_h && entity != EntitySeaScorpion.this && !(entity instanceof EntitySeaScorpion) && (!(entity instanceof EntityCreeper) || entity instanceof EntityGhast || ((EntityMob)entity).func_70660_b(WildMobsMod.potionAquaHealing) != null);
        }
    };
    public final IEntitySelector targetEntitySelectorHuman = new IEntitySelector(){

        public boolean func_82704_a(Entity entity) {
            return entity.func_70089_S() && EntitySeaScorpion.this.func_70635_at().func_75522_a(entity) && EntitySeaScorpion.this.field_70170_p.func_147439_a(MathHelper.func_76128_c((double)entity.field_70165_t), MathHelper.func_76128_c((double)entity.field_70163_u), MathHelper.func_76128_c((double)entity.field_70161_v)).func_149688_o() == Material.field_151586_h && entity != EntitySeaScorpion.this && entity instanceof EntityPlayer && !((EntityPlayer)entity).field_71075_bZ.field_75102_a && ((EntityPlayer)entity).func_70660_b(WildMobsMod.potionAquaHealing) == null;
        }
    };
    public final IEntitySelector targetEntitySelectorLiving = new IEntitySelector(){

        public boolean func_82704_a(Entity entity) {
            return entity.func_70089_S() && EntitySeaScorpion.this.func_70635_at().func_75522_a(entity) && EntitySeaScorpion.this.field_70170_p.func_147439_a(MathHelper.func_76128_c((double)entity.field_70165_t), MathHelper.func_76128_c((double)entity.field_70163_u), MathHelper.func_76128_c((double)entity.field_70161_v)).func_149688_o() == Material.field_151586_h && entity != EntitySeaScorpion.this && !(entity instanceof EntitySeaScorpion) && !(entity instanceof EntityCreeper) && !(entity instanceof EntityGhast);
        }
    };

    public EntitySeaScorpion(World world) {
        super(world);
        this.func_70105_a(0.8f, 0.2f);
        this.setIsWild(true);
        this.setIsSeaMonster(false);
        this.theNearestAttackableTargetSorter = new Sorter((Entity)this);
    }

    public int func_70641_bl() {
        return WildMobsMod.SEASCORPION_CONFIG.getMaxPackSize();
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(20, (Object)0);
        this.field_70180_af.func_75682_a(21, (Object)new Integer(0));
        this.field_70180_af.func_75682_a(22, (Object)new Integer(0));
        this.field_70180_af.func_75682_a(23, (Object)new Integer(0));
        this.field_70180_af.func_75682_a(24, (Object)0);
    }

    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        nbt.func_74757_a("IsWild", this.getIsWild());
        nbt.func_74768_a("Age", this.getGrowingAge());
        nbt.func_74768_a("Regeneration", this.getRegeneration());
        nbt.func_74768_a("Size", this.getSize());
        nbt.func_74757_a("IsSeaMonster", this.getIsSeaMonster());
    }

    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        this.setIsWild(nbt.func_74767_n("IsWild"));
        this.setGrowingAge(nbt.func_74762_e("Age"));
        this.setRegeneration(nbt.func_74762_e("Regeneration"));
        this.setSize(nbt.func_74762_e("Size"));
        this.setIsSeaMonster(nbt.func_74767_n("IsSeaMonster"));
    }

    public boolean getIsWild() {
        return (this.field_70180_af.func_75683_a(20) & 1) != 0;
    }

    public void setIsWild(boolean flag) {
        this.field_70180_af.func_75692_b(20, (Object)((byte)(flag ? 1 : 0)));
    }

    public int getGrowingAge() {
        return this.field_70180_af.func_75679_c(21);
    }

    public void setGrowingAge(int age) {
        this.field_70180_af.func_75692_b(21, (Object)age);
    }

    public int getRegeneration() {
        return this.field_70180_af.func_75679_c(22);
    }

    public void setRegeneration(int regen) {
        this.field_70180_af.func_75692_b(22, (Object)regen);
    }

    public int getSize() {
        return this.field_70180_af.func_75679_c(23);
    }

    public void setSize(int size) {
        this.field_70180_af.func_75692_b(23, (Object)size);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a((double)(8 + 4 * size));
        this.field_70728_aV = 3 + size;
        this.func_70606_j(this.func_110138_aP());
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a((double)this.getSize());
    }

    public boolean getIsSeaMonster() {
        return (this.field_70180_af.func_75683_a(24) & 1) != 0;
    }

    public void setIsSeaMonster(boolean flag) {
        this.field_70180_af.func_75692_b(24, (Object)((byte)(flag ? 1 : 0)));
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.0);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(16.0);
    }

    protected void func_70069_a(float distance) {
        if (this.field_70170_p.func_147439_a(MathHelper.func_76128_c((double)this.field_70165_t), MathHelper.func_76128_c((double)this.field_70163_u), MathHelper.func_76128_c((double)this.field_70161_v)).func_149688_o() != Material.field_151586_h) {
            super.func_70069_a(distance);
        }
    }

    protected void func_70064_a(double distanceFallenThisTick, boolean onGround) {
        if (this.field_70170_p.func_147439_a(MathHelper.func_76128_c((double)this.field_70165_t), MathHelper.func_76128_c((double)this.field_70163_u), MathHelper.func_76128_c((double)this.field_70161_v)).func_149688_o() != Material.field_151586_h) {
            super.func_70064_a(distanceFallenThisTick, onGround);
        }
    }

    public boolean func_70072_I() {
        return false;
    }

    public boolean func_70648_aU() {
        return true;
    }

    protected boolean func_70041_e_() {
        return false;
    }

    protected boolean func_70692_ba() {
        return this.getIsWild() && !this.getIsSeaMonster();
    }

    public float func_70047_e() {
        return this.field_70131_O * 0.5f;
    }

    protected String func_70639_aQ() {
        return this.field_70170_p.func_147439_a(MathHelper.func_76128_c((double)this.field_70165_t), MathHelper.func_76128_c((double)this.field_70163_u), MathHelper.func_76128_c((double)this.field_70161_v)).func_149688_o() == Material.field_151586_h ? "wildmobsmod:mob.seascorpion.saywater" : null;
    }

    @Override
    protected String func_70621_aR() {
        return this.field_70170_p.func_147439_a(MathHelper.func_76128_c((double)this.field_70165_t), MathHelper.func_76128_c((double)this.field_70163_u), MathHelper.func_76128_c((double)this.field_70161_v)).func_149688_o() == Material.field_151586_h ? "wildmobsmod:mob.seascorpion.hurtwater" : "wildmobsmod:mob.seascorpion.hurtland";
    }

    @Override
    protected String func_70673_aS() {
        return this.field_70170_p.func_147439_a(MathHelper.func_76128_c((double)this.field_70165_t), MathHelper.func_76128_c((double)this.field_70163_u), MathHelper.func_76128_c((double)this.field_70161_v)).func_149688_o() == Material.field_151586_h ? "wildmobsmod:mob.seascorpion.hurtwater" : "wildmobsmod:mob.seascorpion.hurtland";
    }

    public int func_70627_aG() {
        return 80;
    }

    public EnumCreatureAttribute func_70668_bt() {
        return EnumCreatureAttribute.ARTHROPOD;
    }

    @Override
    public void func_70636_d() {
        int age;
        super.func_70636_d();
        this.checkBlockCollision();
        int flooredX = MathHelper.func_76128_c((double)this.field_70165_t);
        int flooredY = MathHelper.func_76128_c((double)this.field_70163_u);
        int flooredZ = MathHelper.func_76128_c((double)this.field_70161_v);
        Block blockAtPos = this.field_70170_p.func_147439_a(flooredX, flooredY, flooredZ);
        if (blockAtPos.func_149688_o() == Material.field_151586_h) {
            Block block;
            if (this.timeToJump > 0) {
                this.field_70181_x = 0.2;
                --this.timeToJump;
            } else if (this.cachedPosition != null) {
                double d1 = (double)this.cachedPosition.field_71572_b + 0.1 - this.field_70163_u;
                this.field_70181_x += (Math.signum(d1) * (double)0.7f - this.field_70181_x) * 0.1500000014901161;
                this.field_70181_x *= this.field_70789_a == null ? ((double)this.cachedPosition.field_71572_b - 0.5 > this.field_70163_u || (double)this.cachedPosition.field_71572_b + 0.5 < this.field_70163_u ? 0.6 : 0.4) : 0.8;
            } else {
                this.field_70181_x = 0.0;
            }
            if (this.field_70789_a != null && !(block = this.field_70170_p.func_147439_a(MathHelper.func_76128_c((double)this.field_70789_a.field_70165_t), MathHelper.func_76128_c((double)(this.field_70789_a.field_70163_u + (double)this.field_70789_a.func_70047_e())), MathHelper.func_76128_c((double)this.field_70789_a.field_70161_v))).func_149721_r() && block.func_149688_o() != Material.field_151586_h && this.field_70146_Z.nextInt(30) == 0 && this.func_70068_e(this.field_70789_a) < 16.0) {
                this.timeToJump = 20;
            }
        }
        if (this.timeToJump > 0 && !blockAtPos.func_149721_r() && blockAtPos.func_149688_o() != Material.field_151586_h && this.field_70170_p.func_147439_a(flooredX, flooredY - 1, flooredZ).func_149688_o() == Material.field_151586_h) {
            this.timeToJump = 0;
            this.waterJump();
        }
        if ((this.cachedPosition == null || this.field_70146_Z.nextInt(100) == 0 || this.cachedPosition.func_71569_e(flooredX, flooredY, flooredZ) < 2.0f || this.cachedPosition.func_71569_e(flooredX, this.cachedPosition.field_71572_b, flooredZ) < 1.0f) && this.field_70789_a == null) {
            this.cachedPosition = new ChunkCoordinates(flooredX + this.field_70146_Z.nextInt(12) - this.field_70146_Z.nextInt(12), flooredY + this.field_70146_Z.nextInt(8) - 2, flooredZ + this.field_70146_Z.nextInt(12) - this.field_70146_Z.nextInt(12));
        } else if (this.field_70789_a != null) {
            this.cachedPosition = null;
            int targetX = (int)this.field_70789_a.field_70165_t;
            int targetY = (int)this.field_70789_a.field_70163_u;
            int targetZ = (int)this.field_70789_a.field_70161_v;
            this.cachedPosition = targetY < (int)((float)targetY + this.field_70789_a.func_70047_e()) && this.field_70170_p.func_147439_a(targetX, (int)((float)targetY + this.field_70789_a.func_70047_e()), targetZ).func_149688_o() == Material.field_151586_h ? new ChunkCoordinates(targetX - 1, targetY + 1, targetZ) : new ChunkCoordinates(targetX - 1, targetY, targetZ);
        }
        int cachedX = this.cachedPosition.field_71574_a;
        int cachedY = this.cachedPosition.field_71572_b;
        int cachedZ = this.cachedPosition.field_71573_c;
        if (this.cachedPosition != null && this.field_70170_p.func_147439_a(cachedX, cachedY, cachedZ).func_149688_o() != Material.field_151586_h || cachedY < 1) {
            this.cachedPosition = null;
        }
        if (this.cachedPosition != null && blockAtPos.func_149688_o() == Material.field_151586_h) {
            double xDist = (double)cachedX + 0.5 - this.field_70165_t;
            double zDist = (double)cachedZ + 0.5 - this.field_70161_v;
            double speed = this.field_70789_a == null ? 0.07 : 0.12;
            this.field_70159_w += (Math.signum(xDist) * speed - this.field_70159_w) * 0.5;
            this.field_70179_y += (Math.signum(zDist) * speed - this.field_70179_y) * 0.5;
            this.field_70701_bs = 0.05f;
        }
        if (this.getGrowingAge() >= 0) {
            if (this.getIsSeaMonster() || this.func_94056_bM() && "Leviathan".equals(this.func_94057_bL())) {
                this.findLivingToAttack();
            } else if (!this.getIsWild()) {
                this.findMobToAttack();
            } else if (!this.canSeaScorpionSeeSky() && !this.field_70170_p.func_72935_r() && this.field_70170_p.func_72911_I() && this.field_70170_p.func_72896_J() && this.func_70013_c(1.0f) < 0.5f) {
                this.findHumanToAttack();
            }
        }
        if (this.field_70789_a != null) {
            if (this.getGrowingAge() < 0 || !this.canAttackTargetBeSeen(this.field_70789_a)) {
                this.field_70789_a = null;
            } else {
                int targetZ;
                int targetY;
                int targetX = MathHelper.func_76128_c((double)this.field_70789_a.field_70165_t);
                if (this.field_70170_p.func_147439_a(targetX, targetY = MathHelper.func_76128_c((double)this.field_70789_a.field_70163_u), targetZ = MathHelper.func_76128_c((double)this.field_70789_a.field_70161_v)).func_149688_o() != Material.field_151586_h && this.field_70170_p.func_147439_a(targetX, targetY - 1, targetZ).func_149688_o() != Material.field_151586_h) {
                    this.field_70789_a = null;
                }
            }
        }
        if ((age = this.getGrowingAge()) < 0) {
            ++age;
        } else if (age > 0) {
            --age;
        }
        this.setGrowingAge(age);
        int regen = this.getRegeneration();
        if (regen < 0) {
            ++regen;
        } else if (regen > 0) {
            --regen;
        } else if (!this.getIsWild() && (double)this.func_110143_aJ() < this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111126_e() && blockAtPos.func_149688_o() == Material.field_151586_h) {
            regen = this.field_70789_a == null ? 80 : 50;
            this.func_70691_i(1.0f);
        }
        this.setRegeneration(regen);
        if (this.field_70170_p.field_72995_K && this.eatingTimer > 0) {
            String particleName = "iconcrack_" + Item.func_150891_b((Item)this.food.func_77973_b());
            if (this.food.func_77981_g()) {
                particleName = particleName + "_" + this.food.func_77960_j();
            }
            for (int i = 0; i < 3; ++i) {
                double d0 = this.field_70146_Z.nextGaussian() * 0.01;
                double d1 = this.field_70146_Z.nextGaussian() * 0.01;
                double d2 = this.field_70146_Z.nextGaussian() * 0.01;
                this.field_70170_p.func_72869_a(particleName, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 1.5f) - (double)this.field_70130_N, this.field_70163_u + 0.5 + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O) - 0.5, this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 1.5f) - (double)this.field_70130_N, d0, d1, d2);
            }
        }
        if (this.eatingTimer < 0) {
            ++this.eatingTimer;
        } else if (this.eatingTimer > 0) {
            --this.eatingTimer;
        }
        this.prevSeaScorpionPitch = this.seaScorpionPitch;
        double d0 = Math.sqrt(Math.abs(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y));
        if (this.timeToCalculatePosY > 0) {
            --this.timeToCalculatePosY;
        } else {
            this.timeToCalculatePosY = 2;
            this.movedDist = -(this.prevPosY - this.field_70163_u);
            this.prevPosY = this.field_70163_u;
        }
        this.nextSeaScorpionPitch = (float)(d0 * 100.0 * (this.movedDist * 10.0));
        if (this.seaScorpionPitch < this.nextSeaScorpionPitch - 4.0f) {
            this.seaScorpionPitch += 2.0f;
        } else if (this.seaScorpionPitch > this.nextSeaScorpionPitch + 4.0f) {
            this.seaScorpionPitch -= 2.0f;
        }
    }

    protected void waterJump() {
        this.field_70181_x = 0.4;
        if (this.func_70644_a(Potion.field_76430_j)) {
            this.field_70181_x += (double)((float)(this.func_70660_b(Potion.field_76430_j).func_76458_c() + 1) * 0.1f);
        }
        this.field_70159_w *= 1.5;
        this.field_70179_y *= 1.5;
        this.field_70160_al = true;
    }

    public void func_70626_be() {
        super.func_70626_be();
        this.field_70761_aq = this.field_70177_z = -((float)Math.atan2(this.field_70159_w, this.field_70179_y)) * 180.0f / (float)Math.PI;
    }

    protected void checkBlockCollision() {
        if (this.cachedPosition == null || this.cachedPosition.field_71572_b != (int)this.field_70163_u) {
            return;
        }
        int spawnX = this.cachedPosition.field_71574_a;
        int spawnY = this.cachedPosition.field_71572_b;
        int spawnZ = this.cachedPosition.field_71573_c;
        int x = MathHelper.func_76128_c((double)this.field_70165_t);
        int y = MathHelper.func_76128_c((double)this.field_70163_u);
        int z = MathHelper.func_76128_c((double)this.field_70161_v);
        if ((double)spawnZ > this.field_70161_v && this.field_70170_p.func_147439_a(x, y, z + 1).func_149721_r()) {
            this.cachedPosition = this.field_70789_a == null ? new ChunkCoordinates(x + this.field_70146_Z.nextInt(12) - this.field_70146_Z.nextInt(12), y + this.field_70146_Z.nextInt(8) - 2, z - this.field_70146_Z.nextInt(12)) : null;
        } else if ((double)spawnX < this.field_70165_t && this.field_70170_p.func_147439_a(x - 1, y, z).func_149721_r()) {
            this.cachedPosition = this.field_70789_a == null ? new ChunkCoordinates(x + this.field_70146_Z.nextInt(12), y + this.field_70146_Z.nextInt(8) - 2, z + this.field_70146_Z.nextInt(12) - this.field_70146_Z.nextInt(12)) : null;
        } else if ((double)spawnZ < this.field_70161_v && this.field_70170_p.func_147439_a(x, y, z - 1).func_149721_r()) {
            this.cachedPosition = this.field_70789_a == null ? new ChunkCoordinates(x + this.field_70146_Z.nextInt(12) - this.field_70146_Z.nextInt(12), y + this.field_70146_Z.nextInt(8) - 2, z + this.field_70146_Z.nextInt(12)) : null;
        } else if ((double)spawnX > this.field_70165_t && this.field_70170_p.func_147439_a(x + 1, y, z).func_149721_r()) {
            this.cachedPosition = this.field_70789_a == null ? new ChunkCoordinates(x - this.field_70146_Z.nextInt(12), y + this.field_70146_Z.nextInt(8) - 2, z + this.field_70146_Z.nextInt(12) - this.field_70146_Z.nextInt(12)) : null;
        }
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K) {
            if (this.field_70170_p.field_73013_u == EnumDifficulty.PEACEFUL && this.getIsWild()) {
                this.func_70106_y();
            }
        } else {
            this.setScaleForAge(this.func_70631_g_(), this.getSize());
        }
    }

    public void func_70030_z() {
        int air = this.func_70086_ai();
        super.func_70030_z();
        if (this.func_70089_S() && this.field_70170_p.func_147439_a(MathHelper.func_76128_c((double)this.field_70165_t), MathHelper.func_76128_c((double)this.field_70163_u), MathHelper.func_76128_c((double)this.field_70161_v)).func_149688_o() != Material.field_151586_h) {
            this.func_70050_g(--air);
            if (air <= -20) {
                this.func_70050_g(0);
                this.func_70097_a(DamageSource.field_76369_e, 2.0f);
            }
        } else {
            this.func_70050_g(300);
        }
    }

    public boolean canAttackTargetBeSeen(Entity entity) {
        return this.field_70170_p.func_72933_a(Vec3.func_72443_a((double)this.field_70165_t, (double)(this.field_70163_u + (double)this.func_70047_e()), (double)this.field_70161_v), Vec3.func_72443_a((double)entity.field_70165_t, (double)(entity.field_70163_u + 0.1), (double)entity.field_70161_v)) == null;
    }

    @Override
    public boolean func_70652_k(Entity entity) {
        if (this.getGrowingAge() >= 0 && this.field_70170_p.func_147439_a(MathHelper.func_76128_c((double)this.field_70165_t), MathHelper.func_76128_c((double)this.field_70163_u), MathHelper.func_76128_c((double)this.field_70161_v)).func_149688_o() == Material.field_151586_h) {
            float damage = (float)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e();
            int knockback = 0;
            if (entity instanceof EntityLivingBase) {
                damage += EnchantmentHelper.func_77512_a((EntityLivingBase)this, (EntityLivingBase)((EntityLivingBase)entity));
                knockback += EnchantmentHelper.func_77507_b((EntityLivingBase)this, (EntityLivingBase)((EntityLivingBase)entity));
            }
            if (!this.getIsWild() && !(entity instanceof EntityPlayer)) {
                damage += 5.0f;
            }
            if (entity.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), damage + 5.0f)) {
                int fireAspect;
                if (knockback > 0) {
                    entity.func_70024_g((double)(-MathHelper.func_76126_a((float)(this.field_70177_z * (float)Math.PI / 180.0f)) * (float)knockback * 0.5f), 0.1, (double)(MathHelper.func_76134_b((float)(this.field_70177_z * (float)Math.PI / 180.0f)) * (float)knockback * 0.5f));
                    this.field_70159_w *= 0.6;
                    this.field_70179_y *= 0.6;
                }
                if ((fireAspect = EnchantmentHelper.func_90036_a((EntityLivingBase)this)) > 0) {
                    entity.func_70015_d(fireAspect * 4);
                }
                if (entity instanceof EntityLivingBase) {
                    EnchantmentHelper.func_151384_a((EntityLivingBase)((EntityLivingBase)entity), (Entity)this);
                }
                EnchantmentHelper.func_151385_b((EntityLivingBase)this, (Entity)entity);
                return true;
            }
        }
        return false;
    }

    protected void findMobToAttack() {
        this.findAttackTarget(this.targetEntitySelectorMob);
    }

    protected void findHumanToAttack() {
        this.findAttackTarget(this.targetEntitySelectorHuman);
    }

    protected void findLivingToAttack() {
        this.findAttackTarget(this.targetEntitySelectorLiving);
    }

    protected void findAttackTarget(IEntitySelector selector) {
        List list = this.field_70170_p.func_82733_a(EntityLivingBase.class, this.field_70121_D.func_72314_b(16.0, 16.0, 16.0), selector);
        Collections.sort(list, this.theNearestAttackableTargetSorter);
        if (!list.isEmpty() && this.field_70789_a == null) {
            this.field_70789_a = (EntityLivingBase)list.get(0);
        }
    }

    @Override
    protected Entity func_70782_k() {
        return null;
    }

    public void setScaleForAge(boolean isChild, int size) {
        int i = size + 1;
        this.func_70105_a(isChild ? (0.2f + (float)i * 0.2f) / 2.0f : 0.2f + (float)i * 0.2f, isChild ? (0.025f + (float)i * 0.025f) / 2.0f : 0.05f + (float)i * 0.05f);
    }

    public boolean func_70631_g_() {
        return this.getGrowingAge() < 0;
    }

    @Override
    public boolean func_70097_a(DamageSource source, float amount) {
        if (!this.func_85032_ar() && super.func_70097_a(source, amount)) {
            Entity entity = source.func_76346_g();
            if (this.field_70153_n != entity && this.field_70154_o != entity && entity != this && this.func_70654_ax() >= 0) {
                this.field_70789_a = entity;
            }
            return true;
        }
        return false;
    }

    public boolean func_70085_c(EntityPlayer player) {
        ItemStack stack = player.field_71071_by.func_70448_g();
        if (!this.field_70170_p.field_72995_K && stack != null) {
            Item item = stack.func_77973_b();
            if (item == Items.field_151131_as && !this.getIsWild() && !this.getIsSeaMonster()) {
                int i = 4;
                if (this.getGrowingAge() >= 0 && this.getSize() == 0) {
                    i = 1;
                } else if (this.getGrowingAge() < 0) {
                    switch (this.getSize()) {
                        case 0: {
                            i = 2;
                            break;
                        }
                        case 1: {
                            i = 3;
                            break;
                        }
                        case 2: {
                            i = 0;
                        }
                    }
                }
                if (i < 4) {
                    ItemStack bucket = new ItemStack(WildMobsModItems.seaScorpionBucket, 1, i);
                    if (--stack.field_77994_a < 1) {
                        player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, bucket);
                    } else if (!player.field_71071_by.func_70441_a(bucket)) {
                        player.func_71019_a(bucket, false);
                    }
                    this.func_70106_y();
                    return true;
                }
                return super.func_70085_c(player);
            }
            if (item == WildMobsModItems.seaScorpionSpawnEgg) {
                EntitySeaScorpion entityseascorpion = new EntitySeaScorpion(this.field_70170_p);
                entityseascorpion.setGrowingAge(-24000);
                entityseascorpion.setSize(this.getSize());
                entityseascorpion.setIsWild(this.getIsWild());
                entityseascorpion.setIsSeaMonster(this.getIsSeaMonster());
                entityseascorpion.func_70012_b(this.field_70165_t, this.field_70163_u, this.field_70161_v, 0.0f, 0.0f);
                this.field_70170_p.func_72838_d((Entity)entityseascorpion);
                if (stack.func_82837_s()) {
                    entityseascorpion.func_94058_c(stack.func_82833_r());
                }
                if (!player.field_71075_bZ.field_75098_d && --stack.field_77994_a < 1) {
                    player.func_71028_bD();
                }
                return true;
            }
            if (item instanceof ItemFood) {
                ItemFood itemfood = (ItemFood)item;
                if (this.isHealingItem(stack) && (double)this.func_110143_aJ() < this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111126_e() && !this.getIsWild()) {
                    if (!player.field_71075_bZ.field_75098_d) {
                        --stack.field_77994_a;
                    }
                    this.func_70691_i(itemfood.func_150905_g(stack));
                    this.food = stack;
                    this.eatingTimer = 10;
                    if (stack.field_77994_a < 1) {
                        player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, (ItemStack)null);
                    }
                    return true;
                }
                return super.func_70085_c(player);
            }
        }
        return super.func_70085_c(player);
    }

    public boolean isHealingItem(ItemStack stack) {
        if (stack == null) {
            return false;
        }
        Item item = stack.func_77973_b();
        return item == Items.field_151115_aP || item == WildMobsModItems.rawCalamari;
    }

    protected void func_70628_a(boolean playerkill, int looting) {
        if (this.getGrowingAge() >= 0) {
            int amount = this.field_70146_Z.nextInt(1 + this.getSize()) + this.field_70146_Z.nextInt(1 + looting);
            int type = this.field_70146_Z.nextInt(100);
            for (int k = 0; k < amount; ++k) {
                if (this.func_70027_ad()) {
                    if (type < 60) {
                        this.func_70099_a(new ItemStack(Items.field_151101_aQ, 1, 0), 0.0f);
                        continue;
                    }
                    if (type < 85) {
                        this.func_70099_a(new ItemStack(Items.field_151101_aQ, 1, 1), 0.0f);
                        continue;
                    }
                    if (type < 87) {
                        this.func_70099_a(new ItemStack(Items.field_151115_aP, 1, 2), 0.0f);
                        continue;
                    }
                    this.func_70099_a(new ItemStack(Items.field_151115_aP, 1, 3), 0.0f);
                    continue;
                }
                if (type < 60) {
                    this.func_70099_a(new ItemStack(Items.field_151115_aP, 1, 0), 0.0f);
                    continue;
                }
                if (type < 85) {
                    this.func_70099_a(new ItemStack(Items.field_151115_aP, 1, 1), 0.0f);
                    continue;
                }
                if (type < 87) {
                    this.func_70099_a(new ItemStack(Items.field_151115_aP, 1, 2), 0.0f);
                    continue;
                }
                this.func_70099_a(new ItemStack(Items.field_151115_aP, 1, 3), 0.0f);
            }
            if (this.field_70146_Z.nextInt(100) <= 4 + this.getSize() + looting) {
                this.func_145779_a(WildMobsModItems.seaScorpionEgg, 1);
            }
        }
    }

    public IEntityLivingData func_110161_a(IEntityLivingData data) {
        data = super.func_110161_a(data);
        int size = 4;
        int i = this.field_70146_Z.nextInt(8);
        if (i < 4) {
            size = 1;
        } else if (i < 7) {
            size = 2;
        }
        this.setSize(size);
        this.setIsWild(true);
        return data;
    }

    public void trySpawnPack() {
        if (!this.canSpawnPack) {
            return;
        }
        for (int k = 0; k < 3; ++k) {
            double x = this.field_70165_t + (double)this.field_70170_p.field_73012_v.nextInt(5) - (double)this.field_70170_p.field_73012_v.nextInt(5);
            double y = this.field_70163_u + (double)this.field_70170_p.field_73012_v.nextInt(2) - (double)this.field_70170_p.field_73012_v.nextInt(2);
            double z = this.field_70161_v + (double)this.field_70170_p.field_73012_v.nextInt(5) - (double)this.field_70170_p.field_73012_v.nextInt(5);
            EntitySeaScorpion entityseascorpion = new EntitySeaScorpion(this.field_70170_p);
            entityseascorpion.func_70107_b(x, y, z);
            entityseascorpion.func_110161_a(null);
            entityseascorpion.setSize(this.getSize());
            entityseascorpion.canSpawnPack = false;
            if (!entityseascorpion.func_70601_bi()) continue;
            this.field_70170_p.func_72838_d((Entity)entityseascorpion);
        }
    }

    public boolean canSeaScorpionSeeSky() {
        boolean flag = false;
        int i = 0;
        int x = MathHelper.func_76128_c((double)this.field_70165_t);
        int y = MathHelper.func_76128_c((double)this.field_70121_D.field_72338_b);
        int z = MathHelper.func_76128_c((double)this.field_70161_v);
        int k = y;
        while (k < 255) {
            Block block = this.field_70170_p.func_147439_a(x, k, z);
            if (block.func_149721_r()) {
                k = 255;
                flag = false;
            } else if (k >= 255) {
                flag = true;
            }
            i = k++;
        }
        return flag;
    }

    @Override
    public boolean func_70601_bi() {
        boolean flag;
        int x = MathHelper.func_76128_c((double)this.field_70165_t);
        int y = MathHelper.func_76128_c((double)this.field_70121_D.field_72338_b);
        int z = MathHelper.func_76128_c((double)this.field_70161_v);
        Block block = this.field_70170_p.func_147439_a(x, y, z);
        boolean bl = flag = this.field_70170_p.field_73013_u != EnumDifficulty.PEACEFUL && this.isValidLightLevel() && this.field_70170_p.func_72855_b(this.field_70121_D) && this.field_70170_p.func_72945_a((Entity)this, this.field_70121_D).isEmpty() && block.func_149688_o() == Material.field_151586_h;
        if (flag && this.field_70170_p.func_72935_r() && !this.field_70170_p.func_72912_H().func_76061_m()) {
            return this.canSeaScorpionSeeSky();
        }
        return flag;
    }

    public static class Sorter
    implements Comparator {
        private final Entity theEntity;

        public Sorter(Entity entity) {
            this.theEntity = entity;
        }

        public int compare(Entity entity1, Entity entity2) {
            double distance2;
            double distance1 = this.theEntity.func_70068_e(entity1);
            return distance1 < (distance2 = this.theEntity.func_70068_e(entity2)) ? -1 : (distance1 > distance2 ? 1 : 0);
        }

        public int compare(Object obj1, Object obj2) {
            return this.compare((Entity)obj1, (Entity)obj2);
        }
    }
}

