/*
 * Decompiled with CFR 0.152.
 */
package com.wildmobsmod.entity.passive.jellyfish;

import com.wildmobsmod.entity.EntityConfig;
import net.minecraftforge.common.config.Configuration;

public class EntityConfigJellyfish
extends EntityConfig {
    protected final int defaultNetherSpawnrate;
    protected int netherSpawnrate;

    public static EntityConfigJellyfish construct(String id, int spawnrate, int minPack, int maxPack, boolean enabled, int netherSpawnrate) {
        EntityConfigJellyfish cfg = new EntityConfigJellyfish(id, spawnrate, minPack, maxPack, enabled, netherSpawnrate);
        EntityConfigJellyfish.registerEntityConfig(cfg);
        return cfg;
    }

    protected EntityConfigJellyfish(String id, int defaultSpawnrate, int defaultMinPack, int defaultMaxPack, boolean defaultEnabled, int defaultNetherSpawnrate) {
        super(id, defaultSpawnrate, defaultMinPack, defaultMaxPack, defaultEnabled);
        this.defaultNetherSpawnrate = defaultNetherSpawnrate;
        this.netherSpawnrate = defaultNetherSpawnrate;
    }

    @Override
    protected void sync(Configuration config) {
        super.sync(config);
        this.netherSpawnrate = config.getInt("netherSpawnrate", this.getConfigCategory(), this.defaultNetherSpawnrate, 0, 100, "Nether Medusae (nether variant of the Jellyfish) spawnrate. (Note that pack size will always be 1-2)");
    }

    public int getNetherSpawnrate() {
        return this.netherSpawnrate;
    }

    public int getNetherMinPackSize() {
        return Math.max(1, this.getMinPackSize() / 2);
    }

    public int getNetherMaxPackSize() {
        return Math.max(1, this.getMaxPackSize() / 2);
    }
}

