/*
 * Decompiled with CFR 0.152.
 */
package com.wildmobsmod.main;

import com.wildmobsmod.entity.EntityConfig;
import com.wildmobsmod.entity.monster.dreath.EntityConfigDreathMired;
import com.wildmobsmod.entity.passive.hyena.EntityConfigHyena;
import com.wildmobsmod.entity.passive.jellyfish.EntityConfigJellyfish;
import com.wildmobsmod.entity.passive.mouse.EntityConfigMouse;
import com.wildmobsmod.entity.passive.ocelot.EntityConfigOcelot;
import com.wildmobsmod.entity.passive.wolf.EntityConfigWolf;
import com.wildmobsmod.items.WildMobsModItems;
import com.wildmobsmod.main.CommonProxy;
import com.wildmobsmod.main.IProxy;
import com.wildmobsmod.misc.AquaHealingDrinkWaterHandler;
import com.wildmobsmod.misc.CreeperAvoidWMOcelotHandler;
import com.wildmobsmod.misc.MobDropsHandler;
import com.wildmobsmod.misc.OcelotHuntMiceHandler;
import com.wildmobsmod.misc.OcelotOverrideHandler;
import com.wildmobsmod.misc.PotionAquaHealing;
import com.wildmobsmod.misc.SeaScorpionSpecialSpawnHandler;
import com.wildmobsmod.misc.SkeletonWolfHandler;
import com.wildmobsmod.misc.WolfOverrideHandler;
import cpw.mods.fml.client.event.ConfigChangedEvent;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.ModMetadata;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.stats.Achievement;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;

@Mod(modid="wildmobsmod", name="Wild Mobs", version="1.5.3", guiFactory="com.wildmobsmod.main.GUIFactory")
public class WildMobsMod {
    public static final String MODID = "wildmobsmod";
    public static final String MODNAME = "Wild Mobs";
    public static final String VERSION = "1.5.3";
    @SidedProxy(clientSide="com.wildmobsmod.main.ClientProxy", serverSide="com.wildmobsmod.main.ServerProxy")
    public static IProxy proxy;
    public static Configuration config;
    public static final String CONFIG_CATEGORY_GENERAL = "_general";
    public static final String CONFIG_CATEGORY_ENTITIES = "entities";
    public static int aquaHealingID;
    public static boolean enableCalamari;
    public static int skeletonWolfChance;
    public static final boolean enableFoxUnnaturalVariants = true;
    private static final String[] MIRED_LOOT;
    public static final EntityConfigDreathMired DREATH_MIRED_CONFIG;
    public static final EntityConfig FADED_CONFIG;
    public static final EntityConfig MAGMAPLANT_CONFIG;
    public static final EntityConfig SEASCORPION_CONFIG;
    public static final EntityConfig TARANTULA_CONFIG;
    public static final EntityConfig ZOMGUS_CONFIG;
    public static final EntityConfig ARMADILLO_CONFIG;
    public static final EntityConfig BISON_CONFIG;
    public static final EntityConfig BUTTERFLY_CONFIG;
    public static final EntityConfig COUGAR_CONFIG;
    public static final EntityConfig CHEETAH_CONFIG;
    public static final EntityConfig DEER_CONFIG;
    public static final EntityConfig DIREWOLF_CONFIG;
    public static final EntityConfig DRAGONFLY_CONFIG;
    public static final EntityConfig FOX_CONFIG;
    public static final EntityConfig GOAT_CONFIG;
    public static final EntityConfig GOOSE_CONFIG;
    public static final EntityConfigHyena HYENA_CONFIG;
    public static final EntityConfigJellyfish JELLYFISH_CONFIG;
    public static final EntityConfigMouse MOUSE_CONFIG;
    public static final EntityConfigOcelot OCELOT_CONFIG;
    public static final EntityConfigWolf WOLF_CONFIG;
    @Mod.Metadata
    public static ModMetadata meta;
    @Mod.Instance(value="wildmobsmod")
    public static WildMobsMod modInstance;
    public static final CreativeTabs TAB_WILDMOBS;
    public static Potion potionAquaHealing;
    public static Achievement achievementTameDireWolf;
    public static Achievement achievementKillWizard;
    public static final String ENTITY_LOADING_FLAG_NAME = "wm_NotNewChecked";

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        config = new Configuration(event.getSuggestedConfigurationFile());
        WildMobsMod.syncConfig();
        FMLCommonHandler.instance().bus().register((Object)modInstance);
        proxy.registerModObjects();
        proxy.registerRenderThings();
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        CommonProxy.expandPotionArray();
        if (WOLF_CONFIG.isEnabled() && WOLF_CONFIG.getOverrideChance() > 0) {
            MinecraftForge.EVENT_BUS.register((Object)new WolfOverrideHandler());
        }
        if (skeletonWolfChance > -1) {
            MinecraftForge.EVENT_BUS.register((Object)new SkeletonWolfHandler());
        }
        if (MOUSE_CONFIG.isEnabled()) {
            MinecraftForge.EVENT_BUS.register((Object)new OcelotHuntMiceHandler());
        }
        if (OCELOT_CONFIG.isEnabled()) {
            MinecraftForge.EVENT_BUS.register((Object)new CreeperAvoidWMOcelotHandler());
            if (OCELOT_CONFIG.getOverrideChance() > 0) {
                MinecraftForge.EVENT_BUS.register((Object)new OcelotOverrideHandler());
            }
        }
        if (SEASCORPION_CONFIG.isEnabled()) {
            MinecraftForge.EVENT_BUS.register((Object)new SeaScorpionSpecialSpawnHandler());
            MinecraftForge.EVENT_BUS.register((Object)new AquaHealingDrinkWaterHandler());
        }
        if (enableCalamari) {
            MinecraftForge.EVENT_BUS.register((Object)new MobDropsHandler());
        }
        potionAquaHealing = new PotionAquaHealing(aquaHealingID).func_76399_b(0, 0).func_76390_b("potion.wildmobs.aqua_healing");
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        proxy.performCompatRelevantActions();
    }

    public static void syncConfig() {
        skeletonWolfChance = config.getInt("skeletonWolfChance", CONFIG_CATEGORY_ENTITIES, 3, -1, 100, "Chance (in Percent) for a Skeleton Wolf to spawn alongside a Skeleton (0 to disable; -1 to prevent the Skeleton Wolf Entity from being registered)");
        aquaHealingID = config.getInt("aquaHealingId", CONFIG_CATEGORY_GENERAL, 40, 0, 1024, "The Potion ID for Aqua Healing, please do your research before changing this!");
        enableCalamari = config.getBoolean("enableCalamari", CONFIG_CATEGORY_GENERAL, true, "Make Squids drop calamari");
        EntityConfig.syncAll(config);
        if (config.hasChanged()) {
            config.save();
        }
    }

    @SubscribeEvent
    public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent eventArgs) {
        if (eventArgs.modID.equals(MODID)) {
            WildMobsMod.syncConfig();
        }
    }

    public static boolean checkIsEntityNew(Entity entity) {
        NBTTagCompound nbt = entity.getEntityData();
        if (nbt.func_74767_n(ENTITY_LOADING_FLAG_NAME)) {
            return false;
        }
        nbt.func_74757_a(ENTITY_LOADING_FLAG_NAME, true);
        return true;
    }

    static {
        aquaHealingID = 40;
        enableCalamari = true;
        skeletonWolfChance = 3;
        MIRED_LOOT = new String[]{"minecraft:bone, 1, 8", "minecraft:bone, 2, 4", "minecraft:wheat_seeds, 1, 7", "minecraft:wheat_seeds, 2, 2", "minecraft:arrow, 1, 5", "minecraft:arrow, 2, 2", "minecraft:rotten_flesh, 1, 6", "minecraft:stick, 1, 5", "minecraft:torch, 1, 4", "minecraft:bread, 1, 4", "minecraft:poisonous_potato, 1, 3", "minecraft:potato, 1, 2", "minecraft:coal:1, 1, 2", "minecraft:book, 1, 1", "minecraft:book, 2, 1", "minecraft:stone_sword, 1, 1", "minecraft:stone_pickaxe, 1, 1", "minecraft:stone_axe, 1, 1", "minecraft:stone_shovel, 1, 1", "minecraft:leather_helmet, 1, 1", "minecraft:leather_chestplate, 1, 1", "minecraft:leather_leggings, 1, 1", "minecraft:leather_boots, 1, 1", "minecraft:gold_nugget, 1, 1"};
        DREATH_MIRED_CONFIG = EntityConfigDreathMired.construct("Dreath", 5, 1, 1, true, true, true, 1.0, true, 3, MIRED_LOOT, false);
        FADED_CONFIG = EntityConfig.construct("Faded", 4, 1, 1, true);
        MAGMAPLANT_CONFIG = EntityConfig.construct("Magma Plant", 8, 2, 4, true);
        SEASCORPION_CONFIG = EntityConfig.construct("Sea Scorpion", 5, 1, 1, true);
        TARANTULA_CONFIG = EntityConfig.construct("Tarantula", 15, 4, 4, true);
        ZOMGUS_CONFIG = EntityConfig.construct("Zomgus", 8, 4, 4, true);
        ARMADILLO_CONFIG = EntityConfig.construct("Armadillo", 5, 1, 1, true);
        BISON_CONFIG = EntityConfig.construct("Bison", 4, 6, 10, true);
        BUTTERFLY_CONFIG = EntityConfig.construct("Butterfly", 5, 1, 1, true);
        COUGAR_CONFIG = EntityConfig.construct("Cougar", 4, 1, 1, true);
        CHEETAH_CONFIG = EntityConfig.construct("Cheetah", 4, 1, 5, true);
        DEER_CONFIG = EntityConfig.construct("Deer", 7, 4, 4, true);
        DIREWOLF_CONFIG = EntityConfig.construct("Direwolf", 2, 4, 4, true);
        DRAGONFLY_CONFIG = EntityConfig.construct("Dragonfly", 7, 1, 4, true);
        FOX_CONFIG = EntityConfig.construct("Fox", 6, 1, 1, true);
        GOAT_CONFIG = EntityConfig.construct("Goat", 10, 4, 4, true);
        GOOSE_CONFIG = EntityConfig.construct("Goose", 8, 4, 4, true);
        HYENA_CONFIG = EntityConfigHyena.construct("Hyena", 4, 1, 5, true, true);
        JELLYFISH_CONFIG = EntityConfigJellyfish.construct("Jellyfish", 9, 3, 4, true, 2);
        MOUSE_CONFIG = EntityConfigMouse.construct("Mouse", 5, 1, 2, true, true);
        OCELOT_CONFIG = EntityConfigOcelot.construct("Ocelot", 2, 1, 1, true, 50);
        WOLF_CONFIG = EntityConfigWolf.construct("Wolf", 4, 4, 4, true, 50);
        TAB_WILDMOBS = new CreativeTabs(MODID){

            public Item func_78016_d() {
                return WildMobsModItems.fur;
            }
        };
    }
}

