/*
 * Decompiled with CFR 0.152.
 */
package com.wildmobsmod.misc;

import java.util.ArrayDeque;
import java.util.Random;

public class WeightedRandomSelector<T> {
    private final T[] values;
    private final LoadedDice dice;

    public WeightedRandomSelector(T[] values, double[] probabilities) {
        if (values == null || probabilities == null) {
            throw new NullPointerException();
        }
        if (values.length != probabilities.length) {
            throw new IllegalArgumentException("Value and probability arrays must have the same length!");
        }
        this.values = values;
        this.dice = new LoadedDice(probabilities);
    }

    public T next() {
        return this.values[this.dice.next()];
    }

    public static class LoadedDice {
        private final Random random;
        private final int[] alias;
        private final double[] chance;

        public LoadedDice(double[] probabilities) {
            this(probabilities, new Random());
        }

        public LoadedDice(double[] probabilities, Random random) {
            if (probabilities == null || random == null) {
                throw new NullPointerException();
            }
            int size = probabilities.length;
            if (size == 0) {
                throw new IllegalArgumentException("Cannot create a 0-sided dice! (probability array may not be empty)");
            }
            this.chance = new double[size];
            this.alias = new int[size];
            this.random = random;
            double average = 1.0 / (double)size;
            probabilities = (double[])probabilities.clone();
            ArrayDeque small = new ArrayDeque();
            ArrayDeque<Integer> large = new ArrayDeque<Integer>();
            for (int i = 0; i < size; ++i) {
                (probabilities[i] >= average ? large : small).add(i);
            }
            while (!small.isEmpty() && !large.isEmpty()) {
                double high;
                int less = (Integer)small.removeLast();
                int more = (Integer)large.removeLast();
                double low = probabilities[less];
                this.chance[less] = low * (double)size;
                this.alias[less] = more;
                probabilities[more] = high = probabilities[more] + low - average;
                (high >= average ? large : small).add(more);
            }
            while (!small.isEmpty()) {
                this.chance[((Integer)small.removeLast()).intValue()] = 1.0;
            }
            while (!large.isEmpty()) {
                this.chance[((Integer)large.removeLast()).intValue()] = 1.0;
            }
        }

        public int next() {
            int column = this.random.nextInt(this.chance.length);
            boolean coin = this.random.nextDouble() < this.chance[column];
            return coin ? column : this.alias[column];
        }
    }
}

