/*
 * Decompiled with CFR 0.152.
 */
package binnie.botany.genetics;

import binnie.botany.Botany;
import binnie.botany.api.EnumFlowerStage;
import binnie.botany.api.IFlowerType;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.util.IIcon;

public enum EnumFlowerType implements IFlowerType
{
    DANDELION,
    POPPY,
    ORCHID,
    ALLIUM,
    BLUET,
    TULIP,
    DAISY,
    CORNFLOWER,
    PANSY,
    IRIS,
    LAVENDER(2),
    VIOLA,
    DAFFODIL,
    DAHLIA,
    PEONY(2),
    ROSE(2),
    LILAC(2),
    HYDRANGEA(2),
    FOXGLOVE(2),
    ZINNIA,
    MUMS,
    MARIGOLD,
    GERANIUM,
    AZALEA,
    PRIMROSE,
    ASTER,
    CARNATION,
    LILY,
    YARROW,
    PETUNIA,
    AGAPANTHUS,
    FUCHSIA,
    DIANTHUS,
    FORGET,
    ANEMONE,
    AQUILEGIA,
    EDELWEISS,
    SCABIOUS,
    CONEFLOWER,
    GAILLARDIA,
    AURICULA,
    CAMELLIA(2),
    GOLDENROD(2),
    ALTHEA(2),
    PENSTEMON(2),
    DELPHINIUM(2),
    HOLLYHOCK(2);

    protected int sections;
    protected IIcon[] stem;
    protected IIcon[] petal;
    protected IIcon[] variant;
    protected IIcon[] unflowered;
    protected IIcon seedStem;
    protected IIcon seedPetal;
    protected IIcon seedVariant;
    protected IIcon pollenStem;
    protected IIcon pollenPetal;
    protected IIcon pollenVariant;
    protected IIcon blank;

    private EnumFlowerType() {
        this(1);
    }

    private EnumFlowerType(int sections) {
        this.sections = sections;
        this.stem = new IIcon[sections];
        this.petal = new IIcon[sections];
        this.variant = new IIcon[sections];
        this.unflowered = new IIcon[sections];
    }

    @Override
    public IIcon getStem(EnumFlowerStage stage, boolean flowered, int section) {
        if (stage == EnumFlowerStage.SEED) {
            return this.seedStem;
        }
        if (stage == EnumFlowerStage.POLLEN) {
            return this.pollenStem;
        }
        return this.stem[section % this.sections];
    }

    @Override
    public IIcon getPetalIcon(EnumFlowerStage stage, boolean flowered, int section) {
        if (stage == EnumFlowerStage.SEED) {
            return this.seedPetal;
        }
        if (stage == EnumFlowerStage.POLLEN) {
            return this.pollenPetal;
        }
        if (flowered) {
            return this.petal[section % this.sections];
        }
        return this.unflowered[section % this.sections];
    }

    @Override
    public IIcon getVariantIcon(EnumFlowerStage stage, boolean flowered, int section) {
        if (stage == EnumFlowerStage.SEED) {
            return this.seedVariant;
        }
        if (stage == EnumFlowerStage.POLLEN) {
            return this.pollenVariant;
        }
        return flowered ? this.variant[section % this.sections] : this.blank;
    }

    public void registerIcons(IIconRegister register) {
        for (int i = 0; i < this.sections; ++i) {
            String suf = i == 0 ? "" : "" + (i + 1);
            String pre = this.sections == 1 ? "" : "double/";
            String id = pre + this.toString().toLowerCase() + suf;
            this.stem[i] = Botany.proxy.getIcon(register, "flowers/" + id + ".0");
            this.petal[i] = Botany.proxy.getIcon(register, "flowers/" + id + ".1");
            this.variant[i] = Botany.proxy.getIcon(register, "flowers/" + id + ".2");
            this.unflowered[i] = Botany.proxy.getIcon(register, "flowers/" + id + ".3");
        }
        this.blank = Botany.proxy.getIcon(register, "flowers/blank");
        this.seedStem = Botany.proxy.getIcon(register, "flowers/seed.0");
        this.seedPetal = Botany.proxy.getIcon(register, "flowers/seed.1");
        this.seedVariant = Botany.proxy.getIcon(register, "flowers/seed.2");
        this.pollenStem = Botany.proxy.getIcon(register, "flowers/pollen.0");
        this.pollenPetal = Botany.proxy.getIcon(register, "flowers/pollen.1");
        this.pollenVariant = Botany.proxy.getIcon(register, "flowers/pollen.2");
    }

    @Override
    public int getID() {
        return this.ordinal();
    }

    @Override
    public int getSections() {
        return this.sections;
    }

    public IIcon getBlank() {
        return this.blank;
    }
}

