/*
 * Decompiled with CFR 0.152.
 */
package binnie.core.craftgui.minecraft;

import binnie.core.BinnieCore;
import binnie.core.craftgui.minecraft.CustomSlot;
import binnie.core.craftgui.minecraft.IWindowAffectsShiftClick;
import binnie.core.craftgui.minecraft.InventoryType;
import binnie.core.craftgui.minecraft.ListMap;
import binnie.core.craftgui.minecraft.Window;
import binnie.core.craftgui.minecraft.WindowInventory;
import binnie.core.craftgui.minecraft.control.ControlSlot;
import binnie.core.craftgui.minecraft.control.EnumHighlighting;
import binnie.core.machines.IMachine;
import binnie.core.machines.Machine;
import binnie.core.machines.network.INetwork;
import binnie.core.machines.power.ErrorState;
import binnie.core.machines.power.IErrorStateSource;
import binnie.core.machines.power.IPoweredMachine;
import binnie.core.machines.power.IProcess;
import binnie.core.machines.power.ITankMachine;
import binnie.core.machines.power.PowerInfo;
import binnie.core.machines.power.ProcessInfo;
import binnie.core.machines.power.TankInfo;
import binnie.core.machines.transfer.TransferRequest;
import binnie.core.network.packet.MessageContainerUpdate;
import com.mojang.authlib.GameProfile;
import cpw.mods.fml.relauncher.Side;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class ContainerCraftGUI
extends Container {
    private Window window;
    private Map<String, NBTTagCompound> syncedNBT;
    private Map<String, NBTTagCompound> sentNBT;
    private Map<Integer, TankInfo> syncedTanks;
    private PowerInfo syncedPower;
    private ProcessInfo syncedProcess;
    private int errorType;
    private ErrorState error;
    private int mousedOverSlotNumber;

    public ContainerCraftGUI(Window window) {
        this.window = window;
        this.syncedNBT = new HashMap<String, NBTTagCompound>();
        this.sentNBT = new HashMap<String, NBTTagCompound>();
        this.syncedTanks = new HashMap<Integer, TankInfo>();
        this.syncedPower = new PowerInfo();
        this.syncedProcess = new ProcessInfo();
        this.errorType = 0;
        this.error = null;
        this.mousedOverSlotNumber = -1;
        IMachine machine = Machine.getMachine(window.getInventory());
        if (this.getSide() != Side.SERVER) {
            return;
        }
        this.field_75153_a = new ListMap();
        this.field_75151_b = new ListMap();
        if (machine == null) {
            return;
        }
        GameProfile user = machine.getOwner();
        if (user != null) {
            NBTTagCompound nbt = new NBTTagCompound();
            nbt.func_74778_a("username", user.getName());
            this.sendNBTToClient("username", nbt);
        }
    }

    protected Slot func_75146_a(Slot slot) {
        return super.func_75146_a(slot);
    }

    private Side getSide() {
        return this.window.isServer() ? Side.SERVER : Side.CLIENT;
    }

    public Slot func_75139_a(int index) {
        if (index < 0 || index >= this.field_75151_b.size()) {
            return null;
        }
        return (Slot)this.field_75151_b.get(index);
    }

    public void func_75141_a(int index, ItemStack stack) {
        if (this.func_75139_a(index) != null) {
            this.func_75139_a(index).func_75215_d(stack);
        }
    }

    public void func_75131_a(ItemStack[] par1ArrayOfItemStack) {
        for (int i = 0; i < par1ArrayOfItemStack.length; ++i) {
            if (this.func_75139_a(i) == null) continue;
            this.func_75139_a(i).func_75215_d(par1ArrayOfItemStack[i]);
        }
    }

    public void func_75134_a(EntityPlayer player) {
        super.func_75134_a(player);
        WindowInventory inventory = this.window.getWindowInventory();
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            ItemStack stack;
            if (!inventory.dispenseOnClose(i) || (stack = inventory.func_70301_a(i)) == null || (stack = new TransferRequest(stack, (IInventory)player.field_71071_by).transfer(true)) == null) continue;
            player.func_71019_a(stack, false);
        }
    }

    public ItemStack func_75144_a(int slotNum, int mouseButton, int modifier, EntityPlayer player) {
        Slot slot = this.func_75139_a(slotNum);
        if (slot instanceof CustomSlot && ((CustomSlot)slot).handleClick()) {
            ((CustomSlot)slot).onSlotClick(this, mouseButton, modifier, player);
            return player.field_71071_by.func_70445_o();
        }
        return super.func_75144_a(slotNum, mouseButton, modifier, player);
    }

    public void sendNBTToClient(String key, NBTTagCompound nbt) {
        this.syncedNBT.put(key, nbt);
    }

    public boolean func_75145_c(EntityPlayer player) {
        IInventory inventory;
        if (player instanceof EntityPlayerMP) {
            if (!this.field_75149_d.contains(player)) {
                this.field_75149_d.add(player);
            }
            this.sentNBT.clear();
        }
        return (inventory = this.window.getInventory()) == null || inventory.func_70300_a(player);
    }

    public ItemStack func_82846_b(EntityPlayer player, int slotID) {
        return this.shiftClick(player, slotID);
    }

    private ItemStack shiftClick(EntityPlayer player, int index) {
        TransferRequest request = this.getShiftClickRequest(player, index);
        if (request == null) {
            return null;
        }
        ItemStack stack = request.transfer(true);
        Slot shiftClickedSlot = (Slot)this.field_75151_b.get(index);
        shiftClickedSlot.func_75215_d(stack);
        shiftClickedSlot.func_75218_e();
        return null;
    }

    private TransferRequest getShiftClickRequest(EntityPlayer player, int index) {
        if (index < 0) {
            return null;
        }
        Slot shiftClickedSlot = (Slot)this.field_75151_b.get(index);
        ItemStack itemstack = null;
        if (shiftClickedSlot.func_75216_d()) {
            itemstack = shiftClickedSlot.func_75211_c().func_77946_l();
        }
        InventoryPlayer playerInventory = player.field_71071_by;
        IInventory containerInventory = this.window.getInventory();
        WindowInventory windowInventory = this.window.getWindowInventory();
        WindowInventory fromPlayer = containerInventory == null ? windowInventory : containerInventory;
        int[] target = new int[36];
        for (int i = 0; i < 36; ++i) {
            target[i] = i;
        }
        TransferRequest request = shiftClickedSlot.field_75224_c == playerInventory ? new TransferRequest(itemstack, fromPlayer).setOrigin(shiftClickedSlot.field_75224_c) : new TransferRequest(itemstack, (IInventory)playerInventory).setOrigin(shiftClickedSlot.field_75224_c).setTargetSlots(target);
        if (this.window instanceof IWindowAffectsShiftClick) {
            ((IWindowAffectsShiftClick)((Object)this.window)).alterRequest(request);
        }
        return request;
    }

    public ItemStack tankClick(EntityPlayer player, int slotID) {
        ItemStack stack = player.field_71071_by.func_70445_o();
        if (stack == null || stack.field_77994_a != 1) {
            return null;
        }
        ItemStack heldItem = stack.func_77946_l();
        heldItem = new TransferRequest(heldItem, this.window.getInventory()).setOrigin((IInventory)player.field_71071_by).setTargetSlots(new int[0]).setTargetTanks(new int[]{slotID}).transfer(true);
        player.field_71071_by.func_70437_b(heldItem);
        if (player instanceof EntityPlayerMP) {
            ((EntityPlayerMP)player).func_71113_k();
        }
        return heldItem;
    }

    public boolean handleNBT(Side side, EntityPlayer player, String name, NBTTagCompound action) {
        if (side == Side.SERVER) {
            if (name.equals("tank-click")) {
                this.tankClick(player, action.func_74771_c("id"));
            }
            if (name.equals("slot-reg")) {
                byte type = action.func_74771_c("t");
                short index = action.func_74765_d("i");
                short slotNumber = action.func_74765_d("n");
                this.getOrCreateSlot(InventoryType.values()[type % 4], index, slotNumber);
                for (Object crafterObject : this.field_75149_d) {
                    ICrafting crafter = (ICrafting)crafterObject;
                    crafter.func_71110_a((Container)this, this.func_75138_a());
                }
            }
        }
        if (name.contains("tank-update")) {
            this.onTankUpdate(action);
        } else if (name.equals("power-update")) {
            this.onPowerUpdate(action);
        } else if (name.equals("process-update")) {
            this.onProcessUpdate(action);
        } else if (name.equals("error-update")) {
            this.onErrorUpdate(action);
        } else if (name.equals("mouse-over-slot")) {
            this.onMouseOverSlot(player, action);
        } else if (name.equals("shift-click-info")) {
            this.onRecieveShiftClickHighlights(player, action);
        }
        return false;
    }

    public void func_75142_b() {
        INetwork.SendGuiNBT machineSync;
        super.func_75142_b();
        ITankMachine tanks = Machine.getInterface(ITankMachine.class, this.window.getInventory());
        IPoweredMachine powered = Machine.getInterface(IPoweredMachine.class, this.window.getInventory());
        IErrorStateSource error = Machine.getInterface(IErrorStateSource.class, this.window.getInventory());
        IProcess process = Machine.getInterface(IProcess.class, this.window.getInventory());
        if (tanks != null && this.window.isServer()) {
            for (int i = 0; i < tanks.getTankInfos().length; ++i) {
                TankInfo tank = tanks.getTankInfos()[i];
                if (this.getTankInfo(i).equals(tank)) continue;
                this.syncedNBT.put("tank-update-" + i, this.createTankNBT(i, tank));
                this.syncedTanks.put(i, tank);
            }
        }
        if (powered != null && this.window.isServer()) {
            this.syncedNBT.put("power-update", this.createPowerNBT(powered.getPowerInfo()));
        }
        if (process != null && this.window.isServer()) {
            this.syncedNBT.put("process-update", this.createProcessNBT(process.getInfo()));
        }
        if (error != null && this.window.isServer()) {
            this.syncedNBT.put("error-update", this.createErrorNBT(error));
        }
        if ((machineSync = Machine.getInterface(INetwork.SendGuiNBT.class, this.window.getInventory())) != null) {
            machineSync.sendGuiNBT(this.syncedNBT);
        }
        HashMap<String, NBTTagCompound> sentThisTime = new HashMap<String, NBTTagCompound>();
        for (Map.Entry<String, NBTTagCompound> nbt : this.syncedNBT.entrySet()) {
            nbt.getValue().func_74778_a("type", nbt.getKey());
            boolean shouldSend = true;
            NBTTagCompound lastSent = this.sentNBT.get(nbt.getKey());
            if (lastSent != null) {
                boolean bl = shouldSend = !lastSent.equals((Object)nbt.getValue());
            }
            if (!shouldSend) continue;
            for (Object crafter : this.field_75149_d) {
                if (!(crafter instanceof EntityPlayerMP)) continue;
                EntityPlayerMP player = (EntityPlayerMP)crafter;
                BinnieCore.proxy.sendToPlayer(new MessageContainerUpdate(nbt.getValue()), (EntityPlayer)player);
            }
            sentThisTime.put(nbt.getKey(), nbt.getValue());
        }
        this.sentNBT.putAll(sentThisTime);
        this.syncedNBT.clear();
    }

    private NBTTagCompound createErrorNBT(IErrorStateSource error) {
        NBTTagCompound nbt = new NBTTagCompound();
        ErrorState state = null;
        if (error.canWork() != null) {
            nbt.func_74774_a("type", (byte)0);
            state = error.canWork();
        } else if (error.canProgress() != null) {
            nbt.func_74774_a("type", (byte)1);
            state = error.canProgress();
        }
        if (state != null) {
            state.writeToNBT(nbt);
        }
        return nbt;
    }

    public NBTTagCompound createPowerNBT(PowerInfo powerInfo) {
        NBTTagCompound nbt = new NBTTagCompound();
        powerInfo.writeToNBT(nbt);
        return nbt;
    }

    public NBTTagCompound createProcessNBT(ProcessInfo powerInfo) {
        NBTTagCompound nbt = new NBTTagCompound();
        powerInfo.writeToNBT(nbt);
        return nbt;
    }

    public NBTTagCompound createTankNBT(int tank, TankInfo tankInfo) {
        NBTTagCompound nbt = new NBTTagCompound();
        tankInfo.writeToNBT(nbt);
        nbt.func_74774_a("tank", (byte)tank);
        return nbt;
    }

    public void onTankUpdate(NBTTagCompound nbt) {
        byte tankID = nbt.func_74771_c("tank");
        TankInfo tank = new TankInfo();
        tank.readFromNBT(nbt);
        this.syncedTanks.put(Integer.valueOf(tankID), tank);
    }

    public void onProcessUpdate(NBTTagCompound nbt) {
        this.syncedProcess = new ProcessInfo();
        this.syncedProcess.readFromNBT(nbt);
    }

    public void onPowerUpdate(NBTTagCompound nbt) {
        this.syncedPower = new PowerInfo();
        this.syncedPower.readFromNBT(nbt);
    }

    public PowerInfo getPowerInfo() {
        return this.syncedPower;
    }

    public ProcessInfo getProcessInfo() {
        return this.syncedProcess;
    }

    public TankInfo getTankInfo(int tank) {
        return this.syncedTanks.containsKey(tank) ? this.syncedTanks.get(tank) : new TankInfo();
    }

    public void onErrorUpdate(NBTTagCompound nbt) {
        this.errorType = nbt.func_74771_c("type");
        if (nbt.func_74764_b("name")) {
            this.error = new ErrorState("", "");
            this.error.readFromNBT(nbt);
        } else {
            this.error = null;
        }
    }

    public ErrorState getErrorState() {
        return this.error;
    }

    public int getErrorType() {
        return this.errorType;
    }

    public CustomSlot[] getCustomSlots() {
        ArrayList<CustomSlot> slots = new ArrayList<CustomSlot>();
        for (Object object : this.field_75151_b) {
            if (!(object instanceof CustomSlot)) continue;
            slots.add((CustomSlot)((Object)object));
        }
        return slots.toArray(new CustomSlot[0]);
    }

    public void setMouseOverSlot(Slot slot) {
        if (slot.field_75222_d == this.mousedOverSlotNumber) {
            return;
        }
        this.mousedOverSlotNumber = slot.field_75222_d;
        ControlSlot.highlighting.get((Object)EnumHighlighting.SHIFT_CLICK).clear();
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74777_a("slot", (short)slot.field_75222_d);
        this.window.sendClientAction("mouse-over-slot", nbt);
    }

    private void onMouseOverSlot(EntityPlayer player, NBTTagCompound data) {
        short slotnumber = data.func_74765_d("slot");
        TransferRequest request = this.getShiftClickRequest(player, slotnumber);
        if (request == null) {
            return;
        }
        request.transfer(false);
        NBTTagCompound nbt = new NBTTagCompound();
        ArrayList<Integer> slots = new ArrayList<Integer>();
        for (TransferRequest.TransferSlot tslot : request.getInsertedSlots()) {
            CustomSlot slot = this.getSlot(tslot.inventory, tslot.id);
            if (slot == null) continue;
            slots.add(slot.field_75222_d);
        }
        int[] array = new int[slots.size()];
        for (int i = 0; i < slots.size(); ++i) {
            array[i] = (Integer)slots.get(i);
        }
        nbt.func_74783_a("slots", array);
        nbt.func_74777_a("origin", slotnumber);
        this.syncedNBT.put("shift-click-info", nbt);
    }

    private void onRecieveShiftClickHighlights(EntityPlayer player, NBTTagCompound data) {
        ControlSlot.highlighting.get((Object)EnumHighlighting.SHIFT_CLICK).clear();
        for (int slotnumber : data.func_74759_k("slots")) {
            ControlSlot.highlighting.get((Object)EnumHighlighting.SHIFT_CLICK).add(slotnumber);
        }
    }

    private CustomSlot getSlot(IInventory inventory, int id) {
        for (Object o : this.field_75151_b) {
            CustomSlot slot = (CustomSlot)((Object)o);
            if (slot.field_75224_c != inventory || slot.getSlotIndex() != id) continue;
            return slot;
        }
        return null;
    }

    public void recieveNBT(Side side, EntityPlayer player, NBTTagCompound action) {
        String name = action.func_74779_i("type");
        if (this.handleNBT(side, player, name, action)) {
            return;
        }
        this.window.recieveGuiNBT(this.getSide(), player, name, action);
        INetwork.RecieveGuiNBT machine = Machine.getInterface(INetwork.RecieveGuiNBT.class, this.window.getInventory());
        if (machine != null) {
            machine.recieveGuiNBT(this.getSide(), player, name, action);
        }
    }

    public Slot getOrCreateSlot(InventoryType type, int index) {
        IInventory inventory = this.getInventory(type);
        CustomSlot slot = this.getSlot(inventory, index);
        if (slot == null) {
            slot = new CustomSlot(inventory, index);
            this.func_75146_a(slot);
        }
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74774_a("t", (byte)type.ordinal());
        nbt.func_74777_a("i", (short)index);
        nbt.func_74777_a("n", (short)slot.field_75222_d);
        this.window.sendClientAction("slot-reg", nbt);
        return slot;
    }

    protected IInventory getInventory(InventoryType type) {
        if (type == InventoryType.Machine) {
            return this.window.getInventory();
        }
        if (type == InventoryType.Player) {
            return this.window.getPlayer().field_71071_by;
        }
        if (type == InventoryType.Window) {
            return this.window.getWindowInventory();
        }
        return null;
    }

    private Slot getOrCreateSlot(InventoryType type, int index, int slotNumber) {
        IInventory inventory = this.getInventory(type);
        if (this.field_75151_b.get(slotNumber) != null) {
            return null;
        }
        CustomSlot slot = new CustomSlot(inventory, index);
        slot.field_75222_d = slotNumber;
        this.field_75151_b.add(slotNumber, slot);
        this.field_75153_a.add(slotNumber, null);
        return slot;
    }
}

