/*
 * Decompiled with CFR 0.152.
 */
package binnie.extratrees.craftgui;

import binnie.core.craftgui.CraftGUI;
import binnie.core.craftgui.ITooltip;
import binnie.core.craftgui.IWidget;
import binnie.core.craftgui.Tooltip;
import binnie.core.craftgui.WidgetAttribute;
import binnie.core.craftgui.controls.core.Control;
import binnie.core.craftgui.events.EventHandler;
import binnie.core.craftgui.events.EventWidget;
import binnie.core.craftgui.geometry.IArea;
import binnie.core.craftgui.geometry.IPoint;
import binnie.core.craftgui.resource.minecraft.CraftGUITexture;
import binnie.extratrees.craftgui.ControlFluidDisplay;
import net.minecraftforge.fluids.FluidStack;

public class ControlSlotFluid
extends Control
implements ITooltip {
    protected ControlFluidDisplay itemDisplay;
    protected FluidStack fluidStack;

    public ControlSlotFluid(IWidget parent, int x, int y, FluidStack fluid) {
        this(parent, x, y, 18, fluid);
    }

    public ControlSlotFluid(IWidget parent, int x, int y, int size, FluidStack fluid) {
        super(parent, x, y, size, size);
        this.addAttribute(WidgetAttribute.MOUSE_OVER);
        this.itemDisplay = new ControlFluidDisplay(this, 1.0f, 1.0f, size - 2);
        this.fluidStack = fluid;
        this.addSelfEventHandler((EventHandler)new EventWidget.ChangeSize.Handler(){

            @Override
            public void onEvent(EventWidget.ChangeSize event) {
                if (ControlSlotFluid.this.itemDisplay != null) {
                    ControlSlotFluid.this.itemDisplay.setSize(ControlSlotFluid.this.getSize().sub(new IPoint(2.0f, 2.0f)));
                }
            }
        });
    }

    @Override
    public void onRenderBackground() {
        int size = (int)this.getSize().x();
        CraftGUI.render.texture((Object)CraftGUITexture.Slot, this.getArea());
        if (this.getSuperParent().getMousedOverWidget() == this) {
            CraftGUI.render.gradientRect(new IArea(new IPoint(1.0f, 1.0f), this.getArea().size().sub(new IPoint(2.0f, 2.0f))), -2130706433, -2130706433);
        }
    }

    @Override
    public void onUpdateClient() {
        super.onUpdateClient();
        this.itemDisplay.setItemStack(this.getFluidStack());
    }

    @Override
    public void getTooltip(Tooltip tooltip) {
        FluidStack item = this.getFluidStack();
        if (item == null) {
            return;
        }
        tooltip.add(item.getFluid().getLocalizedName());
    }

    public FluidStack getFluidStack() {
        return this.fluidStack;
    }
}

