/*
 * Decompiled with CFR 0.152.
 */
package binnie.extratrees.genetics;

import binnie.Binnie;
import binnie.core.util.I18N;
import binnie.extratrees.ExtraTrees;
import binnie.extratrees.block.FruitPod;
import binnie.extratrees.config.ConfigurationMain;
import binnie.extratrees.genetics.ExtraTreeFruitFamily;
import binnie.extratrees.genetics.FruitSprite;
import binnie.extratrees.item.Food;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import forestry.api.arboriculture.EnumTreeChromosome;
import forestry.api.arboriculture.IAlleleFruit;
import forestry.api.arboriculture.IAlleleTreeSpecies;
import forestry.api.arboriculture.IFruitProvider;
import forestry.api.arboriculture.ITreeGenome;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IAlleleSpecies;
import forestry.api.genetics.IChromosomeType;
import forestry.api.genetics.IFruitFamily;
import forestry.arboriculture.FruitProviderNone;
import forestry.arboriculture.genetics.alleles.AlleleTreeSpecies;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import sun.misc.Unsafe;

public enum ExtraTreeFruitGene implements IAlleleFruit,
IFruitProvider
{
    Blackthorn(10, 7180062, 14561129, FruitSprite.Small),
    CherryPlum(10, 7180062, 15211595, FruitSprite.Small),
    Peach(10, 7180062, 16424995, FruitSprite.Average),
    Nectarine(10, 7180062, 16405795, FruitSprite.Average),
    Apricot(10, 7180062, 16437027, FruitSprite.Average),
    Almond(10, 7180062, 9364342, FruitSprite.Small),
    WildCherry(10, 7180062, 0xFF0000, FruitSprite.Tiny),
    SourCherry(10, 7180062, 10225963, FruitSprite.Tiny),
    BlackCherry(10, 7180062, 4852249, FruitSprite.Tiny),
    Orange(10, 3665987, 16749578, FruitSprite.Average),
    Manderin(10, 3665987, 16749578, FruitSprite.Average),
    Tangerine(10, 3665987, 16749578, FruitSprite.Average),
    Satsuma(10, 3665987, 16749578, FruitSprite.Average),
    KeyLime(10, 3665987, 10223428, FruitSprite.Small),
    Lime(10, 3665987, 10223428, FruitSprite.Average),
    FingerLime(10, 3665987, 11156280, FruitSprite.Small),
    Pomelo(10, 3665987, 6083402, FruitSprite.Larger),
    Grapefruit(10, 3665987, 16749578, FruitSprite.Large),
    Kumquat(10, 3665987, 16749578, FruitSprite.Small),
    Citron(10, 3665987, 16772192, FruitSprite.Large),
    BuddhaHand(10, 3665987, 16772192, FruitSprite.Large),
    Apple(10, 7915859, 16193046, FruitSprite.Average),
    Crabapple(10, 7915859, 16760140, FruitSprite.Average),
    Banana("Banana", FruitPod.Banana),
    RedBanana("Red Banana", FruitPod.RedBanana),
    Plantain("Platain", FruitPod.Plantain),
    Hazelnut(7, 8223006, 14463606, FruitSprite.Small),
    Butternut(7, 11712336, 16102498, FruitSprite.Small),
    Beechnut(8, 14401148, 6241845, FruitSprite.Tiny),
    Pecan(8, 10660940, 15781769, FruitSprite.Small),
    BrazilNut(10, 5875561, 9852208, FruitSprite.Large),
    Fig(9, 14201186, 7094086, FruitSprite.Small),
    Acorn(6, 7516710, 11364893, FruitSprite.Tiny),
    Elderberry(9, 7444317, 5331779, FruitSprite.Tiny),
    Olive(9, 8887861, 6444842, FruitSprite.Small),
    GingkoNut(7, 9213787, 15063725, FruitSprite.Tiny),
    Coffee(8, 7433501, 16273254, FruitSprite.Tiny),
    Pear(10, 10456913, 10474833, FruitSprite.Pear),
    OsangeOsange(10, 9934674, 10665767, FruitSprite.Larger),
    Clove(9, 6847532, 11224133, FruitSprite.Tiny),
    Coconut("Coconut", FruitPod.Coconut),
    Cashew(8, 12879132, 15289111, FruitSprite.Average),
    Avacado(10, 10272370, 2170640, FruitSprite.Pear),
    Nutmeg(9, 14861101, 11305813, FruitSprite.Tiny),
    Allspice(9, 15180922, 7423542, FruitSprite.Tiny),
    Chilli(10, 7430757, 15145010, FruitSprite.Small),
    StarAnise(8, 8733742, 13917189, FruitSprite.Tiny),
    Mango(10, 6654997, 15902262, FruitSprite.Average),
    Starfruit(10, 9814541, 15061550, FruitSprite.Average),
    Candlenut(8, 8235123, 14600882, FruitSprite.Small),
    Papayimar("Papayimar", FruitPod.Papayimar),
    Blackcurrant(8, 9407571, 4935251, FruitSprite.Tiny),
    Redcurrant(8, 13008910, 15080974, FruitSprite.Tiny),
    Blackberry(8, 9399665, 4801393, FruitSprite.Tiny),
    Raspberry(8, 15520197, 14510449, FruitSprite.Tiny),
    Blueberry(8, 10203799, 6329278, FruitSprite.Tiny),
    Cranberry(8, 12232496, 14555696, FruitSprite.Tiny),
    Juniper(8, 10194034, 6316914, FruitSprite.Tiny),
    Gooseberry(8, 12164944, 12177232, FruitSprite.Tiny),
    GoldenRaspberry(8, 12496955, 15970363, FruitSprite.Tiny);

    protected IFruitFamily family;
    protected boolean isRipening;
    protected int diffR;
    protected int diffG;
    protected int diffB;
    protected FruitPod pod;
    protected int ripeningPeriod;
    protected int colorUnripe;
    protected int color;
    protected FruitSprite index;
    protected HashMap<ItemStack, Float> products;

    private ExtraTreeFruitGene(int time, int unripe, int color, FruitSprite index) {
        this.color = color;
        this.index = index;
        this.isRipening = false;
        this.diffB = 0;
        this.pod = null;
        this.ripeningPeriod = 0;
        this.products = new HashMap();
        this.setRipening(time, unripe);
    }

    private ExtraTreeFruitGene(String name, FruitPod pod) {
        this.pod = pod;
        this.isRipening = false;
        this.diffB = 0;
        this.products = new HashMap();
        this.ripeningPeriod = 2;
    }

    public static void init() {
        IFruitFamily familyPrune = AlleleManager.alleleRegistry.getFruitFamily("forestry.prunes");
        IFruitFamily familyPome = AlleleManager.alleleRegistry.getFruitFamily("forestry.pomes");
        IFruitFamily familyJungle = AlleleManager.alleleRegistry.getFruitFamily("forestry.jungle");
        IFruitFamily familyNuts = AlleleManager.alleleRegistry.getFruitFamily("forestry.nuts");
        ExtraTreeFruitFamily familyBerry = ExtraTreeFruitFamily.Berry;
        ExtraTreeFruitFamily familyCitrus = ExtraTreeFruitFamily.Citrus;
        AlleleManager.alleleRegistry.registerFruitFamily((IFruitFamily)familyBerry);
        AlleleManager.alleleRegistry.registerFruitFamily((IFruitFamily)familyCitrus);
        Apple.addProduct(new ItemStack(Items.field_151034_e), 1.0f);
        Apple.setFamily(familyPome);
        Crabapple.addProduct(Food.Crabapple.get(1), 1.0f);
        Crabapple.setFamily(familyPome);
        Orange.addProduct(Food.Orange.get(1), 1.0f);
        Orange.setFamily(familyCitrus);
        Manderin.addProduct(Food.Manderin.get(1), 1.0f);
        Manderin.setFamily(familyCitrus);
        Tangerine.addProduct(Food.Tangerine.get(1), 1.0f);
        Tangerine.setFamily(familyCitrus);
        Satsuma.addProduct(Food.Satsuma.get(1), 1.0f);
        Satsuma.setFamily(familyCitrus);
        KeyLime.addProduct(Food.KeyLime.get(1), 1.0f);
        KeyLime.setFamily(familyCitrus);
        Lime.addProduct(Food.Lime.get(1), 1.0f);
        Lime.setFamily(familyCitrus);
        FingerLime.addProduct(Food.FingerLime.get(1), 1.0f);
        FingerLime.setFamily(familyCitrus);
        Pomelo.addProduct(Food.Pomelo.get(1), 1.0f);
        Pomelo.setFamily(familyCitrus);
        Grapefruit.addProduct(Food.Grapefruit.get(1), 1.0f);
        Grapefruit.setFamily(familyCitrus);
        Kumquat.addProduct(Food.Kumquat.get(1), 1.0f);
        Kumquat.setFamily(familyCitrus);
        Citron.addProduct(Food.Citron.get(1), 1.0f);
        Citron.setFamily(familyCitrus);
        BuddhaHand.addProduct(Food.BuddhaHand.get(1), 1.0f);
        BuddhaHand.setFamily(familyCitrus);
        Blackthorn.addProduct(Food.Blackthorn.get(1), 1.0f);
        Blackthorn.setFamily(familyPrune);
        CherryPlum.addProduct(Food.CherryPlum.get(1), 1.0f);
        CherryPlum.setFamily(familyPrune);
        Peach.addProduct(Food.Peach.get(1), 1.0f);
        Peach.setFamily(familyPrune);
        Nectarine.addProduct(Food.Nectarine.get(1), 1.0f);
        Nectarine.setFamily(familyPrune);
        Apricot.addProduct(Food.Apricot.get(1), 1.0f);
        Apricot.setFamily(familyPrune);
        Almond.addProduct(Food.Almond.get(1), 1.0f);
        Almond.setFamily(familyPrune);
        WildCherry.addProduct(Food.WildCherry.get(1), 1.0f);
        WildCherry.setFamily(familyPrune);
        SourCherry.addProduct(Food.SourCherry.get(1), 1.0f);
        SourCherry.setFamily(familyPrune);
        BlackCherry.addProduct(Food.BlackCherry.get(1), 1.0f);
        BlackCherry.setFamily(familyPrune);
        Hazelnut.addProduct(Food.Hazelnut.get(1), 1.0f);
        Hazelnut.setFamily(familyNuts);
        Butternut.addProduct(Food.Butternut.get(1), 1.0f);
        Butternut.setFamily(familyNuts);
        Beechnut.addProduct(Food.Beechnut.get(1), 1.0f);
        Beechnut.setFamily(familyNuts);
        Pecan.addProduct(Food.Pecan.get(1), 1.0f);
        Pecan.setFamily(familyNuts);
        Banana.addProduct(Food.Banana.get(2), 1.0f);
        Banana.setFamily(familyJungle);
        RedBanana.addProduct(Food.RedBanana.get(2), 1.0f);
        RedBanana.setFamily(familyJungle);
        Plantain.addProduct(Food.Plantain.get(2), 1.0f);
        Plantain.setFamily(familyJungle);
        BrazilNut.addProduct(Food.BrazilNut.get(4), 1.0f);
        BrazilNut.setFamily(familyNuts);
        Fig.addProduct(Food.Fig.get(1), 1.0f);
        Fig.setFamily(familyPrune);
        Acorn.addProduct(Food.Acorn.get(1), 1.0f);
        Acorn.setFamily(familyNuts);
        Elderberry.addProduct(Food.Elderberry.get(1), 1.0f);
        Elderberry.setFamily(familyPrune);
        Olive.addProduct(Food.Olive.get(1), 1.0f);
        Olive.setFamily(familyPrune);
        GingkoNut.addProduct(Food.GingkoNut.get(1), 1.0f);
        GingkoNut.setFamily(familyNuts);
        Coffee.addProduct(Food.Coffee.get(1), 1.0f);
        Coffee.setFamily(familyJungle);
        Pear.addProduct(Food.Pear.get(1), 1.0f);
        Pear.setFamily(familyPome);
        OsangeOsange.addProduct(Food.OsangeOrange.get(1), 1.0f);
        OsangeOsange.setFamily(familyPome);
        Clove.addProduct(Food.Clove.get(1), 1.0f);
        Clove.setFamily(familyNuts);
        Blackcurrant.addProduct(Food.Blackcurrant.get(2), 1.0f);
        Blackcurrant.setFamily(familyBerry);
        Redcurrant.addProduct(Food.Redcurrant.get(2), 1.0f);
        Redcurrant.setFamily(familyBerry);
        Blackberry.addProduct(Food.Blackberry.get(2), 1.0f);
        Blackberry.setFamily(familyBerry);
        Raspberry.addProduct(Food.Raspberry.get(2), 1.0f);
        Raspberry.setFamily(familyBerry);
        Blueberry.addProduct(Food.Blueberry.get(2), 1.0f);
        Blueberry.setFamily(familyBerry);
        Cranberry.addProduct(Food.Cranberry.get(2), 1.0f);
        Cranberry.setFamily(familyBerry);
        Juniper.addProduct(Food.Juniper.get(2), 1.0f);
        Juniper.setFamily(familyBerry);
        Gooseberry.addProduct(Food.Gooseberry.get(2), 1.0f);
        Gooseberry.setFamily(familyBerry);
        GoldenRaspberry.addProduct(Food.GoldenRaspberry.get(2), 1.0f);
        GoldenRaspberry.setFamily(familyBerry);
        Coconut.addProduct(Food.Coconut.get(1), 1.0f);
        Coconut.setFamily(familyJungle);
        Cashew.addProduct(Food.Cashew.get(1), 1.0f);
        Cashew.setFamily(familyJungle);
        Avacado.addProduct(Food.Avacado.get(1), 1.0f);
        Avacado.setFamily(familyJungle);
        Nutmeg.addProduct(Food.Nutmeg.get(1), 1.0f);
        Nutmeg.setFamily(familyJungle);
        Allspice.addProduct(Food.Allspice.get(1), 1.0f);
        Allspice.setFamily(familyJungle);
        Chilli.addProduct(Food.Chilli.get(1), 1.0f);
        Chilli.setFamily(familyJungle);
        StarAnise.addProduct(Food.StarAnise.get(1), 1.0f);
        StarAnise.setFamily(familyJungle);
        Mango.addProduct(Food.Mango.get(1), 1.0f);
        Mango.setFamily(familyPome);
        Starfruit.addProduct(Food.Starfruit.get(1), 1.0f);
        Starfruit.setFamily(familyJungle);
        Candlenut.addProduct(Food.Candlenut.get(1), 1.0f);
        Candlenut.setFamily(familyJungle);
        if (ConfigurationMain.alterLemon) {
            try {
                IAlleleFruit lemon = (IAlleleFruit)AlleleManager.alleleRegistry.getAllele("forestry.fruitLemon");
                FruitProviderNone prov = (FruitProviderNone)lemon.getProvider();
                Field f = FruitProviderNone.class.getDeclaredField("family");
                Unsafe u = ExtraTreeFruitGene.findUnsafe();
                u.putObject(prov, u.objectFieldOffset(f), (Object)familyCitrus);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        for (IAlleleSpecies tree : Binnie.Genetics.treeBreedingSystem.getAllSpecies()) {
            if (!(tree instanceof AlleleTreeSpecies) || !((IAlleleTreeSpecies)tree).getSuitableFruit().contains(familyPrune)) continue;
            ((AlleleTreeSpecies)tree).addFruitFamily((IFruitFamily)familyCitrus);
        }
    }

    public void setRipening(int time, int unripe) {
        this.ripeningPeriod = time;
        this.colorUnripe = unripe;
        this.isRipening = true;
        this.diffR = (this.color >> 16 & 0xFF) - (unripe >> 16 & 0xFF);
        this.diffG = (this.color >> 8 & 0xFF) - (unripe >> 8 & 0xFF);
        this.diffB = (this.color & 0xFF) - (unripe & 0xFF);
    }

    public void addProduct(ItemStack product, float chance) {
        this.products.put(product, Float.valueOf(chance));
    }

    public String getUID() {
        return "extratrees.fruit." + this.toString().toLowerCase();
    }

    public boolean isDominant() {
        return true;
    }

    public IFruitProvider getProvider() {
        return this;
    }

    public ItemStack[] getProducts() {
        return this.products.keySet().toArray(new ItemStack[0]);
    }

    public ItemStack[] getSpecialty() {
        return new ItemStack[0];
    }

    public String getDescription() {
        return "extratrees.item.food." + this.name().toLowerCase();
    }

    public IFruitFamily getFamily() {
        return this.family;
    }

    private void setFamily(IFruitFamily family) {
        this.family = family;
    }

    public int getColour(ITreeGenome genome, IBlockAccess world, int x, int y, int z, int ripeningTime) {
        if (!this.isRipening) {
            return this.color;
        }
        float stage = this.getRipeningStage(ripeningTime);
        int r = (this.colorUnripe >> 16 & 0xFF) + (int)((float)this.diffR * stage);
        int g = (this.colorUnripe >> 8 & 0xFF) + (int)((float)this.diffG * stage);
        int b = (this.colorUnripe & 0xFF) + (int)((float)this.diffB * stage);
        return (r & 0xFF) << 16 | (g & 0xFF) << 8 | b & 0xFF;
    }

    public boolean markAsFruitLeaf(ITreeGenome genome, World world, int x, int y, int z) {
        return this.pod == null;
    }

    public int getRipeningPeriod() {
        return this.ripeningPeriod;
    }

    public ItemStack[] getFruits(ITreeGenome genome, World world, int x, int y, int z, int ripeningTime) {
        if (this.pod != null) {
            if (ripeningTime >= 2) {
                ArrayList<ItemStack> product = new ArrayList<ItemStack>();
                for (Map.Entry<ItemStack, Float> entry : this.products.entrySet()) {
                    ItemStack single = entry.getKey().func_77946_l();
                    single.field_77994_a = 1;
                    for (int i = 0; i < entry.getKey().field_77994_a; ++i) {
                        if (!(world.field_73012_v.nextFloat() <= entry.getValue().floatValue())) continue;
                        product.add(single.func_77946_l());
                    }
                }
                return product.toArray(new ItemStack[0]);
            }
            return new ItemStack[0];
        }
        ArrayList<ItemStack> product2 = new ArrayList<ItemStack>();
        float stage = this.getRipeningStage(ripeningTime);
        if (stage < 0.5f) {
            return new ItemStack[0];
        }
        float modeYieldMod = 1.0f;
        for (Map.Entry<ItemStack, Float> entry2 : this.products.entrySet()) {
            if (!(world.field_73012_v.nextFloat() <= genome.getYield() * modeYieldMod * entry2.getValue().floatValue() * 5.0f * stage)) continue;
            product2.add(entry2.getKey().func_77946_l());
        }
        return product2.toArray(new ItemStack[0]);
    }

    private float getRipeningStage(int ripeningTime) {
        if (ripeningTime >= this.ripeningPeriod) {
            return 1.0f;
        }
        return ripeningTime / this.ripeningPeriod;
    }

    public boolean requiresFruitBlocks() {
        return this.pod != null;
    }

    public boolean trySpawnFruitBlock(ITreeGenome genome, World world, int x, int y, int z) {
        return this.pod != null && world.field_73012_v.nextFloat() <= genome.getSappiness() && Binnie.Genetics.getTreeRoot().setFruitBlock(world, (IAlleleFruit)genome.getActiveAllele((IChromosomeType)EnumTreeChromosome.FRUITS), genome.getSappiness(), this.pod.getTextures(), x, y, z);
    }

    public short getIconIndex(ITreeGenome genome, IBlockAccess world, int x, int y, int z, int ripeningTime, boolean fancy) {
        return this.index.getIndex();
    }

    @SideOnly(value=Side.CLIENT)
    public void registerIcons(IIconRegister register) {
        if (this.ordinal() == 0) {
            for (FruitSprite sprite : FruitSprite.values()) {
                sprite.registerIcons(register);
            }
        }
    }

    public String getName() {
        return I18N.localise("for." + this.getDescription());
    }

    public String getNameOfFruit() {
        if (this == Apple) {
            return "Apple";
        }
        for (ItemStack stack : this.products.keySet()) {
            if (stack.func_77973_b() != ExtraTrees.itemFood) continue;
            return Food.values()[stack.func_77960_j()].toString();
        }
        return "NoFruit";
    }

    public String getUnlocalizedName() {
        return this.getUID();
    }

    private static Unsafe findUnsafe() {
        for (Field f : Unsafe.class.getDeclaredFields()) {
            if (!Modifier.isStatic(f.getModifiers()) || f.getType() != Unsafe.class) continue;
            f.setAccessible(true);
            try {
                Unsafe u = (Unsafe)f.get(null);
                if (u == null) continue;
                return u;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        try {
            return (Unsafe)Unsafe.class.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Throwable throwable) {
            throw new NoSuchElementException("Cant get Unsafe instance");
        }
    }
}

