/*
 * Decompiled with CFR 0.152.
 */
package binnie.genetics.genetics;

import binnie.genetics.Genetics;
import binnie.genetics.api.IGene;
import binnie.genetics.api.IItemChargable;
import binnie.genetics.api.IItemSerum;
import binnie.genetics.genetics.SequencerItem;
import binnie.genetics.item.GeneticsItems;
import binnie.genetics.item.ItemSerum;
import binnie.genetics.item.ItemSerumArray;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class Engineering {
    public static boolean isGeneAcceptor(ItemStack stack) {
        if (stack == null) {
            return false;
        }
        Item item = stack.func_77973_b();
        if (item instanceof IItemSerum) {
            return ((IItemSerum)item).getCharges(stack) == 0;
        }
        return item == Genetics.itemGenetics && (stack.func_77960_j() == GeneticsItems.EmptySerum.ordinal() || stack.func_77960_j() == GeneticsItems.EmptyGenome.ordinal());
    }

    public static boolean canAcceptGene(ItemStack stack, IGene gene) {
        if (stack == null) {
            return false;
        }
        Item item = stack.func_77973_b();
        if (item instanceof ItemSerum) {
            return true;
        }
        if (item instanceof IItemSerum) {
            return ((IItemSerum)item).getSpeciesRoot(stack) == gene.getSpeciesRoot();
        }
        return Engineering.isGeneAcceptor(stack);
    }

    public static IGene getGene(ItemStack stack, int chromosome) {
        if (stack == null) {
            return null;
        }
        Item item = stack.func_77973_b();
        if (item instanceof IItemSerum) {
            return ((IItemSerum)item).getGene(stack, chromosome);
        }
        return null;
    }

    public static ItemStack addGene(ItemStack stack, IGene gene) {
        if (stack == null) {
            return null;
        }
        Item item = stack.func_77973_b();
        if (item instanceof IItemSerum) {
            ((IItemSerum)item).addGene(stack, gene);
        }
        if (item == Genetics.itemGenetics && stack.func_77960_j() == GeneticsItems.EmptySerum.ordinal()) {
            return ItemSerum.create(gene);
        }
        if (item == Genetics.itemGenetics && stack.func_77960_j() == GeneticsItems.EmptyGenome.ordinal()) {
            return ItemSerumArray.create(gene);
        }
        return stack;
    }

    public static IGene[] getGenes(ItemStack serum) {
        IGene[] genes;
        Item item = serum.func_77973_b();
        if (item instanceof IItemSerum && (genes = ((IItemSerum)item).getGenes(serum)) != null) {
            return genes;
        }
        if (item == Genetics.itemSequencer) {
            SequencerItem sequencerItem = new SequencerItem(serum);
            if (sequencerItem.gene != null) {
                return new IGene[]{sequencerItem.gene};
            }
        }
        return new IGene[0];
    }

    public static int getCharges(ItemStack serum) {
        return ((IItemChargable)serum.func_77973_b()).getCharges(serum);
    }
}

