/*
 * Decompiled with CFR 0.152.
 */
package binnie.genetics.genetics;

import binnie.Binnie;
import binnie.core.BinnieCore;
import binnie.core.genetics.BreedingSystem;
import binnie.core.genetics.Gene;
import binnie.core.util.I18N;
import binnie.genetics.api.IGene;
import binnie.genetics.genetics.IGeneItem;
import forestry.api.core.INBTTagable;
import forestry.api.genetics.ISpeciesRoot;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumChatFormatting;

public class GeneArrayItem
implements INBTTagable,
IGeneItem {
    protected List<IGene> genes = new ArrayList<IGene>();

    public GeneArrayItem(ItemStack stack) {
        if (stack == null) {
            return;
        }
        this.readFromNBT(stack.func_77978_p());
    }

    public GeneArrayItem(IGene gene) {
        this.addGene(gene);
    }

    public GeneArrayItem() {
    }

    @Override
    public int getColour(int color) {
        BreedingSystem breedingSystem;
        if (color == 2 && (breedingSystem = this.getBreedingSystem()) != null) {
            return breedingSystem.getColor();
        }
        return 0xFFFFFF;
    }

    @Override
    public void getInfo(List tooltip) {
        ArrayList<String> totalList = new ArrayList<String>();
        for (IGene gene : this.genes) {
            String chromosomeName = this.getBreedingSystem().getChromosomeName(gene.getChromosome());
            totalList.add(EnumChatFormatting.GOLD + chromosomeName + EnumChatFormatting.GRAY + ": " + gene.getName());
        }
        if (totalList.size() < 4 || BinnieCore.proxy.isShiftDown()) {
            tooltip.addAll(totalList);
        } else {
            tooltip.add(totalList.get(0));
            tooltip.add(totalList.get(1));
            tooltip.add(I18N.localise("genetics.gene.more", totalList.size() - 2));
        }
    }

    public BreedingSystem getBreedingSystem() {
        if (this.genes.isEmpty()) {
            return null;
        }
        BreedingSystem system = Binnie.Genetics.getSystem(this.genes.get(0).getSpeciesRoot().getUID());
        return system == null ? Binnie.Genetics.getActiveSystems().iterator().next() : system;
    }

    public List<IGene> getGenes() {
        return this.genes;
    }

    public void readFromNBT(NBTTagCompound nbt) {
        this.genes.clear();
        if (nbt == null) {
            return;
        }
        NBTTagList list = nbt.func_150295_c("genes", 10);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            Gene gene = Gene.create(list.func_150305_b(i));
            if (gene == null) continue;
            this.genes.add(gene);
        }
    }

    public void writeToNBT(NBTTagCompound nbt) {
        if (this.genes.isEmpty()) {
            return;
        }
        NBTTagList list = new NBTTagList();
        for (IGene gene : this.genes) {
            NBTTagCompound geneNBT = gene.getNBTTagCompound();
            list.func_74742_a((NBTBase)geneNBT);
        }
        nbt.func_74782_a("genes", (NBTBase)list);
    }

    @Override
    public ISpeciesRoot getSpeciesRoot() {
        if (this.genes.isEmpty()) {
            return null;
        }
        return this.genes.get(0).getSpeciesRoot();
    }

    public IGene getGene(int chromosome) {
        for (IGene gene : this.genes) {
            if (gene.getChromosome().ordinal() != chromosome) continue;
            return gene;
        }
        return null;
    }

    @Override
    public void writeToItem(ItemStack stack) {
        if (stack == null) {
            return;
        }
        NBTTagCompound nbt = stack.func_77942_o() ? stack.func_77978_p() : new NBTTagCompound();
        this.writeToNBT(nbt);
        stack.func_77982_d(nbt);
    }

    @Override
    public void addGene(IGene gene) {
        IGene chromosome = this.getGene(gene.getChromosome().ordinal());
        if (chromosome != null) {
            this.genes.remove(chromosome);
        }
        this.genes.add(gene);
    }
}

