/*
 * Decompiled with CFR 0.152.
 */
package binnie.genetics.gui;

import binnie.core.craftgui.CraftGUI;
import binnie.core.craftgui.IWidget;
import binnie.core.craftgui.controls.ControlTextCentered;
import binnie.core.craftgui.controls.ControlTextEdit;
import binnie.core.craftgui.controls.core.Control;
import binnie.core.craftgui.controls.listbox.ControlListBox;
import binnie.core.craftgui.controls.scroll.ControlScrollBar;
import binnie.core.craftgui.controls.scroll.ControlScrollableContent;
import binnie.core.craftgui.events.EventHandler;
import binnie.core.craftgui.events.EventMouse;
import binnie.core.craftgui.geometry.IArea;
import binnie.core.craftgui.geometry.IPoint;
import binnie.core.craftgui.geometry.TextJustification;
import binnie.core.craftgui.minecraft.MinecraftGUI;
import binnie.core.craftgui.resource.minecraft.CraftGUITexture;
import binnie.core.craftgui.window.Panel;
import binnie.core.genetics.BreedingSystem;
import binnie.core.util.I18N;
import binnie.genetics.gui.ControlAnalystPage;
import binnie.genetics.gui.ControlIndividualDisplay;
import binnie.genetics.gui.WindowAnalyst;
import forestry.api.arboriculture.EnumTreeChromosome;
import forestry.api.genetics.IAlleleSpecies;
import forestry.api.genetics.IChromosomeType;
import forestry.api.genetics.IIndividual;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.util.EnumChatFormatting;

public class AnalystPageDatabase
extends ControlAnalystPage {
    ControlScrollableContent scroll = null;
    boolean isMaster;

    public AnalystPageDatabase(IWidget parent, IArea area, final BreedingSystem system, boolean isMaster) {
        super(parent, area);
        this.isMaster = isMaster;
        int cOfSystem = system.getColor();
        int cr = (0xFF0000 & cOfSystem) >> 16;
        int cg = (0xFF00 & cOfSystem) >> 8;
        int cb = 0xFF & cOfSystem;
        float brightness = 0.1f * (float)cb / 255.0f + 0.35f * (float)cr / 255.0f + 0.55f * (float)cg / 255.0f;
        brightness = 0.3f / brightness;
        if (brightness > 1.0f) {
            brightness = 1.0f;
        }
        int newColour = (int)((float)cr * brightness) * 65536 + (int)((float)cg * brightness) * 256 + (int)((float)cb * brightness);
        this.setColor(newColour);
        int y = 4;
        new ControlTextCentered((IWidget)this, y, EnumChatFormatting.UNDERLINE + this.getTitle()).setColor(this.getColor());
        new ControlTextEdit(this, 20.0f, y += 16, this.w() - 40.0f, 16.0f){

            @Override
            public void onTextEdit(String value) {
                ArrayList<IAlleleSpecies> options = new ArrayList<IAlleleSpecies>();
                AnalystPageDatabase.this.getSpecies(system);
                for (IAlleleSpecies species : AnalystPageDatabase.this.getSpecies(system)) {
                    if (value != null && value.isEmpty() && !species.getName().toLowerCase().contains(value.toLowerCase())) continue;
                    options.add(species);
                }
                AnalystPageDatabase.this.scroll.deleteAllChildren();
                AnalystPageDatabase.this.scroll.setScrollableContent(AnalystPageDatabase.this.getItemScrollList(system, options));
            }

            @Override
            public void onRenderBackground() {
                CraftGUI.render.color(0x555555);
                CraftGUI.render.texture((Object)CraftGUITexture.TabSolid, this.getArea().inset(1));
                CraftGUI.render.color(AnalystPageDatabase.this.getColor());
                CraftGUI.render.texture((Object)CraftGUITexture.TabOutline, this.getArea());
                super.renderTextField();
            }
        };
        new Panel(this, 3.0f, (y += 22) - 1, this.w() - 6.0f, this.h() - (float)y - 8.0f + 2.0f, MinecraftGUI.PanelType.TabOutline).setColor(this.getColor());
        boolean textView = false;
        final Collection<IAlleleSpecies> options = this.getSpecies(system);
        for (IAlleleSpecies species : options) {
            String height = system.getAlleleName((IChromosomeType)EnumTreeChromosome.HEIGHT, system.getIndividual(species.getUID()).getGenome().getActiveAllele((IChromosomeType)EnumTreeChromosome.HEIGHT));
            String fertility = system.getAlleleName((IChromosomeType)EnumTreeChromosome.FERTILITY, system.getIndividual(species.getUID()).getGenome().getActiveAllele((IChromosomeType)EnumTreeChromosome.FERTILITY));
            String yield = system.getAlleleName((IChromosomeType)EnumTreeChromosome.YIELD, system.getIndividual(species.getUID()).getGenome().getActiveAllele((IChromosomeType)EnumTreeChromosome.YIELD));
            String sappiness = system.getAlleleName((IChromosomeType)EnumTreeChromosome.SAPPINESS, system.getIndividual(species.getUID()).getGenome().getActiveAllele((IChromosomeType)EnumTreeChromosome.SAPPINESS));
            String string = system.getAlleleName((IChromosomeType)EnumTreeChromosome.MATURATION, system.getIndividual(species.getUID()).getGenome().getActiveAllele((IChromosomeType)EnumTreeChromosome.MATURATION));
        }
        if (textView) {
            this.scroll = new ControlListBox<IAlleleSpecies>((IWidget)this, 4.0f, (float)y, this.w() - 8.0f, this.h() - (float)y - 8.0f - 20.0f, 0.0f){

                @Override
                public void initialise() {
                    super.initialise();
                    this.setOptions(options);
                }

                @Override
                public IWidget createOption(final IAlleleSpecies v, int y) {
                    return new Control((IWidget)this.getContent(), 0.0f, y, this.w(), 12.0f){
                        IAlleleSpecies value;
                        {
                            super(parent, x, y, w, h);
                            this.value = v;
                        }

                        @Override
                        public void onRenderBackground() {
                            CraftGUI.render.text(this.getArea(), TextJustification.MIDDLE_CENTER, this.value.getName(), 0xFFFFFF);
                        }
                    };
                }
            };
        } else {
            this.scroll = new ControlScrollableContent(this, 4.0f, y, this.w() - 8.0f, this.h() - (float)y - 8.0f, 0.0f);
            this.scroll.setScrollableContent(this.getItemScrollList(system, options));
        }
        new ControlScrollBar(this, this.scroll.x() + this.scroll.w() - 6.0f, this.scroll.y() + 3.0f, 3.0f, this.scroll.h() - 6.0f, this.scroll){

            @Override
            public void onRenderBackground() {
                if (!this.isEnabled()) {
                    return;
                }
                CraftGUI.render.gradientRect(this.getArea(), 0x44000000 + AnalystPageDatabase.this.getColor(), 0x44000000 + AnalystPageDatabase.this.getColor());
                CraftGUI.render.solid(this.getRenderArea(), AnalystPageDatabase.this.getColor());
            }
        };
    }

    private IWidget getItemScrollList(final BreedingSystem system, final Collection<IAlleleSpecies> options) {
        return new Control(this.scroll, 0.0f, 0.0f, this.scroll.w(), this.scroll.h()){

            @Override
            public void initialise() {
                int maxBiomePerLine = (int)((this.w() - 4.0f + 2.0f) / 18.0f);
                float biomeListX = -6.0f + (this.w() - (float)(maxBiomePerLine * 18 - 2)) / 2.0f;
                int dx = 0;
                int dy = 0;
                for (final IAlleleSpecies species : options) {
                    final IIndividual ind = system.getSpeciesRoot().templateAsIndividual(system.getSpeciesRoot().getTemplate(species.getUID()));
                    new ControlIndividualDisplay(this, biomeListX + (float)dx, 2 + dy, ind){

                        @Override
                        public void initialise() {
                            this.addSelfEventHandler((EventHandler)new EventMouse.Down.Handler(){

                                @Override
                                public void onEvent(EventMouse.Down event) {
                                    WindowAnalyst window = (WindowAnalyst)AnalystPageDatabase.this.getSuperParent();
                                    window.setIndividual(ind);
                                }
                            });
                        }

                        @Override
                        public void onRenderBackground() {
                            WindowAnalyst window = (WindowAnalyst)AnalystPageDatabase.this.getSuperParent();
                            if (window.getIndividual() != null && window.getIndividual().getGenome().getPrimary() == species) {
                                CraftGUI.render.color(0xEEEEEE);
                                CraftGUI.render.texture((Object)CraftGUITexture.TabSolid, this.getArea().outset(1));
                                CraftGUI.render.color(AnalystPageDatabase.this.getColor());
                                CraftGUI.render.texture((Object)CraftGUITexture.TabOutline, this.getArea().outset(1));
                            } else if (this.calculateIsMouseOver()) {
                                CraftGUI.render.color(0xEEEEEE);
                                CraftGUI.render.texture((Object)CraftGUITexture.TabSolid, this.getArea().outset(1));
                            }
                            super.onRenderBackground();
                        }
                    };
                    if ((dx += 18) < 18 * maxBiomePerLine) continue;
                    dx = 0;
                    dy += 18;
                }
                this.setSize(new IPoint(this.w(), 4 + dy + 18));
            }
        };
    }

    @Override
    public String getTitle() {
        return I18N.localise("genetics.gui.analyst.registry");
    }

    private Collection<IAlleleSpecies> getSpecies(BreedingSystem system) {
        ArrayList<IAlleleSpecies> species = new ArrayList<IAlleleSpecies>();
        species.addAll(this.isMaster ? system.getAllSpecies() : system.getDiscoveredSpecies(this.getWindow().getWorld(), this.getWindow().getPlayer().func_146103_bH()));
        return species;
    }
}

