/*
 * Decompiled with CFR 0.152.
 */
package binnie.genetics.item;

import binnie.Binnie;
import binnie.core.genetics.BreedingSystem;
import binnie.core.genetics.Gene;
import binnie.core.util.I18N;
import binnie.genetics.Genetics;
import binnie.genetics.api.IGene;
import binnie.genetics.api.IItemSerum;
import binnie.genetics.genetics.GeneArrayItem;
import binnie.genetics.item.ItemGene;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IChromosome;
import forestry.api.genetics.IChromosomeType;
import forestry.api.genetics.IIndividual;
import forestry.api.genetics.ISpeciesRoot;
import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import team.luxinfine.binnie.EventConfig;

public class ItemSerumArray
extends ItemGene
implements IItemSerum {
    public ItemSerumArray() {
        super("serumArray");
        this.func_77656_e(16);
    }

    public static ItemStack create(IGene gene) {
        ItemStack item = new ItemStack((Item)Genetics.itemSerumArray);
        item.func_77964_b(item.func_77958_k());
        GeneArrayItem seq = new GeneArrayItem(gene);
        seq.writeToItem(item);
        return item;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List tooltip, boolean advanced) {
        super.func_77624_a(stack, player, tooltip, advanced);
    }

    @Override
    public int getCharges(ItemStack stack) {
        return stack.func_77973_b().func_77612_l() - stack.func_77960_j();
    }

    @Override
    public IGene[] getGenes(ItemStack stack) {
        return this.getGeneItem(stack).getGenes().toArray(new IGene[0]);
    }

    @Override
    public ISpeciesRoot getSpeciesRoot(ItemStack stack) {
        return this.getGeneItem(stack).getSpeciesRoot();
    }

    @Override
    public IGene getGene(ItemStack stack, int chromosome) {
        return this.getGeneItem(stack).getGene(chromosome);
    }

    @Override
    public GeneArrayItem getGeneItem(ItemStack stack) {
        return new GeneArrayItem(stack);
    }

    @Override
    public void func_150895_a(Item item, CreativeTabs tab, List list) {
        if (EventConfig.hideSerums) {
            return;
        }
        for (ISpeciesRoot root : AlleleManager.alleleRegistry.getSpeciesRoot().values()) {
            for (IIndividual template : root.getIndividualTemplates()) {
                if (template.getGenome().getPrimary().isSecret()) continue;
                GeneArrayItem geneItem = new GeneArrayItem();
                for (IChromosomeType type : root.getKaryotype()) {
                    IAllele active;
                    IChromosome c = template.getGenome().getChromosomes()[type.ordinal()];
                    if (c == null || (active = c.getActiveAllele()) == null) continue;
                    geneItem.addGene(new Gene(active, type, root));
                }
                ItemStack array = new ItemStack((Item)this);
                geneItem.writeToItem(array);
                list.add(array);
            }
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister register) {
        this.icons[0] = Genetics.proxy.getIcon(register, "machines/genome.glass");
        this.icons[1] = Genetics.proxy.getIcon(register, "machines/genome.cap");
        this.icons[2] = Genetics.proxy.getIcon(register, "machines/genome.edges");
        this.icons[3] = Genetics.proxy.getIcon(register, "machines/genome.dna");
    }

    @Override
    public String func_77653_i(ItemStack stack) {
        GeneArrayItem gene = this.getGeneItem(stack);
        BreedingSystem breedingSystem = Binnie.Genetics.getSystem(gene.getSpeciesRoot());
        if (breedingSystem != null) {
            return I18N.localise("genetics.item.serumArray.name", breedingSystem.getDescriptor());
        }
        return I18N.localise("genetics.item.genomeEmpty.name");
    }

    @Override
    public ItemStack addGene(ItemStack stack, IGene gene) {
        GeneArrayItem geneI = this.getGeneItem(stack);
        geneI.addGene(gene);
        geneI.writeToItem(stack);
        return stack;
    }
}

