/*
 * Decompiled with CFR 0.152.
 */
package binnie.genetics.machine.incubator;

import binnie.Binnie;
import binnie.core.BinnieCore;
import binnie.core.machines.MachineUtil;
import binnie.genetics.api.IIncubatorRecipe;
import binnie.genetics.item.GeneticLiquid;
import binnie.genetics.item.GeneticsItems;
import binnie.genetics.machine.incubator.IncubatorRecipe;
import forestry.api.apiculture.EnumBeeType;
import forestry.api.apiculture.IBee;
import forestry.api.genetics.IIndividual;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;

public class Incubator {
    public static final int[] SLOT_QUEUE = new int[]{0, 1, 2};
    public static final int[] SLOT_OUTPUT = new int[]{4, 5, 6};
    public static final int SLOT_INCUBATOR = 3;
    public static final int TANK_INPUT = 0;
    public static final int TANK_OUTPUT = 1;
    public static final float ENERGY_PER_TICK = 2.0f;
    public static final List<IIncubatorRecipe> RECIPES = new ArrayList<IIncubatorRecipe>();
    public static final int POWER_CAPACITY = 2000;
    public static final int INPUT_TANK_CAPACITY = 2000;
    public static final int OUTPU_TANK_CAPACITY = 2000;

    public static void addRecipes() {
        RECIPES.add(new IncubatorRecipe(Binnie.Liquid.getLiquidStack("water", 25), GeneticLiquid.GrowthMedium.get(25), 0.2f){

            @Override
            public boolean isItemStack(ItemStack stack) {
                return GeneticsItems.GrowthMedium.get(1).func_77969_a(stack);
            }
        });
        RECIPES.add(new IncubatorRecipe(GeneticLiquid.GrowthMedium.get(25), GeneticLiquid.Bacteria.get(5), 0.2f){

            @Override
            public boolean isItemStack(ItemStack stack) {
                return new ItemStack(Items.field_151015_O).func_77969_a(stack);
            }
        });
        RECIPES.add(new IncubatorRecipe(GeneticLiquid.Bacteria.get(0), GeneticLiquid.Bacteria.get(5), 0.05f){

            @Override
            public boolean isItemStack(ItemStack stack) {
                return GeneticsItems.GrowthMedium.get(1).func_77969_a(stack);
            }
        });
        RECIPES.add(new IncubatorRecipe(GeneticLiquid.Bacteria.get(2), null, 0.5f, 0.2f){

            @Override
            public boolean isItemStack(ItemStack stack) {
                return stack.func_77973_b() == Items.field_151102_aT;
            }
        }.setOutputStack(GeneticsItems.Enzyme.get(1)));
        RECIPES.add(new IncubatorRecipe(GeneticLiquid.BacteriaPoly.get(0), GeneticLiquid.BacteriaPoly.get(5), 0.05f){

            @Override
            public boolean isItemStack(ItemStack stack) {
                return GeneticsItems.GrowthMedium.get(1).func_77969_a(stack);
            }
        });
        RECIPES.add(new IncubatorRecipe(GeneticLiquid.BacteriaVector.get(0), GeneticLiquid.BacteriaVector.get(5), 0.05f){

            @Override
            public boolean isItemStack(ItemStack stack) {
                return GeneticsItems.GrowthMedium.get(1).func_77969_a(stack);
            }
        });
        RECIPES.add(new IncubatorRecipe(GeneticLiquid.Bacteria.get(10), GeneticLiquid.BacteriaPoly.get(10), 0.1f){

            @Override
            public boolean isItemStack(ItemStack stack) {
                return new ItemStack(Items.field_151100_aR, 1, 15).func_77969_a(stack);
            }
        });
        RECIPES.add(new IncubatorRecipe(GeneticLiquid.Bacteria.get(10), GeneticLiquid.BacteriaVector.get(10), 0.05f){

            @Override
            public boolean isItemStack(ItemStack stack) {
                return new ItemStack(Items.field_151065_br).func_77969_a(stack);
            }
        });
        if (BinnieCore.isApicultureActive()) {
            RECIPES.add(new IncubatorRecipe(GeneticLiquid.GrowthMedium.get(50), null, 1.0f, 0.05f){

                @Override
                public boolean isItemStack(ItemStack stack) {
                    return Binnie.Genetics.getBeeRoot().isMember(stack) && Binnie.Genetics.getBeeRoot().getType(stack) == EnumBeeType.LARVAE;
                }

                @Override
                public ItemStack getOutputStack(MachineUtil machine) {
                    ItemStack larvae = machine.getStack(3);
                    IBee bee = Binnie.Genetics.getBeeRoot().getMember(larvae);
                    return Binnie.Genetics.getBeeRoot().getMemberStack((IIndividual)bee, EnumBeeType.DRONE.ordinal());
                }
            });
        }
    }
}

