/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.items;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import forestry.api.core.IToolPipette;
import forestry.core.fluids.PipetteContents;
import forestry.core.items.ItemForestry;
import forestry.core.render.TextureManager;
import forestry.core.utils.StringUtil;
import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.IIcon;
import net.minecraftforge.fluids.FluidStack;

public class ItemPipette
extends ItemForestry
implements IToolPipette {
    @SideOnly(value=Side.CLIENT)
    private IIcon primaryIcon;
    @SideOnly(value=Side.CLIENT)
    private IIcon secondaryIcon;

    public ItemPipette() {
        this.func_77625_d(1);
        this.func_77664_n();
    }

    public boolean func_77651_p() {
        return true;
    }

    @Override
    public boolean canPipette(ItemStack itemstack) {
        PipetteContents contained = new PipetteContents(itemstack.func_77978_p());
        return !contained.isFull();
    }

    @Override
    public int fill(ItemStack itemstack, FluidStack liquid, boolean doFill) {
        int filled;
        PipetteContents contained = new PipetteContents(itemstack.func_77978_p());
        int limit = this.getCapacity(itemstack);
        if (contained.getContents() == null) {
            filled = liquid.amount > limit ? limit : liquid.amount;
            contained.setContents(new FluidStack(liquid, filled));
            filled = liquid.amount;
        } else {
            if (contained.getContents().amount >= limit) {
                return 0;
            }
            if (!contained.getContents().isFluidEqual(liquid)) {
                return 0;
            }
            int space = limit - contained.getContents().amount;
            filled = liquid.amount > space ? space : liquid.amount;
            contained.getContents().amount += filled;
        }
        if (doFill) {
            NBTTagCompound nbttagcompound = new NBTTagCompound();
            contained.writeToNBT(nbttagcompound);
            itemstack.func_77982_d(nbttagcompound);
            itemstack.func_77964_b(1);
        }
        return filled;
    }

    public void func_77624_a(ItemStack itemstack, EntityPlayer player, List list, boolean flag) {
        PipetteContents contained = new PipetteContents(itemstack.func_77978_p());
        contained.addTooltip(list);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister register) {
        this.primaryIcon = TextureManager.registerTex(register, StringUtil.cleanItemName(this) + ".0");
        this.secondaryIcon = TextureManager.registerTex(register, StringUtil.cleanItemName(this) + ".1");
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_77617_a(int damage) {
        if (damage <= 0) {
            return this.primaryIcon;
        }
        return this.secondaryIcon;
    }

    @Override
    public FluidStack drain(ItemStack pipette, int maxDrain, boolean doDrain) {
        PipetteContents contained = new PipetteContents(pipette.func_77978_p());
        if (contained.getContents() == null || contained.getContents().getFluid().getID() <= 0) {
            return null;
        }
        int drained = maxDrain;
        if (contained.getContents().amount < drained) {
            drained = contained.getContents().amount;
        }
        if (doDrain) {
            contained.getContents().amount -= drained;
            if (contained.getContents().amount <= 0) {
                pipette.func_77982_d(null);
                pipette.func_77964_b(0);
            } else {
                NBTTagCompound nbttagcompound = new NBTTagCompound();
                contained.writeToNBT(nbttagcompound);
                pipette.func_77982_d(nbttagcompound);
            }
        }
        return new FluidStack(contained.getContents(), drained);
    }

    @Override
    public int getCapacity(ItemStack pipette) {
        return 1000;
    }
}

