/*
 * Decompiled with CFR 0.152.
 */
package forestry.factory.recipes;

import forestry.api.recipes.IMoistenerManager;
import forestry.api.recipes.IMoistenerRecipe;
import forestry.core.utils.ItemStackUtil;
import forestry.factory.recipes.MoistenerRecipe;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.item.ItemStack;

public class MoistenerRecipeManager
implements IMoistenerManager {
    private static final Set<IMoistenerRecipe> recipes = new HashSet<IMoistenerRecipe>();

    @Override
    public void addRecipe(ItemStack resource, ItemStack product, int timePerItem) {
        MoistenerRecipe recipe = new MoistenerRecipe(resource, product, timePerItem);
        this.addRecipe(recipe);
    }

    public static boolean isResource(ItemStack resource) {
        if (resource == null) {
            return false;
        }
        for (IMoistenerRecipe rec : recipes) {
            if (!ItemStackUtil.isIdenticalItem(resource, rec.getResource())) continue;
            return true;
        }
        return false;
    }

    public static IMoistenerRecipe findMatchingRecipe(ItemStack item) {
        for (IMoistenerRecipe recipe : recipes) {
            if (!ItemStackUtil.isCraftingEquivalent(recipe.getResource(), item)) continue;
            return recipe;
        }
        return null;
    }

    @Override
    public boolean addRecipe(IMoistenerRecipe recipe) {
        return recipes.add(recipe);
    }

    @Override
    public boolean removeRecipe(IMoistenerRecipe recipe) {
        return recipes.remove(recipe);
    }

    @Override
    public Set<IMoistenerRecipe> recipes() {
        return Collections.unmodifiableSet(recipes);
    }

    @Override
    public Map<Object[], Object[]> getRecipes() {
        HashMap<Object[], Object[]> recipeList = new HashMap<Object[], Object[]>();
        for (IMoistenerRecipe recipe : recipes) {
            recipeList.put(new ItemStack[]{recipe.getResource()}, new ItemStack[]{recipe.getProduct()});
        }
        return recipeList;
    }
}

