/*
 * Decompiled with CFR 0.152.
 */
package forestry.plugins;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInterModComms;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.network.FMLNetworkEvent;
import forestry.Forestry;
import forestry.api.recipes.RecipeManagers;
import forestry.api.storage.BackpackManager;
import forestry.api.storage.IBackpackDefinition;
import forestry.api.storage.StorageManager;
import forestry.apiculture.blocks.BlockRegistryApiculture;
import forestry.core.IPickupHandler;
import forestry.core.IResupplyHandler;
import forestry.core.config.LocalizedConfiguration;
import forestry.core.fluids.Fluids;
import forestry.core.items.ItemCrated;
import forestry.core.network.IPacketRegistry;
import forestry.core.recipes.RecipeUtil;
import forestry.core.utils.ItemStackUtil;
import forestry.core.utils.Log;
import forestry.core.utils.StringUtil;
import forestry.lepidopterology.blocks.BlockLepidopterologyType;
import forestry.lepidopterology.blocks.BlockRegistryLepidopterology;
import forestry.plugins.ForestryPlugin;
import forestry.plugins.Plugin;
import forestry.plugins.PluginApiculture;
import forestry.plugins.PluginCore;
import forestry.plugins.PluginLepidopterology;
import forestry.plugins.PluginManager;
import forestry.storage.BackpackDefinition;
import forestry.storage.BackpackInterface;
import forestry.storage.CrateRegistry;
import forestry.storage.CustomItemsFilter;
import forestry.storage.PickupHandlerStorage;
import forestry.storage.ResupplyHandler;
import forestry.storage.items.ItemRegistryStorage;
import forestry.storage.network.PacketBagsSync;
import forestry.storage.proxy.ProxyStorage;
import java.awt.Color;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBasePressurePlate;
import net.minecraft.block.BlockButton;
import net.minecraft.block.BlockChest;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.BlockFence;
import net.minecraft.block.BlockFenceGate;
import net.minecraft.block.BlockFurnace;
import net.minecraft.block.BlockLadder;
import net.minecraft.block.BlockLever;
import net.minecraft.block.BlockRedstoneDiode;
import net.minecraft.block.BlockSlab;
import net.minecraft.block.BlockStairs;
import net.minecraft.block.BlockTorch;
import net.minecraft.block.BlockTrapDoor;
import net.minecraft.block.BlockWall;
import net.minecraft.block.BlockWorkbench;
import net.minecraft.block.IGrowable;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemDoor;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.IShearable;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.oredict.OreDictionary;

@Plugin(pluginID="Storage", name="Storage", author="SirSengir", url="http://forestry.sengir.net/", unlocalizedDescription="for.plugin.storage.description")
public class PluginStorage
extends ForestryPlugin {
    private static final List<ItemCrated> crates = new ArrayList<ItemCrated>();
    private static final String CONFIG_CATEGORY = "backpacks";
    @SidedProxy(clientSide="forestry.storage.proxy.ProxyStorageClient", serverSide="forestry.storage.proxy.ProxyStorage")
    public static ProxyStorage proxy;
    private final ArrayList<ItemStack> minerItems = new ArrayList();
    private final ArrayList<ItemStack> diggerItems = new ArrayList();
    private final ArrayList<ItemStack> foresterItems = new ArrayList();
    private final ArrayList<ItemStack> hunterItems = new ArrayList();
    private final ArrayList<ItemStack> adventurerItems = new ArrayList();
    private final ArrayList<ItemStack> builderItems = new ArrayList();
    public static ItemRegistryStorage items;

    @Override
    protected void setupAPI() {
        BackpackDefinition definition;
        super.setupAPI();
        StorageManager.crateRegistry = new CrateRegistry();
        BackpackManager.backpackInterface = new BackpackInterface();
        BackpackManager.backpackItems = new ArrayList[6];
        BackpackManager.backpackItems[0] = this.minerItems;
        BackpackManager.backpackItems[1] = this.diggerItems;
        BackpackManager.backpackItems[2] = this.foresterItems;
        BackpackManager.backpackItems[3] = this.hunterItems;
        BackpackManager.backpackItems[4] = this.adventurerItems;
        BackpackManager.backpackItems[5] = this.builderItems;
        if (PluginManager.Module.APICULTURE.isEnabled()) {
            definition = new BackpackDefinition.BackpackDefinitionApiarist(new Color(12882493).getRGB());
            BackpackManager.definitions.put(definition.getKey(), definition);
        }
        if (PluginManager.Module.LEPIDOPTEROLOGY.isEnabled()) {
            definition = new BackpackDefinition.BackpackDefinitionLepidopterist(new Color(10050353).getRGB());
            BackpackManager.definitions.put(definition.getKey(), definition);
        }
        definition = new BackpackDefinition("miner", new Color(3545213).getRGB());
        BackpackManager.definitions.put(definition.getKey(), definition);
        definition = new BackpackDefinition("digger", new Color(3554501).getRGB());
        BackpackManager.definitions.put(definition.getKey(), definition);
        definition = new BackpackDefinition("forester", new Color(3437607).getRGB());
        BackpackManager.definitions.put(definition.getKey(), definition);
        definition = new BackpackDefinition("hunter", new Color(4268565).getRGB());
        BackpackManager.definitions.put(definition.getKey(), definition);
        definition = new BackpackDefinition("adventurer", new Color(8370370).getRGB());
        BackpackManager.definitions.put(definition.getKey(), definition);
        definition = new BackpackDefinition("builder", new Color(0xDD3A3A).getRGB());
        BackpackManager.definitions.put(definition.getKey(), definition);
    }

    @Override
    protected void disabledSetupAPI() {
        BackpackManager.backpackItems = new ArrayList[6];
        BackpackManager.backpackItems[0] = this.minerItems;
        BackpackManager.backpackItems[1] = this.diggerItems;
        BackpackManager.backpackItems[2] = this.foresterItems;
        BackpackManager.backpackItems[3] = this.hunterItems;
        BackpackManager.backpackItems[4] = this.adventurerItems;
        BackpackManager.backpackItems[5] = this.builderItems;
    }

    @Override
    protected void registerItemsAndBlocks() {
        items = new ItemRegistryStorage();
    }

    @Override
    public IPacketRegistry getPacketRegistry() {
        return () -> {
            PacketBagsSync packet = new PacketBagsSync();
            packet.getPacketId().setPacketHandler(packet);
        };
    }

    @SubscribeEvent
    public void onDisconnect(FMLNetworkEvent.ClientDisconnectionFromServerEvent event) {
        CustomItemsFilter.allowItems.clear();
        CustomItemsFilter.forbiddenItems.clear();
    }

    @Override
    public void postInit() {
        FMLCommonHandler.instance().bus().register((Object)this);
        String newConfig = "backpacks.cfg";
        File configFile = new File(Forestry.instance.getConfigFolder(), "backpacks.cfg");
        if (!configFile.exists()) {
            this.setDefaultsForConfig();
        }
        LocalizedConfiguration config = new LocalizedConfiguration(configFile, "1.0.0");
        PluginStorage.handleBackpackConfig(config, "miner");
        PluginStorage.handleBackpackConfig(config, "digger");
        PluginStorage.handleBackpackConfig(config, "forester");
        PluginStorage.handleBackpackConfig(config, "hunter");
        PluginStorage.handleBackpackConfig(config, "adventurer");
        PluginStorage.handleBackpackConfig(config, "builder");
        config.save();
        BackpackDefinition forester = (BackpackDefinition)BackpackManager.definitions.get("forester");
        forester.addValidBlockClasses(Arrays.asList(IPlantable.class, IGrowable.class, IShearable.class));
        forester.addValidItemClasses(Arrays.asList(IPlantable.class, IGrowable.class));
        BackpackDefinition builder = (BackpackDefinition)BackpackManager.definitions.get("builder");
        builder.addValidBlockClasses(Arrays.asList(BlockStairs.class, BlockFence.class, BlockFenceGate.class, BlockWall.class, BlockBasePressurePlate.class, BlockLever.class, BlockButton.class, BlockTorch.class, BlockRedstoneDiode.class, BlockChest.class, BlockWorkbench.class, BlockFurnace.class, BlockLadder.class, BlockTrapDoor.class, BlockDoor.class, BlockSlab.class));
        builder.addValidItemClass(ItemDoor.class);
    }

    private void setDefaultsForConfig() {
        BackpackDefinition miner = (BackpackDefinition)BackpackManager.definitions.get("miner");
        BackpackDefinition digger = (BackpackDefinition)BackpackManager.definitions.get("digger");
        BackpackDefinition forester = (BackpackDefinition)BackpackManager.definitions.get("forester");
        BackpackDefinition adventurer = (BackpackDefinition)BackpackManager.definitions.get("adventurer");
        BackpackDefinition builder = (BackpackDefinition)BackpackManager.definitions.get("builder");
        BackpackDefinition hunter = (BackpackDefinition)BackpackManager.definitions.get("hunter");
        miner.addValidItems(this.minerItems);
        digger.addValidItems(this.diggerItems);
        forester.addValidItems(this.foresterItems);
        hunter.addValidItems(this.hunterItems);
        adventurer.addValidItems(this.adventurerItems);
        builder.addValidItems(this.builderItems);
        Pattern minerOreDictPattern = Pattern.compile("(ore|dust|gem|ingot|nugget|crushed|cluster|denseore)[A-Z].*");
        Pattern diggerOreDictPattern = Pattern.compile("(stone)[A-Z].*");
        Pattern foresterOreDictPattern = Pattern.compile("(crop|seed|tree)[A-Z].*");
        Pattern builderOreDictPattern = Pattern.compile("(block|paneGlass|slabWood|stainedClay|stainedGlass)[A-Z].*");
        ArrayList<String> minerOreDictNames = new ArrayList<String>();
        ArrayList<String> diggerOreDictNames = new ArrayList<String>(Arrays.asList("cobblestone", "stone", "sand"));
        ArrayList<String> foresterOreDictNames = new ArrayList<String>(Arrays.asList("logWood", "stickWood", "woodStick", "saplingTree"));
        ArrayList<String> builderOreDictNames = new ArrayList<String>(Arrays.asList("stone", "plankWood", "stairWood", "slabWood", "fenceWood", "glass", "blockGlass", "paneGlass"));
        for (String name : OreDictionary.getOreNames()) {
            if (minerOreDictPattern.matcher(name).matches()) {
                minerOreDictNames.add(name);
                continue;
            }
            if (diggerOreDictPattern.matcher(name).matches()) {
                if (name.equals("stoneRod")) continue;
                diggerOreDictNames.add(name);
                continue;
            }
            if (foresterOreDictPattern.matcher(name).matches()) {
                foresterOreDictNames.add(name);
                continue;
            }
            if (!builderOreDictPattern.matcher(name).matches() || name.equals("blockHopper")) continue;
            builderOreDictNames.add(name);
        }
        miner.addValidOreDictNames(minerOreDictNames);
        miner.addValidItems(Arrays.asList(new ItemStack(Blocks.field_150343_Z), new ItemStack(Blocks.field_150365_q), new ItemStack(Items.field_151044_h), PluginCore.items.bronzePickaxe.getItemStack(), PluginCore.items.kitPickaxe.getItemStack(), PluginCore.items.brokenBronzePickaxe.getItemStack()));
        digger.addValidOreDictNames(diggerOreDictNames);
        digger.addValidItems(Arrays.asList(new ItemStack(Blocks.field_150346_d, 1, Short.MAX_VALUE), new ItemStack(Blocks.field_150351_n), new ItemStack(Items.field_151145_ak), new ItemStack(Blocks.field_150424_aL), new ItemStack(Blocks.field_150322_A, 1, 0), new ItemStack(Items.field_151119_aD), new ItemStack(Blocks.field_150425_aM), PluginCore.items.bronzeShovel.getItemStack(), PluginCore.items.kitShovel.getItemStack(), PluginCore.items.brokenBronzeShovel.getItemStack()));
        forester.addValidOreDictNames(foresterOreDictNames);
        forester.addValidItems(Arrays.asList(new ItemStack((Block)Blocks.field_150337_Q), new ItemStack((Block)Blocks.field_150338_P), new ItemStack((Block)Blocks.field_150328_O), new ItemStack((Block)Blocks.field_150327_N), new ItemStack(Blocks.field_150434_aF), new ItemStack((Block)Blocks.field_150329_H, 1, Short.MAX_VALUE), new ItemStack(Blocks.field_150395_bd), new ItemStack(Blocks.field_150423_aK), new ItemStack(Blocks.field_150440_ba), new ItemStack(Items.field_151153_ao), new ItemStack(Items.field_151075_bm), new ItemStack(Items.field_151080_bb), new ItemStack(Items.field_151081_bc)));
        hunter.addValidItems(Arrays.asList(new ItemStack(Items.field_151008_G), new ItemStack(Items.field_151016_H), new ItemStack(Items.field_151065_br), new ItemStack(Items.field_151072_bj), new ItemStack(Items.field_151103_aS), new ItemStack(Items.field_151007_F), new ItemStack(Items.field_151078_bh), new ItemStack(Items.field_151073_bk), new ItemStack(Items.field_151074_bl), new ItemStack(Items.field_151032_g), new ItemStack(Items.field_151147_al), new ItemStack(Items.field_151157_am), new ItemStack(Items.field_151082_bd), new ItemStack(Items.field_151083_be), new ItemStack(Items.field_151076_bf), new ItemStack(Items.field_151077_bg), new ItemStack(Items.field_151116_aA), new ItemStack(Items.field_151110_aK), new ItemStack(Items.field_151079_bi), new ItemStack(Items.field_151070_bp), new ItemStack(Items.field_151071_bq), new ItemStack(Items.field_151123_aH), new ItemStack(Items.field_151100_aR, 1, 0), new ItemStack(Blocks.field_150407_cf), new ItemStack(Blocks.field_150325_L, 1, Short.MAX_VALUE), new ItemStack(Items.field_151061_bv), new ItemStack(Items.field_151064_bs), new ItemStack(Items.field_151060_bw), new ItemStack(Items.field_151115_aP), new ItemStack(Items.field_151101_aQ), new ItemStack(Items.field_151058_ca), new ItemStack((Item)Items.field_151112_aM), new ItemStack(Items.field_151057_cb), new ItemStack(Items.field_151141_av), new ItemStack(Items.field_151125_bZ), new ItemStack(Items.field_151136_bY), new ItemStack(Items.field_151138_bX)));
        builder.addValidOreDictNames(builderOreDictNames);
        builder.addValidItems(Arrays.asList(new ItemStack(Blocks.field_150478_aa), new ItemStack(Blocks.field_150429_aA), new ItemStack(Blocks.field_150379_bu), new ItemStack(Blocks.field_150417_aV, 1, Short.MAX_VALUE), new ItemStack(Blocks.field_150322_A, 1, 1), new ItemStack(Blocks.field_150322_A, 1, 2), new ItemStack(Blocks.field_150336_V), new ItemStack(Blocks.field_150435_aG), new ItemStack(Blocks.field_150405_ch, 1, Short.MAX_VALUE), new ItemStack(Blocks.field_150406_ce, 1, Short.MAX_VALUE), new ItemStack(Blocks.field_150403_cj), new ItemStack(Blocks.field_150385_bj), new ItemStack(Blocks.field_150462_ai), new ItemStack(Blocks.field_150460_al), new ItemStack(Blocks.field_150442_at), new ItemStack(Blocks.field_150367_z), new ItemStack(Blocks.field_150409_cd), new ItemStack(Blocks.field_150468_ap), new ItemStack(Blocks.field_150411_aY), new ItemStack(Blocks.field_150371_ca, 1, Short.MAX_VALUE), new ItemStack(Items.field_151155_ap), new ItemStack(Items.field_151160_bD)));
        BlockRegistryApiculture beeBlocks = PluginApiculture.blocks;
        if (beeBlocks != null) {
            builder.addValidItem(new ItemStack((Block)beeBlocks.candle, 1, Short.MAX_VALUE));
            builder.addValidItem(new ItemStack((Block)beeBlocks.stump, 1, Short.MAX_VALUE));
        }
    }

    private static void handleBackpackConfig(LocalizedConfiguration config, String backpackName) {
        BackpackDefinition backpackDefinition = (BackpackDefinition)BackpackManager.definitions.get(backpackName);
        ArrayList<String> backpackOreDict = new ArrayList<String>();
        ArrayList<String> validItems = new ArrayList<String>(backpackDefinition.getValidItemStacks());
        Collections.sort(validItems);
        String[] defaultValidItems = validItems.toArray(new String[validItems.size()]);
        Property backpackConf = config.get("backpacks." + backpackName, "item.stacks", defaultValidItems);
        backpackConf.comment = StringUtil.localizeAndFormat("config.backpacks.item.stacks.format", backpackName);
        String[] backpackItemList = backpackConf.getStringList();
        List<ItemStack> backpackItems = ItemStackUtil.parseItemStackStrings(backpackItemList, Short.MAX_VALUE);
        ArrayList<Integer> oreIds = new ArrayList<Integer>(backpackDefinition.getValidOreIds());
        String[] defaultOreNames = new String[oreIds.size()];
        for (int i = 0; i < oreIds.size(); ++i) {
            int oreId = (Integer)oreIds.get(i);
            defaultOreNames[i] = OreDictionary.getOreName((int)oreId);
        }
        ArrayList defaultOreNamesList = new ArrayList();
        Collections.addAll(defaultOreNamesList, defaultOreNames);
        Collections.sort(defaultOreNamesList);
        defaultOreNames = defaultOreNamesList.toArray(new String[defaultOreNamesList.size()]);
        Property backpackConf2 = config.get("backpacks." + backpackName, "ore.dict", defaultOreNames);
        backpackConf2.comment = StringUtil.localizeAndFormat("config.backpacks.ore.dict.format", backpackName);
        String[] oreDictNameList = backpackConf2.getStringList();
        Collections.addAll(backpackOreDict, oreDictNameList);
        backpackDefinition.clearAllValid();
        backpackDefinition.addValidItems(backpackItems);
        backpackDefinition.addValidOreDictNames(backpackOreDict);
    }

    public static void registerCrate(ItemCrated crate) {
        proxy.registerCrateForRendering(crate);
        crates.add(crate);
    }

    public static void createCrateRecipes() {
        for (ItemCrated crate : crates) {
            ItemStack crateStack = new ItemStack((Item)crate);
            ItemStack uncrated = crate.getContained();
            if (crate.usesOreDict()) {
                int[] oreIds;
                for (int oreId : oreIds = OreDictionary.getOreIDs((ItemStack)uncrated)) {
                    String oreName = OreDictionary.getOreName((int)oreId);
                    PluginStorage.addCrating(crateStack, oreName);
                }
            } else {
                PluginStorage.addCrating(crateStack, uncrated);
            }
            PluginStorage.addUncrating(crateStack, uncrated);
        }
    }

    private static void addCrating(ItemStack crateStack, Object uncrated) {
        FluidStack water = Fluids.WATER.getFluid(100);
        ItemStack box = PluginStorage.items.crate.getItemStack();
        RecipeManagers.carpenterManager.addRecipe(5, water, box, crateStack, "###", "###", "###", Character.valueOf('#'), uncrated);
    }

    private static void addUncrating(ItemStack crateStack, ItemStack uncrated) {
        ItemStack product = new ItemStack(uncrated.func_77973_b(), 9, uncrated.func_77960_j());
        RecipeManagers.carpenterManager.addRecipe(5, null, product, "#", Character.valueOf('#'), crateStack);
    }

    @Override
    public boolean processIMCMessage(FMLInterModComms.IMCMessage message) {
        if (message.key.equals("add-backpack-items")) {
            String[] tokens = message.getStringValue().split("@");
            if (tokens.length != 2) {
                PluginStorage.logInvalidIMCMessage(message);
                return true;
            }
            if (!BackpackManager.definitions.containsKey(tokens[0])) {
                String errorMessage = PluginStorage.getInvalidIMCMessageText(message);
                Log.warning("%s For non-existent backpack %s.", errorMessage, tokens[0]);
                return true;
            }
            IBackpackDefinition backpackDefinition = BackpackManager.definitions.get(tokens[0]);
            List<ItemStack> itemStacks = ItemStackUtil.parseItemStackStrings(tokens[1], 0);
            backpackDefinition.addValidItems(itemStacks);
            return true;
        }
        return false;
    }

    @Override
    public IPickupHandler getPickupHandler() {
        return new PickupHandlerStorage();
    }

    @Override
    public IResupplyHandler getResupplyHandler() {
        return new ResupplyHandler();
    }

    @Override
    protected void registerRecipes() {
        BlockRegistryApiculture beeBlocks = PluginApiculture.blocks;
        if (PluginStorage.items.apiaristBackpack != null && beeBlocks != null) {
            PluginStorage.addBackpackRecipe(PluginStorage.items.apiaristBackpack, "stickWood", (Object)beeBlocks.apicultureChest);
        }
        BlockRegistryLepidopterology butterflyBlocks = PluginLepidopterology.blocks;
        if (PluginStorage.items.lepidopteristBackpack != null && butterflyBlocks != null) {
            ItemStack chest = butterflyBlocks.lepidopterology.get(BlockLepidopterologyType.LEPICHEST);
            PluginStorage.addBackpackRecipe(PluginStorage.items.lepidopteristBackpack, "stickWood", chest);
        }
        PluginStorage.addBackpackRecipe(PluginStorage.items.minerBackpack, "ingotIron");
        PluginStorage.addBackpackRecipe(PluginStorage.items.diggerBackpack, "stone");
        PluginStorage.addBackpackRecipe(PluginStorage.items.foresterBackpack, "logWood");
        PluginStorage.addBackpackRecipe(PluginStorage.items.hunterBackpack, Items.field_151008_G);
        PluginStorage.addBackpackRecipe(PluginStorage.items.adventurerBackpack, Items.field_151103_aS);
        PluginStorage.addBackpackRecipe(PluginStorage.items.builderBackpack, Items.field_151119_aD);
        if (PluginManager.Module.FACTORY.isEnabled()) {
            RecipeManagers.carpenterManager.addRecipe(20, Fluids.WATER.getFluid(1000), null, PluginStorage.items.crate.getItemStack(24), " # ", "# #", " # ", Character.valueOf('#'), "logWood");
            PluginStorage.addT2BackpackRecipe(PluginStorage.items.minerBackpack, PluginStorage.items.minerBackpackT2);
            PluginStorage.addT2BackpackRecipe(PluginStorage.items.diggerBackpack, PluginStorage.items.diggerBackpackT2);
            PluginStorage.addT2BackpackRecipe(PluginStorage.items.foresterBackpack, PluginStorage.items.foresterBackpackT2);
            PluginStorage.addT2BackpackRecipe(PluginStorage.items.hunterBackpack, PluginStorage.items.hunterBackpackT2);
            PluginStorage.addT2BackpackRecipe(PluginStorage.items.adventurerBackpack, PluginStorage.items.adventurerBackpackT2);
            PluginStorage.addT2BackpackRecipe(PluginStorage.items.builderBackpack, PluginStorage.items.builderBackpackT2);
        }
    }

    private static void addBackpackRecipe(Item backpack, Object material) {
        PluginStorage.addBackpackRecipe(backpack, material, "chestWood");
    }

    private static void addBackpackRecipe(Item backpack, Object material, Object chest) {
        RecipeUtil.addRecipe(backpack, "X#X", "VYV", "X#X", Character.valueOf('#'), Blocks.field_150325_L, Character.valueOf('X'), Items.field_151007_F, Character.valueOf('V'), material, Character.valueOf('Y'), chest);
    }

    private static void addT2BackpackRecipe(Item backpackT1, Item backpackT2) {
        ItemStack wovenSilk = PluginCore.items.craftingMaterial.getWovenSilk();
        RecipeManagers.carpenterManager.addRecipe(200, Fluids.WATER.getFluid(1000), null, new ItemStack(backpackT2), "WXW", "WTW", "WWW", Character.valueOf('X'), "gemDiamond", Character.valueOf('W'), wovenSilk, Character.valueOf('T'), backpackT1);
    }
}

