/*
 * Decompiled with CFR 0.152.
 */
package forestry.storage;

import cpw.mods.fml.common.registry.GameData;
import forestry.api.apiculture.BeeManager;
import forestry.api.lepidopterology.ButterflyManager;
import forestry.api.storage.IBackpackDefinition;
import forestry.storage.CustomItemsFilter;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.StatCollector;
import net.minecraftforge.oredict.OreDictionary;

public class BackpackDefinition
implements IBackpackDefinition {
    private final String name;
    private final int primaryColor;
    private final int secondaryColor;
    private final Set<String> validItemStacks = new HashSet<String>();
    private final Set<Integer> validOreIds = new HashSet<Integer>();
    private final Set<Class> validItemClasses = new HashSet<Class>();
    private final Set<Class> validBlockClasses = new HashSet<Class>();

    public BackpackDefinition(String name, int primaryColor) {
        this(name, primaryColor, 0xFFFFFF);
    }

    public BackpackDefinition(String name, int primaryColor, int secondaryColor) {
        this.name = name;
        this.primaryColor = primaryColor;
        this.secondaryColor = secondaryColor;
    }

    @Override
    public String getKey() {
        return this.name;
    }

    @Override
    public String getName(ItemStack backpack) {
        NBTTagCompound nbt;
        Item item = backpack.func_77973_b();
        String display = ("" + StatCollector.func_74838_a((String)(item.func_77657_g(backpack) + ".name"))).trim();
        if (backpack.field_77990_d != null && backpack.field_77990_d.func_150297_b("display", 10) && (nbt = backpack.field_77990_d.func_74775_l("display")).func_150297_b("Name", 8)) {
            display = nbt.func_74779_i("Name");
        }
        return display;
    }

    @Override
    public int getPrimaryColour() {
        return this.primaryColor;
    }

    @Override
    public int getSecondaryColour() {
        return this.secondaryColor;
    }

    @Override
    public void addValidItem(ItemStack validItem) {
        if (validItem == null) {
            return;
        }
        Item item = validItem.func_77973_b();
        if (item == null) {
            return;
        }
        String itemStackString = GameData.getItemRegistry().func_148750_c((Object)item);
        int meta = validItem.func_77960_j();
        if (meta != Short.MAX_VALUE) {
            itemStackString = itemStackString + ':' + meta;
        }
        this.validItemStacks.add(itemStackString);
    }

    public void clearAllValid() {
        this.validItemStacks.clear();
        this.validOreIds.clear();
    }

    @Override
    public void addValidItems(List<ItemStack> validItems) {
        for (ItemStack validItem : validItems) {
            this.addValidItem(validItem);
        }
    }

    public void addValidOreDictName(String oreDictName) {
        int oreId = OreDictionary.getOreID((String)oreDictName);
        this.validOreIds.add(oreId);
    }

    public void addValidOreDictNames(List<String> oreDictNames) {
        for (String oreDictName : oreDictNames) {
            this.addValidOreDictName(oreDictName);
        }
    }

    public void addValidItemClass(Class itemClass) {
        if (itemClass != null) {
            this.validItemClasses.add(itemClass);
        }
    }

    public void addValidItemClasses(List<Class> itemClasses) {
        for (Class itemClass : itemClasses) {
            this.addValidItemClass(itemClass);
        }
    }

    public void addValidBlockClass(Class blockClass) {
        if (blockClass != null) {
            this.validBlockClasses.add(blockClass);
        }
    }

    public void addValidBlockClasses(List<Class> blockClasses) {
        for (Class blockClass : blockClasses) {
            this.addValidBlockClass(blockClass);
        }
    }

    public Set<String> getValidItemStacks() {
        return this.validItemStacks;
    }

    public Set<Integer> getValidOreIds() {
        return this.validOreIds;
    }

    public Set<Class> getValidBlockClasses() {
        return this.validBlockClasses;
    }

    public Set<Class> getValidItemClasses() {
        return this.validItemClasses;
    }

    @Override
    public boolean isValidItem(ItemStack itemStack) {
        String itemStackString;
        if (itemStack == null) {
            return false;
        }
        Item item = itemStack.func_77973_b();
        if (item == null) {
            return false;
        }
        if (CustomItemsFilter.isForbiddenItem(this.getKey(), itemStack)) {
            return false;
        }
        if (CustomItemsFilter.isAllowItem(this.getKey(), itemStack)) {
            return true;
        }
        String itemStackStringWild = GameData.getItemRegistry().func_148750_c((Object)item);
        if (this.validItemStacks.contains(itemStackStringWild)) {
            return true;
        }
        int meta = itemStack.func_77960_j();
        if (meta != Short.MAX_VALUE && this.validItemStacks.contains(itemStackString = itemStackStringWild + ':' + meta)) {
            return true;
        }
        int[] oreIds = OreDictionary.getOreIDs((ItemStack)itemStack);
        for (int oreId : oreIds) {
            if (!this.validOreIds.contains(oreId)) continue;
            this.validItemStacks.add(itemStackStringWild);
            return true;
        }
        Object object = this.validItemClasses.iterator();
        while (object.hasNext()) {
            Class itemClass = (Class)object.next();
            if (!itemClass.isInstance(item)) continue;
            this.validItemStacks.add(itemStackStringWild);
            return true;
        }
        Block block = Block.func_149634_a((Item)item);
        if (block != null) {
            for (Class blockClass : this.validBlockClasses) {
                if (!blockClass.isInstance(block)) continue;
                this.validItemStacks.add(itemStackStringWild);
                return true;
            }
        }
        return false;
    }

    public static class BackpackDefinitionLepidopterist
    extends BackpackDefinition {
        public BackpackDefinitionLepidopterist(int primaryColor) {
            super("lepidopterist", primaryColor);
        }

        @Override
        public boolean isValidItem(ItemStack itemStack) {
            return ButterflyManager.butterflyRoot.isMember(itemStack);
        }
    }

    public static class BackpackDefinitionApiarist
    extends BackpackDefinition {
        public BackpackDefinitionApiarist(int primaryColor) {
            super("apiarist", primaryColor);
        }

        @Override
        public boolean isValidItem(ItemStack itemStack) {
            return BeeManager.beeRoot.isMember(itemStack);
        }
    }
}

