/*
 * Decompiled with CFR 0.152.
 */
package forestry.storage.network;

import forestry.core.network.DataInputStreamForestry;
import forestry.core.network.DataOutputStreamForestry;
import forestry.core.network.ForestryPacket;
import forestry.core.network.IForestryPacketClient;
import forestry.core.network.PacketIdClient;
import forestry.storage.CustomItemsFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class PacketBagsSync
extends ForestryPacket
implements IForestryPacketClient {
    private final HashMap<String, List<String>> allowItems = new HashMap();
    private final HashMap<String, List<String>> forbiddenItems = new HashMap();

    @Override
    protected void writeData(DataOutputStreamForestry data) {
    }

    @Override
    public void readData(DataInputStreamForestry data) throws IOException {
        NBTTagCompound packet = data.readNBTTagCompound();
        NBTTagList allowMap = packet.func_150295_c("allowMap", 10);
        for (int index = 0; index < allowMap.func_74745_c(); ++index) {
            NBTTagCompound entry = allowMap.func_150305_b(index);
            ArrayList<String> values = new ArrayList<String>();
            NBTTagList itemsList = entry.func_150295_c("items", 8);
            for (int i = 0; i < itemsList.func_74745_c(); ++i) {
                values.add(itemsList.func_150307_f(i));
            }
            this.allowItems.put(entry.func_74779_i("type"), values);
        }
        NBTTagList forbiddenMap = packet.func_150295_c("forbiddenMap", 10);
        for (int index = 0; index < forbiddenMap.func_74745_c(); ++index) {
            NBTTagCompound entry = forbiddenMap.func_150305_b(index);
            ArrayList<String> values = new ArrayList<String>();
            NBTTagList itemsList = entry.func_150295_c("items", 8);
            for (int i = 0; i < itemsList.func_74745_c(); ++i) {
                values.add(itemsList.func_150307_f(i));
            }
            this.forbiddenItems.put(entry.func_74779_i("type"), values);
        }
    }

    @Override
    public void onPacketData(DataInputStreamForestry data, EntityPlayer player) {
        CustomItemsFilter.allowItems.clear();
        CustomItemsFilter.forbiddenItems.clear();
        CustomItemsFilter.allowItems.putAll(this.allowItems);
        CustomItemsFilter.forbiddenItems.putAll(this.forbiddenItems);
        System.out.println("\u041f\u0430\u043a\u0435\u0442 \u043f\u0440\u043e\u0447\u0438\u0442\u0430\u043d! allows=" + CustomItemsFilter.allowItems.size() + " forbiddens=" + CustomItemsFilter.forbiddenItems.size());
    }

    @Override
    public PacketIdClient getPacketId() {
        return PacketIdClient.BAGS_ITEMS_SYNC;
    }
}

