/*
 * Decompiled with CFR 0.152.
 */
package ic2.core;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import ic2.core.IC2;
import ic2.core.ITickCallback;
import ic2.core.WorldData;
import ic2.core.energy.EnergyNetGlobal;
import ic2.core.init.MainConfig;
import ic2.core.item.tool.ItemNanoSaber;
import ic2.core.util.ConfigUtil;
import ic2.core.util.LogCategory;
import ic2.core.util.ReflectionUtil;
import ic2.core.util.Util;
import java.lang.reflect.Field;
import java.util.Map;
import java.util.WeakHashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityEnderChest;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;

public class TickHandler {
    private static final boolean debugTickCallback = System.getProperty("ic2.debugtickcallback") != null;
    private static final Map<ITickCallback, Throwable> debugTraces = debugTickCallback ? new WeakHashMap() : null;
    private static Throwable lastDebugTrace;
    private static final Field updateEntityTick;

    public TickHandler() {
        FMLCommonHandler.instance().bus().register((Object)this);
    }

    @SubscribeEvent
    public void onWorldTick(TickEvent.WorldTickEvent event) {
        World world;
        block9: {
            world = event.world;
            if (!world.field_72995_K) {
                try {
                    if (world instanceof WorldServer && world.field_73010_i.isEmpty() && world.getPersistentChunks().isEmpty() && updateEntityTick.getInt(world) >= 1200) {
                        return;
                    }
                    break block9;
                }
                catch (Exception var5) {
                    throw new RuntimeException(var5);
                }
            }
            if (Minecraft.func_71410_x().func_147113_T()) {
                return;
            }
        }
        if (event.phase == TickEvent.Phase.START) {
            IC2.platform.profilerStartSection("Wind");
            WorldData.get((World)world).windSim.updateWind();
            IC2.platform.profilerEndStartSection("TickCallbacks");
            TickHandler.processTickCallbacks(world);
            if (!world.field_72995_K && ConfigUtil.getBool(MainConfig.get(), "balance/disableEnderChest")) {
                IC2.platform.profilerEndStartSection("EnderChestCheck");
                for (int i = 0; i < world.field_147482_g.size(); ++i) {
                    TileEntity te = (TileEntity)world.field_147482_g.get(i);
                    if (!(te instanceof TileEntityEnderChest) || te.func_145837_r() || !world.func_72899_e(te.field_145851_c, te.field_145848_d, te.field_145849_e)) continue;
                    world.func_147468_f(te.field_145851_c, te.field_145848_d, te.field_145849_e);
                    IC2.log.info(LogCategory.General, "Removed vanilla ender chest at %s.", Util.formatPosition(te));
                }
            }
            IC2.platform.profilerEndSection();
        } else {
            IC2.platform.profilerStartSection("EnergyNet");
            EnergyNetGlobal.onTickEnd(world);
            IC2.platform.profilerEndStartSection("Networking");
            IC2.network.get().onTickEnd(world);
            IC2.platform.profilerEndSection();
        }
    }

    @SubscribeEvent
    public void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            ++ItemNanoSaber.ticker;
            IC2.getInstance().tickrateTracker.onTickStart();
        } else {
            IC2.getInstance().tickrateTracker.onTickEnd();
        }
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            IC2.platform.profilerStartSection("Keyboard");
            IC2.keyboard.sendKeyUpdate();
            IC2.platform.profilerEndStartSection("AudioManager");
            IC2.audioManager.onTick();
            IC2.platform.profilerEndStartSection("TickCallbacks");
            if (IC2.platform.getPlayerInstance() != null && IC2.platform.getPlayerInstance().field_70170_p != null) {
                TickHandler.processTickCallbacks(IC2.platform.getPlayerInstance().field_70170_p);
            }
            IC2.platform.profilerEndSection();
        }
    }

    public void addSingleTickCallback(World world, ITickCallback tickCallback) {
        WorldData worldData = WorldData.get(world);
        worldData.singleTickCallbacks.add(tickCallback);
        if (debugTickCallback) {
            debugTraces.put(tickCallback, new Throwable());
        }
    }

    public void addContinuousTickCallback(World world, ITickCallback tickCallback) {
        WorldData worldData = WorldData.get(world);
        if (!worldData.continuousTickCallbacksInUse) {
            worldData.continuousTickCallbacks.add(tickCallback);
        } else {
            worldData.continuousTickCallbacksToRemove.remove(tickCallback);
            worldData.continuousTickCallbacksToAdd.add(tickCallback);
        }
        if (debugTickCallback) {
            debugTraces.put(tickCallback, new Throwable());
        }
    }

    public void removeContinuousTickCallback(World world, ITickCallback tickCallback) {
        WorldData worldData = WorldData.get(world);
        if (!worldData.continuousTickCallbacksInUse) {
            worldData.continuousTickCallbacks.remove(tickCallback);
        } else {
            worldData.continuousTickCallbacksToAdd.remove(tickCallback);
            worldData.continuousTickCallbacksToRemove.add(tickCallback);
        }
    }

    public static Throwable getLastDebugTrace() {
        return lastDebugTrace;
    }

    private static void processTickCallbacks(World world) {
        WorldData worldData = WorldData.get(world);
        IC2.platform.profilerStartSection("SingleTickCallback");
        if (!worldData.singleTickCallbacks.isEmpty()) {
            ITickCallback tickCallback = worldData.singleTickCallbacks.poll();
            while (tickCallback != null) {
                if (debugTickCallback) {
                    lastDebugTrace = debugTraces.remove(tickCallback);
                }
                IC2.platform.profilerStartSection(tickCallback.getClass().getName());
                tickCallback.tickCallback(world);
                IC2.platform.profilerEndSection();
                tickCallback = worldData.singleTickCallbacks.poll();
            }
        }
        IC2.platform.profilerEndStartSection("ContTickCallback");
        worldData.continuousTickCallbacksInUse = true;
        if (!worldData.continuousTickCallbacks.isEmpty()) {
            for (ITickCallback tickCallback : worldData.continuousTickCallbacks) {
                if (debugTickCallback) {
                    lastDebugTrace = debugTraces.remove(tickCallback);
                }
                IC2.platform.profilerStartSection(tickCallback.getClass().getName());
                tickCallback.tickCallback(world);
                IC2.platform.profilerEndSection();
            }
        }
        worldData.continuousTickCallbacksInUse = false;
        if (debugTickCallback) {
            lastDebugTrace = null;
        }
        worldData.continuousTickCallbacks.addAll(worldData.continuousTickCallbacksToAdd);
        worldData.continuousTickCallbacksToAdd.clear();
        worldData.continuousTickCallbacksToRemove.forEach(worldData.continuousTickCallbacks::remove);
        worldData.continuousTickCallbacksToRemove.clear();
        IC2.platform.profilerEndSection();
    }

    static {
        updateEntityTick = ReflectionUtil.getField(WorldServer.class, "field_80004_Q", "updateEntityTick");
    }
}

