/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.alg.dense.decomposition.hessenberg;

import org.ejml.alg.dense.decomposition.qr.QrHelperFunctions;
import org.ejml.data.DenseMatrix64F;
import org.ejml.interfaces.decomposition.DecompositionInterface;
import org.ejml.ops.CommonOps;

public class HessenbergSimilarDecomposition_D64
implements DecompositionInterface<DenseMatrix64F> {
    private DenseMatrix64F QH;
    private int N;
    private double[] gammas;
    private double[] b;
    private double[] u;

    public HessenbergSimilarDecomposition_D64(int initialSize) {
        this.gammas = new double[initialSize];
        this.b = new double[initialSize];
        this.u = new double[initialSize];
    }

    public HessenbergSimilarDecomposition_D64() {
        this(5);
    }

    @Override
    public boolean decompose(DenseMatrix64F A) {
        if (A.numRows != A.numCols) {
            throw new IllegalArgumentException("A must be square.");
        }
        if (A.numRows <= 0) {
            return false;
        }
        this.QH = A;
        this.N = A.numCols;
        if (this.b.length < this.N) {
            this.b = new double[this.N];
            this.gammas = new double[this.N];
            this.u = new double[this.N];
        }
        return this._decompose();
    }

    @Override
    public boolean inputModified() {
        return true;
    }

    public DenseMatrix64F getQH() {
        return this.QH;
    }

    public DenseMatrix64F getH(DenseMatrix64F H) {
        if (H == null) {
            H = new DenseMatrix64F(this.N, this.N);
        } else {
            if (this.N != H.numRows || this.N != H.numCols) {
                throw new IllegalArgumentException("The provided H must have the same dimensions as the decomposed matrix.");
            }
            H.zero();
        }
        System.arraycopy(this.QH.data, 0, H.data, 0, this.N);
        for (int i = 1; i < this.N; ++i) {
            for (int j = i - 1; j < this.N; ++j) {
                H.set(i, j, this.QH.get(i, j));
            }
        }
        return H;
    }

    public DenseMatrix64F getQ(DenseMatrix64F Q) {
        if (Q == null) {
            Q = new DenseMatrix64F(this.N, this.N);
            for (int i = 0; i < this.N; ++i) {
                Q.data[i * this.N + i] = 1.0;
            }
        } else {
            if (this.N != Q.numRows || this.N != Q.numCols) {
                throw new IllegalArgumentException("The provided H must have the same dimensions as the decomposed matrix.");
            }
            CommonOps.setIdentity(Q);
        }
        for (int j = this.N - 2; j >= 0; --j) {
            this.u[j + 1] = 1.0;
            for (int k = j + 2; k < this.N; ++k) {
                this.u[k] = this.QH.get(k, j);
            }
            QrHelperFunctions.rank1UpdateMultR(Q, this.u, this.gammas[j], j + 1, j + 1, this.N, this.b);
        }
        return Q;
    }

    private boolean _decompose() {
        double[] h = this.QH.data;
        for (int k = 0; k < this.N - 2; ++k) {
            double max = 0.0;
            for (int i = k + 1; i < this.N; ++i) {
                double n2;
                double[] u = this.u;
                int n = i;
                u[n] = n2 = h[i * this.N + k];
                double val = n2;
                if (!((val = Math.abs(val)) > max)) continue;
                max = val;
            }
            if (max > 0.0) {
                double gamma;
                double tau = 0.0;
                int j = k + 1;
                while (j < this.N) {
                    double n4;
                    double[] u2 = this.u;
                    int n3 = j++;
                    u2[n3] = n4 = u2[n3] / max;
                    double val2 = n4;
                    tau += val2 * val2;
                }
                tau = Math.sqrt(tau);
                if (this.u[k + 1] < 0.0) {
                    tau = -tau;
                }
                double nu = this.u[k + 1] + tau;
                this.u[k + 1] = 1.0;
                int l = k + 2;
                while (l < this.N) {
                    int n6;
                    double[] array = h;
                    int n5 = l * this.N + k;
                    double[] u3 = this.u;
                    int n = n6 = l++;
                    double d = u3[n] / nu;
                    u3[n] = d;
                    array[n5] = d;
                }
                this.gammas[k] = gamma = nu / tau;
                QrHelperFunctions.rank1UpdateMultR(this.QH, this.u, gamma, k + 1, k + 1, this.N, this.b);
                QrHelperFunctions.rank1UpdateMultL(this.QH, this.u, gamma, 0, k + 1, this.N);
                h[(k + 1) * this.N + k] = -tau * max;
                continue;
            }
            this.gammas[k] = 0.0;
        }
        return true;
    }

    public double[] getGammas() {
        return this.gammas;
    }
}

