/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.alg.dense.decomposition.lu;

import org.ejml.alg.dense.decomposition.lu.LUDecompositionBase_D64;
import org.ejml.data.DenseMatrix64F;

public class LUDecompositionAlt_D64
extends LUDecompositionBase_D64 {
    @Override
    public boolean decompose(DenseMatrix64F a) {
        this.decomposeCommonInit(a);
        double[] LUcolj = this.vv;
        for (int j = 0; j < this.n; ++j) {
            double lujj;
            int i;
            for (i = 0; i < this.m; ++i) {
                LUcolj[i] = this.dataLU[i * this.n + j];
            }
            i = 0;
            while (i < this.m) {
                int n2;
                int rowIndex = i * this.n;
                int kmax = i < j ? i : j;
                double s = 0.0;
                for (int k = 0; k < kmax; ++k) {
                    s += this.dataLU[rowIndex + k] * LUcolj[k];
                }
                double[] dataLU = this.dataLU;
                int n = rowIndex + j;
                double[] array = LUcolj;
                int n3 = n2 = i++;
                double d = array[n3] - s;
                array[n3] = d;
                dataLU[n] = d;
            }
            int p = j;
            double max = Math.abs(LUcolj[p]);
            for (int l = j + 1; l < this.m; ++l) {
                double v = Math.abs(LUcolj[l]);
                if (!(v > max)) continue;
                p = l;
                max = v;
            }
            if (p != j) {
                int rowP = p * this.n;
                int rowJ = j * this.n;
                int endP = rowP + this.n;
                while (rowP < endP) {
                    double t = this.dataLU[rowP];
                    this.dataLU[rowP] = this.dataLU[rowJ];
                    this.dataLU[rowJ] = t;
                    ++rowP;
                    ++rowJ;
                }
                int m = this.pivot[p];
                this.pivot[p] = this.pivot[j];
                this.pivot[j] = m;
                this.pivsign = -this.pivsign;
            }
            this.indx[j] = p;
            if (j >= this.m || (lujj = this.dataLU[j * this.n + j]) == 0.0) continue;
            for (int i2 = j + 1; i2 < this.m; ++i2) {
                int n3;
                double[] dataLU2 = this.dataLU;
                int n = n3 = i2 * this.n + j;
                dataLU2[n] = dataLU2[n] / lujj;
            }
        }
        return true;
    }
}

