/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.alg.dense.decomposition.qr;

import org.ejml.data.DenseMatrix64F;

public class QrHelperFunctions {
    public static double findMax(double[] u, int startU, int length) {
        double max = -1.0;
        int stopIndex = startU + length;
        for (int index = startU; index < stopIndex; ++index) {
            double val = u[index];
            double d = val = val < 0.0 ? -val : val;
            if (!(val > max)) continue;
            max = val;
        }
        return max;
    }

    public static void divideElements(int j, int numRows, double[] u, double u_0) {
        int i = j;
        while (i < numRows) {
            int n;
            int n2 = n = i++;
            u[n2] = u[n2] / u_0;
        }
    }

    public static void divideElements(int j, int numRows, double[] u, int startU, double u_0) {
        for (int i = j; i < numRows; ++i) {
            int n;
            int n2 = n = i + startU;
            u[n2] = u[n2] / u_0;
        }
    }

    public static void divideElements_Brow(int j, int numRows, double[] u, double[] b, int startB, double u_0) {
        for (int i = j; i < numRows; ++i) {
            int n2;
            int n = i;
            int n3 = n2 = i + startB;
            double d = b[n3] / u_0;
            b[n3] = d;
            u[n] = d;
        }
    }

    public static void divideElements_Bcol(int j, int numRows, int numCols, double[] u, double[] b, int startB, double u_0) {
        int indexB = j * numCols + startB;
        int i = j;
        while (i < numRows) {
            int n2;
            int n = indexB;
            int n3 = n2 = i++;
            double d = u[n3] / u_0;
            u[n3] = d;
            b[n] = d;
            indexB += numCols;
        }
    }

    public static double computeTauAndDivide(int j, int numRows, double[] u, int startU, double max) {
        double tau = 0.0;
        for (int i = j; i < numRows; ++i) {
            double n2;
            int n = startU + i;
            u[n] = n2 = u[n] / max;
            double d = n2;
            tau += d * d;
        }
        tau = Math.sqrt(tau);
        if (u[startU + j] < 0.0) {
            tau = -tau;
        }
        return tau;
    }

    public static double computeTauAndDivide(int j, int numRows, double[] u, double max) {
        double tau = 0.0;
        int i = j;
        while (i < numRows) {
            double n2;
            int n = i++;
            u[n] = n2 = u[n] / max;
            double d = n2;
            tau += d * d;
        }
        tau = Math.sqrt(tau);
        if (u[j] < 0.0) {
            tau = -tau;
        }
        return tau;
    }

    public static void rank1UpdateMultR(DenseMatrix64F A, double[] u, double gamma, int colA0, int w0, int w1, double[] _temp) {
        int i;
        for (i = colA0; i < A.numCols; ++i) {
            _temp[i] = u[w0] * A.data[w0 * A.numCols + i];
        }
        for (int k = w0 + 1; k < w1; ++k) {
            int indexA = k * A.numCols + colA0;
            double valU = u[k];
            int j = colA0;
            while (j < A.numCols) {
                int n;
                int n2 = n = j++;
                _temp[n2] = _temp[n2] + valU * A.data[indexA++];
            }
        }
        i = colA0;
        while (i < A.numCols) {
            int n2;
            int n = n2 = i++;
            _temp[n] = _temp[n] * gamma;
        }
        for (i = w0; i < w1; ++i) {
            double valU2 = u[i];
            int indexA2 = i * A.numCols + colA0;
            for (int l = colA0; l < A.numCols; ++l) {
                int n3;
                double[] data = A.data;
                int n = n3 = indexA2++;
                data[n] = data[n] - valU2 * _temp[l];
            }
        }
    }

    public static void rank1UpdateMultR(DenseMatrix64F A, double[] u, int offsetU, double gamma, int colA0, int w0, int w1, double[] _temp) {
        int i;
        for (i = colA0; i < A.numCols; ++i) {
            _temp[i] = u[w0 + offsetU] * A.data[w0 * A.numCols + i];
        }
        for (int k = w0 + 1; k < w1; ++k) {
            int indexA = k * A.numCols + colA0;
            double valU = u[k + offsetU];
            int j = colA0;
            while (j < A.numCols) {
                int n;
                int n2 = n = j++;
                _temp[n2] = _temp[n2] + valU * A.data[indexA++];
            }
        }
        i = colA0;
        while (i < A.numCols) {
            int n2;
            int n = n2 = i++;
            _temp[n] = _temp[n] * gamma;
        }
        for (i = w0; i < w1; ++i) {
            double valU2 = u[i + offsetU];
            int indexA2 = i * A.numCols + colA0;
            for (int l = colA0; l < A.numCols; ++l) {
                int n3;
                double[] data = A.data;
                int n = n3 = indexA2++;
                data[n] = data[n] - valU2 * _temp[l];
            }
        }
    }

    public static void rank1UpdateMultL(DenseMatrix64F A, double[] u, double gamma, int colA0, int w0, int w1) {
        for (int i = colA0; i < A.numRows; ++i) {
            int j;
            int startIndex = i * A.numCols + w0;
            double sum = 0.0;
            int rowIndex = startIndex;
            for (j = w0; j < w1; ++j) {
                sum += A.data[rowIndex++] * u[j];
            }
            sum *= -gamma;
            rowIndex = startIndex;
            for (j = w0; j < w1; ++j) {
                int n;
                double[] data = A.data;
                int n2 = n = rowIndex++;
                data[n2] = data[n2] + sum * u[j];
            }
        }
    }
}

