/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.alg.dense.linsol.svd;

import org.ejml.UtilEjml;
import org.ejml.data.DenseMatrix64F;
import org.ejml.factory.DecompositionFactory;
import org.ejml.interfaces.decomposition.SingularValueDecomposition;
import org.ejml.interfaces.linsol.LinearSolver;
import org.ejml.ops.CommonOps;

public class SolvePseudoInverseSvd
implements LinearSolver<DenseMatrix64F> {
    private SingularValueDecomposition<DenseMatrix64F> svd;
    private DenseMatrix64F pinv = new DenseMatrix64F(1, 1);
    private double threshold = UtilEjml.EPS;

    public SolvePseudoInverseSvd(int maxRows, int maxCols) {
        this.svd = DecompositionFactory.svd(maxRows, maxCols, true, true, true);
    }

    public SolvePseudoInverseSvd() {
        this(100, 100);
    }

    @Override
    public boolean setA(DenseMatrix64F A) {
        int j;
        this.pinv.reshape(A.numCols, A.numRows, false);
        if (!this.svd.decompose(A)) {
            return false;
        }
        DenseMatrix64F U_t = this.svd.getU(null, true);
        DenseMatrix64F V = this.svd.getV(null, false);
        double[] S = this.svd.getSingularValues();
        int N = Math.min(A.numRows, A.numCols);
        double maxSingular = 0.0;
        for (int i = 0; i < N; ++i) {
            if (!(S[i] > maxSingular)) continue;
            maxSingular = S[i];
        }
        double tau = this.threshold * (double)Math.max(A.numCols, A.numRows) * maxSingular;
        if (maxSingular != 0.0) {
            for (j = 0; j < N; ++j) {
                double s = S[j];
                S[j] = s < tau ? 0.0 : 1.0 / S[j];
            }
        }
        for (j = 0; j < V.numRows; ++j) {
            int index = j * V.numCols;
            for (int k = 0; k < V.numCols; ++k) {
                int n;
                double[] data = V.data;
                int n2 = n = index++;
                data[n2] = data[n2] * S[k];
            }
        }
        CommonOps.mult(V, U_t, this.pinv);
        return true;
    }

    @Override
    public double quality() {
        throw new IllegalArgumentException("Not supported by this solver.");
    }

    @Override
    public void solve(DenseMatrix64F b, DenseMatrix64F x) {
        CommonOps.mult(this.pinv, b, x);
    }

    @Override
    public void invert(DenseMatrix64F A_inv) {
        A_inv.set(this.pinv);
    }

    @Override
    public boolean modifiesA() {
        return this.svd.inputModified();
    }

    @Override
    public boolean modifiesB() {
        return false;
    }

    public void setThreshold(double threshold) {
        this.threshold = threshold;
    }

    public SingularValueDecomposition<DenseMatrix64F> getDecomposer() {
        return this.svd;
    }
}

