/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.alg.dense.misc;

import org.ejml.data.DenseMatrix64F;

public class UnrolledInverseFromMinor {
    public static final int MAX = 5;

    public static void inv(DenseMatrix64F mat, DenseMatrix64F inv) {
        double max = Math.abs(mat.data[0]);
        int N = mat.getNumElements();
        for (int i = 1; i < N; ++i) {
            double a = Math.abs(mat.data[i]);
            if (!(a > max)) continue;
            max = a;
        }
        switch (mat.numRows) {
            case 2: {
                UnrolledInverseFromMinor.inv2(mat, inv, 1.0 / max);
                break;
            }
            case 3: {
                UnrolledInverseFromMinor.inv3(mat, inv, 1.0 / max);
                break;
            }
            case 4: {
                UnrolledInverseFromMinor.inv4(mat, inv, 1.0 / max);
                break;
            }
            case 5: {
                UnrolledInverseFromMinor.inv5(mat, inv, 1.0 / max);
                break;
            }
            default: {
                throw new IllegalArgumentException("Not supported");
            }
        }
    }

    public static void inv2(DenseMatrix64F mat, DenseMatrix64F inv, double scale) {
        double m11;
        double[] data = mat.data;
        double a11 = data[0] * scale;
        double a12 = data[1] * scale;
        double a13 = data[2] * scale;
        double a14 = m11 = data[3] * scale;
        double m12 = -a13;
        double m13 = -a12;
        double m14 = a11;
        double det = (a11 * m11 + a12 * m12) / scale;
        data = inv.data;
        data[0] = m11 / det;
        data[1] = m13 / det;
        data[2] = m12 / det;
        data[3] = m14 / det;
    }

    public static void inv3(DenseMatrix64F mat, DenseMatrix64F inv, double scale) {
        double[] data = mat.data;
        double a11 = data[0] * scale;
        double a12 = data[1] * scale;
        double a13 = data[2] * scale;
        double a14 = data[3] * scale;
        double a15 = data[4] * scale;
        double a16 = data[5] * scale;
        double a17 = data[6] * scale;
        double a18 = data[7] * scale;
        double a19 = data[8] * scale;
        double m11 = a15 * a19 - a16 * a18;
        double m12 = -(a14 * a19 - a16 * a17);
        double m13 = a14 * a18 - a15 * a17;
        double m14 = -(a12 * a19 - a13 * a18);
        double m15 = a11 * a19 - a13 * a17;
        double m16 = -(a11 * a18 - a12 * a17);
        double m17 = a12 * a16 - a13 * a15;
        double m18 = -(a11 * a16 - a13 * a14);
        double m19 = a11 * a15 - a12 * a14;
        double det = (a11 * m11 + a12 * m12 + a13 * m13) / scale;
        data = inv.data;
        data[0] = m11 / det;
        data[1] = m14 / det;
        data[2] = m17 / det;
        data[3] = m12 / det;
        data[4] = m15 / det;
        data[5] = m18 / det;
        data[6] = m13 / det;
        data[7] = m16 / det;
        data[8] = m19 / det;
    }

    public static void inv4(DenseMatrix64F mat, DenseMatrix64F inv, double scale) {
        double[] data = mat.data;
        double a11 = data[0] * scale;
        double a12 = data[1] * scale;
        double a13 = data[2] * scale;
        double a14 = data[3] * scale;
        double a15 = data[4] * scale;
        double a16 = data[5] * scale;
        double a17 = data[6] * scale;
        double a18 = data[7] * scale;
        double a19 = data[8] * scale;
        double a20 = data[9] * scale;
        double a21 = data[10] * scale;
        double a22 = data[11] * scale;
        double a23 = data[12] * scale;
        double a24 = data[13] * scale;
        double a25 = data[14] * scale;
        double a26 = data[15] * scale;
        double m11 = a16 * (a21 * a26 - a22 * a25) - a17 * (a20 * a26 - a22 * a24) + a18 * (a20 * a25 - a21 * a24);
        double m12 = -(a15 * (a21 * a26 - a22 * a25) - a17 * (a19 * a26 - a22 * a23) + a18 * (a19 * a25 - a21 * a23));
        double m13 = a15 * (a20 * a26 - a22 * a24) - a16 * (a19 * a26 - a22 * a23) + a18 * (a19 * a24 - a20 * a23);
        double m14 = -(a15 * (a20 * a25 - a21 * a24) - a16 * (a19 * a25 - a21 * a23) + a17 * (a19 * a24 - a20 * a23));
        double m15 = -(a12 * (a21 * a26 - a22 * a25) - a13 * (a20 * a26 - a22 * a24) + a14 * (a20 * a25 - a21 * a24));
        double m16 = a11 * (a21 * a26 - a22 * a25) - a13 * (a19 * a26 - a22 * a23) + a14 * (a19 * a25 - a21 * a23);
        double m17 = -(a11 * (a20 * a26 - a22 * a24) - a12 * (a19 * a26 - a22 * a23) + a14 * (a19 * a24 - a20 * a23));
        double m18 = a11 * (a20 * a25 - a21 * a24) - a12 * (a19 * a25 - a21 * a23) + a13 * (a19 * a24 - a20 * a23);
        double m19 = a12 * (a17 * a26 - a18 * a25) - a13 * (a16 * a26 - a18 * a24) + a14 * (a16 * a25 - a17 * a24);
        double m20 = -(a11 * (a17 * a26 - a18 * a25) - a13 * (a15 * a26 - a18 * a23) + a14 * (a15 * a25 - a17 * a23));
        double m21 = a11 * (a16 * a26 - a18 * a24) - a12 * (a15 * a26 - a18 * a23) + a14 * (a15 * a24 - a16 * a23);
        double m22 = -(a11 * (a16 * a25 - a17 * a24) - a12 * (a15 * a25 - a17 * a23) + a13 * (a15 * a24 - a16 * a23));
        double m23 = -(a12 * (a17 * a22 - a18 * a21) - a13 * (a16 * a22 - a18 * a20) + a14 * (a16 * a21 - a17 * a20));
        double m24 = a11 * (a17 * a22 - a18 * a21) - a13 * (a15 * a22 - a18 * a19) + a14 * (a15 * a21 - a17 * a19);
        double m25 = -(a11 * (a16 * a22 - a18 * a20) - a12 * (a15 * a22 - a18 * a19) + a14 * (a15 * a20 - a16 * a19));
        double m26 = a11 * (a16 * a21 - a17 * a20) - a12 * (a15 * a21 - a17 * a19) + a13 * (a15 * a20 - a16 * a19);
        double det = (a11 * m11 + a12 * m12 + a13 * m13 + a14 * m14) / scale;
        data = inv.data;
        data[0] = m11 / det;
        data[1] = m15 / det;
        data[2] = m19 / det;
        data[3] = m23 / det;
        data[4] = m12 / det;
        data[5] = m16 / det;
        data[6] = m20 / det;
        data[7] = m24 / det;
        data[8] = m13 / det;
        data[9] = m17 / det;
        data[10] = m21 / det;
        data[11] = m25 / det;
        data[12] = m14 / det;
        data[13] = m18 / det;
        data[14] = m22 / det;
        data[15] = m26 / det;
    }

    public static void inv5(DenseMatrix64F mat, DenseMatrix64F inv, double scale) {
        double[] data = mat.data;
        double a11 = data[0] * scale;
        double a12 = data[1] * scale;
        double a13 = data[2] * scale;
        double a14 = data[3] * scale;
        double a15 = data[4] * scale;
        double a16 = data[5] * scale;
        double a17 = data[6] * scale;
        double a18 = data[7] * scale;
        double a19 = data[8] * scale;
        double a20 = data[9] * scale;
        double a21 = data[10] * scale;
        double a22 = data[11] * scale;
        double a23 = data[12] * scale;
        double a24 = data[13] * scale;
        double a25 = data[14] * scale;
        double a26 = data[15] * scale;
        double a27 = data[16] * scale;
        double a28 = data[17] * scale;
        double a29 = data[18] * scale;
        double a30 = data[19] * scale;
        double a31 = data[20] * scale;
        double a32 = data[21] * scale;
        double a33 = data[22] * scale;
        double a34 = data[23] * scale;
        double a35 = data[24] * scale;
        double m11 = a17 * (a23 * (a29 * a35 - a30 * a34) - a24 * (a28 * a35 - a30 * a33) + a25 * (a28 * a34 - a29 * a33)) - a18 * (a22 * (a29 * a35 - a30 * a34) - a24 * (a27 * a35 - a30 * a32) + a25 * (a27 * a34 - a29 * a32)) + a19 * (a22 * (a28 * a35 - a30 * a33) - a23 * (a27 * a35 - a30 * a32) + a25 * (a27 * a33 - a28 * a32)) - a20 * (a22 * (a28 * a34 - a29 * a33) - a23 * (a27 * a34 - a29 * a32) + a24 * (a27 * a33 - a28 * a32));
        double m12 = -(a16 * (a23 * (a29 * a35 - a30 * a34) - a24 * (a28 * a35 - a30 * a33) + a25 * (a28 * a34 - a29 * a33)) - a18 * (a21 * (a29 * a35 - a30 * a34) - a24 * (a26 * a35 - a30 * a31) + a25 * (a26 * a34 - a29 * a31)) + a19 * (a21 * (a28 * a35 - a30 * a33) - a23 * (a26 * a35 - a30 * a31) + a25 * (a26 * a33 - a28 * a31)) - a20 * (a21 * (a28 * a34 - a29 * a33) - a23 * (a26 * a34 - a29 * a31) + a24 * (a26 * a33 - a28 * a31)));
        double m13 = a16 * (a22 * (a29 * a35 - a30 * a34) - a24 * (a27 * a35 - a30 * a32) + a25 * (a27 * a34 - a29 * a32)) - a17 * (a21 * (a29 * a35 - a30 * a34) - a24 * (a26 * a35 - a30 * a31) + a25 * (a26 * a34 - a29 * a31)) + a19 * (a21 * (a27 * a35 - a30 * a32) - a22 * (a26 * a35 - a30 * a31) + a25 * (a26 * a32 - a27 * a31)) - a20 * (a21 * (a27 * a34 - a29 * a32) - a22 * (a26 * a34 - a29 * a31) + a24 * (a26 * a32 - a27 * a31));
        double m14 = -(a16 * (a22 * (a28 * a35 - a30 * a33) - a23 * (a27 * a35 - a30 * a32) + a25 * (a27 * a33 - a28 * a32)) - a17 * (a21 * (a28 * a35 - a30 * a33) - a23 * (a26 * a35 - a30 * a31) + a25 * (a26 * a33 - a28 * a31)) + a18 * (a21 * (a27 * a35 - a30 * a32) - a22 * (a26 * a35 - a30 * a31) + a25 * (a26 * a32 - a27 * a31)) - a20 * (a21 * (a27 * a33 - a28 * a32) - a22 * (a26 * a33 - a28 * a31) + a23 * (a26 * a32 - a27 * a31)));
        double m15 = a16 * (a22 * (a28 * a34 - a29 * a33) - a23 * (a27 * a34 - a29 * a32) + a24 * (a27 * a33 - a28 * a32)) - a17 * (a21 * (a28 * a34 - a29 * a33) - a23 * (a26 * a34 - a29 * a31) + a24 * (a26 * a33 - a28 * a31)) + a18 * (a21 * (a27 * a34 - a29 * a32) - a22 * (a26 * a34 - a29 * a31) + a24 * (a26 * a32 - a27 * a31)) - a19 * (a21 * (a27 * a33 - a28 * a32) - a22 * (a26 * a33 - a28 * a31) + a23 * (a26 * a32 - a27 * a31));
        double m16 = -(a12 * (a23 * (a29 * a35 - a30 * a34) - a24 * (a28 * a35 - a30 * a33) + a25 * (a28 * a34 - a29 * a33)) - a13 * (a22 * (a29 * a35 - a30 * a34) - a24 * (a27 * a35 - a30 * a32) + a25 * (a27 * a34 - a29 * a32)) + a14 * (a22 * (a28 * a35 - a30 * a33) - a23 * (a27 * a35 - a30 * a32) + a25 * (a27 * a33 - a28 * a32)) - a15 * (a22 * (a28 * a34 - a29 * a33) - a23 * (a27 * a34 - a29 * a32) + a24 * (a27 * a33 - a28 * a32)));
        double m17 = a11 * (a23 * (a29 * a35 - a30 * a34) - a24 * (a28 * a35 - a30 * a33) + a25 * (a28 * a34 - a29 * a33)) - a13 * (a21 * (a29 * a35 - a30 * a34) - a24 * (a26 * a35 - a30 * a31) + a25 * (a26 * a34 - a29 * a31)) + a14 * (a21 * (a28 * a35 - a30 * a33) - a23 * (a26 * a35 - a30 * a31) + a25 * (a26 * a33 - a28 * a31)) - a15 * (a21 * (a28 * a34 - a29 * a33) - a23 * (a26 * a34 - a29 * a31) + a24 * (a26 * a33 - a28 * a31));
        double m18 = -(a11 * (a22 * (a29 * a35 - a30 * a34) - a24 * (a27 * a35 - a30 * a32) + a25 * (a27 * a34 - a29 * a32)) - a12 * (a21 * (a29 * a35 - a30 * a34) - a24 * (a26 * a35 - a30 * a31) + a25 * (a26 * a34 - a29 * a31)) + a14 * (a21 * (a27 * a35 - a30 * a32) - a22 * (a26 * a35 - a30 * a31) + a25 * (a26 * a32 - a27 * a31)) - a15 * (a21 * (a27 * a34 - a29 * a32) - a22 * (a26 * a34 - a29 * a31) + a24 * (a26 * a32 - a27 * a31)));
        double m19 = a11 * (a22 * (a28 * a35 - a30 * a33) - a23 * (a27 * a35 - a30 * a32) + a25 * (a27 * a33 - a28 * a32)) - a12 * (a21 * (a28 * a35 - a30 * a33) - a23 * (a26 * a35 - a30 * a31) + a25 * (a26 * a33 - a28 * a31)) + a13 * (a21 * (a27 * a35 - a30 * a32) - a22 * (a26 * a35 - a30 * a31) + a25 * (a26 * a32 - a27 * a31)) - a15 * (a21 * (a27 * a33 - a28 * a32) - a22 * (a26 * a33 - a28 * a31) + a23 * (a26 * a32 - a27 * a31));
        double m20 = -(a11 * (a22 * (a28 * a34 - a29 * a33) - a23 * (a27 * a34 - a29 * a32) + a24 * (a27 * a33 - a28 * a32)) - a12 * (a21 * (a28 * a34 - a29 * a33) - a23 * (a26 * a34 - a29 * a31) + a24 * (a26 * a33 - a28 * a31)) + a13 * (a21 * (a27 * a34 - a29 * a32) - a22 * (a26 * a34 - a29 * a31) + a24 * (a26 * a32 - a27 * a31)) - a14 * (a21 * (a27 * a33 - a28 * a32) - a22 * (a26 * a33 - a28 * a31) + a23 * (a26 * a32 - a27 * a31)));
        double m21 = a12 * (a18 * (a29 * a35 - a30 * a34) - a19 * (a28 * a35 - a30 * a33) + a20 * (a28 * a34 - a29 * a33)) - a13 * (a17 * (a29 * a35 - a30 * a34) - a19 * (a27 * a35 - a30 * a32) + a20 * (a27 * a34 - a29 * a32)) + a14 * (a17 * (a28 * a35 - a30 * a33) - a18 * (a27 * a35 - a30 * a32) + a20 * (a27 * a33 - a28 * a32)) - a15 * (a17 * (a28 * a34 - a29 * a33) - a18 * (a27 * a34 - a29 * a32) + a19 * (a27 * a33 - a28 * a32));
        double m22 = -(a11 * (a18 * (a29 * a35 - a30 * a34) - a19 * (a28 * a35 - a30 * a33) + a20 * (a28 * a34 - a29 * a33)) - a13 * (a16 * (a29 * a35 - a30 * a34) - a19 * (a26 * a35 - a30 * a31) + a20 * (a26 * a34 - a29 * a31)) + a14 * (a16 * (a28 * a35 - a30 * a33) - a18 * (a26 * a35 - a30 * a31) + a20 * (a26 * a33 - a28 * a31)) - a15 * (a16 * (a28 * a34 - a29 * a33) - a18 * (a26 * a34 - a29 * a31) + a19 * (a26 * a33 - a28 * a31)));
        double m23 = a11 * (a17 * (a29 * a35 - a30 * a34) - a19 * (a27 * a35 - a30 * a32) + a20 * (a27 * a34 - a29 * a32)) - a12 * (a16 * (a29 * a35 - a30 * a34) - a19 * (a26 * a35 - a30 * a31) + a20 * (a26 * a34 - a29 * a31)) + a14 * (a16 * (a27 * a35 - a30 * a32) - a17 * (a26 * a35 - a30 * a31) + a20 * (a26 * a32 - a27 * a31)) - a15 * (a16 * (a27 * a34 - a29 * a32) - a17 * (a26 * a34 - a29 * a31) + a19 * (a26 * a32 - a27 * a31));
        double m24 = -(a11 * (a17 * (a28 * a35 - a30 * a33) - a18 * (a27 * a35 - a30 * a32) + a20 * (a27 * a33 - a28 * a32)) - a12 * (a16 * (a28 * a35 - a30 * a33) - a18 * (a26 * a35 - a30 * a31) + a20 * (a26 * a33 - a28 * a31)) + a13 * (a16 * (a27 * a35 - a30 * a32) - a17 * (a26 * a35 - a30 * a31) + a20 * (a26 * a32 - a27 * a31)) - a15 * (a16 * (a27 * a33 - a28 * a32) - a17 * (a26 * a33 - a28 * a31) + a18 * (a26 * a32 - a27 * a31)));
        double m25 = a11 * (a17 * (a28 * a34 - a29 * a33) - a18 * (a27 * a34 - a29 * a32) + a19 * (a27 * a33 - a28 * a32)) - a12 * (a16 * (a28 * a34 - a29 * a33) - a18 * (a26 * a34 - a29 * a31) + a19 * (a26 * a33 - a28 * a31)) + a13 * (a16 * (a27 * a34 - a29 * a32) - a17 * (a26 * a34 - a29 * a31) + a19 * (a26 * a32 - a27 * a31)) - a14 * (a16 * (a27 * a33 - a28 * a32) - a17 * (a26 * a33 - a28 * a31) + a18 * (a26 * a32 - a27 * a31));
        double m26 = -(a12 * (a18 * (a24 * a35 - a25 * a34) - a19 * (a23 * a35 - a25 * a33) + a20 * (a23 * a34 - a24 * a33)) - a13 * (a17 * (a24 * a35 - a25 * a34) - a19 * (a22 * a35 - a25 * a32) + a20 * (a22 * a34 - a24 * a32)) + a14 * (a17 * (a23 * a35 - a25 * a33) - a18 * (a22 * a35 - a25 * a32) + a20 * (a22 * a33 - a23 * a32)) - a15 * (a17 * (a23 * a34 - a24 * a33) - a18 * (a22 * a34 - a24 * a32) + a19 * (a22 * a33 - a23 * a32)));
        double m27 = a11 * (a18 * (a24 * a35 - a25 * a34) - a19 * (a23 * a35 - a25 * a33) + a20 * (a23 * a34 - a24 * a33)) - a13 * (a16 * (a24 * a35 - a25 * a34) - a19 * (a21 * a35 - a25 * a31) + a20 * (a21 * a34 - a24 * a31)) + a14 * (a16 * (a23 * a35 - a25 * a33) - a18 * (a21 * a35 - a25 * a31) + a20 * (a21 * a33 - a23 * a31)) - a15 * (a16 * (a23 * a34 - a24 * a33) - a18 * (a21 * a34 - a24 * a31) + a19 * (a21 * a33 - a23 * a31));
        double m28 = -(a11 * (a17 * (a24 * a35 - a25 * a34) - a19 * (a22 * a35 - a25 * a32) + a20 * (a22 * a34 - a24 * a32)) - a12 * (a16 * (a24 * a35 - a25 * a34) - a19 * (a21 * a35 - a25 * a31) + a20 * (a21 * a34 - a24 * a31)) + a14 * (a16 * (a22 * a35 - a25 * a32) - a17 * (a21 * a35 - a25 * a31) + a20 * (a21 * a32 - a22 * a31)) - a15 * (a16 * (a22 * a34 - a24 * a32) - a17 * (a21 * a34 - a24 * a31) + a19 * (a21 * a32 - a22 * a31)));
        double m29 = a11 * (a17 * (a23 * a35 - a25 * a33) - a18 * (a22 * a35 - a25 * a32) + a20 * (a22 * a33 - a23 * a32)) - a12 * (a16 * (a23 * a35 - a25 * a33) - a18 * (a21 * a35 - a25 * a31) + a20 * (a21 * a33 - a23 * a31)) + a13 * (a16 * (a22 * a35 - a25 * a32) - a17 * (a21 * a35 - a25 * a31) + a20 * (a21 * a32 - a22 * a31)) - a15 * (a16 * (a22 * a33 - a23 * a32) - a17 * (a21 * a33 - a23 * a31) + a18 * (a21 * a32 - a22 * a31));
        double m30 = -(a11 * (a17 * (a23 * a34 - a24 * a33) - a18 * (a22 * a34 - a24 * a32) + a19 * (a22 * a33 - a23 * a32)) - a12 * (a16 * (a23 * a34 - a24 * a33) - a18 * (a21 * a34 - a24 * a31) + a19 * (a21 * a33 - a23 * a31)) + a13 * (a16 * (a22 * a34 - a24 * a32) - a17 * (a21 * a34 - a24 * a31) + a19 * (a21 * a32 - a22 * a31)) - a14 * (a16 * (a22 * a33 - a23 * a32) - a17 * (a21 * a33 - a23 * a31) + a18 * (a21 * a32 - a22 * a31)));
        double m31 = a12 * (a18 * (a24 * a30 - a25 * a29) - a19 * (a23 * a30 - a25 * a28) + a20 * (a23 * a29 - a24 * a28)) - a13 * (a17 * (a24 * a30 - a25 * a29) - a19 * (a22 * a30 - a25 * a27) + a20 * (a22 * a29 - a24 * a27)) + a14 * (a17 * (a23 * a30 - a25 * a28) - a18 * (a22 * a30 - a25 * a27) + a20 * (a22 * a28 - a23 * a27)) - a15 * (a17 * (a23 * a29 - a24 * a28) - a18 * (a22 * a29 - a24 * a27) + a19 * (a22 * a28 - a23 * a27));
        double m32 = -(a11 * (a18 * (a24 * a30 - a25 * a29) - a19 * (a23 * a30 - a25 * a28) + a20 * (a23 * a29 - a24 * a28)) - a13 * (a16 * (a24 * a30 - a25 * a29) - a19 * (a21 * a30 - a25 * a26) + a20 * (a21 * a29 - a24 * a26)) + a14 * (a16 * (a23 * a30 - a25 * a28) - a18 * (a21 * a30 - a25 * a26) + a20 * (a21 * a28 - a23 * a26)) - a15 * (a16 * (a23 * a29 - a24 * a28) - a18 * (a21 * a29 - a24 * a26) + a19 * (a21 * a28 - a23 * a26)));
        double m33 = a11 * (a17 * (a24 * a30 - a25 * a29) - a19 * (a22 * a30 - a25 * a27) + a20 * (a22 * a29 - a24 * a27)) - a12 * (a16 * (a24 * a30 - a25 * a29) - a19 * (a21 * a30 - a25 * a26) + a20 * (a21 * a29 - a24 * a26)) + a14 * (a16 * (a22 * a30 - a25 * a27) - a17 * (a21 * a30 - a25 * a26) + a20 * (a21 * a27 - a22 * a26)) - a15 * (a16 * (a22 * a29 - a24 * a27) - a17 * (a21 * a29 - a24 * a26) + a19 * (a21 * a27 - a22 * a26));
        double m34 = -(a11 * (a17 * (a23 * a30 - a25 * a28) - a18 * (a22 * a30 - a25 * a27) + a20 * (a22 * a28 - a23 * a27)) - a12 * (a16 * (a23 * a30 - a25 * a28) - a18 * (a21 * a30 - a25 * a26) + a20 * (a21 * a28 - a23 * a26)) + a13 * (a16 * (a22 * a30 - a25 * a27) - a17 * (a21 * a30 - a25 * a26) + a20 * (a21 * a27 - a22 * a26)) - a15 * (a16 * (a22 * a28 - a23 * a27) - a17 * (a21 * a28 - a23 * a26) + a18 * (a21 * a27 - a22 * a26)));
        double m35 = a11 * (a17 * (a23 * a29 - a24 * a28) - a18 * (a22 * a29 - a24 * a27) + a19 * (a22 * a28 - a23 * a27)) - a12 * (a16 * (a23 * a29 - a24 * a28) - a18 * (a21 * a29 - a24 * a26) + a19 * (a21 * a28 - a23 * a26)) + a13 * (a16 * (a22 * a29 - a24 * a27) - a17 * (a21 * a29 - a24 * a26) + a19 * (a21 * a27 - a22 * a26)) - a14 * (a16 * (a22 * a28 - a23 * a27) - a17 * (a21 * a28 - a23 * a26) + a18 * (a21 * a27 - a22 * a26));
        double det = (a11 * m11 + a12 * m12 + a13 * m13 + a14 * m14 + a15 * m15) / scale;
        data = inv.data;
        data[0] = m11 / det;
        data[1] = m16 / det;
        data[2] = m21 / det;
        data[3] = m26 / det;
        data[4] = m31 / det;
        data[5] = m12 / det;
        data[6] = m17 / det;
        data[7] = m22 / det;
        data[8] = m27 / det;
        data[9] = m32 / det;
        data[10] = m13 / det;
        data[11] = m18 / det;
        data[12] = m23 / det;
        data[13] = m28 / det;
        data[14] = m33 / det;
        data[15] = m14 / det;
        data[16] = m19 / det;
        data[17] = m24 / det;
        data[18] = m29 / det;
        data[19] = m34 / det;
        data[20] = m15 / det;
        data[21] = m20 / det;
        data[22] = m25 / det;
        data[23] = m30 / det;
        data[24] = m35 / det;
    }
}

