/*
 * Decompiled with CFR 0.152.
 */
package james94jeans2.minimapsync.client;

import james94jeans2.minimapsync.Minimapsync;
import james94jeans2.minimapsync.client.MinimapKeyHandler;
import james94jeans2.minimapsync.client.MinimapsyncClientConfiguration;
import james94jeans2.minimapsync.client.gui.GuiManager;
import james94jeans2.minimapsync.network.packet.MinimapsyncCheckPacket;
import james94jeans2.minimapsync.network.packet.MinimapsyncDonePacket;
import james94jeans2.minimapsync.network.packet.MinimapsyncKeyPacket;
import james94jeans2.minimapsync.network.packet.MinimapsyncRequestPacket;
import james94jeans2.minimapsync.network.packet.MinimapsyncSendPacket;
import james94jeans2.minimapsync.network.packet.MinimapsyncSendWaypointPacket;
import james94jeans2.minimapsync.network.packet.MinimapsyncWaypointPacket;
import james94jeans2.minimapsync.util.AbstractWaypointManager;
import james94jeans2.minimapsync.util.Waypoint;
import james94jeans2.minimapsync.util.WaypointList;
import james94jeans2.minimapsync.util.loader.IWaypointLoader;
import james94jeans2.minimapsync.util.loader.JourneyMapLoader;
import james94jeans2.minimapsync.util.loader.MinimapsyncLoader;
import james94jeans2.minimapsync.util.loader.VoxelmapLoader;
import james94jeans2.minimapsync.util.loader.XaerosMinimapLoader;
import java.util.Iterator;
import java.util.LinkedList;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import org.apache.commons.lang3.tuple.Pair;
import reifnsk.minimap.MinimapsyncUpdaterRei;

public class ClientWaypointManager
extends AbstractWaypointManager {
    private int key;
    private int map = Minimapsync.instance.getMap();
    private MinimapsyncUpdaterRei updaterRei;
    private boolean syncOnServer;
    private boolean enabled = Minimapsync.instance.getEnabled();
    private boolean lan = false;
    private boolean counting = false;
    private boolean guiEnabled = ((MinimapsyncClientConfiguration)Minimapsync.instance.getConfiguration()).getEnableGui();
    private IWaypointLoader syncloader;
    private GuiManager guiMng = GuiManager.instance();

    public ClientWaypointManager() {
        String mapName = "";
        switch (this.map) {
            case 1: {
                this.loader = new VoxelmapLoader();
                mapName = "VoxelMap";
                break;
            }
            case 2: {
                this.updaterRei = new MinimapsyncUpdaterRei();
                mapName = "Rei's Minimap";
                break;
            }
            case 3: {
                this.loader = new JourneyMapLoader();
                mapName = "JourneyMap";
                break;
            }
            case 4: {
                this.loader = new XaerosMinimapLoader();
                mapName = "Xaero's Minimap";
            }
        }
        this.syncloader = new MinimapsyncLoader();
        this.logger.info("Using map: " + this.map + "|" + mapName);
    }

    public void resetWaypoints() {
        this.dimensions = new LinkedList();
        this.noWaypoints = true;
    }

    public void requestRemoteWaypoints() {
        this.pipeline.sendToServer(new MinimapsyncRequestPacket());
    }

    public void requestAllRemoteWaypoints() {
        this.pipeline.sendToServer(new MinimapsyncRequestPacket(true));
    }

    @Override
    public WaypointList checkWaypointTeleport(String pWaypointName, EntityPlayerMP player) {
        this.loadWaypoints();
        return super.checkWaypointTeleport(pWaypointName, player);
    }

    public void handleKeyPacket(int pKey) {
        this.logger.info("received key: " + pKey);
        if (this.guiEnabled) {
            if (pKey == 0) {
                this.requestAllRemoteWaypoints();
            } else {
                this.key = pKey;
                this.guiMng.displaySyncList();
            }
        } else if (pKey != 0) {
            this.key = pKey;
            this.requestRemoteWaypoints();
        }
    }

    @Override
    public void handleWaypointPacket(MinimapsyncWaypointPacket packet, EntityPlayer player) {
        if (this.counting) {
            this.guiMng.upCount();
        }
        super.handleWaypointPacket(packet, player);
    }

    @Override
    public void handleDonePacket(MinimapsyncDonePacket packet, EntityPlayer player) {
        if (packet.getKey() != 0) {
            this.logger.info("handling keyed done packet");
            boolean loaded = false;
            Pair localPair = null;
            for (Pair pair : this.remoteIn) {
                if (!((EntityPlayer)pair.getKey()).equals((Object)player)) continue;
                loaded = true;
                localPair = pair;
                break;
            }
            if (loaded) {
                this.loadWaypoints();
                this.checkMissingLocalWaypoints(player);
                this.remoteIn.remove(localPair);
            }
        } else {
            super.handleDonePacket(packet, player);
        }
        MinimapKeyHandler.getInstance().enable();
    }

    @Override
    public void sendCheckPacket(EntityPlayer pPlayer) {
        MinimapsyncCheckPacket pkt = new MinimapsyncCheckPacket('L');
        this.pipeline.sendTo(pkt, (EntityPlayerMP)pPlayer);
    }

    public void sendCheckPacket() {
        if (!Minecraft.func_71410_x().func_71356_B()) {
            MinimapsyncCheckPacket pkt = new MinimapsyncCheckPacket('c');
            this.pipeline.sendToServer(pkt);
        }
    }

    public void setLAN(boolean pBoolean) {
        this.lan = pBoolean;
    }

    public boolean getLAN() {
        return this.lan;
    }

    public void setSyncOnServer(boolean pBoolean) {
        this.syncOnServer = pBoolean;
    }

    public boolean syncOnServer() {
        return this.syncOnServer;
    }

    @Override
    public void afterStartup() {
    }

    public void handleSaving() {
        Pair in = (Pair)this.remoteIn.getFirst();
        this.remoteIn.remove();
        WaypointList inList = (WaypointList)in.getValue();
        WaypointList dimList = null;
        int dimension = Minecraft.func_71410_x().field_71439_g.field_71093_bK;
        if (this.anyWaypointsInDimension(dimension)) {
            dimList = this.getWaypointsForDimension(dimension);
            WaypointList toSend = inList.getPublic().getMissingPoints(dimList);
            toSend.setPrivate(true);
            if (this.mode != 1) {
                if (this.key != 0) {
                    this.sendWaypointListToServer(this.key, toSend);
                } else {
                    this.sendWaypointListToServer(toSend);
                }
            } else {
                this.sendWaypointListToServer(toSend);
            }
            dimList.removeAll(dimList.getDoublePoints(inList.getPublic()));
            dimList.addAll(inList.getPublic());
        } else {
            if (this.dimensions == null) {
                this.logger.info("dimensions is null");
                return;
            }
            this.dimensions.add(inList.getPublic());
            if (this.mode != 1) {
                if (this.key != 0) {
                    this.pipeline.sendToServer(new MinimapsyncDonePacket(this.key, true));
                    this.key = 0;
                }
            } else {
                this.pipeline.sendToServer(new MinimapsyncDonePacket(true));
            }
        }
        this.saveWaypoints();
    }

    @Override
    protected void checkMissingRemoteWaypoints(EntityPlayer player) {
        if (this.mode == 1 || this.lan) {
            if (this.counting) {
                this.guiMng.upCount();
                return;
            }
            super.checkMissingRemoteWaypoints(player);
        } else {
            if (this.counting) {
                this.guiMng.upCount();
                return;
            }
            if (this.key != 0) {
                for (Pair pair : this.remoteIn) {
                    if (pair.getKey() != player) continue;
                    WaypointList list = this.checkMissingRemoteWaypoints((WaypointList)pair.getValue());
                    this.remoteIn.remove(pair);
                    this.handleRemoteOut(this.key, list);
                    return;
                }
            } else {
                this.handleSaving();
            }
        }
    }

    private void handleRemoteOut(int key, WaypointList list) {
        this.sendWaypointListToServer(key, list);
    }

    protected void sendWaypointListToServer(int key, WaypointList waypoints) {
        if (waypoints != null) {
            for (Waypoint waypoint : waypoints) {
                this.sendWaypointToServer(key, waypoint);
            }
        }
        this.pipeline.sendToServer(new MinimapsyncDonePacket(key, waypoints.isPrivate()));
        key = 0;
    }

    public void sendWaypointToServer(MinimapsyncSendPacket packet) {
        String waypointName = packet.getWaypoint();
        int dimension = packet.getDimension();
        this.loadWaypoints();
        if (!this.noWaypoints) {
            for (WaypointList list : this.dimensions) {
                if (list.getDim() != dimension) continue;
                WaypointList wp = list.getWaypointsForName(waypointName);
                if (wp.size() == 1) {
                    Waypoint point = wp.get(0);
                    this.pipeline.sendToServer(new MinimapsyncSendWaypointPacket(point.getServerLine(), point.getDim(), packet.getKey()));
                }
                return;
            }
        }
    }

    public void setWaypointsForDimension(int dim, WaypointList newList) {
        Iterator listIt = this.dimensions.iterator();
        while (listIt.hasNext()) {
            if (((WaypointList)listIt.next()).getDim() != dim) continue;
            listIt.remove();
            break;
        }
        this.dimensions.add(newList);
    }

    @Override
    protected void loadWaypoints() {
        LinkedList<WaypointList> sync = this.syncloader.loadAllWaypoints();
        this.dimensions = this.loader.loadAllWaypoints();
        if (sync != null) {
            if (this.dimensions != null) {
                for (WaypointList tempList : sync) {
                    boolean handled = false;
                    for (WaypointList dimList : this.dimensions) {
                        if (dimList.getDim() != tempList.getDim()) continue;
                        WaypointList toRemove = dimList.getDoublePoints(tempList);
                        dimList.removeAll(toRemove);
                        WaypointList toAdd = dimList.getMissingPoints(tempList);
                        dimList.addAll(toAdd);
                        handled = true;
                        break;
                    }
                    if (handled) continue;
                    this.dimensions.add(tempList);
                }
            } else {
                this.dimensions = sync;
            }
        }
        if (this.dimensions == null) {
            this.logger.info("No waypoints saved up to now!");
            this.noWaypoints = true;
        } else {
            for (WaypointList list : this.dimensions) {
                if (list.isEmpty()) continue;
                this.noWaypoints = false;
                break;
            }
        }
        this.saveWaypoints();
    }

    @Override
    protected WaypointList loadWaypointsForDimension(int pDim) {
        WaypointList returnList = this.loader.loadWaypointsForDimension(pDim);
        WaypointList tempList = this.syncloader.loadWaypointsForDimension(pDim);
        if (tempList != null) {
            WaypointList toRemove = returnList.getDoublePoints(tempList);
            WaypointList toAdd = tempList.getDoublePoints(returnList);
            returnList.removeAll(toRemove);
            returnList.addAll(toAdd);
            return returnList;
        }
        return returnList;
    }

    @Override
    protected void saveWaypoints() {
        if (this.dimensions != null) {
            this.loader.saveAllWaypoints(this.dimensions);
            this.syncloader.saveAllWaypoints(this.dimensions);
        }
    }

    public void setCounting(boolean state) {
        this.counting = state;
    }

    public void discardRemoteIn() {
        this.remoteIn.remove();
    }

    @Override
    public WaypointList getWaypointsForDimension(int dimension) {
        if (!this.noWaypoints) {
            for (WaypointList list : this.dimensions) {
                if (list.getDim() != dimension) continue;
                WaypointList returnList = list.clone();
                return returnList;
            }
        }
        return null;
    }

    public void requestKey() {
        this.pipeline.sendToServer(new MinimapsyncKeyPacket());
    }
}

