/*
 * Decompiled with CFR 0.152.
 */
package james94jeans2.minimapsync.client.gui;

import james94jeans2.minimapsync.client.ClientWaypointManager;
import james94jeans2.minimapsync.client.MinimapKeyHandler;
import james94jeans2.minimapsync.util.Waypoint;
import james94jeans2.minimapsync.util.WaypointList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiSlot;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.MathHelper;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

public class GuiScreenSyncList
extends GuiScreen {
    private List clientList;
    private List serverList;
    private WaypointList clientData;
    private WaypointList serverData;
    private ClientWaypointManager manager;
    private GuiButton delete;

    public GuiScreenSyncList(ClientWaypointManager manager) {
        this.manager = manager;
        WaypointList tempList = manager.getWaypointsForDimension(Minecraft.func_71410_x().field_71439_g.field_71093_bK);
        if (tempList != null) {
            this.clientData = tempList.getPrivate();
            this.serverData = tempList.getPublic();
        } else {
            this.clientData = new WaypointList(Minecraft.func_71410_x().field_71439_g.field_71093_bK, false);
            this.serverData = new WaypointList(Minecraft.func_71410_x().field_71439_g.field_71093_bK, true);
        }
    }

    public void func_73866_w_() {
        this.clientList = new List(this.field_146294_l / 2, this.field_146294_l / 2 - 50, 0, this.clientData, true);
        this.serverList = new List(this.field_146294_l / 2 + 1, this.field_146294_l / 2 - 50, this.field_146294_l / 2, this.serverData, false);
        this.field_146292_n.clear();
        this.field_146292_n.add(new GuiButton(0, this.field_146294_l / 2 + 45, this.field_146295_m - 26, 60, 20, "Cancel"));
        this.field_146292_n.add(new GuiButton(1, this.field_146294_l / 2 - 30, this.field_146295_m - 26, 60, 20, "Apply"));
        this.field_146292_n.add(new GuiButton(2, this.field_146294_l / 2 - 15, this.clientList.field_148154_c / 2 - 20, 30, 20, ">"));
        this.field_146292_n.add(new GuiButton(3, this.field_146294_l / 2 - 15, this.clientList.field_148154_c / 2 + 20, 30, 20, "<"));
        this.delete = new GuiButton(4, this.field_146294_l / 2 - 105, this.field_146295_m - 26, 60, 20, "Delete");
        this.field_146292_n.add(this.delete);
        this.delete.field_146124_l = !this.clientData.isEmpty();
    }

    public void func_73878_a(boolean result, int id) {
    }

    public void func_73863_a(int mouseX, int mouseY, float f) {
        if (this.clientList != null && this.serverList != null) {
            this.clientList.func_148128_a(mouseX, mouseY, f);
            this.serverList.func_148128_a(mouseX, mouseY, f);
            this.overlayMiddle();
            this.func_73732_a(this.field_146289_q, "Minimapsync", this.field_146294_l / 2, 10, -1);
            this.func_73732_a(this.field_146289_q, "private waypoints:", (this.clientList.listWidth + 6) / 2, 20, -1);
            this.func_73732_a(this.field_146289_q, "public waypoints:", this.field_146294_l - (this.serverList.listWidth + 6) / 2, 20, -1);
        }
        super.func_73863_a(mouseX, mouseY, f);
    }

    public void func_73869_a(char par1, int par2) {
        switch (par2) {
            case 1: {
                this.cancel();
                break;
            }
            case 28: {
                this.saveChanges();
                break;
            }
            case 211: {
                if (!this.delete.field_146124_l) break;
                this.deleteWaypoint();
            }
        }
        super.func_73869_a(par1, par2);
    }

    private void deleteWaypoint() {
        Waypoint toDelete = this.clientList.getSelected();
        if (toDelete != null) {
            this.clientData.remove(toDelete);
            this.delete.field_146124_l = !this.clientData.isEmpty();
        }
    }

    private void cancel() {
        this.manager.handleSaving();
        MinimapKeyHandler.getInstance().enable();
        Minecraft.func_71410_x().func_147108_a(null);
    }

    public void func_146284_a(GuiButton button) {
        switch (button.field_146127_k) {
            case 0: {
                this.cancel();
                break;
            }
            case 1: {
                this.saveChanges();
                break;
            }
            case 2: {
                this.add();
                break;
            }
            case 3: {
                this.remove();
                break;
            }
            case 4: {
                this.deleteWaypoint();
            }
        }
    }

    private void remove() {
        Waypoint toRemove = this.serverList.getSelected();
        if (toRemove != null) {
            toRemove.setPublic(false);
            this.serverData.remove(toRemove);
            this.clientData.add(toRemove);
            this.clientList.select(0);
            this.delete.field_146124_l = true;
        }
    }

    private void add() {
        Waypoint toAdd = this.clientList.getSelected();
        if (toAdd != null) {
            toAdd.setPublic(true);
            this.clientData.remove(toAdd);
            this.serverData.add(toAdd);
            this.delete.field_146124_l = !this.clientData.isEmpty();
        }
    }

    private void saveChanges() {
        WaypointList tempList = this.clientData;
        tempList.addAll(this.serverData);
        ((ClientWaypointManager)ClientWaypointManager.getInstance()).setWaypointsForDimension(tempList.getDim(), tempList);
        this.manager.handleSaving();
        MinimapKeyHandler.getInstance().enable();
        Minecraft.func_71410_x().func_147108_a(null);
    }

    public void func_146274_d() {
        super.func_146274_d();
        if (this.clientList != null && this.serverList != null) {
            this.clientList.handleMouseInput();
            this.serverList.handleMouseInput();
        }
    }

    private void overlayMiddle() {
        Tessellator tessellator = Tessellator.field_78398_a;
        this.field_146297_k.func_110434_K().func_110577_a(Gui.field_110325_k);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        float f = 32.0f;
        tessellator.func_78382_b();
        tessellator.func_78384_a(0x404040, 255);
        tessellator.func_78374_a((double)(this.clientList.func_148139_c() + 12), (double)(this.clientList.field_148158_l - this.clientList.field_148153_b), 0.0, (double)((float)(this.clientList.func_148139_c() + 12) / f), (double)((float)(this.clientList.field_148158_l - this.clientList.field_148153_b) / f));
        tessellator.func_78374_a((double)(this.field_146294_l - this.serverList.func_148139_c() - 12), (double)(this.clientList.field_148158_l - this.clientList.field_148153_b), 0.0, (double)((float)(this.field_146294_l - this.serverList.func_148139_c() - 12) / f), (double)((float)(this.clientList.field_148158_l - this.clientList.field_148153_b) / f));
        tessellator.func_78374_a((double)(this.field_146294_l - this.serverList.func_148139_c() - 12), (double)this.clientList.field_148153_b, 0.0, (double)((float)(this.field_146294_l - this.serverList.func_148139_c() - 12) / f), (double)((float)this.clientList.field_148153_b / f));
        tessellator.func_78374_a((double)(this.clientList.func_148139_c() + 12), (double)this.clientList.field_148153_b, 0.0, (double)((float)(this.clientList.func_148139_c() + 12) / f), (double)((float)this.clientList.field_148153_b / f));
        tessellator.func_78381_a();
    }

    private class List
    extends GuiSlot {
        private WaypointList data;
        private int listWidth;
        private int mSelectedElement;
        private float mAmountScrolled;
        private float mInitialClickY;
        private float mScrollMultiplier;
        private boolean isleft;
        private boolean mHasListHeader;
        private long mLastClicked;
        private Minecraft mc;

        public List(int width, int listWidth, int position, WaypointList data, boolean isleft) {
            super(Minecraft.func_71410_x(), width, GuiScreenSyncList.this.field_146295_m, 32, GuiScreenSyncList.this.field_146295_m - 32, 14);
            this.mInitialClickY = -2.0f;
            this.mHasListHeader = false;
            this.field_148152_e = position;
            this.field_148151_d = position + width;
            this.data = data;
            this.mSelectedElement = 0;
            this.listWidth = listWidth;
            this.isleft = isleft;
            this.mc = Minecraft.func_71410_x();
        }

        public int func_148139_c() {
            return this.listWidth;
        }

        protected int func_148137_d() {
            if (this.isleft) {
                return this.field_148152_e + this.func_148139_c() + 6;
            }
            return this.field_148152_e + this.field_148155_a - 6;
        }

        protected int func_148127_b() {
            return this.data.size();
        }

        protected void func_148144_a(int slotIndex, boolean isDoubleClick, int mouseX, int mouseY) {
            this.mSelectedElement = slotIndex < this.func_148127_b() ? slotIndex : -1;
        }

        protected boolean func_148131_a(int slotIndex) {
            return this.mSelectedElement == slotIndex;
        }

        protected void func_148126_a(int var1, int var2, int var3, int var4, Tessellator tessl, int var5, int var6) {
            if (this.data != null && !this.data.isEmpty() && this.data.size() > var1) {
                String text = this.data.get(var1).getName();
                int stringWidth = GuiScreenSyncList.this.field_146289_q.func_78256_a(text);
                int x = this.isleft ? this.field_148152_e + 5 + this.listWidth / 2 - stringWidth / 2 : this.field_148152_e + this.field_148155_a - this.listWidth / 2 - stringWidth / 2;
                GuiScreenSyncList.this.func_73731_b(GuiScreenSyncList.this.field_146289_q, text, x, var3 + 1, 0x808080);
            }
        }

        protected void func_148123_a() {
        }

        protected void func_148120_b(int p_148120_1_, int p_148120_2_, int p_148120_3_, int p_148120_4_) {
            int i1 = this.func_148127_b();
            Tessellator tessellator = Tessellator.field_78398_a;
            for (int j1 = 0; j1 < i1; ++j1) {
                int k1 = p_148120_2_ + j1 * this.field_148149_f + this.field_148160_j;
                int l1 = this.field_148149_f - 4;
                if (this.func_148131_a(j1)) {
                    int j2;
                    int i2;
                    if (this.isleft) {
                        i2 = this.field_148152_e + 5;
                        j2 = this.field_148152_e + this.func_148139_c() + 5;
                    } else {
                        i2 = this.field_148152_e + this.field_148155_a - this.func_148139_c() - 7;
                        j2 = this.field_148152_e + this.field_148155_a - 7;
                    }
                    GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    GL11.glDisable((int)3553);
                    tessellator.func_78382_b();
                    tessellator.func_78378_d(0x808080);
                    tessellator.func_78374_a((double)i2, (double)(k1 + l1 + 2), 0.0, 0.0, 1.0);
                    tessellator.func_78374_a((double)j2, (double)(k1 + l1 + 2), 0.0, 1.0, 1.0);
                    tessellator.func_78374_a((double)j2, (double)(k1 - 2), 0.0, 1.0, 0.0);
                    tessellator.func_78374_a((double)i2, (double)(k1 - 2), 0.0, 0.0, 0.0);
                    tessellator.func_78378_d(0);
                    tessellator.func_78374_a((double)(i2 + 1), (double)(k1 + l1 + 1), 0.0, 0.0, 1.0);
                    tessellator.func_78374_a((double)(j2 - 1), (double)(k1 + l1 + 1), 0.0, 1.0, 1.0);
                    tessellator.func_78374_a((double)(j2 - 1), (double)(k1 - 1), 0.0, 1.0, 0.0);
                    tessellator.func_78374_a((double)(i2 + 1), (double)(k1 - 1), 0.0, 0.0, 0.0);
                    tessellator.func_78381_a();
                    GL11.glEnable((int)3553);
                }
                this.func_148126_a(j1, p_148120_1_, k1, l1, tessellator, p_148120_3_, p_148120_4_);
            }
        }

        public void handleMouseInput() {
            if (this.func_148141_e(this.field_148162_h)) {
                if (Mouse.isButtonDown((int)0) && this.func_148125_i()) {
                    if (this.mInitialClickY == -1.0f) {
                        boolean flag = true;
                        if (this.field_148162_h >= this.field_148153_b && this.field_148162_h <= this.field_148154_c) {
                            int j;
                            int i;
                            if (this.isleft) {
                                i = this.field_148152_e + 6;
                                j = 6 + this.listWidth;
                            } else {
                                i = this.field_148152_e + (this.field_148155_a - this.listWidth - 6);
                                j = this.field_148152_e + this.field_148155_a - 6;
                            }
                            int k = this.field_148162_h - this.field_148153_b - this.field_148160_j + (int)this.mAmountScrolled - 4;
                            int l2 = k / this.field_148149_f;
                            if (this.field_148150_g >= i && this.field_148150_g <= j && l2 >= 0 && k >= 0 && l2 < this.func_148127_b()) {
                                boolean flag1 = l2 == this.mSelectedElement && Minecraft.func_71386_F() - this.mLastClicked < 250L;
                                this.func_148144_a(l2, flag1, this.field_148150_g, this.field_148162_h);
                                this.mSelectedElement = l2;
                                this.mLastClicked = Minecraft.func_71386_F();
                            } else if (this.field_148150_g >= i && this.field_148150_g <= j && k < 0) {
                                this.func_148132_a(this.field_148150_g - i, this.field_148162_h - this.field_148153_b + (int)this.mAmountScrolled - 4);
                                flag = false;
                            }
                            int i2 = this.func_148137_d();
                            int i1 = i2 + 6;
                            if (this.field_148150_g >= i2 && this.field_148150_g <= i1) {
                                this.mScrollMultiplier = -1.0f;
                                int j1 = this.func_148135_f();
                                if (j1 < 1) {
                                    j1 = 1;
                                }
                                int k1 = (int)((float)((this.field_148154_c - this.field_148153_b) * (this.field_148154_c - this.field_148153_b)) / (float)this.func_148138_e());
                                k1 = MathHelper.func_76125_a((int)k1, (int)32, (int)(this.field_148154_c - this.field_148153_b - 8));
                                this.mScrollMultiplier /= (float)(this.field_148154_c - this.field_148153_b - k1) / (float)j1;
                            } else {
                                this.mScrollMultiplier = 1.0f;
                            }
                            this.mInitialClickY = flag ? (float)this.field_148162_h : -2.0f;
                        } else {
                            this.mInitialClickY = -2.0f;
                        }
                    } else if (this.mInitialClickY >= 0.0f) {
                        this.mAmountScrolled -= ((float)this.field_148162_h - this.mInitialClickY) * this.mScrollMultiplier;
                        this.mInitialClickY = this.field_148162_h;
                    }
                } else {
                    this.mInitialClickY = -1.0f;
                }
                int l1 = Mouse.getEventDWheel();
                if (l1 != 0) {
                    if (l1 > 0) {
                        l1 = -1;
                    } else if (l1 < 0) {
                        l1 = 1;
                    }
                    this.mAmountScrolled += (float)(l1 * this.field_148149_f / 2);
                }
            }
        }

        public boolean func_148141_e(int p_148141_1_) {
            if (this.isleft) {
                return p_148141_1_ >= this.field_148153_b && p_148141_1_ <= this.field_148154_c && this.field_148150_g >= this.field_148152_e && this.field_148150_g <= this.field_148152_e + this.listWidth + 12;
            }
            return p_148141_1_ >= this.field_148153_b && p_148141_1_ <= this.field_148154_c && this.field_148150_g >= this.field_148152_e + this.field_148155_a - this.listWidth - 12 && this.field_148150_g <= this.field_148152_e + this.field_148155_a;
        }

        public void select(int index) {
            this.mSelectedElement = index;
        }

        public Waypoint getSelected() {
            if (this.data != null && this.data.size() > this.mSelectedElement && this.mSelectedElement > -1) {
                return this.data.get(this.mSelectedElement);
            }
            return null;
        }

        private void mBindAmountScrolled() {
            int i = this.func_148135_f();
            if (i < 0) {
                i /= 2;
            }
            if (!this.field_148163_i && i < 0) {
                i = 0;
            }
            if (this.mAmountScrolled < 0.0f) {
                this.mAmountScrolled = 0.0f;
            }
            if (this.mAmountScrolled > (float)i) {
                this.mAmountScrolled = i;
            }
        }

        public void func_148128_a(int p_148128_1_, int p_148128_2_, float p_148128_3_) {
            this.field_148150_g = p_148128_1_;
            this.field_148162_h = p_148128_2_;
            this.func_148123_a();
            int k = this.func_148127_b();
            int l2 = this.func_148137_d();
            int i1 = l2 + 6;
            this.handleMouseInput();
            this.mBindAmountScrolled();
            GL11.glDisable((int)2896);
            GL11.glDisable((int)2912);
            Tessellator tessellator = Tessellator.field_78398_a;
            this.drawContainerBackground(tessellator);
            int l1 = this.field_148152_e + this.field_148155_a / 2 - this.func_148139_c() / 2 + 2;
            int i2 = this.field_148153_b + 4 - (int)this.mAmountScrolled;
            if (this.mHasListHeader) {
                this.func_148129_a(l1, i2, tessellator);
            }
            this.func_148120_b(l1, i2, p_148128_1_, p_148128_2_);
            GL11.glDisable((int)2929);
            int b0 = 4;
            this.mOverlayBackground(0, this.field_148153_b, 255, 255);
            this.mOverlayBackground(this.field_148154_c, this.field_148158_l, 255, 255);
            GL11.glEnable((int)3042);
            OpenGlHelper.func_148821_a((int)770, (int)771, (int)0, (int)1);
            GL11.glDisable((int)3008);
            GL11.glShadeModel((int)7425);
            GL11.glDisable((int)3553);
            tessellator.func_78382_b();
            tessellator.func_78384_a(0, 0);
            tessellator.func_78374_a((double)this.field_148152_e, (double)(this.field_148153_b + b0), 0.0, 0.0, 1.0);
            tessellator.func_78374_a((double)this.field_148151_d, (double)(this.field_148153_b + b0), 0.0, 1.0, 1.0);
            tessellator.func_78384_a(0, 255);
            tessellator.func_78374_a((double)this.field_148151_d, (double)this.field_148153_b, 0.0, 1.0, 0.0);
            tessellator.func_78374_a((double)this.field_148152_e, (double)this.field_148153_b, 0.0, 0.0, 0.0);
            tessellator.func_78381_a();
            tessellator.func_78382_b();
            tessellator.func_78384_a(0, 255);
            tessellator.func_78374_a((double)this.field_148152_e, (double)this.field_148154_c, 0.0, 0.0, 1.0);
            tessellator.func_78374_a((double)this.field_148151_d, (double)this.field_148154_c, 0.0, 1.0, 1.0);
            tessellator.func_78384_a(0, 0);
            tessellator.func_78374_a((double)this.field_148151_d, (double)(this.field_148154_c - b0), 0.0, 1.0, 0.0);
            tessellator.func_78374_a((double)this.field_148152_e, (double)(this.field_148154_c - b0), 0.0, 0.0, 0.0);
            tessellator.func_78381_a();
            int i3 = this.func_148135_f();
            if (i3 > 0) {
                int l22;
                int k2 = (this.field_148154_c - this.field_148153_b) * (this.field_148154_c - this.field_148153_b) / this.func_148138_e();
                if (k2 < 32) {
                    k2 = 32;
                }
                if (k2 > this.field_148154_c - this.field_148153_b - 8) {
                    k2 = this.field_148154_c - this.field_148153_b - 8;
                }
                if ((l22 = (int)this.mAmountScrolled * (this.field_148154_c - this.field_148153_b - k2) / i3 + this.field_148153_b) < this.field_148153_b) {
                    l22 = this.field_148153_b;
                }
                tessellator.func_78382_b();
                tessellator.func_78384_a(0, 255);
                tessellator.func_78374_a((double)l2, (double)this.field_148154_c, 0.0, 0.0, 1.0);
                tessellator.func_78374_a((double)i1, (double)this.field_148154_c, 0.0, 1.0, 1.0);
                tessellator.func_78374_a((double)i1, (double)this.field_148153_b, 0.0, 1.0, 0.0);
                tessellator.func_78374_a((double)l2, (double)this.field_148153_b, 0.0, 0.0, 0.0);
                tessellator.func_78381_a();
                tessellator.func_78382_b();
                tessellator.func_78384_a(0x808080, 255);
                tessellator.func_78374_a((double)l2, (double)(l22 + k2), 0.0, 0.0, 1.0);
                tessellator.func_78374_a((double)i1, (double)(l22 + k2), 0.0, 1.0, 1.0);
                tessellator.func_78374_a((double)i1, (double)l22, 0.0, 1.0, 0.0);
                tessellator.func_78374_a((double)l2, (double)l22, 0.0, 0.0, 0.0);
                tessellator.func_78381_a();
                tessellator.func_78382_b();
                tessellator.func_78384_a(0xC0C0C0, 255);
                tessellator.func_78374_a((double)l2, (double)(l22 + k2 - 1), 0.0, 0.0, 1.0);
                tessellator.func_78374_a((double)(i1 - 1), (double)(l22 + k2 - 1), 0.0, 1.0, 1.0);
                tessellator.func_78374_a((double)(i1 - 1), (double)l22, 0.0, 1.0, 0.0);
                tessellator.func_78374_a((double)l2, (double)l22, 0.0, 0.0, 0.0);
                tessellator.func_78381_a();
            }
            this.func_148142_b(p_148128_1_, p_148128_2_);
            GL11.glEnable((int)3553);
            GL11.glShadeModel((int)7424);
            GL11.glEnable((int)3008);
            GL11.glDisable((int)3042);
        }

        private void mOverlayBackground(int p_148136_1_, int p_148136_2_, int p_148136_3_, int p_148136_4_) {
            Tessellator tessellator = Tessellator.field_78398_a;
            this.mc.func_110434_K().func_110577_a(Gui.field_110325_k);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            float f = 32.0f;
            tessellator.func_78382_b();
            tessellator.func_78384_a(0x404040, p_148136_4_);
            tessellator.func_78374_a((double)this.field_148152_e, (double)p_148136_2_, 0.0, 0.0, (double)((float)p_148136_2_ / f));
            tessellator.func_78374_a((double)(this.field_148152_e + this.field_148155_a), (double)p_148136_2_, 0.0, (double)((float)this.field_148155_a / f), (double)((float)p_148136_2_ / f));
            tessellator.func_78384_a(0x404040, p_148136_3_);
            tessellator.func_78374_a((double)(this.field_148152_e + this.field_148155_a), (double)p_148136_1_, 0.0, (double)((float)this.field_148155_a / f), (double)((float)p_148136_1_ / f));
            tessellator.func_78374_a((double)this.field_148152_e, (double)p_148136_1_, 0.0, 0.0, (double)((float)p_148136_1_ / f));
            tessellator.func_78381_a();
        }
    }
}

