/*
 * Decompiled with CFR 0.152.
 */
package james94jeans2.minimapsync.network.packet;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import james94jeans2.minimapsync.Minimapsync;
import james94jeans2.minimapsync.client.ClientWaypointManager;
import james94jeans2.minimapsync.client.MinimapKeyHandler;
import james94jeans2.minimapsync.network.packet.AbstractMinimapsyncPacket;
import james94jeans2.minimapsync.server.ServerWaypointManager;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;

public class MinimapsyncCheckPacket
extends AbstractMinimapsyncPacket {
    private char checkType;

    public MinimapsyncCheckPacket() {
    }

    public MinimapsyncCheckPacket(char pCheckType) {
        this.checkType = pCheckType;
    }

    @Override
    public void encodeInto(ChannelHandlerContext ctx, ByteBuf buffer) {
        buffer.writeChar((int)this.checkType);
    }

    @Override
    public void decodeInto(ChannelHandlerContext ctx, ByteBuf buffer) {
        this.checkType = buffer.readChar();
    }

    @Override
    public void handleClientSide(EntityPlayer player) {
        ClientWaypointManager manager = (ClientWaypointManager)ClientWaypointManager.getInstance();
        if (this.checkType == 'c') {
            manager.sendCheckPacket(player);
        } else {
            this.logger.info("Got checkpacket answer from server!");
            if (this.checkType == 'L') {
                manager.setLAN(true);
                this.logger.info("LAN-packet received!");
            }
            if (this.checkType == 'C') {
                manager.setMode(2);
                this.logger.info("CMD-packet received!");
            }
            if (this.checkType == 'R') {
                manager.setMode(3);
                this.logger.info("READ-packet received!");
            }
            if (this.checkType == 'S') {
                manager.setMode(1);
                this.logger.info("STANDARD-packet received!");
            }
            manager.setSyncOnServer(true);
            MinimapKeyHandler.getInstance().enable();
            if (!Minecraft.func_71410_x().func_71356_B() && !Minimapsync.instance.getEnabled()) {
                this.chat("[Minimapsync]However you can still use the warptowaypoint command to teleport to the servers public waypoints!");
            }
        }
    }

    @Override
    public void handleServerSide(EntityPlayer player) {
        if (this.checkType == 'c') {
            ServerWaypointManager.getInstance().sendCheckPacket(player);
            this.logger.info("Sending checkpacket answer to client!");
        } else {
            this.logger.warn((Object)Character.valueOf(this.checkType));
        }
    }
}

