/*
 * Decompiled with CFR 0.152.
 */
package james94jeans2.minimapsync.network.packet;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import james94jeans2.minimapsync.client.ClientWaypointManager;
import james94jeans2.minimapsync.network.packet.AbstractMinimapsyncPacket;
import james94jeans2.minimapsync.server.ServerWaypointManager;
import net.minecraft.entity.player.EntityPlayer;

public class MinimapsyncDonePacket
extends AbstractMinimapsyncPacket {
    private int key;
    private boolean priv;

    public MinimapsyncDonePacket(int key, boolean pPriv) {
        this.key = key;
        this.priv = pPriv;
    }

    public MinimapsyncDonePacket(int key) {
        this(key, false);
    }

    public MinimapsyncDonePacket(boolean pPriv) {
        this(0, pPriv);
    }

    public MinimapsyncDonePacket() {
        this(0);
    }

    @Override
    public void encodeInto(ChannelHandlerContext ctx, ByteBuf buffer) {
        buffer.writeInt(this.key);
        buffer.writeBoolean(this.priv);
    }

    @Override
    public void decodeInto(ChannelHandlerContext ctx, ByteBuf buffer) {
        this.key = buffer.readInt();
        this.priv = buffer.readBoolean();
    }

    @Override
    public void handleClientSide(EntityPlayer player) {
        ClientWaypointManager.getInstance().handleDonePacket(this, player);
    }

    @Override
    public void handleServerSide(EntityPlayer player) {
        ServerWaypointManager.getInstance().handleDonePacket(this, player);
    }

    public int getKey() {
        return this.key;
    }

    public boolean getPriv() {
        return this.priv;
    }
}

