/*
 * Decompiled with CFR 0.152.
 */
package james94jeans2.minimapsync.network.packet;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import james94jeans2.minimapsync.client.ClientWaypointManager;
import james94jeans2.minimapsync.network.packet.AbstractMinimapsyncPacket;
import net.minecraft.entity.player.EntityPlayer;

public class MinimapsyncSendPacket
extends AbstractMinimapsyncPacket {
    private String waypoint;
    private int dimension;
    private int key;

    public MinimapsyncSendPacket() {
    }

    public MinimapsyncSendPacket(String name, int dim, int key) {
        this.waypoint = name;
        this.dimension = dim;
        this.key = key;
    }

    @Override
    public void encodeInto(ChannelHandlerContext ctx, ByteBuf buffer) {
        buffer.writeInt(this.key);
        buffer.writeInt(this.dimension);
        for (char c : this.waypoint.toCharArray()) {
            buffer.writeChar((int)c);
        }
    }

    @Override
    public void decodeInto(ChannelHandlerContext ctx, ByteBuf buffer) {
        this.key = buffer.readInt();
        this.dimension = buffer.readInt();
        this.waypoint = "";
        while (buffer.isReadable()) {
            this.waypoint = this.waypoint + buffer.readChar();
        }
    }

    @Override
    public void handleClientSide(EntityPlayer player) {
        ((ClientWaypointManager)ClientWaypointManager.getInstance()).sendWaypointToServer(this);
    }

    @Override
    public void handleServerSide(EntityPlayer player) {
    }

    public int getDimension() {
        return this.dimension;
    }

    public String getWaypoint() {
        return this.waypoint;
    }

    public int getKey() {
        return this.key;
    }
}

