/*
 * Decompiled with CFR 0.152.
 */
package james94jeans2.minimapsync.network.packet;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import james94jeans2.minimapsync.network.packet.AbstractMinimapsyncPacket;
import james94jeans2.minimapsync.server.ServerWaypointManager;
import net.minecraft.entity.player.EntityPlayer;

public class MinimapsyncSendWaypointPacket
extends AbstractMinimapsyncPacket {
    private String waypoint;
    private int dimension;
    private int key;

    public MinimapsyncSendWaypointPacket() {
    }

    public MinimapsyncSendWaypointPacket(String waypointString, int dim, int key) {
        this.waypoint = waypointString;
        this.dimension = dim;
        this.key = key;
    }

    @Override
    public void encodeInto(ChannelHandlerContext ctx, ByteBuf buffer) {
        buffer.writeInt(this.key);
        buffer.writeInt(this.dimension);
        for (char c : this.waypoint.toCharArray()) {
            buffer.writeChar((int)c);
        }
    }

    @Override
    public void decodeInto(ChannelHandlerContext ctx, ByteBuf buffer) {
        this.key = buffer.readInt();
        this.dimension = buffer.readInt();
        this.waypoint = "";
        while (buffer.isReadable()) {
            this.waypoint = this.waypoint + buffer.readChar();
        }
        this.logger.info("dimension: " + this.dimension);
        this.logger.info("waypoint: " + this.waypoint);
    }

    @Override
    public void handleClientSide(EntityPlayer player) {
    }

    @Override
    public void handleServerSide(EntityPlayer player) {
        ((ServerWaypointManager)ServerWaypointManager.getInstance()).addAndCheckWaypoint(this);
    }

    public String getWaypoint() {
        return this.waypoint;
    }

    public int getDimension() {
        return this.dimension;
    }

    public int getKey() {
        return this.key;
    }
}

