/*
 * Decompiled with CFR 0.152.
 */
package james94jeans2.minimapsync.network.packet;

import cpw.mods.fml.common.FMLCommonHandler;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import james94jeans2.minimapsync.client.ClientWaypointManager;
import james94jeans2.minimapsync.network.packet.AbstractMinimapsyncPacket;
import james94jeans2.minimapsync.server.ServerWaypointManager;
import net.minecraft.entity.player.EntityPlayer;

public class MinimapsyncWaypointPacket
extends AbstractMinimapsyncPacket {
    private String waypoint;
    private int dimension;
    private int key;

    public MinimapsyncWaypointPacket() {
    }

    public MinimapsyncWaypointPacket(String waypointString, int dim) {
        this(waypointString, dim, 0);
    }

    public MinimapsyncWaypointPacket(String waypointString, int dim, int syncKey) {
        this.waypoint = waypointString;
        this.dimension = dim;
        this.key = syncKey;
    }

    @Override
    public void encodeInto(ChannelHandlerContext ctx, ByteBuf buffer) {
        buffer.writeInt(this.key);
        buffer.writeInt(this.dimension);
        for (char c : this.waypoint.toCharArray()) {
            buffer.writeChar((int)c);
        }
    }

    @Override
    public void decodeInto(ChannelHandlerContext ctx, ByteBuf buffer) {
        this.key = buffer.readInt();
        this.dimension = buffer.readInt();
        this.waypoint = "";
        while (buffer.isReadable()) {
            this.waypoint = this.waypoint + buffer.readChar();
        }
    }

    @Override
    public void handleClientSide(EntityPlayer player) {
        if (!FMLCommonHandler.instance().getEffectiveSide().isServer()) {
            ClientWaypointManager.getInstance().handleWaypointPacket(this, player);
        }
    }

    @Override
    public void handleServerSide(EntityPlayer player) {
        ServerWaypointManager.getInstance().handleWaypointPacket(this, player);
    }

    public String getWaypointString() {
        return this.waypoint;
    }

    public int getDimension() {
        return this.dimension;
    }

    public int getKey() {
        return this.key;
    }
}

