/*
 * Decompiled with CFR 0.152.
 */
package james94jeans2.minimapsync.server;

import james94jeans2.minimapsync.util.MinimapsyncConfiguration;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;

public class MinimapsyncServerConfiguration
extends MinimapsyncConfiguration {
    private Configuration config;
    private int mode;
    private boolean autosync;
    private boolean dynmap;

    public MinimapsyncServerConfiguration(Configuration config) {
        this.config = config;
        config.load();
        Property syncMode = config.get("general", "mode", 1);
        syncMode.comment = "Set this to 1 for normal synchronization,\n2 for command-synchronization (ops only)";
        this.mode = syncMode.getInt(1);
        if (this.mode <= 0 || this.mode > 2) {
            syncMode.set(1);
            this.mode = 1;
        }
        Property autoSync = config.get("general", "syncOnJoin", false);
        autoSync.comment = "Set this to true to send all server waypoints to joining clients";
        this.autosync = autoSync.getBoolean(false);
        Property dynmapEnabled = config.get("general", "enableDynmapIntegration", true);
        dynmapEnabled.comment = "Set this to false to disable showing server waypoints in dynmap (if installed)";
        this.dynmap = dynmapEnabled.getBoolean(true);
        config.save();
    }

    public int getMode() {
        return this.mode;
    }

    public boolean getAutosync() {
        return this.autosync;
    }

    public boolean getDynmap() {
        return this.dynmap;
    }

    public void setDynmap(boolean aim) {
        this.dynmap = aim;
        this.writeSettings();
    }

    private void writeSettings() {
        this.config.load();
        Property syncMode = this.config.get("general", "mode", 1);
        syncMode.comment = "Set this to 1 for normal synchronization,\n2 for command-synchronization (ops only)";
        syncMode.set(this.mode);
        Property autoSync = this.config.get("general", "syncOnJoin", false);
        autoSync.comment = "Set this to true to send all server waypoints to joining clients";
        autoSync.set(this.autosync);
        Property dynmapEnabled = this.config.get("general", "enableDynmapIntegration", true);
        dynmapEnabled.comment = "Set this to false to disable showing server waypoints in dynmap (if installed)";
        dynmapEnabled.set(this.dynmap);
        this.config.save();
    }

    public void setAutosync(boolean aim) {
        this.autosync = aim;
        this.writeSettings();
    }
}

