/*
 * Decompiled with CFR 0.152.
 */
package james94jeans2.minimapsync.server;

import cpw.mods.fml.common.FMLCommonHandler;
import james94jeans2.minimapsync.network.packet.MinimapsyncCheckPacket;
import james94jeans2.minimapsync.network.packet.MinimapsyncDonePacket;
import james94jeans2.minimapsync.network.packet.MinimapsyncKeyPacket;
import james94jeans2.minimapsync.network.packet.MinimapsyncSendWaypointPacket;
import james94jeans2.minimapsync.network.packet.MinimapsyncWaypointPacket;
import james94jeans2.minimapsync.server.command.CommandSendWaypoint;
import james94jeans2.minimapsync.server.command.CommandSync;
import james94jeans2.minimapsync.util.AbstractWaypointManager;
import james94jeans2.minimapsync.util.Waypoint;
import james94jeans2.minimapsync.util.WaypointList;
import james94jeans2.minimapsync.util.loader.DynmapLoader;
import james94jeans2.minimapsync.util.loader.IWaypointLoader;
import james94jeans2.minimapsync.util.loader.PlayerLoader;
import james94jeans2.minimapsync.util.loader.ServerBlacklistLoader;
import james94jeans2.minimapsync.util.loader.ServerWaypointLoader;
import java.util.LinkedList;
import java.util.Random;
import net.minecraft.command.CommandHandler;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import org.apache.commons.lang3.tuple.Pair;

public class ServerWaypointManager
extends AbstractWaypointManager {
    private LinkedList<WaypointList> blacklists;
    private LinkedList<Integer> keys;
    private LinkedList<EntityPlayer> syncPlayers;
    protected LinkedList<Pair<EntityPlayer, WaypointList>> tabCompletions;
    private boolean noBlacklist = true;
    private boolean dynmapEnabled;
    private boolean autoSync;
    private CommandSync command;
    private CommandSendWaypoint send;
    private IWaypointLoader blacklistLoader;
    private IWaypointLoader dynmapLoader;
    private IWaypointLoader playerLoader;

    @Override
    public void setMode(int pMode) {
        super.setMode(pMode);
        CommandHandler ch = (CommandHandler)FMLCommonHandler.instance().getMinecraftServerInstance().func_71187_D();
        if (this.send == null) {
            this.send = new CommandSendWaypoint();
            ch.func_71560_a((ICommand)this.send);
        }
        if (this.mode == 2) {
            this.command = new CommandSync();
            ch.func_71560_a((ICommand)this.command);
            this.send.setPermissionLevel(2);
        } else if (this.command != null) {
            ch.func_71555_a().remove((Object)this.command);
            this.command = null;
            this.send.setPermissionLevel(0);
        }
    }

    @Override
    protected void loadWaypoints() {
        int counter;
        this.dimensions = this.loader.loadAllWaypoints();
        this.noWaypoints = false;
        if (this.dimensions == null) {
            this.logger.info("No waypoints saved up to now!");
            this.noWaypoints = true;
        } else {
            counter = 0;
            for (WaypointList list : this.dimensions) {
                counter += list.size();
            }
            this.logger.info("Successfully loaded " + counter + " waypoints!");
        }
        this.blacklists = this.blacklistLoader.loadAllWaypoints();
        this.noBlacklist = false;
        if (this.blacklists == null) {
            this.logger.info("No blacklist saved up to now!");
            this.noBlacklist = true;
        } else {
            counter = 0;
            for (WaypointList list : this.blacklists) {
                counter += list.size();
            }
            this.logger.info("Successfully loaded " + counter + " waypoints from blacklist!");
        }
        this.saveWaypoints();
    }

    @Override
    protected void saveWaypoints() {
        this.loader.saveAllWaypoints(this.dimensions);
        this.blacklistLoader.saveAllWaypoints(this.blacklists);
        if (this.dynmapEnabled) {
            this.dynmapLoader.saveAllWaypoints(this.dimensions);
        }
    }

    public int generateKey() {
        int key = new Random().nextInt();
        while (key == 0) {
            key = new Random().nextInt();
        }
        this.keys.add(key);
        return key;
    }

    public ServerWaypointManager() {
        this.mode = 1;
        this.keys = new LinkedList();
        this.syncPlayers = new LinkedList();
        this.tabCompletions = new LinkedList();
        this.dynmapEnabled = false;
    }

    public WaypointList getTabCompletionsFor(EntityPlayer player) {
        return null;
    }

    public WaypointList getWaypointForNameFromBlacklist(String name) {
        return this.getWaypointForName(this.blacklists, name);
    }

    public boolean delWaypoint(int pDim, Waypoint pPoint) {
        WaypointList tempList = null;
        for (WaypointList list : this.dimensions) {
            if (list.getDim() != pDim) continue;
            tempList = list;
            break;
        }
        if (tempList != null && tempList.remove(pPoint)) {
            tempList = null;
            if (!this.noBlacklist) {
                for (WaypointList list : this.blacklists) {
                    if (list.getDim() != pDim) continue;
                    tempList = list;
                    break;
                }
            }
            if (tempList != null) {
                tempList.add(pPoint);
            } else {
                tempList = new WaypointList(pDim, true);
                tempList.add(pPoint);
                if (this.noBlacklist) {
                    this.blacklists = new LinkedList();
                }
                this.blacklists.add(tempList);
            }
            this.updateStates();
            return true;
        }
        return false;
    }

    private void updateStates() {
        this.saveWaypoints();
        this.noWaypoints = this.dimensions == null || this.dimensions.isEmpty();
        this.noBlacklist = this.blacklists == null || this.blacklists.isEmpty();
    }

    public boolean recWaypoint(int pDim, Waypoint pPoint) {
        WaypointList tempList = null;
        for (WaypointList list : this.blacklists) {
            if (list.getDim() != pDim) continue;
            tempList = list;
            break;
        }
        if (tempList != null && tempList.remove(pPoint)) {
            tempList = null;
            if (!this.noWaypoints) {
                for (WaypointList list : this.dimensions) {
                    if (list.getDim() != pDim) continue;
                    tempList = list;
                    break;
                }
            }
            if (tempList != null) {
                tempList.add(pPoint);
            } else {
                tempList = new WaypointList(pDim, true);
                tempList.add(pPoint);
                this.dimensions.add(tempList);
            }
            this.updateStates();
            return true;
        }
        return false;
    }

    @Override
    public WaypointList getWaypoints() {
        if (!this.noWaypoints) {
            WaypointList returnList = new WaypointList(0, true);
            for (WaypointList list : this.dimensions) {
                returnList.addAll(list);
            }
            return returnList;
        }
        return null;
    }

    public WaypointList getBlacklistedWaypoints() {
        if (!this.noBlacklist) {
            WaypointList returnList = new WaypointList(0, true);
            for (Object e : this.blacklists) {
                WaypointList tempList = (WaypointList)e;
                returnList.addAll(tempList);
            }
            return returnList;
        }
        return null;
    }

    @Override
    public WaypointList getWaypointsForDimension(int pDim) {
        if (!this.noWaypoints) {
            for (WaypointList tempList : this.dimensions) {
                if (tempList.getDim() != pDim) continue;
                return tempList;
            }
        }
        return null;
    }

    @Override
    public void sendCheckPacket(EntityPlayer pPlayer) {
        MinimapsyncCheckPacket pkt = null;
        switch (this.mode) {
            case 1: {
                pkt = new MinimapsyncCheckPacket('S');
                break;
            }
            case 2: {
                pkt = new MinimapsyncCheckPacket('C');
                break;
            }
        }
        this.pipeline.sendTo(pkt, (EntityPlayerMP)pPlayer);
        if (this.autoSync) {
            this.sendAllWaypointsToClient(pPlayer);
        }
    }

    public void sendKeyPacket(EntityPlayerMP pPlayer) {
        this.syncPlayers.add((EntityPlayer)pPlayer);
        MinimapsyncKeyPacket pkt = new MinimapsyncKeyPacket(this.generateKey());
        this.pipeline.sendTo(pkt, pPlayer);
    }

    @Override
    public boolean noWaypoints() {
        return this.noWaypoints;
    }

    public boolean noBlacklists() {
        return this.noBlacklist;
    }

    public void addAndCheckWaypoint(MinimapsyncSendWaypointPacket packet) {
        Waypoint waypoint = new Waypoint(packet.getWaypoint(), packet.getDimension(), true);
        WaypointList points = null;
        if (!this.noWaypoints) {
            for (WaypointList list : this.dimensions) {
                if (list.getDim() != packet.getDimension()) continue;
                points = list;
                break;
            }
        }
        if (!this.noBlacklist) {
            for (WaypointList list : this.blacklists) {
                if (list.getDim() != packet.getDimension()) continue;
                WaypointList tempList = list.getWaypointsForName(waypoint.getName());
                if (tempList == null || tempList.isEmpty()) break;
                for (Waypoint waypoint2 : tempList) {
                    if (!waypoint2.getCompareStr().equalsIgnoreCase(waypoint.getCompareStr())) continue;
                    return;
                }
            }
        }
        if (points == null) {
            points = new WaypointList(packet.getDimension(), true);
            points.add(waypoint);
            if (this.dimensions != null) {
                this.dimensions.add(points);
            } else {
                this.dimensions = new LinkedList();
                this.dimensions.add(points);
            }
        } else {
            WaypointList tempList = points.getWaypointsForName(waypoint.getName());
            if (tempList != null && !tempList.isEmpty()) {
                for (Waypoint waypoint2 : tempList) {
                    if (!waypoint2.getCompareStr().equalsIgnoreCase(waypoint.getCompareStr())) continue;
                    return;
                }
            }
            points.add(waypoint);
        }
        this.updateStates();
    }

    @Override
    public void afterStartup() {
        this.loader = new ServerWaypointLoader();
        this.playerLoader = new PlayerLoader();
        this.blacklistLoader = new ServerBlacklistLoader();
        if (this.dynmapEnabled) {
            this.dynmapLoader = new DynmapLoader();
        }
        this.loadWaypoints();
    }

    @Override
    protected void handleRemoteOut() {
    }

    @Override
    protected void checkMissingLocalWaypoints(EntityPlayer player) {
        for (Pair pair : this.remoteIn) {
            if (pair.getKey() != player) continue;
            this.checkMissingLocalWaypoints((WaypointList)pair.getValue());
            if (((WaypointList)pair.getValue()).isPrivate()) {
                this.updatePrivateWaypoints(player, (WaypointList)pair.getValue());
            }
            this.remoteIn.remove(pair);
            return;
        }
    }

    private void updatePrivateWaypoints(EntityPlayer player, WaypointList remoteIn) {
        IWaypointLoader pLoader = ((PlayerLoader)this.playerLoader).createLoader(player);
        LinkedList<WaypointList> privLists = pLoader.loadAllWaypoints();
        boolean added = false;
        if (privLists != null) {
            for (WaypointList list : privLists) {
                if (list.getDim() != remoteIn.getDim()) continue;
                privLists.remove(list);
                privLists.add(remoteIn.getPrivate().clone());
                added = true;
                break;
            }
        } else {
            privLists = new LinkedList();
        }
        if (!added) {
            WaypointList newList = new WaypointList(remoteIn.getDim(), false);
            newList.addAll(remoteIn.getPrivate());
            if (!newList.isEmpty()) {
                privLists.add(newList);
            }
        }
        pLoader.saveAllWaypoints(privLists);
    }

    @Override
    protected void checkMissingLocalWaypoints(WaypointList remoteIn) {
        this.logger.info("checking Local Points");
        WaypointList compareList = null;
        if (!this.noWaypoints) {
            for (WaypointList tempList : this.dimensions) {
                if (remoteIn.getDim() != tempList.getDim()) continue;
                compareList = tempList;
                break;
            }
        }
        if (!this.noBlacklist) {
            for (WaypointList list : this.blacklists) {
                if (list.getDim() != remoteIn.getDim()) continue;
                remoteIn = list.getMissingPoints(remoteIn);
                break;
            }
        }
        if (compareList != null) {
            compareList.addAll(compareList.getMissingPoints(remoteIn.getPublic()));
        } else {
            WaypointList newList = new WaypointList(remoteIn.getDim(), true);
            newList.addAll(remoteIn.getPublic());
            if (!newList.isEmpty()) {
                if (this.noWaypoints) {
                    this.dimensions = new LinkedList();
                    this.noWaypoints = false;
                }
                this.dimensions.add(newList);
            }
        }
        this.saveWaypoints();
    }

    @Override
    public void handleDonePacket(MinimapsyncDonePacket packet, EntityPlayer player) {
        this.logger.info("received " + (packet.getPriv() ? "private" : "public") + " done packet from client");
        if (this.mode == 1) {
            boolean loaded = false;
            for (Pair pair : this.remoteIn) {
                if (!((EntityPlayer)pair.getKey()).equals((Object)player)) continue;
                ((WaypointList)pair.getValue()).setPrivate(packet.getPriv());
                loaded = true;
                break;
            }
            if (loaded) {
                this.checkMissingLocalWaypoints(player);
            } else if (packet.getPriv()) {
                this.updatePrivateWaypoints(player, new WaypointList(player.field_71093_bK, player.func_70005_c_()));
            } else {
                this.logger.fatal("Player: " + player.func_70005_c_());
                this.logger.fatal("sent donePacket but no waypoints!");
            }
        } else if (this.keys.contains(packet.getKey())) {
            this.keys.remove((Object)packet.getKey());
            this.checkMissingLocalWaypoints(player);
            this.syncPlayers.remove(player);
        } else if (packet.getKey() == -1) {
            Pair pair = null;
            for (Pair p : this.remoteIn) {
                if (!((EntityPlayer)p.getKey()).equals((Object)player)) continue;
                pair = p;
                break;
            }
            if (pair != null) {
                this.updatePrivateWaypoints(player, (WaypointList)pair.getValue());
                this.remoteIn.remove(pair);
            } else {
                this.updatePrivateWaypoints(player, new WaypointList(player.field_71093_bK, player.func_70005_c_()));
            }
        } else {
            for (Pair pair : this.remoteIn) {
                if (!((EntityPlayer)pair.getKey()).equals((Object)player)) continue;
                this.remoteIn.remove(pair);
                return;
            }
        }
    }

    @Override
    public void handleWaypointPacket(MinimapsyncWaypointPacket packet, EntityPlayer player) {
        if (this.mode == 1 || packet.getKey() == -1) {
            super.handleWaypointPacket(packet, player);
        } else {
            WaypointList temp;
            boolean loaded = false;
            Pair match = null;
            for (Pair pair : this.remoteIn) {
                if (!((EntityPlayer)pair.getKey()).equals((Object)player)) continue;
                loaded = true;
                match = pair;
                break;
            }
            if (loaded) {
                if (this.keys.contains(packet.getKey())) {
                    temp = (WaypointList)match.getValue();
                    temp.add(new Waypoint(packet.getWaypointString(), packet.getDimension()));
                    this.remoteIn.add(Pair.of((Object)player, (Object)temp));
                    this.remoteIn.remove(match);
                }
            } else if (this.keys.contains(packet.getKey())) {
                temp = new WaypointList(packet.getDimension(), false);
                temp.add(new Waypoint(packet.getWaypointString(), packet.getDimension()));
                this.remoteIn.add(Pair.of((Object)player, (Object)temp));
                this.syncPlayers.add(player);
            }
        }
    }

    public WaypointList checkWaypointList(String waypointName) {
        if (this.noWaypoints) {
            return null;
        }
        WaypointList wp = new WaypointList(0, false);
        for (WaypointList list : this.dimensions) {
            wp.addAll(list);
        }
        return wp.getWaypointsForName(waypointName);
    }

    public WaypointList checkWaypointBlacklist(String waypointName) {
        if (this.noBlacklist) {
            return null;
        }
        WaypointList wp = new WaypointList(0, false);
        for (WaypointList list : this.blacklists) {
            wp.addAll(list);
        }
        return wp.getWaypointsForName(waypointName);
    }

    public void updateDynmap() {
        this.dynmapLoader.saveAllWaypoints(this.dimensions);
    }

    public void setDynmapEnabled(boolean enabled) {
        this.dynmapEnabled = enabled;
        if (!enabled && this.dynmapLoader != null) {
            ((DynmapLoader)this.dynmapLoader).destroy();
            this.dynmapLoader = null;
        } else if (this.loader != null) {
            this.dynmapLoader = new DynmapLoader();
            this.saveWaypoints();
        }
    }

    public boolean getDynmapEnabled() {
        return this.dynmapEnabled;
    }

    public void setAutoSync(boolean enabled) {
        this.autoSync = enabled;
    }

    public boolean getAutoSyncEnabled() {
        return this.autoSync;
    }

    public void sendAllPrivateWaypointsForDimensionToClient(int dimension, EntityPlayer player) {
        IWaypointLoader tempLoader = ((PlayerLoader)this.playerLoader).createLoader(player);
        WaypointList playersPoints = tempLoader.loadWaypointsForDimension(dimension);
        WaypointList publicPoints = null;
        if (this.anyWaypointsInDimension(dimension)) {
            for (WaypointList list : this.dimensions) {
                if (list.getDim() != dimension) continue;
                publicPoints = list;
                break;
            }
            WaypointList missing = null;
            if (playersPoints != null) {
                missing = playersPoints.getMissingPoints(publicPoints);
                playersPoints.addAll(missing);
            } else {
                playersPoints = new WaypointList(dimension, false);
                playersPoints.addAll(publicPoints);
            }
        } else if (playersPoints == null) {
            playersPoints = new WaypointList(dimension, false);
        }
        this.sendWaypointListToClient(playersPoints, player);
    }

    @Override
    public void sendAllWaypointsToClient(EntityPlayer player) {
        IWaypointLoader pLoader = ((PlayerLoader)this.playerLoader).createLoader(player);
        LinkedList<WaypointList> privLists = pLoader.loadAllWaypoints();
        if (!this.noWaypoints) {
            block0: for (WaypointList tempList : this.dimensions) {
                if (privLists != null) {
                    for (WaypointList privList : privLists) {
                        if (privList.getDim() != tempList.getDim()) continue;
                        tempList.addAll(privList);
                        this.sendReadOnlyWaypointListToClient(tempList, player);
                        continue block0;
                    }
                    continue;
                }
                this.sendReadOnlyWaypointListToClient(tempList, player);
            }
        }
    }

    public void sendKeyPacketCheck(EntityPlayer player) {
        if (this.command.func_71519_b((ICommandSender)player)) {
            this.sendKeyPacket((EntityPlayerMP)player);
        } else {
            this.pipeline.sendTo(new MinimapsyncKeyPacket(0), (EntityPlayerMP)player);
        }
    }
}

