/*
 * Decompiled with CFR 0.152.
 */
package james94jeans2.minimapsync.server.command;

import cpw.mods.fml.common.FMLCommonHandler;
import james94jeans2.minimapsync.server.ServerWaypointManager;
import james94jeans2.minimapsync.util.Waypoint;
import james94jeans2.minimapsync.util.WaypointList;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.command.CommandBase;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.PlayerNotFoundException;
import net.minecraft.command.WrongUsageException;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;

public class CommandWaypointManager
extends CommandBase {
    private StringBuilder waypointBuilder;
    private String waypointName;
    private static String player;
    private static WaypointList waypoints;

    static String getUser() {
        return player;
    }

    static WaypointList getWaypointList() {
        return waypoints;
    }

    static void resetWaypoints() {
        waypoints = null;
    }

    public List func_71516_a(ICommandSender sender, String[] args) {
        if (FMLCommonHandler.instance().getSide().isServer()) {
            if (args.length == 1) {
                return CommandWaypointManager.func_71530_a((String[])args, (String[])new String[]{"dp", "rp", "delpoint", "recpoint"});
            }
            String[] args2 = new String[args.length - 1];
            for (int i = 1; i < args.length; ++i) {
                args2[i - 1] = args[i];
            }
            if (args[0].equals("delpoint") || args[0].equals("dp")) {
                return this.deltab(sender, args2);
            }
            if (args[0].equals("recpoint") || args[0].equals("rp")) {
                return this.rectab(sender, args2);
            }
        }
        return new ArrayList();
    }

    private List deltab(ICommandSender sender, String[] args) {
        if (!ServerWaypointManager.getInstance().noWaypoints()) {
            WaypointList tempList = ServerWaypointManager.getInstance().getWaypoints();
            String[] names = new String[tempList.size()];
            for (Waypoint tempPoint : tempList) {
                names[tempList.indexOf((Waypoint)tempPoint)] = tempPoint.getName();
            }
            return this.getTabCompletions(args, names);
        }
        return new ArrayList();
    }

    private List getTabCompletions(String[] args, String[] waypoints) {
        String[] argu = new String[1];
        StringBuilder builder = new StringBuilder();
        for (String string : args) {
            if (string.isEmpty()) continue;
            builder.append(string + "_");
        }
        if (!args[args.length - 1].isEmpty() && builder.length() > 0 && builder.charAt(builder.length() - 1) == '_') {
            builder.deleteCharAt(builder.length() - 1);
        }
        argu[0] = builder.toString();
        int length = 0;
        for (String string : args) {
            if (string.isEmpty()) continue;
            ++length;
        }
        for (int i = 0; i < waypoints.length; ++i) {
            waypoints[i] = waypoints[i].replace(' ', '_');
        }
        waypoints = ((ArrayList)CommandWaypointManager.func_71530_a((String[])argu, (String[])waypoints)).toArray(new String[0]);
        ArrayList<String> returnList = new ArrayList<String>();
        if (waypoints.length > 1) {
            for (String string : waypoints) {
                String[] split = string.split("_");
                if (split.length <= length) continue;
                if (args[args.length - 1].isEmpty()) {
                    returnList.add(split[length]);
                    continue;
                }
                if (length <= 0) continue;
                returnList.add(split[length - 1]);
            }
        } else if (waypoints.length > 0) {
            String[] split = waypoints[waypoints.length - 1].split("_");
            StringBuilder name = new StringBuilder();
            for (int i = args[args.length - 1].isEmpty() ? length : length - 1; i < split.length; ++i) {
                name.append(split[i] + " ");
            }
            returnList.add(name.toString());
        }
        return returnList;
    }

    private List rectab(ICommandSender sender, String[] args) {
        if (!((ServerWaypointManager)ServerWaypointManager.getInstance()).noBlacklists()) {
            WaypointList tempList = ((ServerWaypointManager)ServerWaypointManager.getInstance()).getBlacklistedWaypoints();
            String[] names = new String[tempList.size()];
            for (Waypoint tempPoint : tempList) {
                names[tempList.indexOf((Waypoint)tempPoint)] = tempPoint.getName();
            }
            return this.getTabCompletions(args, names);
        }
        return new ArrayList();
    }

    public List func_71514_a() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("wpm");
        return list;
    }

    public String func_71517_b() {
        return "waypointmanager";
    }

    public String func_71518_a(ICommandSender sender) {
        return "/waypointmanager or /wpm <command> <name of waypoint>\npossible commands:\n - delpoint or dp\n - recpoint or rp";
    }

    public int func_82362_a() {
        return 2;
    }

    public void func_71515_b(ICommandSender sender, String[] args) throws WrongUsageException, PlayerNotFoundException {
        if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            CommandWaypointManager.func_71521_c((ICommandSender)sender).func_145747_a((IChatComponent)new ChatComponentText("This command is only available in SMP!"));
        } else {
            if (args.length == 0) {
                throw new WrongUsageException(this.func_71518_a(sender), new Object[0]);
            }
            if (args.length == 1) {
                if (args[0].equals("delpoint") || args[0].equals("dp")) {
                    CommandWaypointManager.func_71521_c((ICommandSender)sender).func_145747_a((IChatComponent)new ChatComponentText("Insufficient arguments: /wpm dp <name of waypoint>"));
                    return;
                }
                if (args[0].equals("recpoint") || args[0].equals("rp")) {
                    CommandWaypointManager.func_71521_c((ICommandSender)sender).func_145747_a((IChatComponent)new ChatComponentText("Insufficient arguments: /wpm rp <name of waypoint>"));
                    return;
                }
            } else {
                String[] args2 = new String[args.length - 1];
                for (int i = 1; i < args.length; ++i) {
                    args2[i - 1] = args[i];
                }
                if (args[0].equals("delpoint") || args[0].equals("dp")) {
                    this.delpoint(sender, args2);
                    return;
                }
                if (args[0].equals("recpoint") || args[0].equals("rp")) {
                    this.recpoint(sender, args2);
                    return;
                }
            }
        }
    }

    private void delpoint(ICommandSender sender, String[] args) throws PlayerNotFoundException {
        this.waypointBuilder = new StringBuilder();
        this.waypointBuilder.append(args[0]);
        if (args.length > 1) {
            for (int i = 1; i < args.length; ++i) {
                this.waypointBuilder.append(" ");
                this.waypointBuilder.append(args[i]);
            }
        }
        this.waypointName = this.waypointBuilder.toString();
        waypoints = ((ServerWaypointManager)ServerWaypointManager.getInstance()).checkWaypointList(this.waypointName);
        if (waypoints != null) {
            if (waypoints.size() == 1) {
                if (((ServerWaypointManager)ServerWaypointManager.getInstance()).delWaypoint(waypoints.get(0).getDim(), waypoints.get(0))) {
                    CommandWaypointManager.func_71521_c((ICommandSender)sender).func_145747_a((IChatComponent)new ChatComponentText("[Minimapsync]Deleted the waypoint \"" + waypoints.get(0).getName() + "\" from the server's list!"));
                    waypoints = null;
                } else {
                    CommandWaypointManager.func_71521_c((ICommandSender)sender).func_145747_a((IChatComponent)new ChatComponentText("[Minimapsync]Could not delete the waypoint \"" + waypoints.get(0).getName() + "\" from the server's list!"));
                }
            } else if (waypoints.size() == 0) {
                CommandWaypointManager.func_71521_c((ICommandSender)sender).func_145747_a((IChatComponent)new ChatComponentText("[Minimapsync]The waypoint \"" + this.waypointName + "\" could not be found on this server!"));
            } else {
                player = CommandWaypointManager.func_71521_c((ICommandSender)sender).func_70005_c_();
                CommandWaypointManager.func_71521_c((ICommandSender)sender).func_145747_a((IChatComponent)new ChatComponentText("[Minimapsync]There are " + waypoints.size() + " waypoints matching the name: \"" + this.waypointName + "\" on this server!"));
                CommandWaypointManager.func_71521_c((ICommandSender)sender).func_145747_a((IChatComponent)new ChatComponentText("There are the following waypoints:"));
                for (Waypoint tempPoint : waypoints) {
                    CommandWaypointManager.func_71521_c((ICommandSender)sender).func_145747_a((IChatComponent)new ChatComponentText(tempPoint.getName() + "  [ " + tempPoint.getXCord() + " | " + tempPoint.getYCord() + " | " + tempPoint.getZCord() + " ] [dim:" + tempPoint.getDim() + "]   [" + waypoints.indexOf(tempPoint) + "]"));
                }
                CommandWaypointManager.func_71521_c((ICommandSender)sender).func_145747_a((IChatComponent)new ChatComponentText("Type /wpmx dp followed by the number of the waypoint you want to delete!"));
                CommandWaypointManager.func_71521_c((ICommandSender)sender).func_145747_a((IChatComponent)new ChatComponentText("The number can be found at the end of each waypoint line \"[number]\""));
            }
        } else {
            CommandWaypointManager.func_71521_c((ICommandSender)sender).func_145747_a((IChatComponent)new ChatComponentText("[Minimapsync]The waypoint \"" + this.waypointName + "\" could not be found on this server!"));
        }
    }

    private void recpoint(ICommandSender sender, String[] args) throws PlayerNotFoundException {
        this.waypointBuilder = new StringBuilder();
        this.waypointBuilder.append(args[0]);
        if (args.length > 1) {
            for (int i = 1; i < args.length; ++i) {
                this.waypointBuilder.append(" ");
                this.waypointBuilder.append(args[i]);
            }
        }
        this.waypointName = this.waypointBuilder.toString();
        waypoints = ((ServerWaypointManager)ServerWaypointManager.getInstance()).checkWaypointBlacklist(this.waypointName);
        if (waypoints != null) {
            if (waypoints.size() == 1) {
                if (((ServerWaypointManager)ServerWaypointManager.getInstance()).recWaypoint(waypoints.get(0).getDim(), waypoints.get(0))) {
                    CommandWaypointManager.func_71521_c((ICommandSender)sender).func_145747_a((IChatComponent)new ChatComponentText("[Minimapsync]Recovered the waypoint \"" + waypoints.get(0).getName() + "\" to the server's list!"));
                    waypoints = null;
                } else {
                    CommandWaypointManager.func_71521_c((ICommandSender)sender).func_145747_a((IChatComponent)new ChatComponentText("[Minimapsync]Could not recover the waypoint \"" + waypoints.get(0).getName() + "\" to the server's list!"));
                }
            } else if (waypoints.size() == 0) {
                CommandWaypointManager.func_71521_c((ICommandSender)sender).func_145747_a((IChatComponent)new ChatComponentText("[Minimapsync]The waypoint \"" + this.waypointName + "\" could not be found on this server!"));
            } else {
                player = CommandWaypointManager.func_71521_c((ICommandSender)sender).func_70005_c_();
                CommandWaypointManager.func_71521_c((ICommandSender)sender).func_145747_a((IChatComponent)new ChatComponentText("[Minimapsync]There are " + waypoints.size() + " waypoints matching the name: \"" + this.waypointName + "\" on this server's blacklist!"));
                CommandWaypointManager.func_71521_c((ICommandSender)sender).func_145747_a((IChatComponent)new ChatComponentText("There are the following waypoints:"));
                for (Waypoint tempPoint : waypoints) {
                    CommandWaypointManager.func_71521_c((ICommandSender)sender).func_145747_a((IChatComponent)new ChatComponentText(tempPoint.getName() + "  [ " + tempPoint.getXCord() + " | " + tempPoint.getYCord() + " | " + tempPoint.getZCord() + " ] [dim:" + tempPoint.getDim() + "]   [" + waypoints.indexOf(tempPoint) + "]"));
                }
                CommandWaypointManager.func_71521_c((ICommandSender)sender).func_145747_a((IChatComponent)new ChatComponentText("Type /wpmx rp followed by the number of the waypoint you want to delete!"));
                CommandWaypointManager.func_71521_c((ICommandSender)sender).func_145747_a((IChatComponent)new ChatComponentText("The number can be found at the end of each waypoint line \"[number]\""));
            }
        } else {
            CommandWaypointManager.func_71521_c((ICommandSender)sender).func_145747_a((IChatComponent)new ChatComponentText("[Minimapsync]The waypoint \"" + this.waypointName + "\" could not be found on this server!"));
        }
    }
}

