/*
 * Decompiled with CFR 0.152.
 */
package james94jeans2.minimapsync.util;

import james94jeans2.minimapsync.Minimapsync;
import james94jeans2.minimapsync.network.packet.MinimapsyncDonePacket;
import james94jeans2.minimapsync.network.packet.MinimapsyncInfoPacket;
import james94jeans2.minimapsync.network.packet.MinimapsyncWaypointPacket;
import james94jeans2.minimapsync.network.packethandling.MinimapsyncPacketPipeline;
import james94jeans2.minimapsync.util.Waypoint;
import james94jeans2.minimapsync.util.WaypointList;
import james94jeans2.minimapsync.util.loader.IWaypointLoader;
import java.util.LinkedList;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.Logger;

public abstract class AbstractWaypointManager {
    protected int mode;
    private static AbstractWaypointManager instance;
    protected Logger logger;
    protected MinimapsyncPacketPipeline pipeline;
    protected LinkedList<WaypointList> dimensions;
    protected LinkedList<Pair<EntityPlayer, WaypointList>> remoteIn;
    protected LinkedList<Pair<EntityPlayer, WaypointList>> remoteOut;
    protected boolean noWaypoints;
    protected IWaypointLoader loader;

    public void setMode(int pMode) {
        this.mode = pMode;
    }

    public int getMode() {
        return this.mode;
    }

    public static AbstractWaypointManager getInstance() {
        return instance;
    }

    public AbstractWaypointManager() {
        instance = this;
        this.logger = Minimapsync.instance.logger;
        this.pipeline = Minimapsync.pipeline;
        this.dimensions = new LinkedList();
        this.remoteIn = new LinkedList();
        this.remoteOut = new LinkedList();
        this.noWaypoints = true;
    }

    public boolean anyWaypointsInDimension(int pDim) {
        if (this.noWaypoints) {
            this.loadWaypoints();
        }
        if (!this.noWaypoints) {
            for (WaypointList tempList : this.dimensions) {
                if (tempList.getDim() != pDim || tempList.isEmpty()) continue;
                return true;
            }
        }
        return false;
    }

    public abstract void sendCheckPacket(EntityPlayer var1);

    protected WaypointList loadWaypointsForDimension(int pDim) {
        return this.loader.loadWaypointsForDimension(pDim);
    }

    protected void loadWaypoints() {
        this.dimensions = this.loader.loadAllWaypoints();
        if (this.dimensions == null) {
            this.logger.info("No waypoints saved up to now!");
            this.noWaypoints = true;
        } else {
            for (WaypointList list : this.dimensions) {
                if (list.isEmpty()) continue;
                this.noWaypoints = false;
                return;
            }
        }
    }

    protected void saveWaypoints() {
        this.loader.saveAllWaypoints(this.dimensions);
    }

    public abstract void afterStartup();

    protected void chat(String message, EntityPlayer player) {
        ((EntityPlayerMP)player).func_145747_a((IChatComponent)new ChatComponentText(message));
    }

    protected WaypointList checkMissingRemoteWaypoints(WaypointList remoteIn) {
        WaypointList compareList = null;
        if (!this.noWaypoints) {
            for (WaypointList tempList : this.dimensions) {
                if (remoteIn.getDim() != tempList.getDim()) continue;
                compareList = tempList;
                break;
            }
        }
        if (compareList != null) {
            return remoteIn.getMissingPoints(compareList);
        }
        return null;
    }

    protected void checkMissingRemoteWaypoints(EntityPlayer player) {
        for (Pair pair : this.remoteIn) {
            if (pair.getKey() != player) continue;
            this.remoteOut.add((Pair<EntityPlayer, WaypointList>)Pair.of((Object)player, (Object)this.checkMissingRemoteWaypoints((WaypointList)pair.getValue())));
            this.remoteIn.remove(pair);
            this.handleRemoteOut();
            return;
        }
    }

    protected void handleRemoteOut() {
        for (Pair pair : this.remoteOut) {
            if (pair.getValue() != null) {
                if (!((WaypointList)pair.getValue()).isEmpty()) {
                    if (((EntityPlayer)pair.getKey()).func_70005_c_().equals(Minecraft.func_71410_x().field_71439_g.func_70005_c_())) {
                        this.sendWaypointListToServer((WaypointList)pair.getValue());
                    } else {
                        this.sendWaypointListToClient((WaypointList)pair.getValue(), (EntityPlayer)pair.getKey());
                    }
                }
            } else {
                this.sendWaypointListToServer(new WaypointList(0, true));
            }
            this.remoteOut.remove(pair);
        }
    }

    protected void checkMissingLocalWaypoints(EntityPlayer player) {
        for (Pair pair : this.remoteIn) {
            if (pair.getKey() != player) continue;
            this.checkMissingLocalWaypoints((WaypointList)pair.getValue());
            return;
        }
    }

    protected void checkMissingLocalWaypoints(WaypointList remoteIn) {
        WaypointList compareList = null;
        if (!this.noWaypoints) {
            for (WaypointList tempList : this.dimensions) {
                if (remoteIn.getDim() != tempList.getDim()) continue;
                compareList = tempList;
                break;
            }
        }
        if (compareList != null) {
            compareList.removeAll(compareList.getDoublePoints(remoteIn.getPublic()));
            compareList.addAll(compareList.getMissingPoints(remoteIn));
        } else {
            WaypointList newList = new WaypointList(remoteIn.getDim(), true);
            newList.addAll(remoteIn);
            if (!newList.isEmpty()) {
                if (this.noWaypoints) {
                    this.dimensions = new LinkedList();
                    this.noWaypoints = false;
                }
                this.dimensions.add(newList);
            }
        }
        this.saveWaypoints();
    }

    public void sendAllWaypointsForDimensionToClient(int dimension, EntityPlayer player) {
        if (!this.noWaypoints) {
            for (WaypointList tempList : this.dimensions) {
                if (dimension != tempList.getDim()) continue;
                this.sendWaypointListToClient(tempList, player);
                return;
            }
        }
        this.sendWaypointListToClient(new WaypointList(dimension, true), player);
    }

    public void sendAllWaypointsToClient(EntityPlayer player) {
        if (!this.noWaypoints) {
            for (WaypointList tempList : this.dimensions) {
                this.sendReadOnlyWaypointListToClient(tempList, player);
            }
        }
    }

    protected void sendReadOnlyWaypointListToClient(WaypointList waypoints, EntityPlayer player) {
        for (Waypoint waypoint : waypoints) {
            this.sendWaypointToClient(waypoint, player);
        }
        this.pipeline.sendTo(new MinimapsyncDonePacket(1, waypoints.isPrivate()), (EntityPlayerMP)player);
    }

    protected void sendWaypointListToClient(WaypointList waypoints, EntityPlayer player) {
        if (waypoints.isPrivate()) {
            this.pipeline.sendTo(new MinimapsyncInfoPacket(waypoints.size()), (EntityPlayerMP)player);
        }
        for (Waypoint waypoint : waypoints) {
            this.sendWaypointToClient(waypoint, player);
        }
        this.pipeline.sendTo(new MinimapsyncDonePacket(0, waypoints.isPrivate()), (EntityPlayerMP)player);
    }

    protected void sendWaypointToClient(Waypoint waypoint, EntityPlayer player) {
        this.pipeline.sendTo(new MinimapsyncWaypointPacket(waypoint.getNetworkLine(), waypoint.getDim()), (EntityPlayerMP)player);
    }

    protected void sendWaypointListToServer(WaypointList waypoints) {
        if (this.mode != 1 && waypoints.isPrivate()) {
            waypoints.removeAll(waypoints.getPublic().clone());
        }
        for (Waypoint waypoint : waypoints) {
            this.sendWaypointToServer(this.mode == 1 ? 0 : -1, waypoint);
        }
        this.pipeline.sendToServer(new MinimapsyncDonePacket(this.mode == 1 ? 0 : -1, waypoints.isPrivate()));
    }

    protected void sendWaypointToServer(Waypoint waypoint) {
        this.pipeline.sendToServer(new MinimapsyncWaypointPacket(waypoint.getNetworkLine(), waypoint.getDim()));
    }

    protected void sendWaypointToServer(int key, Waypoint waypoint) {
        this.pipeline.sendToServer(new MinimapsyncWaypointPacket(waypoint.getNetworkLine(), waypoint.getDim(), key));
    }

    public void handleDonePacket(MinimapsyncDonePacket packet, EntityPlayer player) {
        this.logger.info("handling " + (packet.getPriv() ? "private" : "public") + " done packet");
        boolean loaded = false;
        for (Pair pair : this.remoteIn) {
            if (!((EntityPlayer)pair.getKey()).equals((Object)player)) continue;
            ((WaypointList)pair.getValue()).setPrivate(packet.getPriv());
            loaded = true;
            break;
        }
        if (loaded) {
            this.loadWaypoints();
            this.checkMissingLocalWaypoints(player);
            this.checkMissingRemoteWaypoints(player);
        } else {
            this.loadWaypoints();
            if (player.func_70005_c_().equals(Minecraft.func_71410_x().field_71439_g.func_70005_c_())) {
                this.remoteIn.add((Pair<EntityPlayer, WaypointList>)Pair.of((Object)player, (Object)new WaypointList(Minecraft.func_71410_x().field_71439_g.field_71093_bK, !packet.getPriv())));
                this.checkMissingRemoteWaypoints(player);
            } else {
                this.logger.fatal("Player: " + player.func_70005_c_());
                this.logger.fatal("sent donePacket but no waypoints!");
            }
        }
    }

    public void handleWaypointPacket(MinimapsyncWaypointPacket packet, EntityPlayer player) {
        WaypointList temp;
        boolean loaded = false;
        Pair match = null;
        for (Pair pair : this.remoteIn) {
            if (!((EntityPlayer)pair.getKey()).equals((Object)player)) continue;
            loaded = true;
            match = pair;
            break;
        }
        if (loaded) {
            temp = (WaypointList)match.getValue();
            temp.add(new Waypoint(packet.getWaypointString(), packet.getDimension()));
            this.remoteIn.add((Pair<EntityPlayer, WaypointList>)Pair.of((Object)player, (Object)temp));
            this.remoteIn.remove(match);
        } else {
            temp = new WaypointList(packet.getDimension(), false);
            temp.add(new Waypoint(packet.getWaypointString(), packet.getDimension()));
            this.remoteIn.add((Pair<EntityPlayer, WaypointList>)Pair.of((Object)player, (Object)temp));
        }
    }

    protected WaypointList getWaypointsForName(String name) {
        return this.getWaypointForName(this.dimensions, name);
    }

    protected WaypointList getWaypointForName(LinkedList<WaypointList> lists, String name) {
        if (this.noWaypoints) {
            return null;
        }
        WaypointList returnList = new WaypointList(0, true);
        for (WaypointList tempList : lists) {
            returnList.addAll(tempList.getWaypointsForName(name));
        }
        return returnList;
    }

    public WaypointList getWaypointsForDimension(int dimension) {
        if (!this.noWaypoints) {
            for (WaypointList list : this.dimensions) {
                if (list.getDim() != dimension) continue;
                return list;
            }
        }
        return null;
    }

    public boolean noWaypoints() {
        return this.noWaypoints;
    }

    public WaypointList checkWaypointTeleport(String name, EntityPlayerMP player) {
        if (this.noWaypoints) {
            return null;
        }
        for (WaypointList list : this.dimensions) {
            if (list.getDim() != player.field_71093_bK) continue;
            return list.getWaypointsForNameWithCase(name);
        }
        return null;
    }

    public WaypointList getWaypoints() {
        if (this.noWaypoints) {
            return null;
        }
        WaypointList returnList = new WaypointList(0, true);
        for (WaypointList tempList : this.dimensions) {
            returnList.addAll(tempList);
        }
        return returnList;
    }
}

